/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import org.eclipse.ercp.swt.mobile.ListBoxItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.qt.ListBase;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;

public class ListBox
extends ListBase {
    int delegateHandle = OS.ListBoxItemDelegate_new(this.internal_topHandle());
    Font headingFont;
    Image[][] detailImages;
    Image[][] headingImages;
    public static final int LB_STYLE_NO_HEADING_TEXT = 0;
    public static final int LB_STYLE_1LINE_ITEM = 1;
    public static final int LB_STYLE_2LINE_ITEM = 2;
    public static final int LB_MOD_SHOW_SELECTION_NUMBER = 16;
    public static final int LB_MOD_SHOW_HEADING_ICONS = 32;
    public static final int LB_MOD_SHOW_DETAIL_ICONS = 64;

    public ListBox(Composite composite, int n, int n2) {
        super(composite, ListBox.checkStyle(n), ListBox.checkLayoutStyle(n2));
        OS.QListView_setItemDelegate(this.internal_topHandle(), this.delegateHandle);
    }

    static int checkLayoutStyle(int n) {
        return ListBox.checkBits(n, 0, 1, 2, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.listBase_addSelectionListener(selectionListener);
    }

    public void deselect(int n) {
        this.listBase_deselect(n);
    }

    public void deselect(int n, int n2) {
        this.listBase_deselect(n, n2);
    }

    public void deselect(int[] nArray) {
        this.listBase_deselect(nArray);
    }

    public void deselectAll() {
        this.listBase_deselectAll();
    }

    public int getFocusIndex() {
        return this.listBase_getFocusIndex();
    }

    public int getSelectionCount() {
        return this.listBase_getSelectionCount();
    }

    public int[] getSelectionIndices() {
        return this.listBase_getSelectionIndices();
    }

    protected Point getPreferredClientAreaSize() {
        int n = this.listBase_getItemCount();
        if (n < 1) {
            return super.getPreferredClientAreaSize();
        }
        int n2 = OS.QAbstractItemView_sizeHintForColumn(this.internal_topHandle(), 0);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 += OS.QAbstractItemView_sizeHintForIndex((int)this.internal_topHandle(), (int)0, (int)0).y;
        }
        return new Point(n2, n3);
    }

    public void refreshItem(int n) {
        this.listBase_refreshItem(n);
    }

    public void refreshList() {
        this.listBase_refreshList();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.listBase_removeSelectionListener(selectionListener);
    }

    public void setHeadingFont(Font font) {
        this.checkWidget();
        if (this.delegateHandle == 0 || (this.layoutStyle & 3) == 0) {
            return;
        }
        if (this.headingFont == null && font == null) {
            return;
        }
        this.headingFont = font;
        int n = 0;
        if (font != null) {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            n = font.handle;
        }
        OS.ListModel_layoutAboutToBeChanged(this.dataModelHandle);
        OS.ListBoxItemDelegate_setHeadingFont(this.delegateHandle, n);
        OS.ListModel_layoutChanged(this.dataModelHandle);
    }

    public void select(int n) {
        this.listBase_select(n);
    }

    public void select(int n, int n2) {
        this.listBase_select(n, n2);
    }

    public void select(int[] nArray) {
        this.listBase_select(nArray);
    }

    public void selectAll() {
        this.listBase_selectAll();
    }

    public void setDataModel(ListBoxItem[] listBoxItemArray) {
        int n;
        this.checkWidget();
        if (listBoxItemArray == null) {
            SWT.error(4);
        }
        if (this.listBase_getItemCount() > 0) {
            OS.ListModel_clearList(this.dataModelHandle);
        }
        if ((n = listBoxItemArray.length) < 1) {
            this.headingImages = null;
            this.detailImages = null;
            return;
        }
        this.headingImages = new Image[n][];
        this.detailImages = new Image[n][];
        OS.ListModel_beginInsertRows(this.dataModelHandle, 0, 0, n - 1);
        for (int i = 0; i < n; ++i) {
            int[] nArray;
            int n2;
            int[] nArray2;
            int n3;
            if (listBoxItemArray[i].detailIcons != null) {
                n3 = listBoxItemArray[i].detailIcons.length;
                nArray2 = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray2[n2] = listBoxItemArray[i].detailIcons[n2].internal_getPixmapHandle();
                }
            } else {
                nArray2 = null;
            }
            if (listBoxItemArray[i].headingIcons != null) {
                n3 = listBoxItemArray[i].headingIcons.length;
                nArray = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray[n2] = listBoxItemArray[i].headingIcons[n2].internal_getPixmapHandle();
                }
            } else {
                nArray = null;
            }
            OS.ListModel_append(this.dataModelHandle, listBoxItemArray[i].detailText, nArray2, nArray2 != null ? nArray2.length : 0, listBoxItemArray[i].headingText, nArray, nArray != null ? nArray.length : 0);
            this.headingImages[i] = listBoxItemArray[i].getHeadingIcons();
            this.detailImages[i] = listBoxItemArray[i].getDetailIcons();
        }
        OS.ListModel_endInsertRows(this.dataModelHandle);
    }

    public void setSelection(int n) {
        this.listBase_setSelection(n);
    }

    public void setSelection(int n, int n2) {
        this.listBase_setSelection(n, n2);
    }

    public void setSelection(int[] nArray) {
        this.listBase_setSelection(nArray);
    }

    public void showSelection() {
        this.listBase_showSelection();
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.headingImages = null;
        this.detailImages = null;
    }

    protected int createDataModel() {
        this.listType = LISTTYPE_LISTBOX;
        return OS.ListModel_new(this.layoutStyle, this.internal_topHandle(), this.listType);
    }
}

