/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Vector;
import org.eclipse.ercp.swt.mobile.ScreenEvent;
import org.eclipse.ercp.swt.mobile.ScreenListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Screen {
    private int screenHandle;
    private boolean isDisposed;
    private Vector screenListeners;
    public static final int PRIMARY = 1;
    public static final int SECONDARY = 2;
    public static final int STATUS = 3;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    private Screen thisScreenForRunnable;
    private Rectangle boundsForRunnable;
    private int colorDepthForRunnable;
    private int locationForRunnable;
    private int orientationGetForRunnable;
    private int usageForRunnable;
    private boolean isActiveForRunnable;
    private boolean isTouchScreenForRunnable;
    private int orientationSetForRunnable;
    private int id;

    Screen(int n) {
        this.id = n;
        this.thisScreenForRunnable = this;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
            }
        });
        this.screenListeners = new Vector();
        this.isDisposed = false;
    }

    public void addEventListener(ScreenListener screenListener) {
        this.check();
        if (screenListener == null) {
            SWT.error(4);
        }
        this.screenListeners.addElement(screenListener);
    }

    public Rectangle getBounds() {
        this.check();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
            }
        });
        return this.boundsForRunnable;
    }

    public int getColorDepth() {
        this.check();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
            }
        });
        return this.colorDepthForRunnable;
    }

    public int getLocation() {
        this.check();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
            }
        });
        return this.locationForRunnable;
    }

    public int getOrientation() {
        this.check();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
            }
        });
        return this.orientationGetForRunnable;
    }

    public int getUsage() {
        this.check();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
            }
        });
        return this.usageForRunnable;
    }

    public boolean isActive() {
        this.check();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
            }
        });
        return this.isActiveForRunnable;
    }

    public boolean isTouchScreen() {
        this.check();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
            }
        });
        return this.isTouchScreenForRunnable;
    }

    public void removeEventListener(ScreenListener screenListener) {
        this.check();
        if (screenListener == null) {
            SWT.error(4);
        }
        this.screenListeners.removeElement(screenListener);
    }

    public void setOrientation(int n) {
        this.check();
        if (n != 0 && n != 1) {
            SWT.error(5);
        }
        this.orientationSetForRunnable = n;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
            }
        });
    }

    void internal_dispose() {
        this.isDisposed = true;
        this.screenHandle = 0;
    }

    private void check() {
        if (this.isDisposed) {
            SWT.error(24);
        }
    }

    private ScreenEvent getAScreenEvent() {
        ScreenEvent screenEvent = new ScreenEvent(this);
        screenEvent.isActive = this.isActive();
        screenEvent.orientation = this.getOrientation();
        return screenEvent;
    }

    private void internal_sendScreenEventActivated() {
        ScreenEvent screenEvent = this.getAScreenEvent();
        int n = this.screenListeners.size();
        for (int i = 0; i < n; ++i) {
            ScreenListener screenListener = (ScreenListener)this.screenListeners.elementAt(i);
            screenListener.screenActivated(screenEvent);
        }
    }

    private void internal_sendScreenEventDeactivated() {
        ScreenEvent screenEvent = this.getAScreenEvent();
        int n = this.screenListeners.size();
        for (int i = 0; i < n; ++i) {
            ScreenListener screenListener = (ScreenListener)this.screenListeners.elementAt(i);
            screenListener.screenDeactivated(screenEvent);
        }
    }

    private void internal_sendOrientationScreenChanged() {
        ScreenEvent screenEvent = this.getAScreenEvent();
        int n = this.screenListeners.size();
        for (int i = 0; i < n; ++i) {
            ScreenListener screenListener = (ScreenListener)this.screenListeners.elementAt(i);
            screenListener.screenOrientationChanged(screenEvent);
        }
    }
}

