/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.ListUtils;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class SortedList
extends Scrollable {
    private int containerHandle;
    private int layoutHandle;
    private int editorHandle;
    private int appHandle;
    private boolean ignoreSelectionEvent = false;
    private int keyEventDestination = 0;
    private int firstFilteredIndex = -1;
    private int lastFilteredIndex = -1;
    private boolean filtering = false;
    public static final int FILTER = 1;

    public SortedList(Composite composite, int n) {
        super(composite, SortedList.checkStyle(n));
        this.checkSubclass();
    }

    public SortedList(Composite composite, int n, int n2) {
        super(composite, SortedList.checkStyle(n), n2);
        this.checkSubclass();
    }

    public void add(String string) {
        this.checkWidget();
        ListUtils.add(this.scrollAreaHandle, string, null);
        this.sortList();
        this.ignoreSelectionEvent = true;
        this.filterList();
        this.ignoreSelectionEvent = false;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public String getFocus() {
        this.checkWidget();
        int n = this.scrollAreaHandle;
        int n2 = ListUtils.getFocusIndex(n);
        if (n2 != -1) {
            return ListUtils.getItem(n, n2);
        }
        return null;
    }

    public int getItemHeight() {
        this.checkWidget();
        return ListUtils.getItemHeight(this.scrollAreaHandle);
    }

    public String[] getSelection() {
        this.checkWidget();
        return ListUtils.getSelection(this.scrollAreaHandle);
    }

    public int getSelectionCount() {
        this.checkWidget();
        return ListUtils.getSelectionCount(this.scrollAreaHandle);
    }

    public void remove(String string) {
        this.checkWidget();
        ListUtils.remove(this.scrollAreaHandle, string);
    }

    public void removeAll() {
        this.checkWidget();
        ListUtils.removeAll(this.scrollAreaHandle);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void select(String string) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.select(this.scrollAreaHandle, string, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
        this.filterList();
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        ListUtils.setItems(this.scrollAreaHandle, stringArray, null);
        this.sortList();
        this.ignoreSelectionEvent = true;
        this.filterList();
        this.ignoreSelectionEvent = false;
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.setSelection(this.scrollAreaHandle, stringArray, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
        this.filterList();
    }

    public void showSelection() {
        this.checkWidget();
        ListUtils.showSelection(this.scrollAreaHandle);
    }

    protected void createHandle(int n) {
        super.createHandle(n);
        this.appHandle = OS.QCoreApplication_instance();
        this.containerHandle = OS.QFrame_new();
        this.layoutHandle = OS.QVBoxLayout_new(this.containerHandle);
        this.scrollAreaHandle = OS.QListWidget_new();
        this.handle = OS.QAbstractScrollArea_viewPort(this.scrollAreaHandle);
        if ((this.extraStyle & 1) != 0) {
            this.editorHandle = OS.QLineEdit_new();
        }
        OS.QLayout_setContentsMargins(this.layoutHandle, 0, 0, 0, 0);
        OS.QLayout_setSpacing(this.layoutHandle, 0);
        OS.QLayout_addWidget(this.layoutHandle, this.scrollAreaHandle);
        if (this.editorHandle != 0) {
            OS.QLayout_addWidget(this.layoutHandle, this.editorHandle);
        }
        OS.QWidget_setLayout(this.containerHandle, this.layoutHandle);
        OS.QWidget_setFocusPolicy(this.containerHandle, 1);
        OS.QWidget_setFocusProxy(this.containerHandle, this.scrollAreaHandle);
        OS.QAbstractItemView_setSelectionBehavior(this.scrollAreaHandle, 0);
        if ((this.getStyle() & 2) != 0) {
            OS.QAbstractItemView_setSelectionMode(this.scrollAreaHandle, 2);
        } else {
            OS.QAbstractItemView_setSelectionMode(this.scrollAreaHandle, 1);
        }
        OS.QListWidget_setSortingEnabled(this.scrollAreaHandle, true);
        OS.QFrame_setFrameStyle(this.scrollAreaHandle, 0);
        this.state |= 8;
    }

    protected void hookEvents() {
        super.hookEvents();
        int n = OS.SignalHandler_new(this.scrollAreaHandle, this.display, 1012);
        OS.QObject_connectOrThrow(this.scrollAreaHandle, "itemSelectionChanged()", n, "widgetSignal()", 0);
        int n2 = OS.SignalHandler_new(this.scrollAreaHandle, this.display, 1013);
        OS.QObject_connectOrThrow(this.scrollAreaHandle, "itemDoubleClicked(QListWidgetItem*)", n2, "widgetSignal(QListWidgetItem*)", 0);
        int n3 = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1014);
        OS.QObject_connectOrThrow(this.scrollAreaHandle, "itemActivated(QListWidgetItem* )", n3, "widgetSignal(QListWidgetItem* )", 0);
        if (this.editorHandle != 0) {
            int n4 = OS.SignalHandler_new(this.editorHandle, this.display, 1009);
            OS.QObject_connectOrThrow(this.editorHandle, "textChanged(const QString&)", n4, "widgetSignal(const QString&)", 0);
        }
    }

    protected void qt_signal_list_itemSelectionChanged() {
        if (!this.ignoreSelectionEvent) {
            this.sendEvent(13);
        }
    }

    protected void qt_signal_list_itemDoubleClicked(int n) {
        if (!this.ignoreSelectionEvent) {
            this.sendEvent(14);
        }
    }

    protected void qt_signal_list_itemActivated(int n) {
        if (!this.ignoreSelectionEvent) {
            this.sendEvent(14);
        }
    }

    protected boolean qt_event_mouseButtonRelease(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.getStyle() & 2) != 0) {
            this.filterList();
        }
        return super.qt_event_mouseButtonRelease(n, n2, n3, n4, n5, n6);
    }

    protected void qt_signal_text_changed(String string) {
        this.firstFilteredIndex = -1;
        this.lastFilteredIndex = -1;
        int n = this.scrollAreaHandle;
        int n2 = ListUtils.getItemCount(n);
        if (string != null && string.length() > 0) {
            string = string.toLowerCase();
            if (!this.filtering) {
                if (this.isFocusControl()) {
                    OS.QWidget_setFocus(this.editorHandle, 7);
                }
                OS.QWidget_setFocusProxy(this.containerHandle, this.editorHandle);
            }
            this.filtering = true;
            for (int i = 0; i < n2; ++i) {
                if (ListUtils.getItem(n, i).toLowerCase().startsWith(string) || (this.getStyle() & 2) != 0 && OS.QListWidget_swt_isItemSelected(n, i)) {
                    OS.QListWidget_swt_setItemVisible(n, i, true);
                    if (this.firstFilteredIndex < 0) {
                        this.firstFilteredIndex = i;
                    }
                    this.lastFilteredIndex = i;
                    continue;
                }
                OS.QListWidget_swt_setItemVisible(n, i, false);
            }
            if (!OS.QListWidget_swt_isItemVisible(n, ListUtils.getFocusIndex(n))) {
                ListUtils.setFocusIndex(this.scrollAreaHandle, this.firstFilteredIndex, (this.getStyle() & 2) != 0);
            }
        } else {
            if (this.filtering) {
                if (this.isFocusControl()) {
                    OS.QWidget_setFocus(this.scrollAreaHandle, 7);
                }
                OS.QWidget_setFocusProxy(this.containerHandle, this.scrollAreaHandle);
            }
            this.filtering = false;
            this.firstFilteredIndex = -1;
            this.lastFilteredIndex = -1;
            for (int i = 0; i < n2; ++i) {
                OS.QListWidget_swt_setItemVisible(n, i, true);
            }
            if (ListUtils.getFocusIndex(this.scrollAreaHandle) < 0) {
                ListUtils.setFocusIndex(this.scrollAreaHandle, 0, (this.getStyle() & 2) != 0);
            }
        }
    }

    protected boolean forceFocus(int n) {
        super.forceFocus(n);
        return this.isFocusControl();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        int n = OS.QApplication_focusWidget();
        return n != 0 && (n == this.containerHandle || n == this.scrollAreaHandle || n == this.editorHandle) && !this.isDisposed();
    }

    protected boolean qt_event_keypress(int n, int n2, int n3, int n4) {
        if (this.keyEventDestination == 0) {
            if (super.qt_event_keypress(n, n2, n3, n4)) {
                return true;
            }
        } else {
            return false;
        }
        if (this.editorHandle != 0 && n2 != 0x1000013 && n2 != 0x1000015 && n2 != 0x1000005 && n2 != 0x1FFFFFF) {
            if (this.keyEventDestination == 0) {
                OS.QWidget_setFocus(this.editorHandle, 7);
                OS.QWidget_setFocusProxy(this.containerHandle, this.editorHandle);
            }
            this.keyEventDestination = this.editorHandle;
        } else {
            if (this.keyEventDestination == 0) {
                OS.QWidget_setFocus(this.scrollAreaHandle, 7);
                OS.QWidget_setFocusProxy(this.containerHandle, this.scrollAreaHandle);
            }
            this.keyEventDestination = this.scrollAreaHandle;
        }
        int n5 = OS.QKeyEvent_new(6, n2, n3, "" + (char)n4);
        OS.QCoreApplication_sendEvent(this.appHandle, this.keyEventDestination, n5);
        int n6 = OS.QKeyEvent_new(7, n2, n3, "" + (char)n4);
        OS.QCoreApplication_sendEvent(this.appHandle, this.keyEventDestination, n6);
        this.keyEventDestination = 0;
        return true;
    }

    protected boolean qt_event_keyrelease(int n, int n2, int n3, int n4) {
        if (this.keyEventDestination == n) {
            return super.qt_event_keyrelease(n, n2, n3, n4);
        }
        return true;
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        this.traverseDoit = false;
        this.traverseCancel = false;
        switch (n2) {
            case 0x1000013: {
                if (!(!this.filtering && ListUtils.getFocusIndex(this.scrollAreaHandle) == 0 || this.filtering && this.firstFilteredIndex < 0) && (!this.filtering || ListUtils.getFocusIndex(this.scrollAreaHandle) != this.firstFilteredIndex)) break;
                this.traverseDoit = true;
                this.traverseCancel = true;
                break;
            }
            case 0x1000015: {
                if (!(!this.filtering && ListUtils.getFocusIndex(this.scrollAreaHandle) == ListUtils.getItemCount(this.scrollAreaHandle) - 1 || this.filtering && this.lastFilteredIndex < 0) && (!this.filtering || ListUtils.getFocusIndex(this.scrollAreaHandle) != this.lastFilteredIndex)) break;
                this.traverseDoit = true;
                this.traverseCancel = true;
                break;
            }
            case 0x1000012: {
                this.traverseDoit = true;
                this.traverseCancel = true;
                int n5 = OS.QApplication_focusWidget();
                if (n5 != this.editorHandle || OS.QLineEdit_cursorPosition(this.editorHandle) == 0) break;
                this.traverseDoit = false;
                this.traverseCancel = false;
                break;
            }
            case 0x1000014: {
                String string;
                this.traverseDoit = true;
                this.traverseCancel = true;
                int n6 = OS.QApplication_focusWidget();
                if (n6 != this.editorHandle || (string = OS.QLineEdit_text(this.editorHandle)) == null || OS.QLineEdit_cursorPosition(this.editorHandle) == string.length()) break;
                this.traverseDoit = false;
                this.traverseCancel = false;
                break;
            }
            default: {
                super.setTraversalFlags(n, n2, n3, n4);
            }
        }
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        if (this.editorHandle != 0) {
            int n5 = OS.QWidget_sizeHint((int)this.editorHandle).y;
            if (n5 % 2 != 0) {
                ++n5;
            }
            rectangle.height += n5;
        }
        return rectangle;
    }

    protected Point getPreferredClientAreaSize() {
        int n = ListUtils.getItemCount(this.scrollAreaHandle);
        int n2 = OS.QAbstractItemView_sizeHintForColumn(this.scrollAreaHandle, 0);
        int n3 = n * ListUtils.getItemHeight(this.scrollAreaHandle);
        return new Point(n2, n3);
    }

    protected void deregister() {
        super.deregister();
        this.removeWidget(this.containerHandle);
        if (this.editorHandle != 0) {
            this.removeWidget(this.editorHandle);
        }
    }

    protected int internal_frameHandle() {
        return this.containerHandle;
    }

    public int internal_topHandle() {
        return this.containerHandle;
    }

    protected void register() {
        super.register();
        this.addWidget(this.containerHandle);
        if (this.editorHandle != 0) {
            this.addWidget(this.editorHandle);
        }
    }

    protected void releaseHandle() {
        this.containerHandle = 0;
        this.editorHandle = 0;
        this.layoutHandle = 0;
        this.appHandle = 0;
        super.releaseHandle();
    }

    private static int checkStyle(int n) {
        n = SortedList.checkBits(n, 4, 2, 0, 0, 0, 0);
        n = SortedList.checkBits(n, 128, 1024, 0, 0, 0, 0);
        return n;
    }

    private void sortList() {
        OS.QListWidget_sortItems(this.scrollAreaHandle, (this.getStyle() & 0x80) != 0 ? 0 : 1);
    }

    private void filterList() {
        if (this.editorHandle != 0) {
            this.qt_signal_text_changed(OS.QLineEdit_text(this.editorHandle));
        }
    }

    protected void setBackground() {
        if (this.editorHandle != 0) {
            OS.QWidget_swt_unsetPalette(this.editorHandle);
        }
        super.setBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void backgroundImageApplied(Image image) {
        if (this.editorHandle == 0) {
            return;
        }
        int n = 0;
        try {
            n = OS.QWidget_swt_palette_new(this.editorHandle);
            int[] nArray = this.getBackgroundImageRoles();
            for (int i = 0; i < nArray.length; ++i) {
                OS.QPalette_swt_setBrush(n, nArray[i], 0);
            }
            OS.QWidget_setPalette(this.editorHandle, n);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            OS.QPalette_delete(n);
            throw throwable;
        }
        OS.QPalette_delete(n);
    }
}

