/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TextExtension
extends Text {
    public static final int EMAILADDRESS = 2;
    public static final int URL = 4;
    public static final int NON_PREDICTIVE = 8;
    public static final int LATIN_INPUT_ONLY = 16;
    public static final int UPPERCASE = 1;
    public static final int LOWERCASE = 2;
    public static final int TEXTCASE = 3;
    public static final int TITLECASE = 4;
    static final String UCB_BASIC_LATIN = "UCB_BASIC_LATIN";
    static final String UCB_GREEK = "UCB_GREEK";
    static final String UCB_CYRILLIC = "UCB_CYRILLIC";
    static final String UCB_ARMENIAN = "UCB_ARMENIAN";
    static final String UCB_HEBREW = "UCB_HEBREW";
    static final String UCB_ARABIC = "UCB_ARABIC";
    static final String UCB_DEVANAGARI = "UCB_DEVANAGARI";
    static final String UCB_BENGALI = "UCB_BENGALI";
    static final String UCB_THAI = "UCB_THAI";
    static final String UCB_HIRAGANA = "UCB_HIRAGANA";
    static final String UCB_KATAKANA = "UCB_KATAKANA";
    static final String UCB_HANGUL_SYLLABLES = "UCB_HANGUL_SYLLABLES";
    static final String IS_FULLWIDTH_DIGITS = "IS_FULLWIDTH_DIGITS";
    static final String IS_FULLWIDTH_LATIN = "IS_FULLWIDTH_LATIN";
    static final String IS_HALFWIDTH_KATAKANA = "HALFWIDTH_KATAKANA";
    static final String IS_HANJA = "IS_HANJA";
    static final String IS_KANJI = "IS_KANJI";
    static final String IS_LATIN = "IS_LATIN";
    static final String IS_LATIN_DIGITS = "IS_LATIN_DIGITS";
    static final String IS_SIMPLIFIED_HANZI = "IS_SIMPLIFIED_HANZI";
    static final String IS_TRADITIONAL_HANZI = "IS_TRADITIONAL_HANZI";
    static final String emailScheme = "mailto:";
    int inputContext;

    public TextExtension(Composite composite, int n) {
        this(composite, n, 0);
    }

    public TextExtension(Composite composite, int n, int n2) {
        super(composite, TextExtension.checkStyle(n, n2), n2);
        if ((n & 0x10) != 0) {
            int n3 = OS.QInputContextFactory_create("coefep", this.internal_topHandle());
            OS.QWidget_setInputContext(this.internal_topHandle(), n3);
            this.inputContext = n3;
        } else {
            OS.QWidget_setAttribute(this.handle, 14, true);
        }
        if ((n & 8) != 0) {
            // empty if block
        }
        this.format();
        this.addCommand();
    }

    void addCommand() {
        String string;
        if ((this.extraStyle & 2) != 0) {
            string = OS.Qt_tr(1);
        } else if ((this.extraStyle & 4) != 0) {
            string = OS.Qt_tr(2);
        } else {
            return;
        }
        Command command = new Command(this, 1, 0);
        command.setText(string);
        command.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if ((TextExtension.this.extraStyle & 2) != 0 || (TextExtension.this.extraStyle & 4) != 0) {
                    // empty if block
                }
            }
        });
    }

    private static int checkStyle(int n, int n2) {
        if ((n & 8) != 0) {
            n2 = 0;
        }
        if ((n2 & 0xFFFFFFE1) != 0) {
            SWT.error(5);
        }
        if ((n2 & 6) == 6) {
            SWT.error(5);
        }
        if ((n2 & 6) != 0) {
            n |= 4;
        }
        return n;
    }

    String inputContextKey(String string) {
        if (string == null || string.length() < 1) {
            return null;
        }
        String string2 = string.trim().toUpperCase();
        String string3 = null;
        if (string2.equals(UCB_BASIC_LATIN)) {
            string3 = "coefep";
        } else if (string.equals(IS_FULLWIDTH_DIGITS)) {
            string3 = "coefep";
        } else if (string.equals(IS_FULLWIDTH_LATIN)) {
            string3 = "coefep";
        } else if (string2.equals(IS_LATIN)) {
            string3 = "coefep";
        } else if (string.equals(IS_LATIN_DIGITS)) {
            string3 = "coefep";
        } else {
            String string4 = this.language(string2);
            if (string4 != null) {
                string3 = OS.QInputContextFactory_swt_key(string4);
            }
        }
        return string3;
    }

    String language(String string) {
        String string2 = null;
        if (string.equals(UCB_GREEK)) {
            string2 = "el";
        } else if (string.equals(UCB_CYRILLIC)) {
            string2 = "sr";
        } else if (string.equals(UCB_ARMENIAN)) {
            string2 = "hy";
        } else if (string.equals(UCB_HEBREW)) {
            string2 = "he";
        } else if (string.equals(UCB_ARABIC)) {
            string2 = "ar";
        } else if (string.equals(UCB_DEVANAGARI)) {
            string2 = "hi";
        } else if (string.equals(UCB_BENGALI)) {
            string2 = "bn";
        } else if (string.equals(UCB_THAI)) {
            string2 = "th";
        } else if (string.equals(UCB_HIRAGANA)) {
            string2 = "ja";
        } else if (string.equals(UCB_KATAKANA)) {
            string2 = "ja";
        } else if (string.equals(UCB_HANGUL_SYLLABLES)) {
            string2 = "ko";
        } else if (string.equals(IS_HALFWIDTH_KATAKANA)) {
            string2 = "ja";
        } else if (string.equals(IS_HANJA)) {
            string2 = "ko";
        } else if (string.equals(IS_KANJI)) {
            string2 = "ja";
        } else if (string.equals(IS_SIMPLIFIED_HANZI)) {
            string2 = "zh-CN;zh-SG";
        } else if (string.equals(IS_TRADITIONAL_HANZI)) {
            string2 = "zh-TW;zh-HK";
        }
        return string2;
    }

    public void setInitialInputMode(int n, String string) {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        if ((this.extraStyle & 0x10) == 0) {
            String string2 = this.inputContextKey(string);
            int n2 = 0;
            if (string2 != null) {
                n2 = OS.QInputContextFactory_create(string2, this.internal_topHandle());
            }
            if (n2 != 0 || this.inputContext != 0) {
                OS.QWidget_setInputContext(this.internal_topHandle(), n2);
            }
            this.inputContext = n2;
        }
        if (this.variant() == 0) {
            return;
        }
        int n3 = 0;
        switch (n) {
            case 2: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 3: {
                n3 = 0;
                break;
            }
            case 4: {
                n3 = 4;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.QTextEdit_swt_setCapitalization(this.internal_topHandle(), n3);
    }

    protected int variant() {
        return (this.getStyle() & 0x400000) != 0 ? 0 : 1;
    }

    protected boolean qt_event_keypress(int n, int n2, int n3, int n4) {
        this.format();
        return super.qt_event_keypress(n, n2, n3, n4);
    }

    protected boolean qt_event_keyrelease(int n, int n2, int n3, int n4) {
        if ((this.getStyle() & 4) != 0 && (n2 == 0x1000004 || n2 == 0x1000005)) {
            this.sendEvent(14);
        }
        return super.qt_event_keyrelease(n, n2, n3, n4);
    }

    private void format() {
        if (this.variant() != 0 && (this.extraStyle & 6) != 0 && OS.QTextEdit_toPlainText(this.internal_topHandle()).length() == 0) {
            OS.QTextEdit_swt_setHref(this.internal_topHandle());
        }
    }
}

