/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class ByteArrayTransfer
extends Transfer {
    public TransferData[] getSupportedTypes() {
        int[] nArray = this.getTypeIds();
        if (nArray == null) {
            return new TransferData[0];
        }
        TransferData[] transferDataArray = new TransferData[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            transferDataArray[i] = new TransferData();
            transferDataArray[i].type = nArray[i];
        }
        return transferDataArray;
    }

    public boolean isSupportedType(TransferData transferData) {
        int[] nArray = this.getTypeIds();
        if (nArray == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (transferData.type != nArray[i]) continue;
            return true;
        }
        return false;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkByteArray(object) || !this.isSupportedType(transferData)) {
            return;
        }
        transferData.data = (byte[])object;
        transferData.result = 1;
    }

    protected Object nativeToJava(TransferData transferData) {
        if (this.checkByteArray(transferData.data) && this.isSupportedType(transferData)) {
            transferData.result = 1;
            return transferData.data;
        }
        transferData.result = 0;
        return null;
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

