/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer instance = new TextTransfer();
    private static final String ID_NAME = "text/plain";
    private static final int ID = TextTransfer.registerType("text/plain");

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            return;
        }
        transferData.data = ((String)object).getBytes();
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.checkByteArray(transferData.data) && this.isSupportedType(transferData)) {
            transferData.result = 1;
            return new String(transferData.data);
        }
        transferData.result = 0;
        return null;
    }

    protected int[] getTypeIds() {
        return new int[]{ID};
    }

    protected String[] getTypeNames() {
        return new String[]{ID_NAME};
    }

    private boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }
}

