/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public final class Color {
    public int handle;
    Device device;

    Color() {
    }

    public Color(Device device, int n, int n2, int n3) {
        this.init(device, n, n2, n3);
    }

    public Color(Device device, RGB rGB) {
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(device, rGB.red, rGB.green, rGB.blue);
    }

    public void dispose() {
        if (this.device == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
        this.handle = -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        if (this.isDisposed() || color.isDisposed()) {
            return false;
        }
        return this.device == color.device && (this.handle & 0xFFFFFF) == (color.handle & 0xFFFFFF);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF0000) >> 16;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF00) >> 8;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle & 0xFF;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.handle & 0xFF, (this.handle & 0xFF00) >> 8, (this.handle & 0xFF0000) >> 16);
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return this.handle;
    }

    void init(Device device, int n, int n2, int n3) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0) {
            SWT.error(5);
        }
        this.handle = n & 0xFF | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 16;
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public boolean isDisposed() {
        return this.handle == -1;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }

    public static Color qt_new(Device device, int n) {
        Color color = new Color();
        color.device = device;
        color.handle = n;
        return color;
    }
}

