/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.internal.qt.QtSupplementaryFontData;

public final class Font {
    public int handle;
    Device device;
    boolean extraFontStyle;
    String xlfd;

    Font() {
    }

    public Font(Device device, FontData fontData) {
        if (fontData == null) {
            SWT.error(4);
        }
        this.init(device, fontData.getName(), fontData.getHeight(), fontData.getStyle());
        this.initExtraFontData(fontData);
    }

    public Font(Device device, FontData[] fontDataArray) {
        if (fontDataArray == null) {
            SWT.error(4);
        }
        if (fontDataArray.length == 0) {
            SWT.error(5);
        }
        for (int i = 0; i < fontDataArray.length; ++i) {
            if (fontDataArray[i] != null) continue;
            SWT.error(5);
        }
        FontData fontData = fontDataArray[0];
        this.init(device, fontData.getName(), fontData.getHeight(), fontData.getStyle());
        this.initExtraFontData(fontData);
    }

    public Font(Device device, String string, int n, int n2) {
        this.init(device, string, n, n2);
    }

    public void dispose() {
        if (this.device == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (!OS.SwtFontCache_isCached(this.handle)) {
            OS.QFont_delete(this.handle);
        }
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        return OS.QFont_swt_equals(this.handle, ((Font)object).handle);
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        String string = OS.QFont_family(this.handle);
        int n = OS.QFont_pointSize(this.handle);
        int n2 = OS.QFont_weight(this.handle);
        boolean bl = OS.QFont_italic(this.handle);
        int n3 = 0;
        if (n2 > 50) {
            n3 |= 1;
        }
        if (bl) {
            n3 |= 2;
        }
        FontData fontData = new FontData(string, n, n3);
        if (this.xlfd != null) {
            fontData.xlfd = this.xlfd;
        } else if (this.extraFontStyle) {
            QtSupplementaryFontData qtSupplementaryFontData = fontData.extraFontData = new QtSupplementaryFontData();
            qtSupplementaryFontData.underline = OS.QFont_underline(this.handle) ? 1 : 0;
            qtSupplementaryFontData.overline = OS.QFont_overline(this.handle) ? 1 : 0;
            qtSupplementaryFontData.strikeOut = OS.QFont_strikeOut(this.handle) ? 1 : 0;
            qtSupplementaryFontData.stretch = OS.QFont_stretch(this.handle);
            qtSupplementaryFontData.fixedPitch = OS.QFont_fixedPitch(this.handle) ? 1 : 0;
            qtSupplementaryFontData.style = OS.QFont_style(this.handle);
            qtSupplementaryFontData.weight = OS.QFont_weight(this.handle);
            qtSupplementaryFontData.styleStrategy = OS.QFont_styleStrategy(this.handle);
        }
        return new FontData[]{fontData};
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, String string, int n, int n2) {
        this.extraFontStyle = false;
        this.xlfd = null;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (string == null) {
            SWT.error(4);
        }
        if (n < 0) {
            SWT.error(5);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
        boolean bl = (n2 & 2) != 0;
        int n3 = 50;
        if ((n2 & 1) != 0) {
            n3 = 75;
        }
        this.handle = OS.QFont_new(string, n, n3, bl);
    }

    void initExtraFontData(FontData fontData) {
        if (fontData.xlfd != null) {
            OS.QFont_setRawName(this.handle, fontData.xlfd);
            this.xlfd = fontData.xlfd;
        } else if (fontData.extraFontData != null) {
            QtSupplementaryFontData qtSupplementaryFontData = fontData.extraFontData;
            if (qtSupplementaryFontData.underline > -1) {
                OS.QFont_setUnderline(this.handle, qtSupplementaryFontData.underline > 0);
            }
            if (qtSupplementaryFontData.overline > -1) {
                OS.QFont_setOverline(this.handle, qtSupplementaryFontData.overline > 0);
            }
            if (qtSupplementaryFontData.strikeOut > -1) {
                OS.QFont_setStrikeOut(this.handle, qtSupplementaryFontData.strikeOut > 0);
            }
            if (qtSupplementaryFontData.stretch > -1) {
                OS.QFont_setStretch(this.handle, qtSupplementaryFontData.stretch);
            }
            if (qtSupplementaryFontData.fixedPitch > -1) {
                OS.QFont_setFixedPitch(this.handle, qtSupplementaryFontData.fixedPitch > 0);
            }
            if (qtSupplementaryFontData.style > -1) {
                OS.QFont_setStyle(this.handle, qtSupplementaryFontData.style);
            }
            if (qtSupplementaryFontData.weight > -1) {
                OS.QFont_setWeight(this.handle, qtSupplementaryFontData.weight);
            }
            if (qtSupplementaryFontData.styleStrategy > -1) {
                OS.QFont_setStyleStrategy(this.handle, qtSupplementaryFontData.styleStrategy);
            }
            this.extraFontStyle = true;
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }

    public static Font qt_new(Device device, int n) {
        if (n <= 0) {
            return null;
        }
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        Font font = new Font();
        font.handle = n;
        font.device = device;
        return font;
    }
}

