/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class GC {
    private static final int FM_ASCENT = 0;
    private static final int FM_AVERAGE_CHAR_WIDTH = 1;
    private static final int FM_DESCENT = 2;
    private static final int FM_HEIGHT = 3;
    private static final int FM_LEADING = 4;
    private static final int FM_DATA_COUNT = 5;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_CAP = 16;
    static final int LINE_JOIN = 32;
    static final int LINE_WIDTH = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int BACKGROUND_BG = 256;
    static final int DRAW_OFFSET = 512;
    static final int DRAW = 761;
    static final int FILL = 2;
    public int handle;
    GCData data;
    Color customForeground;
    Color customBackground;
    Drawable drawable;

    static int checkStyle(int n) {
        if ((n & 0x2000000) != 0) {
            n &= 0xFBFFFFFF;
        }
        return n & 0x6000000;
    }

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int n) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData gCData = new GCData();
        gCData.style = GC.checkStyle(n);
        int n2 = drawable.internal_new_GC(gCData);
        try {
            this.init(drawable, gCData, n2);
        }
        catch (Error error) {
            drawable.internal_dispose_GC(n2, gCData);
            throw error;
        }
    }

    void checkGC(int n) {
        int n2 = this.data.state;
        if ((n2 & n) == n) {
            return;
        }
        n2 = (n2 ^ n) & n;
        this.data.state |= n;
        if ((this.data.state & 1) != 0 && (this.data.style & 0x8000000) != 0) {
            int n3 = OS.QPaintDevice_width(this.data.drawable);
            this.data.internalGc.resetTransform();
            this.data.internalGc.translate(n3 - 1, 0);
            this.data.internalGc.scale(-1, 1);
        }
    }

    public void copyArea(Image image, int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        if ((this.data.style & 0x8000000) != 0) {
            this.data.internalGc.resetTransform();
            this.data.state = -2;
            int n3 = OS.QPaintDevice_width(this.data.drawable);
            n = n3 - n - image.getBounds().width;
        }
        this.data.internalGc.copyArea(image.internal_getImage(), n, n2);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n7 = n5 - n;
        int n8 = n6 - n2;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            this.data.internalGc.resetTransform();
            this.data.state = -2;
            int n9 = OS.QPaintDevice_width(this.data.drawable);
            n = n9 - n - n3;
            n5 = n9 - n5 - n3;
        }
        this.data.internalGc.copyArea(n, n2, n3, n4, n5, n6);
    }

    public void dispose() {
        if (this.drawable != null && this.handle != 0) {
            if (this.data.buffered && this.drawable instanceof Control) {
                final Display display = Display.getDefault();
                display.syncExec(new Runnable(){

                    public void run() {
                        ((Control)GC.this.drawable).redraw();
                        while (display.readAndDispatch()) {
                        }
                    }
                });
            }
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.data.destroy();
        this.handle = 0;
        this.customForeground = null;
        this.customBackground = null;
        this.drawable = null;
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        this.checkGC(1);
        this.data.internalGc.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void drawFocus(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1);
        this.data.internalGc.drawFocus(n, n2, n3, n4);
    }

    public void drawImage(Image image, int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        if ((this.data.style & 0x8000000) != 0) {
            this.data.internalGc.resetTransform();
            this.data.state = -2;
            int n3 = OS.QPaintDevice_width(this.data.drawable);
            n = n3 - n - image.getBounds().width;
        }
        this.data.internalGc.drawImage(image.internal_getImage(), n, n2);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0 || n7 == 0 || n8 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n7 < 0 || n8 < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        if ((this.data.style & 0x8000000) != 0) {
            this.data.internalGc.resetTransform();
            this.data.state = -2;
            int n9 = OS.QPaintDevice_width(this.data.drawable);
            n = image.getBounds().width - n - n3;
            n5 = n9 - n5 - n7;
        }
        this.data.internalGc.drawImage(image.internal_getImage(), n5, n6, n7, n8, n, n2, n3, n4);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1);
        this.data.internalGc.drawLine(n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        this.checkGC(1);
        this.data.internalGc.drawEllipse(n, n2, n3, n4);
    }

    public void drawPoint(int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1);
        this.data.internalGc.drawPoint(n, n2);
    }

    public void drawPolygon(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(1);
        this.data.internalGc.drawPolygon(nArray);
    }

    public void drawPolyline(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(1);
        this.data.internalGc.drawPolyline(nArray);
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        this.checkGC(1);
        this.data.internalGc.drawRect(n, n2, n3, n4);
    }

    public void drawRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        this.drawRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1);
        this.data.internalGc.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, n, n2, false);
    }

    public void drawString(String string, int n, int n2, boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            this.data.internalGc.resetTransform();
            this.data.state = -2;
            int n3 = OS.QPaintDevice_width(this.data.drawable);
            int[] nArray = new int[4];
            this.data.internalGc.getTextBoundingBox(nArray, string, 33, 256);
            n = n3 - n - nArray[2];
        }
        this.data.internalGc.drawString(string, n, n2, bl);
    }

    public void drawText(String string, int n, int n2) {
        this.drawText(string, n, n2, 6);
    }

    public void drawText(String string, int n, int n2, int n3) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        int n4 = 0;
        boolean bl = false;
        if ((n3 & 2) == 0) {
            n4 |= 0x100;
        }
        if ((n3 & 4) != 0) {
            n4 |= 0x400;
        }
        if ((n3 & 8) != 0) {
            n4 |= 0x800;
        }
        if ((n3 & 1) != 0) {
            bl = true;
        }
        if ((this.data.style & 0x8000000) != 0) {
            this.data.internalGc.resetTransform();
            this.data.state = -2;
            int n5 = OS.QPaintDevice_width(this.data.drawable);
            int[] nArray = new int[4];
            this.data.internalGc.getTextBoundingBox(nArray, string, 5, n4);
            n = n5 - n - nArray[2];
        }
        this.data.internalGc.drawString(string, n, n2, 0, 0, 5, n4, bl);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        this.checkGC(1);
        this.data.internalGc.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillGradientRectangle(int n, int n2, int n3, int n4, boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        boolean bl2 = false;
        if (n3 < 0) {
            if (!bl) {
                bl2 = true;
            }
            n3 = Math.abs(n3);
        }
        if (n4 < 0) {
            if (bl) {
                bl2 = true;
            }
            n4 = Math.abs(n4);
        }
        this.checkGC(1);
        this.data.internalGc.fillGradientRect(n, n2, n3, n4, bl, bl2);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        this.checkGC(1);
        this.data.internalGc.fillEllipse(n, n2, n3, n4);
    }

    public void fillPolygon(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(1);
        this.data.internalGc.fillPolygon(nArray);
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        this.checkGC(1);
        this.data.internalGc.fillRect(n, n2, n3, n4);
    }

    public void fillRectangle(Rectangle rectangle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void fillRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1);
        this.data.internalGc.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public int getAdvanceWidth(char c) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.internalGc.getAdvancedCharacterWidth(c);
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.customBackground != null ? this.customBackground : this.data.background;
    }

    public int getCharWidth(char c) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.internalGc.getCharacterWidth(c);
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(1);
        if (this.data.clippingRect == null) {
            int[] nArray = new int[4];
            this.data.internalGc.getClip(nArray);
            this.data.clippingRect = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        return new Rectangle(this.data.clippingRect.x, this.data.clippingRect.y, this.data.clippingRect.width, this.data.clippingRect.height);
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int[] nArray = new int[5];
        this.data.internalGc.getFontMetricsData(nArray, 0, false);
        FontMetrics fontMetrics = new FontMetrics();
        fontMetrics.ascent = nArray[0];
        fontMetrics.averageCharWidth = nArray[1];
        fontMetrics.descent = nArray[2];
        fontMetrics.height = nArray[3];
        fontMetrics.leading = nArray[4];
        return fontMetrics;
    }

    public Color getForeground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.customForeground != null ? this.customForeground : this.data.foreground;
    }

    public GCData getGCData() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineStyle == -1) {
            this.data.lineStyle = GCData.translateStrokeStyle(this.data.internalGc.getStrokeStyle(), false);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineWidth == -1) {
            this.data.lineWidth = this.data.internalGc.getStrokeWidth();
        }
        return this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.xorMode == -1) {
            this.data.xorMode = this.data.internalGc.getBlendingMode() == 12 ? 1 : 0;
        }
        return this.data.xorMode == 1;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Drawable drawable, GCData gCData, int n) {
        this.drawable = drawable;
        this.data = gCData;
        this.handle = n;
        if (gCData.foreground == null) {
            gCData.foreground = gCData.device.getSystemColor(2);
        }
        if (gCData.background == null) {
            gCData.background = gCData.device.getSystemColor(1);
        }
        gCData.internalGc.setForegroundColor(gCData.foreground.getRed(), gCData.foreground.getGreen(), gCData.foreground.getBlue());
        gCData.internalGc.setBackgroundColor(gCData.background.getRed(), gCData.background.getGreen(), gCData.background.getBlue());
        this.drawable = drawable;
        this.data = gCData;
        this.handle = n;
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.internalGc.hasClipping();
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setAlpha(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.alpha = n & 0xFF;
        this.data.internalGc.setForegroundAlpha(this.data.alpha);
        this.data.internalGc.setBackgroundAlpha(this.data.alpha);
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.customBackground = color;
        this.data.internalGc.setBackgroundColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public void setClipping(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((this.data.style & 0x8000000) != 0) {
            this.data.internalGc.resetTransform();
            this.data.state = -2;
            int n5 = OS.QPaintDevice_width(this.data.drawable);
            n = n5 - n - (n3 + 1);
        }
        this.data.clippingRect = new Rectangle(n, n2, n3, n4);
        this.data.internalGc.setClip(n, n2, n3 + 1, n4, false);
    }

    public void setClipping(Rectangle rectangle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rectangle != null) {
            this.setClipping(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.data.internalGc.cancelClipping();
        }
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : Font.qt_new(this.data.device, OS.SwtFontCache_cache(OS.QApplication_swt_font_new()));
        this.data.internalGc.setFont(this.data.font.handle);
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.customForeground = color;
        this.data.internalGc.setForegroundColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public void setLineStyle(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineStyle == n) {
            return;
        }
        this.data.internalGc.setStrokeStyle(GCData.translateStrokeStyle(n, true));
        this.data.lineStyle = n;
    }

    public void setLineWidth(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineWidth == n) {
            return;
        }
        this.data.lineWidth = n;
        this.data.internalGc.setStrokeWidth(n);
    }

    public void setXORMode(boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (bl) {
            if (this.data.xorMode == 1) {
                return;
            }
            this.data.xorMode = 1;
            this.data.internalGc.setBlendingMode(12);
        } else {
            if (this.data.xorMode == 0) {
                return;
            }
            this.data.xorMode = 0;
            this.data.internalGc.setBlendingMode(11);
        }
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        int[] nArray = new int[4];
        int n2 = 0;
        if ((n & 2) == 0) {
            n2 |= 0x100;
        }
        if ((n & 4) != 0) {
            n2 |= 0x400;
        }
        if ((n & 8) != 0) {
            n2 |= 0x800;
        }
        this.data.internalGc.getTextBoundingBox(nArray, string, 1, n2);
        return new Point(nArray[2], nArray[3]);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

