/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.internal.qt.graphics.GraphicsContext;
import org.eclipse.swt.internal.qt.graphics.ImageLoader;

public final class Image
implements Drawable {
    public int type;
    GCData bindedGc;
    byte[] alphaData;
    int alpha;
    static final int DEFAULT_SCANLINE_PAD = 4;
    private org.eclipse.swt.internal.qt.graphics.Image cgImage;
    private int icon;
    int transparentPixel;
    Device device;

    public static int internal_getNullIconHandle() {
        if (Device.nullIconHandle == 0) {
            Device.nullIconHandle = OS.QIcon_new();
        }
        return Device.nullIconHandle;
    }

    public static Image internal_new_Image(Device device, org.eclipse.swt.internal.qt.graphics.Image image) {
        Image image2 = new Image(device);
        image2.init(image);
        return image2;
    }

    Image(Device device) {
        this.type = 0;
        this.alpha = -1;
        this.icon = 0;
        this.transparentPixel = -1;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
    }

    public Image(Device device, ImageData imageData) {
        this(device);
        this.init(imageData);
        this.track();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, InputStream inputStream) {
        block7: {
            this(device);
            if (inputStream == null) {
                SWT.error(4);
            }
            this.init();
            ImageLoader imageLoader = new ImageLoader();
            try {
                try {
                    this.cgImage = imageLoader.loadImage(inputStream);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SWT.error(42);
                    Object var6_5 = null;
                    imageLoader.dispose();
                    break block7;
                }
                catch (IllegalStateException illegalStateException) {
                    SWT.error(40);
                    Object var6_6 = null;
                    imageLoader.dispose();
                    break block7;
                }
                catch (IOException iOException) {
                    SWT.error(39);
                    Object var6_7 = null;
                    imageLoader.dispose();
                }
                Object var6_4 = null;
                imageLoader.dispose();
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                imageLoader.dispose();
                throw throwable;
            }
        }
        this.track();
    }

    public Image(Device device, int n, int n2) {
        this(device);
        this.init(n, n2);
        this.track();
    }

    public Image(Device device, Rectangle rectangle) {
        this(device);
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(rectangle.width, rectangle.height);
        this.track();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, String string) {
        block7: {
            this(device);
            if (string == null) {
                SWT.error(4);
            }
            ImageLoader imageLoader = new ImageLoader();
            try {
                try {
                    this.cgImage = imageLoader.loadImage(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SWT.error(42);
                    Object var6_5 = null;
                    imageLoader.dispose();
                    break block7;
                }
                catch (IllegalStateException illegalStateException) {
                    SWT.error(40);
                    Object var6_6 = null;
                    imageLoader.dispose();
                    break block7;
                }
                catch (IOException iOException) {
                    SWT.error(39);
                    Object var6_7 = null;
                    imageLoader.dispose();
                }
                Object var6_4 = null;
                imageLoader.dispose();
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                imageLoader.dispose();
                throw throwable;
            }
        }
        this.track();
    }

    protected void checkValidity() {
        if (this.type != 0 && this.type != 1) {
            SWT.error(5);
        }
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    public void dispose() {
        if (this.cgImage != null) {
            this.cgImage.dispose();
            this.cgImage = null;
        }
        if (this.icon != 0) {
            OS.QIcon_delete(this.icon);
            this.icon = 0;
        }
        if (this.device == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.hashCode() == image.hashCode();
    }

    public Rectangle getBounds() {
        this.checkValidity();
        return new Rectangle(0, 0, this.cgImage.getWidth(), this.cgImage.getHeight());
    }

    public ImageData getImageData() {
        this.checkValidity();
        return this.cgImage.getImageData();
    }

    public int hashCode() {
        if (this.cgImage != null) {
            return this.cgImage.getHandle();
        }
        return -1;
    }

    protected void init() {
        if (this.cgImage != null && !this.cgImage.isDisposed()) {
            this.cgImage.dispose();
        }
    }

    protected void init(ImageData imageData) {
        Object object;
        if (imageData == null) {
            SWT.error(4);
        }
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || imageData.palette.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !imageData.palette.isDirect)) {
            SWT.error(38);
        }
        this.init();
        int n = imageData.width;
        int n2 = imageData.height;
        PaletteData paletteData = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
            SWT.error(38);
        }
        byte[] byArray = imageData.data;
        if (imageData.depth != 32 || imageData.bytesPerLine != n * 4) {
            byArray = new byte[n * 4 * n2];
            if (paletteData.isDirect) {
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n, n2, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray, 32, n * 4, 1, 0, 0, n, n2, 0xFF0000, 65280, 255, false, false);
                paletteData = new PaletteData(0xFF0000, 65280, 255);
            } else {
                object = paletteData.getRGBs();
                int n3 = ((RGB[])object).length;
                byte[] byArray2 = new byte[n3];
                byte[] byArray3 = new byte[n3];
                byte[] byArray4 = new byte[n3];
                for (int i = 0; i < ((RGB[])object).length; ++i) {
                    RGB rGB = object[i];
                    if (rGB == null) continue;
                    byArray2[i] = (byte)rGB.red;
                    byArray3[i] = (byte)rGB.green;
                    byArray4[i] = (byte)rGB.blue;
                }
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n, n2, byArray2, byArray3, byArray4, 255, null, 0, 0, 0, byArray, 32, n * 4, 1, 0, 0, n, n2, 0xFF0000, 65280, 255, false, false);
            }
            imageData = new ImageData(n, n2, 32, paletteData, 4, byArray, imageData.maskPad, imageData.maskData, imageData.alphaData, imageData.alpha, imageData.transparentPixel, imageData.type, imageData.x, imageData.y, imageData.disposalMethod, imageData.delayTime);
        }
        this.type = 0;
        this.cgImage = new org.eclipse.swt.internal.qt.graphics.Image(imageData);
        try {
            if (imageData.transparentPixel != -1) {
                object = null;
                if (paletteData.isDirect) {
                    object = paletteData.getRGB(imageData.transparentPixel);
                } else if (imageData.transparentPixel < paletteData.colors.length) {
                    object = paletteData.getRGB(imageData.transparentPixel);
                }
                if (object != null) {
                    this.transparentPixel = object.red << 24 | object.green << 16 | object.blue << 8 | 0xFF;
                }
            }
        }
        catch (Error error) {
            this.cgImage.dispose();
            throw error;
        }
    }

    protected void init(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.init();
        this.type = 0;
        this.cgImage = new org.eclipse.swt.internal.qt.graphics.Image(n, n2);
    }

    protected void init(org.eclipse.swt.internal.qt.graphics.Image image) {
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(38);
        }
        this.init();
        this.type = 0;
        this.cgImage = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internal_dispose_GC(int n, GCData gCData) {
        if (gCData == null || gCData.internalGc == null) {
            SWT.error(4);
        }
        Image image = this;
        synchronized (image) {
            this.bindedGc = null;
            gCData.internalGc.releaseTarget();
            gCData.internalGc = null;
        }
    }

    public int internal_getIconHandle() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.icon == 0) {
            this.icon = OS.QIcon_new(this.cgImage.getNativePixmapHandle());
        }
        return this.icon;
    }

    public org.eclipse.swt.internal.qt.graphics.Image internal_getImage() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.cgImage;
    }

    public int internal_getImageHandle() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.cgImage.getHandle();
    }

    public int internal_getPixmapHandle() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.cgImage.getNativePixmapHandle();
    }

    public boolean internal_isDisposed() {
        return this.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int internal_new_GC(GCData gCData) {
        this.checkValidity();
        if (gCData == null) {
            SWT.error(4);
        }
        Image image = this;
        synchronized (image) {
            int n;
            if (this.bindedGc != null) {
                SWT.error(5);
            }
            if ((gCData.style & (n = 0x6000000)) == 0) {
                gCData.style |= 0x2000000;
            } else if ((gCData.style & 0x4000000) != 0) {
                gCData.style |= 0x8000000;
            }
            gCData.internalGc = new GraphicsContext();
            gCData.internalGc.bindTarget(this.internal_getImage());
            this.bindedGc = gCData;
            gCData.device = this.device;
            gCData.drawable = OS.QPixmap_swt_paintDevice(this.cgImage.getNativePixmapHandle());
            gCData.background = this.device.getSystemColor(1);
            gCData.foreground = this.device.getSystemColor(2);
            gCData.font = Font.qt_new(this.device, OS.SwtFontCache_cache(OS.QApplication_swt_font_new()));
            gCData.image = this;
        }
        return gCData.internalGc.getHandle();
    }

    public boolean isDisposed() {
        if (this.cgImage != null) {
            return this.cgImage.isDisposed();
        }
        return true;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.cgImage.getHandle() + "}";
    }

    private void track() {
        if (this.device.tracking) {
            this.device.new_Object(this);
        }
    }
}

