/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public abstract class ListBase
extends Scrollable {
    private static final int LISTBASE_SHOW_CHECKBOX = 128;
    protected static int LISTTYPE_STRINGLIST = 1;
    protected static int LISTTYPE_SORTEDLIST = 2;
    protected static int LISTTYPE_LISTVIEW = 4;
    protected static int LISTTYPE_LISTBOX = 8;
    protected int layoutStyle;
    protected int dataModelHandle;
    protected int selectionModelHandle;
    protected int listType;
    boolean undoSelectionChangePhase = false;

    public ListBase(Composite composite, int n) {
        super(composite, n);
        this.initList();
    }

    public ListBase(Composite composite, int n, int n2) {
        super(composite, n);
        this.layoutStyle = n2;
        if (OS.windowServer == 1) {
            this.layoutStyle |= 0x80;
        }
        this.initList();
    }

    void initList() {
        this.dataModelHandle = this.createDataModel();
        OS.QAbstractItemView_setModel(this.internal_topHandle(), this.dataModelHandle);
        OS.QAbstractItemView_setSelectionBehavior(this.internal_topHandle(), 1);
        int n = 1;
        if ((this.style & 2) != 0) {
            n = 2;
        }
        OS.QAbstractItemView_setSelectionMode(this.internal_topHandle(), n);
        this.selectionModelHandle = OS.QAbstractItemView_selectionModel(this.internal_topHandle());
        this.hookEvents();
    }

    protected abstract int createDataModel();

    protected void createHandle(int n) {
        this.scrollAreaHandle = OS.QListView_new();
        this.handle = OS.QAbstractScrollArea_viewPort(this.scrollAreaHandle);
        this.state |= 8;
    }

    protected void createWidget(int n) {
        super.createWidget(n);
    }

    protected void hookEvents() {
        if (this.selectionModelHandle != 0) {
            int n = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1008);
            OS.QObject_connectOrThrow(this.selectionModelHandle, "selectionChanged( const QItemSelection&, const QItemSelection& )", n, "widgetSignal( const QItemSelection&, const QItemSelection& )", 0);
            int n2 = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1036);
            OS.QObject_connectOrThrow(this.internal_topHandle(), "activated(const QModelIndex& )", n2, "widgetSignal(const QModelIndex&)", 0);
        }
    }

    protected static int checkStyle(int n) {
        return ListBase.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    protected void listBase_addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void listBase_deselect(int n) {
        this.checkWidget();
        if (n < 0 || n > this.listBase_getItemCount() - 1) {
            return;
        }
        this.internalSelect(n, 4, false, false);
    }

    protected void listBase_deselect(int n, int n2) {
        this.checkWidget();
        int n3 = this.listBase_getItemCount();
        if (n > n3 - 1 || n2 < 0 || n > n2) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        this.internalSelect(n, n2, 4, false, false);
    }

    protected void listBase_deselect(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            SWT.error(4);
        }
        if ((n = nArray.length) == 0) {
            return;
        }
        int n2 = this.listBase_getItemCount();
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 < 0 || n3 > n2 - 1) continue;
            this.internalSelect(nArray[i], 4, false, false);
        }
    }

    protected void listBase_deselectAll() {
        this.checkWidget();
        OS.QItemSelectionModel_clearSelection(this.selectionModelHandle);
    }

    protected int listBase_getFocusIndex() {
        this.checkWidget();
        int n = OS.QItemSelectionModel_currentIndex(this.selectionModelHandle);
        int n2 = OS.QModelIndex_row(n);
        OS.QModelIndex_delete(n);
        return n2;
    }

    protected String[] listBase_getItems() {
        this.checkWidget();
        int n = this.listBase_getItemCount();
        if (n < 1) {
            return new String[0];
        }
        String[] stringArray = OS.ListModel_itemStrings(this.dataModelHandle);
        if (stringArray == null || stringArray == new String[0]) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    protected int listBase_getSelectionCount() {
        this.checkWidget();
        int[] nArray = OS.QItemSelectionModel_selectedRows(this.selectionModelHandle, 0);
        if (nArray != null) {
            return nArray.length;
        }
        return 0;
    }

    protected String[] listBase_getSelection() {
        this.checkWidget();
        int[] nArray = this.listBase_getSelectionIndices();
        if (nArray.length < 1) {
            return new String[0];
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.listBase_getItem(nArray[i]);
        }
        return stringArray;
    }

    protected int[] listBase_getSelectionIndices() {
        this.checkWidget();
        int[] nArray = OS.QItemSelectionModel_selectedRows(this.selectionModelHandle, 0);
        if (nArray == null) {
            nArray = new int[]{};
        }
        this.sort(nArray);
        return nArray;
    }

    protected void listBase_refreshItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.listBase_getItemCount()) {
            SWT.error(6);
        }
        int n2 = OS.QAbstractItemModel_index(this.dataModelHandle, n, 0, 0);
        OS.QAbstractItemView_update(this.internal_topHandle(), n2);
        OS.QModelIndex_delete(n2);
    }

    protected void listBase_refreshList() {
        this.checkWidget();
        for (int i = 0; i < this.listBase_getItemCount(); ++i) {
            this.listBase_refreshItem(i);
        }
    }

    protected void listBase_removeSelectionListener(SelectionListener selectionListener) {
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    protected void listBase_select(int n) {
        this.checkWidget();
        if (n < 0 || n > this.listBase_getItemCount() - 1) {
            return;
        }
        int n2 = 2;
        if ((this.style & 4) != 0) {
            n2 |= 1;
        }
        this.internalSelect(n, n2, false, false);
    }

    protected void listBase_select(int n, int n2) {
        this.checkWidget();
        if (n == n2) {
            this.listBase_select(n);
            return;
        }
        int n3 = this.listBase_getItemCount();
        if (n > n3 - 1 || n2 < 0 || n > n2) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        if ((this.style & 2) == 0) {
            return;
        }
        this.internalSelect(n, n2, 2, false, false);
    }

    protected void listBase_select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            SWT.error(4);
        }
        if ((n = nArray.length) == 1) {
            this.listBase_select(nArray[0]);
            return;
        }
        if (n == 0 || (this.style & 2) == 0) {
            return;
        }
        int n2 = this.listBase_getItemCount();
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 < 0 || n3 > n2 - 1) continue;
            this.internalSelect(n3, 2, false, false);
        }
    }

    protected void listBase_selectAll() {
        this.checkWidget();
        if ((this.style & 2) == 0 && this.listBase_getItemCount() != 1) {
            return;
        }
        this.internalSelect(0, this.listBase_getItemCount() - 1, 2, false, false);
    }

    protected boolean listBase_isSelected(int n) {
        this.checkWidget();
        int n2 = OS.QAbstractItemModel_index(this.dataModelHandle, n, 0, 0);
        if (n2 == 0) {
            return false;
        }
        boolean bl = OS.QItemSelectionModel_isSelected(this.selectionModelHandle, n2);
        OS.QModelIndex_delete(n2);
        return bl;
    }

    protected void listBase_setSelection(int n) {
        this.checkWidget();
        if (n < 0 || n > this.listBase_getItemCount() - 1) {
            this.listBase_deselectAll();
            return;
        }
        int n2 = 19;
        this.internalSelect(n, n2, true, true);
    }

    protected void listBase_setSelection(int n, int n2) {
        this.checkWidget();
        if (n == n2) {
            this.listBase_setSelection(n);
            return;
        }
        this.listBase_deselectAll();
        int n3 = this.listBase_getItemCount();
        if (n > n3 - 1 || n2 < 0 | n > n2) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        if ((this.style & 2) == 0) {
            return;
        }
        this.internalSelect(n, n2, 2, true, true);
    }

    protected void listBase_setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            SWT.error(4);
        }
        this.listBase_deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 2) == 0 && n != 1) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n2 = this.listBase_getItemCount();
        for (int i = 0; i < n; ++i) {
            int n3 = nArray2[i];
            if (n3 < 0 || n3 > n2 - 1) continue;
            if (i == 0) {
                this.internalSelect(n3, 2, true, true);
                continue;
            }
            this.internalSelect(n3, 2, false, false);
        }
    }

    protected void listBase_setSelection(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            SWT.error(4);
        }
        this.listBase_deselectAll();
        int n = stringArray.length;
        if (n == 0 || (this.style & 2) == 0 && n != 1) {
            return;
        }
        int n2 = this.listBase_getItemCount();
        if (n2 < 1) {
            return;
        }
        int n3 = n2;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) {
                SWT.error(5);
            }
            for (int j = 0; j < n2 && (j = this.listBase_indexOf(stringArray[i], j)) >= 0; ++j) {
                if (j > n3) {
                    this.internalSelect(j, 2, false, false);
                    continue;
                }
                if (n3 < n2) {
                    this.internalSelect(n3, 2, false, false);
                }
                n3 = j;
            }
        }
        if (n3 < n2) {
            this.internalSelect(n3, 2, true, true);
        }
    }

    protected void listBase_showSelection() {
        this.checkWidget();
        int[] nArray = this.listBase_getSelectionIndices();
        if (nArray == null || nArray.length < 1) {
            return;
        }
        int n = OS.QAbstractItemModel_index(this.dataModelHandle, nArray[0], 0, 0);
        OS.QAbstractItemView_scrollTo(this.internal_topHandle(), n, 0);
        OS.QModelIndex_delete(n);
    }

    private void internalSelect(int n, int n2, boolean bl, boolean bl2) {
        int n3 = OS.QAbstractItemModel_index(this.dataModelHandle, n, 0, 0);
        if (bl2) {
            OS.QItemSelectionModel_setCurrentIndex(this.selectionModelHandle, n3, n2);
        } else {
            OS.QItemSelectionModel_select(this.selectionModelHandle, n3, n2);
        }
        if (bl) {
            OS.QAbstractItemView_scrollTo(this.internal_topHandle(), n3, 0);
        }
        OS.QModelIndex_delete(n3);
    }

    private void internalSelect(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = OS.QAbstractItemModel_index(this.dataModelHandle, n, 0, 0);
        int n5 = OS.QAbstractItemModel_index(this.dataModelHandle, n2, 0, 0);
        OS.QItemSelectionModel_select(this.selectionModelHandle, n4, n5, n3);
        if (bl) {
            OS.QAbstractItemView_scrollTo(this.internal_topHandle(), n4, 1);
        }
        if (bl2) {
            OS.QItemSelectionModel_setCurrentIndex(this.selectionModelHandle, n4, 16);
        }
        OS.QModelIndex_delete(n4);
        OS.QModelIndex_delete(n5);
    }

    private boolean getTraversalDoIt(int n, int n2, int n3, int n4) {
        int n5 = this.listBase_getFocusIndex();
        boolean bl = n5 == 0;
        boolean bl2 = n5 == this.listBase_getItemCount() - 1;
        boolean bl3 = bl && (n & 0x28) != 0 || bl2 && (n & 0x50) != 0 || (n & 0x80) != 0;
        return bl3;
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        this.traverseDoit = this.getTraversalDoIt(n, n2, n3, n4);
        this.traverseCancel = (n & 0x80) != 0 ? true : this.traverseDoit;
    }

    protected void qt_signal_selectionChanged(int n, int n2) {
        if (!this.undoSelectionChangePhase) {
            Event event = new Event();
            this.sendEvent(13, event);
            if (!event.doit) {
                this.undoSelectionChangePhase = true;
                OS.QItemSelectionModel_select__set(this.selectionModelHandle, n, 4);
                OS.QItemSelectionModel_select__set(this.selectionModelHandle, n2, 2);
                this.undoSelectionChangePhase = false;
            } else if (OS.windowServer == 1) {
                OS.ListModel_setCheckState(this.dataModelHandle, n, 2);
                OS.ListModel_setCheckState(this.dataModelHandle, n2, 0);
            }
        }
    }

    protected void qt_signal_abstractitemview_activated(int n, int n2) {
        super.qt_signal_abstractitemview_activated(n, n2);
        this.sendEvent(14);
    }

    protected int listBase_getItemCount() {
        this.checkWidget();
        return OS.QAbstractItemModel_rowCount(this.dataModelHandle);
    }

    protected int listBase_getItemHeight() {
        this.checkWidget();
        return OS.ListModel_itemHeight(this.dataModelHandle);
    }

    protected void listBase_add(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n = this.listBase_getItemCount();
        OS.ListModel_beginInsertRows(this.dataModelHandle, 0, n, n);
        OS.ListModel_append(this.dataModelHandle, string);
        OS.ListModel_endInsertRows(this.dataModelHandle);
    }

    protected String listBase_getItem(int n) {
        this.checkWidget();
        int n2 = this.listBase_getItemCount();
        if (n < 0 || n > n2 - 1) {
            SWT.error(6);
        }
        return OS.ListModel_itemString(this.dataModelHandle, n);
    }

    protected int listBase_indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (n < 0 || n > this.listBase_getItemCount() - 1) {
            return -1;
        }
        return OS.ListModel_indexOf(this.dataModelHandle, string, n);
    }

    protected void listBase_remove(int n) {
        this.checkWidget();
        int n2 = this.listBase_getItemCount();
        if (n < 0 || n > n2 - 1) {
            SWT.error(6);
        }
        int n3 = OS.QAbstractItemModel_index(this.dataModelHandle, n, 0, 0);
        OS.ListModel_beginRemoveRows(this.dataModelHandle, 0, n, n);
        OS.ListModel_remove(this.dataModelHandle, n);
        OS.ListModel_endRemoveRows(this.dataModelHandle);
        OS.QModelIndex_delete(n3);
    }

    protected void listBase_remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if ((n = this.listBase_indexOf(string, 0)) < 0) {
            SWT.error(5);
        }
        this.listBase_remove(n);
    }

    protected void listBase_remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = this.listBase_getItemCount();
        if (n < 0 || n2 > n3 - 1) {
            SWT.error(6);
        }
        OS.ListModel_beginRemoveRows(this.dataModelHandle, 0, n, n2);
        for (int i = n2; i >= n; --i) {
            int n4 = OS.QAbstractItemModel_index(this.dataModelHandle, i, 0, 0);
            OS.ListModel_remove(this.dataModelHandle, i);
            OS.QModelIndex_delete(n4);
        }
        OS.ListModel_endRemoveRows(this.dataModelHandle);
    }

    protected void listBase_remove(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            SWT.error(4);
        }
        if ((n = nArray.length) < 1) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n2 = this.listBase_getItemCount();
        int n3 = nArray2[0];
        int n4 = nArray2[nArray2.length - 1];
        if (n3 < 0 || n4 > n2 - 1) {
            SWT.error(6);
        }
        int n5 = -1;
        for (int i = n - 1; i > -1; --i) {
            if (nArray2[i] == n5) continue;
            this.listBase_remove(nArray2[i]);
            n5 = nArray2[i];
        }
    }

    protected void listBase_removeAll() {
        this.checkWidget();
        int n = this.listBase_getItemCount();
        if (n < 1) {
            return;
        }
        OS.ListModel_beginRemoveRows(this.dataModelHandle, 0, 0, n - 1);
        OS.ListModel_clearList(this.dataModelHandle);
        OS.ListModel_endRemoveRows(this.dataModelHandle);
    }

    protected void listBase_setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            SWT.error(4);
        }
        this.listBase_removeAll();
        int n = stringArray.length;
        if (n < 1) {
            return;
        }
        OS.ListModel_beginInsertRows(this.dataModelHandle, 0, 0, n - 1);
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) {
                SWT.error(5);
            }
            OS.ListModel_append(this.dataModelHandle, stringArray[i]);
        }
        OS.ListModel_endInsertRows(this.dataModelHandle);
    }

    protected int listBase_getTopIndex() {
        this.checkWidget();
        if (this.listBase_getItemCount() < 1) {
            return 0;
        }
        return OS.QAbstractItemView_swt_indexAt(this.internal_topHandle(), 1, 1);
    }

    protected void listBase_setTopIndex(int n) {
        this.checkWidget();
        if (n < 0 || n > this.listBase_getItemCount() - 1) {
            return;
        }
        int n2 = OS.QAbstractItemModel_index(this.dataModelHandle, n, 0, 0);
        OS.QAbstractItemView_scrollTo(this.internal_topHandle(), n2, 1);
        OS.QModelIndex_delete(n2);
    }

    protected void releaseHandle() {
        super.releaseHandle();
        this.dataModelHandle = 0;
        this.selectionModelHandle = 0;
    }
}

