/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.qt.OS;

public class ListUtils {
    public static void add(int n, String string, Image image) {
        if (string == null) {
            SWT.error(4);
        }
        OS.QListWidget_addItem(n, string, image != null ? image.internal_getIconHandle() : 0);
    }

    public static void add(int n, String string, Image image, int n2) {
        if (string == null) {
            SWT.error(4);
        }
        if (n2 < 0 || n2 > OS.QListWidget_count(n)) {
            SWT.error(6);
        }
        OS.QListWidget_insertItem(n, n2, string, image != null ? image.internal_getIconHandle() : 0);
    }

    public static void deselect(int n, int n2) {
        if (n2 < 0 || n2 >= OS.QListWidget_count(n)) {
            return;
        }
        OS.QListWidget_swt_selectIndex(n, n2, 4);
    }

    public static void deselect(int n, int[] nArray) {
        int n2;
        if (nArray == null) {
            SWT.error(4);
        }
        if ((n2 = nArray.length) == 0) {
            return;
        }
        OS.QListWidget_swt_selectArray(n, nArray, n2, 4, false);
    }

    public static void deselect(int n, int n2, int n3) {
        if (n2 > n3 || n3 < 0) {
            return;
        }
        int n4 = OS.QListWidget_count(n);
        if (n2 > n4 - 1) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        OS.QListWidget_swt_selectRange(n, n2, n3, 4);
    }

    public static void deselectAll(int n) {
        OS.QListWidget_swt_selectRange(n, 0, OS.QListWidget_count(n) - 1, 4);
    }

    public static int getFocusIndex(int n) {
        return OS.QListWidget_currentRow(n);
    }

    public static String getItem(int n, int n2) {
        String string;
        if (n2 < 0 || n2 >= OS.QListWidget_count(n)) {
            SWT.error(6);
        }
        if ((string = OS.QListWidget_swt_itemText(n, n2)) == null) {
            SWT.error(8);
        }
        return string;
    }

    public static int getItemCount(int n) {
        return OS.QListWidget_count(n);
    }

    public static int getItemHeight(int n) {
        int n2 = 0;
        if (OS.QListWidget_count(n) > 0) {
            n2 = OS.QAbstractItemView_sizeHintForRow(n, 0);
        } else {
            ListUtils.add(n, "", null);
            n2 = OS.QAbstractItemView_sizeHintForRow(n, 0);
            ListUtils.remove(n, 0);
        }
        return n2;
    }

    public static String[] getItems(int n) {
        String[] stringArray = OS.QListWidget_swt_itemTexts(n);
        if (stringArray == null) {
            if (OS.QListWidget_count(n) == 0) {
                return new String[0];
            }
            SWT.error(8);
            return null;
        }
        if (OS.QListWidget_count(n) != stringArray.length) {
            SWT.error(36);
            return null;
        }
        return stringArray;
    }

    public static String[] getSelection(int n) {
        int[] nArray = OS.QListWidget_swt_selectedRows(n, 0);
        if (nArray == null || nArray.length <= 0) {
            return new String[0];
        }
        ListUtils.sort(nArray);
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = OS.QListWidget_swt_itemText(n, nArray[i]);
            if (stringArray[i] != null) continue;
            SWT.error(8);
        }
        return stringArray;
    }

    public static int getSelectionCount(int n) {
        int[] nArray = OS.QListWidget_swt_selectedRows(n, 0);
        if (nArray != null) {
            return nArray.length;
        }
        return 0;
    }

    public static int[] getSelectionIndices(int n) {
        int[] nArray = OS.QListWidget_swt_selectedRows(n, 0);
        if (nArray == null) {
            nArray = new int[]{};
        }
        ListUtils.sort(nArray);
        return nArray;
    }

    public static int indexOf(int n, String string, int n2) {
        if (string == null) {
            SWT.error(4);
        }
        if (n2 < 0 || n2 > OS.QListWidget_count(n) - 1) {
            return -1;
        }
        return OS.QListWidget_swt_indexOf(n, string, n2);
    }

    public static boolean isSelected(int n, int n2) {
        if (n2 < 0 || n2 > OS.QListWidget_count(n) - 1) {
            return false;
        }
        return OS.QListWidget_swt_isItemSelected(n, n2);
    }

    public static void remove(int n, int n2) {
        if (n2 < 0 || n2 >= OS.QListWidget_count(n)) {
            SWT.error(6);
        }
        OS.QListWidget_swt_removeIndex(n, n2);
    }

    public static void remove(int n, String string) {
        int n2;
        if (string == null) {
            SWT.error(4);
        }
        if ((n2 = OS.QListWidget_swt_indexOf(n, string, 0)) == -1) {
            SWT.error(5);
        }
        OS.QListWidget_swt_removeIndex(n, n2);
    }

    public static void remove(int n, int n2, int n3) {
        if (n2 > n3) {
            return;
        }
        int n4 = OS.QListWidget_count(n);
        if (n2 < 0 || n3 >= n4 || n2 > n4) {
            SWT.error(6);
        }
        OS.QListWidget_swt_removeRange(n, n2, n3);
    }

    public static int[] remove(int n, int[] nArray) {
        int n2;
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length == 0) {
            return nArray;
        }
        int[] nArray2 = ListUtils.sortAndRemoveDuplicates(nArray);
        if (nArray2[0] >= (n2 = OS.QListWidget_count(n)) || nArray2[0] < 0 || nArray2[nArray2.length - 1] >= n2) {
            SWT.error(6);
        }
        OS.QListWidget_swt_removeArray(n, nArray2, nArray2.length);
        return nArray2;
    }

    public static void removeAll(int n) {
        OS.QListWidget_clear(n);
    }

    public static void select(int n, int n2, boolean bl) {
        if (n2 < 0 || n2 >= OS.QListWidget_count(n)) {
            return;
        }
        int n3 = 2;
        if (!bl) {
            n3 |= 1;
        }
        OS.QListWidget_swt_selectIndex(n, n2, n3);
        if (!bl) {
            OS.QListWidget_swt_setFocusIndex(n, n2);
        }
    }

    public static void select(int n, String string, boolean bl) {
        if (string == null) {
            ListUtils.deselectAll(n);
            return;
        }
        int n2 = OS.QListWidget_swt_indexOf(n, string, 0);
        if (n2 == -1) {
            SWT.error(5);
        }
        int n3 = 2;
        if (!bl) {
            n3 |= 1;
        }
        OS.QListWidget_swt_selectIndex(n, n2, n3);
        if (!bl) {
            OS.QListWidget_swt_setFocusIndex(n, n2);
        }
    }

    public static void select(int n, int n2, int n3, boolean bl) {
        if (n2 > n3 || n3 < 0) {
            return;
        }
        if (n2 == n3) {
            ListUtils.select(n, n2, bl);
            return;
        }
        if (!bl) {
            return;
        }
        int n4 = OS.QListWidget_count(n);
        if (n2 > n4 - 1) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        OS.QListWidget_swt_selectRange(n, n2, n3, 2);
    }

    public static void select(int n, int[] nArray, boolean bl) {
        int n2;
        if (nArray == null) {
            SWT.error(4);
        }
        if ((n2 = nArray.length) == 1) {
            ListUtils.select(n, nArray[0], bl);
            return;
        }
        if (n2 == 0 || !bl) {
            return;
        }
        OS.QListWidget_swt_selectArray(n, nArray, n2, 2, false);
    }

    public static void selectAll(int n, boolean bl) {
        int n2 = OS.QListWidget_count(n);
        if (!bl && n2 != 1) {
            return;
        }
        OS.QListWidget_swt_selectRange(n, 0, n2 - 1, 2);
    }

    public static void setFocusIndex(int n, int n2, boolean bl) {
        OS.QListWidget_swt_setFocusIndex(n, n2);
        if (!bl) {
            int n3 = 2;
            OS.QListWidget_swt_selectIndex(n, n2, n3 |= 1);
        }
    }

    public static void setItems(int n, String[] stringArray, Image[] imageArray) {
        if (stringArray == null) {
            SWT.error(4);
        }
        if (imageArray != null && imageArray.length != stringArray.length) {
            SWT.error(6);
        }
        ListUtils.removeAll(n);
        int n2 = stringArray.length;
        if (n2 <= 0) {
            return;
        }
        int[] nArray = null;
        if (imageArray != null) {
            nArray = new int[imageArray.length];
            for (int i = 0; i < imageArray.length; ++i) {
                nArray[i] = imageArray[i] != null ? imageArray[i].internal_getIconHandle() : 0;
            }
        }
        OS.QListWidget_addItems(n, stringArray, nArray);
    }

    public static void setSelection(int n, int n2) {
        int n3 = OS.QListWidget_count(n);
        OS.QListWidget_swt_selectRange(n, 0, n3 - 1, 4);
        if (n2 < 0 || n2 > n3 - 1) {
            return;
        }
        OS.QListWidget_swt_selectIndex(n, n2, 2);
        OS.QListWidget_scrollToItem(n, n2, 0);
        OS.QListWidget_swt_setFocusIndex(n, n2);
    }

    public static void setSelection(int n, int n2, int n3, boolean bl) {
        int n4 = OS.QListWidget_count(n);
        OS.QListWidget_swt_selectRange(n, 0, n4 - 1, 4);
        if (n3 < 0 || n2 > n3 || !bl && n2 != n3) {
            return;
        }
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        OS.QListWidget_swt_selectRange(n, n2, n3, 2);
        OS.QListWidget_scrollToItem(n, n3, 0);
        OS.QListWidget_swt_setFocusIndex(n, n3);
    }

    public static void setSelection(int n, int[] nArray, boolean bl) {
        if (nArray == null) {
            SWT.error(4);
        }
        int n2 = OS.QListWidget_count(n);
        OS.QListWidget_swt_selectRange(n, 0, n2 - 1, 4);
        int n3 = nArray.length;
        if (n3 == 0 || !bl && n3 > 1) {
            return;
        }
        OS.QListWidget_swt_selectArray(n, nArray, n3, 2, true);
    }

    public static void setSelection(int n, String[] stringArray, boolean bl) {
        if (stringArray == null) {
            SWT.error(4);
        }
        int n2 = OS.QListWidget_count(n);
        OS.QListWidget_swt_selectRange(n, 0, n2 - 1, 4);
        int n3 = stringArray.length;
        if (n3 == 0 || !bl && n3 > 1) {
            return;
        }
        int n4 = 2;
        if (!bl) {
            n4 |= 1;
        }
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            for (int j = -1; j < n2 && (j = OS.QListWidget_swt_indexOf(n, string, j >= 0 ? j : 0)) > -1; ++j) {
                n5 = j;
                OS.QListWidget_swt_selectIndex(n, j, n4);
            }
        }
        OS.QListWidget_scrollToItem(n, n5, 0);
        OS.QListWidget_swt_setFocusIndex(n, n5);
    }

    public static void showSelection(int n) {
        OS.QListWidget_scrollToItem(n, OS.QListWidget_currentRow(n), 0);
    }

    public static void sort(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = n / 2; i > 0; i /= 2) {
            for (int j = i; j < n; ++j) {
                for (int k = j - i; k >= 0; k -= i) {
                    if (nArray2[k] <= nArray2[k + i]) continue;
                    int n2 = nArray2[k];
                    nArray2[k] = nArray2[k + i];
                    nArray2[k + i] = n2;
                }
            }
        }
    }

    public static int[] sortAndRemoveDuplicates(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        ListUtils.sort(nArray2);
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            if (i > 0 && n2 == nArray2[i]) continue;
            n2 = nArray2[i];
            Integer n3 = new Integer(n2);
            vector.addElement(n3);
        }
        int[] nArray3 = new int[vector.size()];
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = (Integer)vector.elementAt(i);
        }
        return nArray3;
    }
}

