/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt.graphics;

import org.eclipse.swt.internal.qt.graphics.OS;
import org.eclipse.swt.internal.qt.graphics.Utils;

public final class FontUtils {
    private int iFontHandle;

    public FontUtils(int n) {
        this.checkState();
        this.setFont(n);
    }

    public int getAscent() {
        this.checkState();
        return OS.fontUtils_getAscent(this.iFontHandle);
    }

    public void getBoundingRect(int[] nArray, String string) {
        this.checkState();
        if (nArray == null || string == null) {
            throw new NullPointerException("rect or str is null");
        }
        if (string.length() == 0) {
            for (int i = 0; i < 4; ++i) {
                nArray[i] = 0;
            }
            return;
        }
        if (nArray.length < 4) {
            throw new IllegalArgumentException("rect size is < 4");
        }
        OS.fontUtils_getBoundingRect(this.iFontHandle, nArray, string);
    }

    public int getDescent() {
        this.checkState();
        return OS.fontUtils_getDescent(this.iFontHandle);
    }

    public void setFont(int n) {
        this.checkState();
        if (n == 0) {
            throw new IllegalArgumentException("fontHandle is 0");
        }
        this.iFontHandle = n;
    }

    public int stringWidth(String string) {
        this.checkState();
        if (string == null) {
            throw new NullPointerException("str is null");
        }
        if (string.length() == 0) {
            return 0;
        }
        return OS.fontUtils_getStringWidth(this.iFontHandle, string);
    }

    private void checkState() {
        Utils.validateUiThread();
    }
}

