/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt.graphics;

import org.eclipse.swt.internal.qt.graphics.Buffer;
import org.eclipse.swt.internal.qt.graphics.Image;
import org.eclipse.swt.internal.qt.graphics.OS;
import org.eclipse.swt.internal.qt.graphics.RenderingTarget;
import org.eclipse.swt.internal.qt.graphics.SurfaceCache;
import org.eclipse.swt.internal.qt.graphics.Utils;
import org.eclipse.swt.internal.qt.graphics.WindowSurface;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class GraphicsContext {
    public static final int RECT_X = 0;
    public static final int RECT_Y = 1;
    public static final int RECT_WIDTH = 2;
    public static final int RECT_HEIGHT = 3;
    public static final int BLENDING_MODE_SRC = 10;
    public static final int BLENDING_MODE_SRC_OVER = 11;
    public static final int BLENDING_MODE_XOR = 12;
    public static final int STROKE_NO = 0;
    public static final int STROKE_SOLID = 1;
    public static final int STROKE_DOT = 2;
    public static final int STROKE_DASH = 3;
    public static final int STROKE_DASH_DOT = 4;
    public static final int STROKE_DASH_DOT_DOT = 5;
    public static final int TEXT_SINGLE_LINE = 256;
    public static final int TEXT_DONT_CLIP = 512;
    public static final int TEXT_EXPAND_TABS = 1024;
    public static final int TEXT_SHOW_MNEMONIC = 2048;
    public static final int TEXT_WORD_WRAP = 4096;
    public static final int TEXT_WRAP_ANYWHERE = 8192;
    public static final int TEXT_HIDE_MNEMONIC = 32768;
    public static final int TEXT_DONT_PRINT = 16384;
    public static final int TEXT_INCLUDE_TRAILING_SPACES = 0x8000000;
    public static final int TEXT_JUSTIFICATIONFORCED = 65536;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_HCENTER = 4;
    public static final int ALIGNMENT_JUSTIFY = 8;
    public static final int ALIGNMENT_TOP = 32;
    public static final int ALIGNMENT_BOTTOM = 64;
    public static final int ALIGNMENT_VCENTER = 128;
    static final int TYPE_NONE = -1;
    static final int TYPE_MAINWINDOW = 0;
    static final int TYPE_WIDGET = 1;
    static final int TYPE_IMAGE = 2;
    static final int TYPE_BUFFER = 3;
    int handle = -1;
    private boolean iDisposed;
    private RenderingTarget iTarget = null;

    public GraphicsContext() {
        this(0);
    }

    public GraphicsContext(int n) {
        Utils.validateUiThread();
        this.handle = OS.graphicsContext_init(n);
        this.iTarget = new RenderingTarget();
        this.iDisposed = false;
    }

    public WindowSurface getWindowSurface() {
        SurfaceCache surfaceCache;
        WindowSurface windowSurface;
        this.checkState();
        if (this.iTarget.getType() == 3) {
            return null;
        }
        Object object = this.iTarget.getTarget();
        if (this.iTarget.getType() == 1 && !(object instanceof Shell)) {
            object = ((Control)object).getShell();
        }
        if ((windowSurface = (surfaceCache = SurfaceCache.getInstance()).getSurface(object)) == null) {
            windowSurface = new WindowSurface(OS.graphicsContext_get_windowsurface(this.handle));
            if (this.iTarget.getType() == 1) {
                surfaceCache.addSurface(windowSurface, object, true);
            } else {
                surfaceCache.addSurface(windowSurface, object, false);
            }
            return windowSurface;
        }
        return windowSurface;
    }

    public void bindTarget(Object object) {
        int n;
        int n2;
        Utils.validateUiThread();
        if (this.iDisposed) {
            throw new IllegalStateException("GraphicsContext already disposed");
        }
        if (object == null) {
            throw new NullPointerException("Null target");
        }
        if (this.iTarget.getTarget() != null) {
            throw new IllegalStateException("Already bound to target: " + this.iTarget.getTarget());
        }
        this.iTarget.reset();
        if (object instanceof Widget) {
            if (((Widget)object).isDisposed()) {
                throw new IllegalArgumentException("Target already disposed: " + object);
            }
            n2 = ((Widget)object).handle;
            n = 1;
        } else if (object instanceof Image) {
            if (((Image)object).isDisposed()) {
                throw new IllegalArgumentException("Target already disposed: " + object);
            }
            n2 = ((Image)object).handle;
            n = 2;
        } else if (object instanceof Display) {
            if (((Display)object).isDisposed()) {
                throw new IllegalArgumentException("Target already disposed: " + object);
            }
            n2 = org.eclipse.swt.internal.qt.OS.QApplication_desktop();
            n = 1;
        } else if (object instanceof Buffer) {
            if (((Buffer)object).isDisposed()) {
                throw new IllegalArgumentException("Target already disposed: " + object);
            }
            n2 = ((Buffer)object).handle;
            n = 3;
        } else {
            throw new IllegalArgumentException("Unsupported target type: " + object);
        }
        this.doBind(n2, n, object);
        this.iTarget.setHandle(n2);
        this.iTarget.setType(n);
        this.iTarget.setTarget(object);
    }

    public Object getBoundTarget() {
        this.checkState();
        return this.iTarget.getTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTarget() {
        Utils.validateUiThread();
        if (this.iDisposed) {
            throw new IllegalStateException("GraphicsContext already disposed");
        }
        if (this.iTarget.getTarget() != null) {
            GraphicsContext graphicsContext = this;
            synchronized (graphicsContext) {
                OS.graphicsContext_releaseTarget(this.handle);
                if (this.iTarget.getType() == 2) {
                    ((Image)this.iTarget.getTarget()).notifyRelease();
                }
            }
            this.iTarget.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBind(int n, int n2, Object object) {
        GraphicsContext graphicsContext = this;
        synchronized (graphicsContext) {
            OS.graphicsContext_bindTarget(this.handle, n, n2);
            if (this.iTarget.getType() == 2) {
                ((Image)object).notifyBind(this);
            }
        }
    }

    public void render(Buffer buffer) {
        this.checkState();
        if (buffer == null) {
            throw new NullPointerException("buffer is null");
        }
        if (buffer.isDisposed()) {
            throw new IllegalArgumentException("buffer already disposed");
        }
        OS.graphicsContext_render(this.handle, buffer.handle);
    }

    public void copyArea(Image image, int n, int n2) {
        this.checkState();
        if (image == null) {
            throw new NullPointerException("Target image is null");
        }
        OS.graphicsContext_copyArea(this.handle, image.handle, n, n2);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkState();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        OS.graphicsContext_copyArea(this.handle, n, n2, n3, n4, n5, n6);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkState();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        OS.graphicsContext_drawArc(this.handle, n, n2, n3, n4, n5, n6);
    }

    public void drawEllipse(int n, int n2, int n3, int n4) {
        this.checkState();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        OS.graphicsContext_drawEllipse(this.handle, n, n2, n3, n4);
    }

    public void drawFocus(int n, int n2, int n3, int n4) {
        this.checkState();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        OS.graphicsContext_drawFocus(this.handle, n, n2, n3, n4);
    }

    public void drawImage(Image image, int n, int n2) {
        this.checkState();
        OS.graphicsContext_drawImage(this.handle, image.handle, n, n2);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.checkState();
        OS.graphicsContext_drawImage(this.handle, image.handle, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.checkState();
        OS.graphicsContext_drawLine(this.handle, n, n2, n3, n4);
    }

    public void drawPoint(int n, int n2) {
        this.checkState();
        OS.graphicsContext_drawPoint(this.handle, n, n2);
    }

    public void drawPolygon(int[] nArray) {
        this.checkState();
        if (nArray == null) {
            throw new NullPointerException("pointaArray is null");
        }
        OS.graphicsContext_drawPolygon(this.handle, nArray);
    }

    public void drawPolyline(int[] nArray) {
        this.checkState();
        if (nArray == null) {
            throw new NullPointerException("pointaArray is null");
        }
        OS.graphicsContext_drawPolyline(this.handle, nArray);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.checkState();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        OS.graphicsContext_drawRect(this.handle, n, n2, n3, n4);
    }

    public void drawRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7) {
        this.checkState();
        if (nArray == null) {
            throw new NullPointerException("rgbData is null");
        }
        if (n < 0 || nArray.length < n + n5) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        if (Math.abs(n2) < n5) {
            return;
        }
        OS.graphicsContext_drawRGB(this.handle, nArray, n, n2, n3, n4, n5, n6, bl, n7);
    }

    public void drawRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.checkState();
        this.drawRGB(nArray, n, n2, n3, n4, n5, n6, bl, 100);
    }

    public void drawRGB(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.checkState();
        if (byArray == null) {
            throw new NullPointerException("rgbData is null");
        }
        if (n < 0 || byArray.length < n + n5) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        if (Math.abs(n2) < n5) {
            return;
        }
        OS.graphicsContext_drawRGB(this.handle, byArray, byArray2, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void drawRGB(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, int n8) {
        this.checkState();
        if (sArray == null) {
            throw new NullPointerException("rgbData is null");
        }
        if (n < 0 || sArray.length < n + n5) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        if (Math.abs(n2) < n5) {
            return;
        }
        OS.graphicsContext_drawRGB(this.handle, sArray, n, n2, n3, n4, n5, n6, bl, n7, n8);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkState();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        OS.graphicsContext_drawRoundRect(this.handle, n, n2, n3, n4, n5, n6);
    }

    public void drawString(String string, int n, int n2, boolean bl) {
        this.checkState();
        this.drawString(string, n, n2, 0, 0, 33, 256, bl);
    }

    public void drawString(String string, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.checkState();
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        if ((n6 & 0x4000) == 16384) {
            return;
        }
        OS.graphicsContext_drawString(this.handle, string, n, n2, n3, n4, n5, n6, bl);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkState();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        OS.graphicsContext_fillArc(this.handle, n, n2, n3, n4, n5, n6);
    }

    public void fillEllipse(int n, int n2, int n3, int n4) {
        this.checkState();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        OS.graphicsContext_fillEllipse(this.handle, n, n2, n3, n4);
    }

    public void fillGradientRect(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.checkState();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        OS.graphicsContext_fillGradientRect(this.handle, n, n2, n3, n4, bl, bl2);
    }

    public void fillPolygon(int[] nArray) {
        this.checkState();
        if (nArray == null) {
            throw new NullPointerException("pointaArray is null");
        }
        OS.graphicsContext_fillPolygon(this.handle, nArray);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.checkState();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        OS.graphicsContext_fillRect(this.handle, n, n2, n3, n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkState();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        OS.graphicsContext_fillRoundRect(this.handle, n, n2, n3, n4, n5, n6);
    }

    public int getAdvancedCharacterWidth(char c) {
        this.checkState();
        return OS.graphicsContext_getCharacterWidth(this.handle, c, true);
    }

    public int getCharacterWidth(char c) {
        this.checkState();
        return OS.graphicsContext_getCharacterWidth(this.handle, c, false);
    }

    public void getFontMetricsData(int[] nArray, int n) {
        this.getFontMetricsData(nArray, n, true);
    }

    public void getFontMetricsData(int[] nArray, int n, boolean bl) {
        if (bl) {
            this.checkState();
        }
        if (nArray == null) {
            throw new NullPointerException("data is null");
        }
        OS.graphicsContext_getFontMetricsData(this.handle, nArray, n);
    }

    public int getBackgroundAlpha() {
        this.checkState();
        return OS.graphicsContext_getBackgroundAlpha(this.handle);
    }

    public int getBackgroundColor() {
        this.checkState();
        return OS.graphicsContext_getBackgroundColor(this.handle);
    }

    public int getBlendingMode() {
        this.checkState();
        return OS.graphicsContext_getBlendingMode(this.handle);
    }

    public void getClip(int[] nArray) {
        this.checkState();
        if (nArray == null) {
            throw new NullPointerException("clip is null");
        }
        if (nArray.length < 4) {
            throw new IllegalArgumentException("clip array size is < 4");
        }
        OS.graphicsContext_getClip(this.handle, nArray);
    }

    public int getForegroundAlpha() {
        this.checkState();
        return OS.graphicsContext_getForegroundAlpha(this.handle);
    }

    public int getForegroundColor() {
        this.checkState();
        return OS.graphicsContext_getForegroundColor(this.handle);
    }

    public void getTextBoundingBox(int[] nArray, String string, int n, int n2) {
        this.getTextBoundingBox(nArray, string, n, n2, 0, 0, 0, 0);
    }

    public void getTextBoundingBox(int[] nArray, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkState();
        if (nArray == null) {
            throw new NullPointerException("boundingBox is null");
        }
        if (nArray.length < 4) {
            throw new IllegalArgumentException("boundingBox size must not be < 4");
        }
        OS.graphicsContext_getTextBoundingBox(this.handle, nArray, string, n, n2, n3, n4, n5, n6);
    }

    public int getStrokeWidth() {
        this.checkState();
        return OS.graphicsContext_getStrokeWidth(this.handle);
    }

    public int getStrokeStyle() {
        this.checkState();
        return OS.graphicsContext_getStrokeStyle(this.handle);
    }

    public int getTranslateX() {
        this.checkState();
        return OS.graphicsContext_getTranslateX(this.handle);
    }

    public int getTranslateY() {
        this.checkState();
        return OS.graphicsContext_getTranslateY(this.handle);
    }

    public void setBackgroundAlpha(int n) {
        this.checkState();
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("alpha is not in range 0-255");
        }
        OS.graphicsContext_setBackgroundAlpha(this.handle, n);
    }

    public void setBackgroundColor(int n, boolean bl) {
        this.checkState();
        OS.graphicsContext_setBackgroundColor(this.handle, n, bl);
    }

    public void setBackgroundColor(int n, int n2, int n3) {
        this.checkState();
        if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255) {
            throw new IllegalArgumentException();
        }
        OS.graphicsContext_setBackgroundColor(this.handle, 0xFF000000 | n << 16 | n2 << 8 | n3, false);
    }

    public void setBackgroundColor(int n, int n2, int n3, int n4) {
        this.checkState();
        if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255 || n4 < 0 || n4 > 255) {
            throw new IllegalArgumentException();
        }
        OS.graphicsContext_setBackgroundColor(this.handle, n << 24 | n2 << 16 | n3 << 8 | n4, true);
    }

    public void setBlendingMode(int n) {
        this.checkState();
        if (n != 10 && n != 11 && n != 12) {
            throw new IllegalArgumentException("Illegal blending mode");
        }
        OS.graphicsContext_setBlendingMode(this.handle, n);
    }

    public boolean hasClipping() {
        this.checkState();
        return OS.graphicsContext_hasClipping(this.handle);
    }

    public void cancelClipping() {
        this.checkState();
        OS.graphicsContext_cancelClipping(this.handle);
    }

    public void setClip(int n, int n2, int n3, int n4, boolean bl) {
        this.checkState();
        if (n3 < 0 || n4 < 0) {
            return;
        }
        OS.graphicsContext_setClip(this.handle, n, n2, n3, n4, bl);
    }

    public void setFont(int n) {
        this.checkState();
        OS.graphicsContext_setFont(this.handle, n);
    }

    public void setForegroundAlpha(int n) {
        this.checkState();
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("alpha is not in range 0-255");
        }
        OS.graphicsContext_setForegroundAlpha(this.handle, n);
    }

    public void setForegroundColor(int n, boolean bl) {
        this.checkState();
        OS.graphicsContext_setForegroundColor(this.handle, n, bl);
    }

    public void setForegroundColor(int n, int n2, int n3) {
        this.checkState();
        if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255) {
            throw new IllegalArgumentException();
        }
        OS.graphicsContext_setForegroundColor(this.handle, 0xFF000000 | n << 16 | n2 << 8 | n3, false);
    }

    public void setForegroundColor(int n, int n2, int n3, int n4) {
        this.checkState();
        if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255 || n4 < 0 || n4 > 255) {
            throw new IllegalArgumentException();
        }
        OS.graphicsContext_setForegroundColor(this.handle, n << 24 | n2 << 16 | n3 << 8 | n4, true);
    }

    public void setStrokeStyle(int n) {
        this.checkState();
        if (n != 1 && n != 2 && n != 3 && n != 4 && n != 5) {
            throw new IllegalArgumentException("Invalid style: " + n);
        }
        OS.graphicsContext_setStrokeStyle(this.handle, n);
    }

    public void setStrokeWidth(int n) {
        this.checkState();
        if (n < 0) {
            throw new IllegalArgumentException("Invalid width: " + n);
        }
        OS.graphicsContext_setStrokeWidth(this.handle, n);
    }

    public void translate(int n, int n2) {
        this.checkState();
        OS.graphicsContext_translate(this.handle, n, n2);
    }

    public void scale(int n, int n2) {
        this.checkState();
        OS.graphicsContext_scale(this.handle, n, n2);
    }

    public void resetTransform() {
        this.checkState();
        OS.graphicsContext_resetTransform(this.handle);
    }

    public void dispose() {
        Utils.validateUiThread();
        if (this.iDisposed) {
            return;
        }
        if (this.iTarget.getTarget() != null) {
            this.releaseTarget();
        }
        OS.graphicsContext_dispose(this.handle);
        this.handle = 0;
        this.iDisposed = true;
    }

    public boolean isDisposed() {
        return this.iDisposed;
    }

    public int getHandle() {
        return this.handle;
    }

    private void checkState() {
        Utils.validateUiThread();
        if (this.iDisposed) {
            throw new IllegalStateException("GraphicsContext already disposed");
        }
        if (this.iTarget.getTarget() == null) {
            throw new IllegalStateException("No target set");
        }
    }

    public int saveSurfaceasImage(String string) {
        this.checkState();
        return OS.graphicsContext_saveSurfaceasImage(this.handle, string);
    }
}

