/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt.graphics;

import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.qt.graphics.GraphicsContext;
import org.eclipse.swt.internal.qt.graphics.OS;
import org.eclipse.swt.internal.qt.graphics.SurfaceCache;
import org.eclipse.swt.internal.qt.graphics.Utils;

public final class Image {
    public static final int TRANS_NONE = 100;
    public static final int TRANS_ROT90 = 101;
    public static final int TRANS_ROT180 = 102;
    public static final int TRANS_ROT270 = 103;
    public static final int TRANS_MIRROR = 104;
    public static final int TRANS_MIRROR_ROT90 = 105;
    public static final int TRANS_MIRROR_ROT180 = 106;
    public static final int TRANS_MIRROR_ROT270 = 107;
    public static final int TRANS_FLIP_HORIZONTAL = 108;
    public static final int TRANS_FLIP_VERTICAL = 109;
    public static final int FORMAT_IMG_NONE = 0;
    public static final int FORMAT_IMG_RGB32 = 1;
    public static final int FORMAT_IMG_ARGB32 = 2;
    public static final int FORMAT_IMG_ARGB32PREMULTIPLIED = 3;
    public static final int FORMAT_IMG_RGB16 = 4;
    public static final int FORMAT_IMG_RGB555 = 5;
    public static final int FORMAT_IMG_RGB444 = 6;
    public static final int FORMAT_IMG_RGB4444PREMULTIPLIED = 7;
    public static final int FORMAT_IMG_MONO = 8;
    int handle = -1;
    int pixmapHandle = -1;
    int imageHandle = -1;
    private boolean iDisposed;
    private int iWidth;
    private int iHeight;
    private final int DEFAULT_FILL_COLOR = -1;
    private boolean iIsBound = false;
    private GraphicsContext iGC = null;

    Image(int n) {
        Utils.validateUiThread();
        if (n == 0) {
            throw new OutOfMemoryError();
        }
        this.iDisposed = false;
        this.handle = n;
        this.updateSize();
    }

    public Image(int n, int n2) {
        Utils.validateUiThread();
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("width or height is equal or less than 0");
        }
        this.handle = OS.image_create(n, n2, -1);
        this.iDisposed = false;
        this.updateSize();
    }

    public Image(int n, int n2, int n3) {
        Utils.validateUiThread();
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("width or height is equal or less than 0");
        }
        this.handle = OS.image_create(n, n2, n3);
        this.iDisposed = false;
        this.updateSize();
    }

    public Image(Image image) {
        this(image, 0, 0, 0, 0);
    }

    public Image(Image image, int n, int n2, int n3, int n4) {
        if (image == null) {
            throw new IllegalArgumentException("img is null");
        }
        this.handle = OS.image_create(image.handle, n, n2, n3, n4);
        this.iDisposed = false;
        this.updateSize();
    }

    public Image(ImageData imageData) {
        if (imageData == null) {
            throw new IllegalArgumentException("imageData is null");
        }
        this.handle = OS.image_create(imageData);
        this.iDisposed = false;
        this.updateSize();
    }

    public Image(int[] nArray, int n, int n2, boolean bl) {
        if (nArray == null) {
            throw new IllegalArgumentException("argbData is null");
        }
        this.handle = OS.image_create(nArray, n, n2, bl);
        this.iDisposed = false;
        this.updateSize();
    }

    public void dispose() {
        Utils.validateUiThread();
        if (this.handle != 0 || !this.iDisposed) {
            if (this.iIsBound) {
                this.iIsBound = false;
                if (this.iGC != null) {
                    this.iGC.releaseTarget();
                }
                this.iGC = null;
            }
            SurfaceCache.getInstance().deleteSurface(this);
            OS.image_dispose(this.handle);
            this.handle = 0;
            this.iDisposed = true;
        }
    }

    public boolean isDisposed() {
        return this.iDisposed;
    }

    public int getFormat() {
        this.checkState();
        return OS.image_getFormat(this.handle);
    }

    public int getHeight() {
        this.checkState();
        return this.iHeight;
    }

    public int getWidth() {
        this.checkState();
        return this.iWidth;
    }

    public void getRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkState();
        if (nArray == null) {
            throw new IllegalArgumentException("argbData is null");
        }
        if (n3 + n5 > this.getWidth() || n4 + n6 > this.getHeight() || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Area specified is out of image bounds");
        }
        if (n2 < 0) {
            int n7 = n5 - 1;
            int n8 = 0;
            int n9 = n + (n7 - n3) + (n8 - n4) * n2;
            if (n9 > nArray.length - 1) {
                throw new ArrayIndexOutOfBoundsException("Data does not fit in given array");
            }
            n7 = 0;
            n8 = n6 - 1;
            n9 = n + (n7 - n3) + (n8 - n4) * n2;
            if (n9 < 0) {
                throw new ArrayIndexOutOfBoundsException("Data does not fit in given array");
            }
        } else if (nArray.length < n + n2 * n6 || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Data does not fit in given array");
        }
        if ((n2 > 0 ? n2 : -n2) < n5) {
            throw new IllegalArgumentException("scanlength is less than width");
        }
        OS.image_getRGB(this.handle, nArray, n, n2, n3, n4, n5, n6);
    }

    public void getRGB(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkState();
        if (byArray == null) {
            throw new IllegalArgumentException("argbData is null");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("transparencyMask is null");
        }
        if (n3 + n5 > this.getWidth() || n4 + n6 > this.getHeight() || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Area specified is out of image bounds");
        }
        if (n2 < 0) {
            int n8 = n5 - 1;
            int n9 = 0;
            int n10 = n + (n8 - n3) + (n9 - n4) * n2;
            if (n10 > byArray.length - 1) {
                throw new ArrayIndexOutOfBoundsException("Data does not fit in given array");
            }
            if (n10 > byArray2.length - 1) {
                throw new ArrayIndexOutOfBoundsException("Mask does not fit in given array");
            }
            n8 = 0;
            n9 = n6 - 1;
            n10 = n + (n8 - n3) + (n9 - n4) * n2;
            if (n10 < 0) {
                throw new ArrayIndexOutOfBoundsException("Data does not fit in given array");
            }
        } else {
            if (byArray.length < n + n2 * n6 || n < 0) {
                throw new ArrayIndexOutOfBoundsException("Data does not fit in given array");
            }
            if (byArray2.length < n + n2 * n6 || n < 0) {
                throw new ArrayIndexOutOfBoundsException("Mask does not fit in given array");
            }
        }
        if ((n2 > 0 ? n2 : -n2) < n5) {
            throw new IllegalArgumentException("scanlength is less than width");
        }
        OS.image_getRGB(this.handle, byArray, byArray2, n, n2, n3, n4, n5, n6, n7);
    }

    public void getRGB(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkState();
        if (sArray == null) {
            throw new IllegalArgumentException("argbData is null");
        }
        if (n3 + n5 > this.getWidth() || n4 + n6 > this.getHeight() || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Area specified is out of image bounds");
        }
        if (n2 < 0) {
            int n8 = n5 - 1;
            int n9 = 0;
            int n10 = n + (n8 - n3) + (n9 - n4) * n2;
            if (n10 > sArray.length - 1) {
                throw new ArrayIndexOutOfBoundsException("Data does not fit in given array");
            }
            n8 = 0;
            n9 = n6 - 1;
            n10 = n + (n8 - n3) + (n9 - n4) * n2;
            if (n10 < 0) {
                throw new ArrayIndexOutOfBoundsException("Data does not fit in given array");
            }
        } else if (sArray.length < n + n2 * n6 || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Data does not fit in given array");
        }
        if ((n2 > 0 ? n2 : -n2) < n5) {
            throw new IllegalArgumentException("scanlength is less than width");
        }
        OS.image_getRGB(this.handle, sArray, n, n2, n3, n4, n5, n6, n7);
    }

    public void transform(int n) {
        this.checkState();
        if (n != 100 && n != 101 && n != 102 && n != 103 && n != 104 && n != 105 && n != 106 && n != 107) {
            throw new IllegalArgumentException("Invalid transform");
        }
        if (n == 100) {
            return;
        }
        OS.image_transform(this.handle, n);
        this.updateSize();
    }

    void notifyBind(GraphicsContext graphicsContext) {
        this.iGC = graphicsContext;
        this.iIsBound = true;
    }

    void notifyRelease() {
        this.iGC = null;
        this.iIsBound = false;
    }

    public int getHandle() {
        this.checkState();
        return this.handle;
    }

    public synchronized int getNativePixmapHandle() {
        this.checkState();
        if (this.pixmapHandle == -1) {
            this.pixmapHandle = OS.image_getPixmapHandle(this.handle);
        }
        return this.pixmapHandle;
    }

    public ImageData getImageData() {
        this.checkState();
        return OS.image_getImageData(this.handle);
    }

    private void checkState() {
        Utils.validateUiThread();
        if (this.iDisposed) {
            throw new IllegalStateException("Image already disposed");
        }
    }

    private void updateSize() {
        this.iWidth = OS.image_getWidth(this.handle);
        this.iHeight = OS.image_getHeight(this.handle);
    }

    public static Image createImage(ImageData imageData) {
        if (imageData == null) {
            throw new IllegalArgumentException("imageData is null");
        }
        int n = OS.image_create(imageData);
        return new Image(n);
    }
}

