/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt.graphics;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.internal.qt.graphics.Image;
import org.eclipse.swt.internal.qt.graphics.OS;
import org.eclipse.swt.internal.qt.graphics.Utils;

public final class ImageLoader {
    private final int BLOCKSIZE = 0;
    private int handle = 0;
    private boolean iDisposed;

    public ImageLoader() {
        Utils.validateUiThread();
        this.handle = OS.imageLoader_init();
        if (this.handle == 0) {
            throw new OutOfMemoryError();
        }
        this.iDisposed = false;
    }

    public void dispose() {
        Utils.validateUiThread();
        if (this.iDisposed) {
            return;
        }
        OS.imageLoader_dispose(this.handle);
        this.handle = 0;
        this.iDisposed = true;
    }

    public boolean isDisposed() {
        return this.iDisposed;
    }

    public Image loadImage(String string) throws IOException {
        this.checkState();
        if (string == null) {
            throw new NullPointerException("path is null");
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("Cannot obtain inputstream for given path: " + string);
        }
        return this.loadImage(inputStream);
    }

    public Image loadImage(byte[] byArray, int n, int n2) throws IOException {
        this.checkState();
        if (byArray == null) {
            throw new NullPointerException("data is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("offset is negative");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("length is negative or zero");
        }
        if (n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("offset and lenght define invalid range");
        }
        OS.imageLoader_beginStream(this.handle, n2 + 1);
        OS.imageLoader_append(this.handle, n2, n, byArray);
        return new Image(OS.imageLoader_endStream(this.handle));
    }

    public Image loadImage(InputStream inputStream) throws IOException {
        this.checkState();
        if (inputStream == null) {
            throw new NullPointerException("InputStream is null");
        }
        int n = 0;
        int n2 = 0;
        n2 = inputStream.available();
        if (n2 == 0) {
            throw new IllegalArgumentException("Empty file");
        }
        byte[] byArray = new byte[n2];
        OS.imageLoader_beginStream(this.handle, n2);
        try {
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                OS.imageLoader_append(this.handle, n, 0, byArray);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        return new Image(OS.imageLoader_endStream(this.handle));
    }

    private void checkState() {
        Utils.validateUiThread();
        if (this.iDisposed) {
            throw new IllegalStateException("Image loader already disposed");
        }
    }
}

