/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt.graphics;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.internal.qt.graphics.SurfaceCacheItemDisposeListener;
import org.eclipse.swt.internal.qt.graphics.WindowSurface;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

final class SurfaceCache {
    private Hashtable iSurfaces = new Hashtable();
    private boolean iDisposeListenerSet = false;
    private static SurfaceCache iInstance = null;
    private static boolean iDisposed = false;

    static SurfaceCache getInstance() {
        if (iDisposed) {
            return null;
        }
        if (iInstance == null) {
            iInstance = new SurfaceCache();
        }
        return iInstance;
    }

    private SurfaceCache() {
    }

    void addSurface(WindowSurface windowSurface, Object object, boolean bl) {
        if (iDisposed) {
            throw new IllegalStateException("Cache already disposed");
        }
        if (windowSurface == null || object == null) {
            throw new NullPointerException("Parameter surface or target is null");
        }
        if (this.iSurfaces.containsKey(object)) {
            return;
        }
        this.iSurfaces.put(object, windowSurface);
        if (object instanceof Widget) {
            if (!this.iDisposeListenerSet) {
                this.setDisposeListener(((Widget)object).getDisplay());
            }
            if (bl) {
                ((Widget)object).addDisposeListener(new SurfaceCacheItemDisposeListener());
            }
        }
    }

    void deleteSurface(Object object) {
        if (iDisposed) {
            throw new IllegalStateException("Cache already disposed");
        }
        if (object == null) {
            throw new NullPointerException("Parameter target is null");
        }
        if (this.iSurfaces.containsKey(object)) {
            this.iSurfaces.remove(object);
        }
    }

    WindowSurface getSurface(Object object) {
        if (iDisposed) {
            throw new IllegalStateException("Cache already disposed");
        }
        if (object == null) {
            throw new NullPointerException("Parameter target is null");
        }
        return (WindowSurface)this.iSurfaces.get(object);
    }

    boolean isDisposed() {
        return iDisposed;
    }

    void dispose() {
        if (iDisposed) {
            return;
        }
        if (this.iSurfaces == null) {
            return;
        }
        if (this.iSurfaces.size() == 0) {
            return;
        }
        Enumeration enumeration = this.iSurfaces.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            ((WindowSurface)this.iSurfaces.get(k)).dispose();
            this.iSurfaces.remove(k);
        }
        iDisposed = true;
        this.iSurfaces = null;
    }

    private void setDisposeListener(Display display) {
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SurfaceCache.getInstance().dispose();
            }
        });
        this.iDisposeListenerSet = true;
    }
}

