/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.qt.graphics;

import org.eclipse.swt.internal.qt.graphics.OS;
import org.eclipse.swt.internal.qt.graphics.Utils;

public final class WindowSurface {
    static final int QImage = 1;
    static final int PBuffer = 2;
    private int iHandle;
    private boolean iDisposed;

    WindowSurface(int n) {
        this.iHandle = n;
        this.iDisposed = false;
    }

    public int getType() {
        this.checkState();
        int n = OS.windowsurface_getType(this.iHandle);
        return n;
    }

    public int getHandle() {
        this.checkState();
        return this.iHandle;
    }

    public void dispose() {
        Utils.validateUiThread();
        if (this.iHandle != 0) {
            OS.windowsurface_dispose(this.iHandle);
            this.iHandle = 0;
        }
    }

    private void checkState() {
        Utils.validateUiThread();
        if (this.iDisposed) {
            throw new IllegalStateException("WindowSurface already disposed");
        }
    }
}

