/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    int alignment;
    Image image;

    public Button(Composite composite, int n) {
        super(composite, Button.checkStyle(n));
    }

    static int checkStyle(int n) {
        if (((n = Button.checkBits(n, 8, 32, 16, 2, 0, 0)) & 0xA) != 0) {
            return Button.checkBits(n, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((n & 0x30) != 0) {
            return Button.checkBits(n, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        return n;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
    }

    protected void createHandle(int n) {
        int n2 = 58;
        switch (this.style & n2) {
            case 32: {
                this.handle = OS.QCheckBox_new();
                break;
            }
            case 16: {
                this.handle = OS.QRadioButton_new();
                if ((this.getParent().style & 0x400000) == 0) break;
                OS.QAbstractButton_setAutoExclusive(this.handle, false);
                break;
            }
            default: {
                this.handle = OS.QPushButton_new();
                if ((this.style & 2) != 0) {
                    OS.QAbstractButton_setCheckable(this.handle, true);
                }
                if ((this.style & 0x800000) == 0) break;
                OS.QPushButton_setFlat(this.handle, true);
            }
        }
        this.state |= 8;
    }

    protected void hookEvents() {
        int n = OS.SignalHandler_new(this.handle, this.display, 1002);
        OS.QObject_connectOrThrow(this.handle, "released()", n, "widgetSignal()", 0);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.alignment & 0x4000) != 0) {
            return 16384;
        }
        if ((this.alignment & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.alignment & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return OS.QAbstractButton_isChecked(this.handle);
    }

    public String getText() {
        this.checkWidget();
        return OS.QAbstractButton_text(this.handle);
    }

    void qt_swt_event_focusWasGained() {
        super.qt_swt_event_focusWasGained();
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        if ((this.style & 8) != 0) {
            this.menuShell().setDefaultButton(this, false);
        }
    }

    void qt_swt_event_focusWasLost() {
        super.qt_swt_event_focusWasLost();
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        if ((this.style & 8) != 0 && OS.QPushButton_isDefault(this.handle)) {
            this.menuShell().setDefaultButton(null, false);
        }
    }

    void qt_signal_released() {
        this.sendEvent(13);
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        this.alignment = n;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            Rectangle rectangle = image.getBounds();
            OS.QAbstractButton_setIconSize(this.handle, rectangle.width, rectangle.height);
            OS.QAbstractButton_setIcon(this.handle, image.internal_getIconHandle());
        } else {
            OS.QAbstractButton_setIcon(this.handle, Image.internal_getNullIconHandle());
        }
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.QAbstractButton_setChecked(this.handle, bl);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        OS.QAbstractButton_setText(this.handle, string);
    }

    boolean setRadioFocus(boolean bl) {
        if ((this.style & 0x10) == 0 || !this.getSelection()) {
            return false;
        }
        return bl ? this.setTabItemFocus() : this.setFocus(bl ? 1 : 7);
    }

    boolean isTabGroup() {
        if ((this.style & 0x10) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    Control getShortcutHandler() {
        return null;
    }

    void setDefault(boolean bl) {
        if ((this.style & 8) == 0) {
            return;
        }
        OS.QPushButton_setDefault(this.handle, bl);
    }
}

