/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.internal.qt.TextUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    int comboTextHandle;
    public static final int LIMIT = Short.MAX_VALUE;

    public Combo(Composite composite, int n) {
        super(composite, n);
    }

    protected void createHandle(int n) {
        this.handle = OS.QComboBox_new();
        OS.QComboBox_setEditable(this.handle, true);
        OS.QComboBox_setSizeAdjustPolicy(this.handle, 2);
        OS.QComboBox_setInsertPolicy(this.handle, 0);
        this.comboTextHandle = OS.QComboBox_lineEdit(this.handle);
        if ((this.style & 8) != 0) {
            OS.QLineEdit_setReadOnly(this.comboTextHandle, true);
        }
        this.state |= 8;
    }

    protected void register() {
        super.register();
        this.display.addWidget(this.comboTextHandle, this);
    }

    protected void deregister() {
        super.deregister();
        this.display.removeWidget(this.comboTextHandle);
    }

    protected void releaseHandle() {
        this.comboTextHandle = 0;
        super.releaseHandle();
    }

    public int internal_topHandle() {
        return this.handle;
    }

    public void add(String string) {
        this.add(string, this.getItemCount());
    }

    public void add(String string, int n) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n > (n2 = this.getItemCount()) || n < 0) {
            this.error(6);
        }
        OS.QComboBox_insertItem(this.internal_topHandle(), string, n);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void hookEvents() {
        super.hookEvents();
        int n = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1008);
        OS.QObject_connectOrThrow(this.internal_topHandle(), "currentIndexChanged(const QString&)", n, "widgetSignal(const QString&)", 0);
        int n2 = OS.SignalHandler_new(this.comboTextHandle, this.display, 1011);
        OS.QObject_connectOrThrow(this.comboTextHandle, "returnPressed()", n2, "widgetSignal()", 0);
        int n3 = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1009);
        OS.QObject_connectOrThrow(this.internal_topHandle(), "editTextChanged(const QString&)", n3, "widgetSignal(const QString&)", 0);
    }

    protected void qt_signal_text_changed(String string) {
        this.sendEvent(24);
    }

    protected void qt_signal_selectionChanged(int n, int n2) {
        this.setSelection(new Point(0, OS.QLineEdit_text(this.comboTextHandle).length()));
        this.sendEvent(13);
    }

    protected void qt_signal_return_pressed() {
        this.sendEvent(14);
    }

    protected boolean qt_event_keypress(int n, int n2, int n3, int n4) {
        if (super.qt_event_keypress(n, n2, n3, n4)) {
            return true;
        }
        if (!this.hooks(25) && !this.filters(25) && this.getTextLimit() <= 0) {
            return false;
        }
        Event event = this.makeKeyEvent(n2, n3, n4);
        return TextUtils.handle_keypress(0, this.comboTextHandle, n2, n3, n4, event, this.getTextLimit(), this);
    }

    int getTraversalTypeForKey(int n, int n2, int n3) {
        int n4 = 0;
        switch (n) {
            case 0x1000004: 
            case 0x1000005: {
                n4 = 0;
                break;
            }
            default: {
                n4 = super.getTraversalTypeForKey(n, n2, n3);
            }
        }
        return n4;
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        this.traverseDoit = false;
        this.traverseCancel = false;
        if (n == 128) {
            this.traverseDoit = true;
            return;
        }
        switch (n2) {
            case 0x1000004: 
            case 0x1000005: {
                this.traverseDoit = false;
                break;
            }
            case 0x1000001: {
                this.traverseDoit = true;
                break;
            }
            case 0x1000012: 
            case 0x1000014: {
                this.traverseDoit = false;
                break;
            }
            case 0x1000013: 
            case 0x1000015: {
                this.traverseDoit = true;
                break;
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        OS.QLineEdit_setCursorPosition(this.comboTextHandle, 0);
    }

    public void copy() {
        this.checkWidget();
        TextUtils.copy(0, this.comboTextHandle);
    }

    public void cut() {
        this.checkWidget();
        TextUtils.cut(0, this.comboTextHandle, this);
    }

    public void deselect(int n) {
        this.checkWidget();
        if (this.getSelectionIndex() == n) {
            this.deselectAll();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        OS.QComboBox_swt_deselect(this.internal_topHandle());
    }

    public String getItem(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n >= n2 || n < 0) {
            this.error(6);
        }
        String string = OS.QComboBox_itemText(this.internal_topHandle(), n);
        return string;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.QComboBox_count(this.internal_topHandle());
    }

    public int getItemHeight() {
        this.checkWidget();
        return OS.QComboBox_swt_getItemHeight(this.internal_topHandle());
    }

    public String[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getItem(i);
        }
        return stringArray;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        return OS.QComboBox_swt_getSelection(this.internal_topHandle());
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.QComboBox_currentIndex(this.internal_topHandle());
    }

    public String getText() {
        this.checkWidget();
        return TextUtils.getText(0, this.comboTextHandle);
    }

    public int getTextHeight() {
        this.checkWidget();
        return OS.QComboBox_swt_getTextHeight(this.internal_topHandle());
    }

    public int getTextLimit() {
        this.checkWidget();
        return OS.QLineEdit_maxLength(this.comboTextHandle);
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return OS.QComboBox_maxVisibleItems(this.internal_topHandle());
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = OS.QComboBox_findText(this.internal_topHandle(), string);
        if (0 > n || n > n2) {
            return -1;
        }
        return n2;
    }

    public void paste() {
        this.checkWidget();
        TextUtils.paste(0, this.comboTextHandle, this.getTextLimit(), this);
    }

    public void remove(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n >= n2 || n < 0) {
            this.error(6);
        }
        OS.QComboBox_removeItem(this.internal_topHandle(), n);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (n >= n3 || n < 0 || n2 >= n3) {
            this.error(6);
        }
        if (n > n2) {
            return;
        }
        for (int i = n2; i >= n; --i) {
            OS.QComboBox_removeItem(this.internal_topHandle(), i);
        }
    }

    public void remove(String string) {
        this.checkWidget();
        int n = this.indexOf(string, 0);
        if (n == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        OS.QComboBox_clear(this.internal_topHandle());
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            return;
        }
        OS.QComboBox_setCurrentIndex(this.internal_topHandle(), n);
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        if (string == null) {
            this.error(4);
        }
        OS.QComboBox_setItemText(this.internal_topHandle(), string, n);
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        OS.QComboBox_swt_setItems(this.internal_topHandle(), stringArray);
    }

    public void setOrientation(int n) {
        this.setOrientation(this.internal_topHandle(), n);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TextUtils.setSelection(0, this.comboTextHandle, point.x, point.y);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.getText().equals(string)) {
            return;
        }
        if ((string = TextUtils.verify(0, this.comboTextHandle, string, this, this.getTextLimit(), 0, OS.QLineEdit_text(this.comboTextHandle).length())) == null) {
            return;
        }
        OS.QComboBox_swt_setText(this.internal_topHandle(), string);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n <= 0) {
            this.error(7);
        }
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        }
        OS.QLineEdit_setMaxLength(this.comboTextHandle, n);
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        OS.QComboBox_setMaxVisibleItems(this.internal_topHandle(), n);
    }

    protected void doRedraw() {
        this.checkWidget();
        OS.QWidget_update(this.internal_topHandle());
    }

    protected void doRedraw(int n, int n2, int n3, int n4) {
        this.checkWidget();
        OS.QWidget_update(this.internal_topHandle(), n, n2, n3, n4);
    }

    protected int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = n4;
        if (bl2) {
            Point point = OS.QWidget_sizeHint(this.internal_topHandle());
            n5 = point.y;
            if (n4 < point.y) {
                n5 = n4;
            }
        }
        return super.setBounds(n, n2, n3, n5, bl, bl2);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (bl) {
            OS.QWidget_updateGeometry(this.internal_topHandle());
        }
        OS.QComboBox_setSizeAdjustPolicy(this.internal_topHandle(), 0);
        Point point = OS.QWidget_sizeHint(this.internal_topHandle());
        int n3 = 64;
        int n4 = 64;
        if (point.x >= 0) {
            n3 = point.x;
        }
        if (point.y >= 0) {
            n4 = point.y;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1 && n2 < point.y) {
            n4 = n2;
        }
        OS.QComboBox_setSizeAdjustPolicy(this.internal_topHandle(), 2);
        return new Point(n3, n4);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Point point = OS.QWidget_frameSize(this.internal_topHandle());
        Rectangle rectangle = OS.QWidget_rect(this.handle);
        Point point2 = OS.QWidget_mapTo(this.handle, this.internal_topHandle(), rectangle.x, rectangle.y);
        int n5 = point2.x;
        int n6 = point2.y;
        int n7 = point.x - rectangle.width - n5;
        int n8 = point.y - rectangle.height - n6;
        Point point3 = this.computeSize(-1, n4, false);
        return new Rectangle(n - n5, n2 - n6, n3 + n5 + n7, (n4 < point3.y ? n4 : point3.y) + n6 + n8);
    }

    protected void setBackground() {
        int n = OS.QComboBox_view(this.handle);
        if (n != 0) {
            OS.QWidget_swt_unsetPalette(n);
        }
        super.setBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void backgroundImageInherited(Image image) {
        int n = 0;
        int n2 = OS.QComboBox_view(this.handle);
        if (n2 == 0) {
            return;
        }
        try {
            n = OS.QWidget_swt_palette_new(n2);
            int[] nArray = this.getBackgroundImageRoles();
            for (int i = 0; i < nArray.length; ++i) {
                OS.QPalette_swt_setBrush(n, nArray[i], image.internal_getPixmapHandle());
            }
            OS.QWidget_setPalette(n2, n);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            OS.QPalette_delete(n);
            throw throwable;
        }
        OS.QPalette_delete(n);
    }
}

