/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    Layout layout;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;

    Composite() {
    }

    public Composite(Composite composite, int n) {
        super(composite, n);
    }

    protected void addControl(Control control) {
    }

    void checkBuffered() {
        if ((this.state & 2) == 0) {
            super.checkBuffered();
        }
    }

    void checkNoBackground() {
        if ((this.style & 0x40000) != 0 && this.handle != 0) {
            OS.QWidget_setAttribute(this.handle, 9, true);
        }
    }

    void checkNoFocus() {
        if ((this.style & 0x80000) != 0) {
            OS.QWidget_setFocusPolicy(this.handle, 0);
            int n = this.internal_topHandle();
            if (n != this.handle) {
                OS.QWidget_setFocusPolicy(n, 0);
            }
        }
    }

    void checkNoRedrawResize() {
        if ((this.style & 0x100000) != 0 && this.handle != 0) {
            OS.QWidget_setAttribute(this.handle, 5, true);
        }
    }

    protected void checkSubclass() {
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if ((this.state & 2) != 0) {
            Point point;
            if (this.layout != null) {
                if (n == -1 || n2 == -1) {
                    boolean bl2 = (this.state & 0x40000) != 0;
                    this.state &= 0xFFFBFFFF;
                    point = this.layout.computeSize(this, n, n2, bl |= bl2);
                } else {
                    point = new Point(n, n2);
                }
            } else {
                point = this.minimumSize(n, n2, bl);
            }
            if (point.x == 0) {
                point.x = 64;
            }
            if (point.y == 0) {
                point.y = 64;
            }
            if (n != -1) {
                point.x = n;
            }
            if (n2 != -1) {
                point.y = n2;
            }
            Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
            return new Point(rectangle.width, rectangle.height);
        }
        return super.computeSize(n, n2, bl);
    }

    Control[] computeTabList() {
        Control[] controlArray = super.computeTabList();
        if (controlArray.length == 0) {
            return controlArray;
        }
        Control[] controlArray2 = this.tabList != null ? this._getTabList() : this._getChildren();
        for (int i = 0; i < controlArray2.length; ++i) {
            Control control = controlArray2[i];
            Control[] controlArray3 = control.computeTabList();
            if (controlArray3.length == 0) continue;
            Control[] controlArray4 = new Control[controlArray.length + controlArray3.length];
            System.arraycopy(controlArray, 0, controlArray4, 0, controlArray.length);
            System.arraycopy(controlArray3, 0, controlArray4, controlArray.length, controlArray3.length);
            controlArray = controlArray4;
        }
        return controlArray;
    }

    protected void createHandle(int n) {
        super.createHandle(n);
        this.scrollAreaHandle = OS.QScrollArea_new(0);
        this.handle = OS.QAbstractScrollArea_viewPort(this.scrollAreaHandle);
        int n2 = this.internal_topHandle();
        int n3 = OS.QWidget_focusPolicy(n2) & 0xFFFFFFFD;
        OS.QWidget_setFocusPolicy(n2, n3);
        this.state |= 0xA;
    }

    boolean doHandleMouseEvent(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl = super.doHandleMouseEvent(n, n2, n3, n4, n5, n6, n7);
        if ((this.state & 2) != 0) {
            Control[] controlArray;
            bl = true;
            if (n == 3 && (this.style & 0x80000) == 0 && this.hooksKeys() && ((controlArray = this.getChildren()) == null || controlArray.length == 0)) {
                this.setFocus(7);
            }
        }
        return bl;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] menuArray = super.findMenus(control);
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control2 = controlArray[i];
            Menu[] menuArray2 = control2.findMenus(control);
            if (menuArray2.length == 0) continue;
            Menu[] menuArray3 = new Menu[menuArray.length + menuArray2.length];
            System.arraycopy(menuArray, 0, menuArray3, 0, menuArray.length);
            System.arraycopy(menuArray2, 0, menuArray3, menuArray.length, menuArray2.length);
            menuArray = menuArray3;
        }
        return menuArray;
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i] != control) continue;
            ++n;
        }
        if (n == 0) {
            return;
        }
        Control[] controlArray = null;
        int n2 = this.tabList.length - n;
        if (n2 != 0) {
            controlArray = new Control[n2];
            int n3 = 0;
            for (int i = 0; i < this.tabList.length; ++i) {
                if (this.tabList[i] == control) continue;
                controlArray[n3++] = this.tabList[i];
            }
        }
        this.tabList = controlArray;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    protected Control[] _getChildren() {
        return this._getChildren(this.handle);
    }

    protected Control[] _getChildren(int n) {
        int[] nArray = OS.QObject_children(n);
        int n2 = nArray.length;
        if (n2 == 0) {
            return new Control[0];
        }
        Control[] controlArray = new Control[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Widget widget;
            int n4 = nArray[i];
            if (n4 == 0 || (widget = this.display.getWidget(n4)) == null || widget == this || !(widget instanceof Control) || widget instanceof Shell) continue;
            controlArray[n3++] = (Control)widget;
        }
        if (n3 == n2) {
            return controlArray;
        }
        Control[] controlArray2 = new Control[n3];
        System.arraycopy(controlArray, 0, controlArray2, 0, n3);
        return controlArray2;
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] controlArray = this._getTabList();
        if (controlArray == null) {
            int n;
            int n2 = 0;
            Control[] controlArray2 = this._getChildren();
            for (n = 0; n < controlArray2.length; ++n) {
                if (!controlArray2[n].isTabGroup()) continue;
                ++n2;
            }
            controlArray = new Control[n2];
            n = 0;
            for (int i = 0; i < controlArray2.length; ++i) {
                if (!controlArray2[i].isTabGroup()) continue;
                controlArray[n++] = controlArray2[i];
            }
        }
        return controlArray;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int n = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i].isDisposed()) continue;
            ++n;
        }
        if (n == this.tabList.length) {
            return this.tabList;
        }
        Control[] controlArray = new Control[n];
        int n2 = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i].isDisposed()) continue;
            controlArray[n2++] = this.tabList[i];
        }
        this.tabList = controlArray;
        return this.tabList;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean bl) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(bl, false);
    }

    void layout(boolean bl, boolean bl2) {
        this.checkWidget();
        if (this.layout == null && !bl2) {
            return;
        }
        this.markLayout(bl, bl2);
        this.updateLayout(bl2);
    }

    void markLayout(boolean bl, boolean bl2) {
        if (this.layout != null) {
            this.state |= 0x20000;
            if (bl) {
                this.state |= 0x40000;
            }
        }
        if (bl2) {
            Control[] controlArray = this._getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                controlArray[i].markLayout(bl, bl2);
            }
        }
    }

    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < controlArray.length; ++i) {
            Rectangle rectangle = controlArray[i].getBounds();
            n3 = Math.max(n3, rectangle.x + rectangle.width);
            n4 = Math.max(n4, rectangle.y + rectangle.height);
        }
        return new Point(n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void qt_swt_event_widgetResized(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (this.isDisposed()) {
            return;
        }
        if (n == this.handle && this.isMirrored() && (n6 = n4 - n2) != 0) {
            Control[] controlArray = this._getChildren();
            try {
                this.display.blockedQtEventType = 2005;
                for (int i = 0; i < controlArray.length; ++i) {
                    Control control = controlArray[i];
                    if (control.isDisposed()) continue;
                    int n7 = control.internal_topHandle();
                    Point point = OS.QWidget_pos(n7);
                    OS.QWidget_move(n7, point.x + n6, point.y);
                }
                Object var13_12 = null;
                this.display.blockedQtEventType = 0;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                this.display.blockedQtEventType = 0;
                throw throwable;
            }
        }
        super.qt_swt_event_widgetResized(n, n2, n3, n4, n5);
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
    }

    void redrawChildren() {
        super.redrawChildren();
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            if ((control.state & 0x8000) == 0) continue;
            control.redraw();
            control.redrawChildren();
        }
    }

    protected void releaseChildren(boolean bl) {
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            if (control == null || control.isDisposed()) continue;
            control.release(false);
        }
        super.releaseChildren(bl);
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
    }

    protected void removeControl(Control control) {
        this.fixTabList(control);
    }

    public void setBackgroundMode(int n) {
        this.checkWidget();
        this.backgroundMode = n;
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].updateBackgroundMode();
        }
    }

    protected int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n5 & 0x100) != 0 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return n5;
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.setFocus(7);
    }

    protected boolean setFocus(int n) {
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            if (!control.getVisible() || !control.setFocus(n)) continue;
            return true;
        }
        return super.setFocus(n);
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    boolean setTabGroupFocus() {
        Control control;
        int n;
        boolean bl;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl2 = bl = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            bl = this.hooksKeys();
            if ((this.style & 0x1000000) != 0) {
                bl = true;
            }
        }
        if (bl && this.setTabItemFocus()) {
            return true;
        }
        Control[] controlArray = this._getChildren();
        for (n = 0; n < controlArray.length; ++n) {
            control = controlArray[n];
            if (!control.isTabItem() || !control.setRadioFocus(true)) continue;
            return true;
        }
        for (n = 0; n < controlArray.length; ++n) {
            control = controlArray[n];
            if (!control.isTabItem() || control.isTabGroup() || !control.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    public void setTabList(Control[] controlArray) {
        this.checkWidget();
        if (controlArray != null) {
            for (int i = 0; i < controlArray.length; ++i) {
                Control control = controlArray[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent == this) continue;
                this.error(32);
            }
            Control[] controlArray2 = new Control[controlArray.length];
            System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
            controlArray = controlArray2;
        }
        this.tabList = controlArray;
    }

    void updateBackground() {
        super.updateBackground();
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            if ((controlArray[i].state & 0x8000) == 0) continue;
            controlArray[i].updateBackground();
        }
    }

    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] controlArray = this._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].updateBackgroundMode();
        }
    }

    void updateLayout(boolean bl) {
        Composite composite = this.findDeferredControl();
        if (composite != null) {
            composite.state |= 0x80000;
            return;
        }
        if ((this.state & 0x20000) != 0) {
            boolean bl2 = (this.state & 0x40000) != 0;
            this.state &= 0xFFF9FFFF;
            this.layout.layout(this, bl2);
        }
        if (bl) {
            this.state &= 0xFFF7FFFF;
            Control[] controlArray = this._getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                controlArray[i].updateLayout(bl);
            }
        }
    }
}

