/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    String dialogID;
    static int dialogCount;

    public DirectoryDialog(Shell shell) {
        this(shell, 0);
    }

    public DirectoryDialog(Shell shell, int n) {
        super(shell, DirectoryDialog.checkStyle(shell, n));
        this.checkSubclass();
        this.dialogID = this.toString() + String.valueOf(++dialogCount);
    }

    protected static int checkStyle(Shell shell, int n) {
        if (((n &= 0xF7FFFFFF) & 0x4000000) == 0 && shell != null && (shell.style & 0x4000000) != 0) {
            n |= 0x4000000;
        }
        if ((n & 0x2000000) != 0 && (n & 0x4000000) != 0) {
            n &= 0xFDFFFFFF;
        }
        return n;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        this.checkDialog();
        DisposeListener disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (disposeEvent.widget == DirectoryDialog.this.parent) {
                    OS.QDialog_swt_closeDialogs(DirectoryDialog.this.parent.handle, DirectoryDialog.this.dialogID);
                }
            }
        };
        this.parent.addDisposeListener(disposeListener);
        int n = (this.style & 0x4000000) != 0 ? 1 : 0;
        String string = OS.QFileDialog_swt_getOpenDirectoryName(this.parent.handle, this.title, this.filterPath, this.dialogID, n);
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.removeDisposeListener(disposeListener);
        }
        if (string != null) {
            this.filterPath = string;
            int n2 = string.length();
            if (n2 > 0 && string.charAt(n2 - 1) == SEPARATOR) {
                this.filterPath = string.substring(0, n2 - 1);
            }
        } else {
            this.filterPath = null;
        }
        return this.filterPath;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    void checkDialog() {
        Display display;
        if (this.parent == null) {
            this.error(24);
        }
        if (this.parent.isDisposed()) {
            this.error(24);
        }
        if ((display = this.parent.display) == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
    }
}

