/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ApplicationUidWrapper;
import org.eclipse.swt.internal.ExitNotificationWrapper;
import org.eclipse.swt.internal.qt.CommandArranger;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.internal.qt.graphics.GraphicsContext;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    static int handle;
    int eventFilterHandle;
    static final String SWT_OBJECT_INDEX = "swt_obj_idx";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String REMOVE_WIDGET_KEY = "org.eclipse.swt.internal.removeWidget";
    static final String SWT_EVENT_FILTER = "swt_event_filter";
    public CommandArranger commandArranger;
    Event[] eventQueue;
    EventTable eventTable;
    EventTable filterTable;
    static String APP_NAME;
    int[] indexTable;
    int freeSlot;
    int lastHandle;
    Widget lastWidget;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    Shell[] modalShells;
    Dialog modalDialog;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    Tray tray;
    int[] timerHandles;
    Runnable[] timerRunnables;
    int lastEventTime;
    boolean noInterrupt;
    int blockedQtEventType;
    int defaultOrientation;
    static final int[][] KeyTable;
    static final int[][] KeyPadKeyTable;
    static Display Default;
    static Display[] Displays;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    static final String ERCP_MOBILE_PACKAGE_PREFIX = "org.eclipse.ercp.swt.mobile.";
    static final String INTERNAL_EXTENSION_PACKAGE_PREFIX = "org.eclipse.swt.internal.extension.";
    Object data;
    String[] keys;
    Object[] values;
    int shortcutOverrideKey;
    int shortcutOverrideModifier;
    int shortcutOverrideCharacter;
    Control mnemonicControl;
    int focusEvent;
    static /* synthetic */ Class class$org$eclipse$swt$graphics$Device;

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
    }

    public void addFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n, listener);
    }

    public void addListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    void addWidget(int n, Widget widget) {
        int n2;
        if (n == 0) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            n2 = this.freeSlot + 1024;
            int[] nArray = new int[n2];
            Widget[] widgetArray = new Widget[n2];
            System.arraycopy(this.indexTable, 0, nArray, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, widgetArray, 0, this.freeSlot);
            for (int i = this.freeSlot; i < n2 - 1; ++i) {
                nArray[i] = i + 1;
            }
            nArray[n2 - 1] = -1;
            this.indexTable = nArray;
            this.widgetTable = widgetArray;
        }
        n2 = this.freeSlot + 1;
        OS.QObject_setProperty(n, SWT_OBJECT_INDEX, n2);
        int n3 = this.freeSlot;
        this.freeSlot = this.indexTable[n3];
        this.indexTable[n3] = -2;
        this.widgetTable[n3] = widget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
        }
    }

    public void beep() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        OS.QApplication_beep();
    }

    private void checkDefaultOrientation(int n) {
        this.defaultOrientation = 0x2000000;
        String string = System.getProperty("org.eclipse.ercp.swt.defaultOrientation");
        if (string != null) {
            if (string.equals("system")) {
                this.defaultOrientation = n;
            } else if (string.equals("rtl")) {
                this.defaultOrientation = 0x4000000;
            }
        }
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean bl) {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            for (int i = 0; i < Displays.length; ++i) {
                if (Displays[i] == null) continue;
                if (!bl) {
                    SWT.error(20, null, " [multiple displays]");
                }
                if (Display.Displays[i].thread != thread) continue;
                SWT.error(22);
            }
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    void clearModal(Shell shell) {
        int n;
        if (this.modalShells == null) {
            return;
        }
        int n2 = this.modalShells.length;
        for (n = 0; n < n2 && this.modalShells[n] != shell; ++n) {
            if (this.modalShells[n] != null) continue;
            return;
        }
        if (n == n2) {
            return;
        }
        System.arraycopy(this.modalShells, n + 1, this.modalShells, n, --n2 - n);
        this.modalShells[n2] = null;
        if (n == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].updateModal();
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(deviceData);
        this.commandArranger = new CommandArranger();
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
        this.tryDestroy();
        if (handle != 0) {
            SWT.error(1);
        }
        if (OS.initUiThread(ApplicationUidWrapper.uid()) != 0) {
            SWT.error(1);
        }
        if ((handle = OS.QApplication_swt_new(this)) == 0) {
            SWT.error(1);
        }
        OS.QApplication_setQuitOnLastWindowClosed(false);
        int n = Display.translateDirection(OS.QApplication_layoutDirection());
        this.checkDefaultOrientation(n);
        if (n != 0x2000000) {
            OS.QApplication_setLayoutDirection(0);
        }
        this.eventFilterHandle = OS.EventHandler_new();
        OS.QObject_installEventFilter(handle, this.eventFilterHandle);
        OS.QObject_setProperty(handle, SWT_EVENT_FILTER, this.eventFilterHandle);
        this.paintDevice = OS.QApplication_swt_desktopPaintDevice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            for (int i = 0; i < Displays.length; ++i) {
                if (display != Displays[i]) continue;
                Display.Displays[i] = null;
            }
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
        OS.QObject_removeEventFilter(handle, this.eventFilterHandle);
        OS.EventHandler_destroy(this.eventFilterHandle);
        OS.QApplication_syncX();
        this.tryDestroy();
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        for (int i = 0; i < this.disposeList.length; ++i) {
            if (this.disposeList[i] != null) continue;
            this.disposeList[i] = runnable;
            return;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    void error(int n) {
        SWT.error(n);
    }

    final boolean eventProcess(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string) {
        if (this.blockedQtEventType == n2) {
            return false;
        }
        this.lastEventTime = n3;
        Widget widget = this.getWidget(n);
        if (!this.noInterrupt) {
            this.interrupt();
        }
        if (n2 < 1000) {
            return this.handleQtEvent(widget, n, n2, n4, n5, n6, n7, n8);
        }
        if (n2 > 2000) {
            return this.handleNativeSwtEvent(widget, n, n2, n3, n4, n5, n6, n7, n8);
        }
        return this.handleQtSignal(widget, n, n2, n4, n5, n6, n7, n8, string);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int n) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n);
    }

    Control findControl(int n) {
        if (n == 0) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(n)) != null && widget instanceof Control) {
                return (Control)widget;
            }
            if ((n = OS.QObject_parent(n)) == 0) break;
        } while (n != handle);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            for (int i = 0; i < Displays.length; ++i) {
                Display display = Displays[i];
                if (display == null || display.thread != thread) continue;
                return display;
            }
            return null;
        }
    }

    public Shell getActiveShell() {
        Widget widget;
        this.checkDevice();
        Shell shell = null;
        int n = OS.QApplication_activeWindow();
        if (n != 0 && (widget = this.getWidget(n)) instanceof Shell) {
            shell = (Shell)widget;
        }
        return shell;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return OS.QDesktopWidget_screenGeometry(OS.QApplication_desktop(), -1);
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return OS.QDesktopWidget_availableGeometry(OS.QApplication_desktop(), -1);
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(string)) continue;
            return this.values[i];
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (Default == null) {
                Default = new Display();
            }
            return Default;
        }
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.QApplication_doubleClickInterval();
    }

    public Control getFocusControl() {
        this.checkDevice();
        return this._getFocusControl();
    }

    Control _getFocusControl() {
        return this.findControl(OS.QApplication_focusWidget());
    }

    public int getIconDepth() {
        this.checkDevice();
        return super.getDepth();
    }

    int getLastEventTime() {
        return this.lastEventTime;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    public Shell[] getShells() {
        this.checkDevice();
        int n = 0;
        Shell[] shellArray = new Shell[16];
        for (int i = 0; i < this.widgetTable.length; ++i) {
            int n2;
            Widget widget = this.widgetTable[i];
            if (widget == null || !(widget instanceof Shell)) continue;
            for (n2 = 0; n2 < n && shellArray[n2] != widget; ++n2) {
            }
            if (n2 != n) continue;
            if (n == shellArray.length) {
                Shell[] shellArray2 = new Shell[n + 16];
                System.arraycopy(shellArray, 0, shellArray2, 0, n);
                shellArray = shellArray2;
            }
            shellArray[n++] = (Shell)widget;
        }
        if (n == shellArray.length) {
            return shellArray;
        }
        Shell[] shellArray3 = new Shell[n];
        System.arraycopy(shellArray, 0, shellArray3, 0, n);
        return shellArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            return this.synchronizer.syncThread;
        }
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (!OS.QSystemTrayIcon_isSystemTrayAvailable()) {
            return null;
        }
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            return this.thread;
        }
    }

    private final int getTimerHandleIndex(int n) {
        if (this.timerHandles == null) {
            return -1;
        }
        for (int i = 0; i < this.timerHandles.length; ++i) {
            if (this.timerHandles[i] != n) continue;
            return i;
        }
        return -1;
    }

    Widget getWidget(int n) {
        if (n == 0) {
            return null;
        }
        if (this.lastWidget != null && this.lastHandle == n) {
            return this.lastWidget;
        }
        int n2 = OS.QObject_property(n, SWT_OBJECT_INDEX) - 1;
        if (0 <= n2 && n2 < this.widgetTable.length) {
            this.lastHandle = n;
            this.lastWidget = this.widgetTable[n2];
            return this.lastWidget;
        }
        return null;
    }

    private final boolean handleNativeSwtEvent(Widget widget, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        switch (n2) {
            case 2006: {
                this.qt_swt_event_endKeyPressed();
                return true;
            }
            case 2007: {
                this.qt_swt_event_systemShutdown();
                return false;
            }
        }
        if (widget == null) {
            return false;
        }
        switch (n2) {
            case 2001: {
                widget.qt_swt_event_widgetPainted(n, n4, n5, n6, n7, n8);
                return false;
            }
            case 2003: {
                widget.qt_swt_event_focusWasLost();
                return false;
            }
            case 2002: {
                widget.qt_swt_event_focusWasGained();
                return false;
            }
            case 2004: {
                widget.qt_swt_event_widgetResized(n, n4, n5, n6, n7);
                return false;
            }
            case 2005: {
                widget.qt_swt_event_widgetMoved(n);
                return false;
            }
        }
        return false;
    }

    private final boolean handleQtEvent(Widget widget, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (widget == null) {
            return false;
        }
        switch (n2) {
            case 12: {
                return widget.qt_event_paint(n, n3, n4, n5, n6, n7);
            }
            case 6: {
                return widget.qt_event_keypress(n, n3, n4, n5);
            }
            case 7: {
                return widget.qt_event_keyrelease(n, n3, n4, n5);
            }
            case 2: {
                return widget.qt_event_mouseButtonPress(n, n3, n4, n5, n6, n7);
            }
            case 3: {
                return widget.qt_event_mouseButtonRelease(n, n3, n4, n5, n6, n7);
            }
            case 4: {
                return widget.qt_event_mouseButtonDblClick(n, n3, n4, n5, n6, n7);
            }
            case 5: {
                return widget.qt_event_mouseMove(n, n3, n4, n5, n6, n7);
            }
            case 19: {
                return widget.qt_event_close();
            }
            case 13: {
                return widget.qt_event_move(n);
            }
            case 14: {
                return widget.qt_event_resize(n);
            }
            case 8: {
                return widget.qt_event_focusIn(n3);
            }
            case 9: {
                return widget.qt_event_focusOut(n3);
            }
            case 82: {
                return widget.qt_event_contextmenu(n3, n4, n5);
            }
            case 117: {
                return widget.qt_event_shortcut(this.shortcutOverrideKey, this.shortcutOverrideModifier, this.shortcutOverrideCharacter);
            }
            case 51: {
                this.shortcutOverrideKey = n3;
                this.shortcutOverrideModifier = n4;
                this.shortcutOverrideCharacter = n5;
                return false;
            }
            case 24: {
                return widget.qt_event_windowActivate(n);
            }
            case 25: {
                return widget.qt_event_windowDeactivate(n);
            }
            case 105: {
                return widget.qt_event_windowStateChange(n, n3);
            }
        }
        return false;
    }

    private final boolean handleQtSignal(Widget widget, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        int n8 = -1;
        if (widget == null) {
            n8 = this.getTimerHandleIndex(n);
        }
        if (widget == null && n8 == -1) {
            return false;
        }
        switch (n2) {
            case 1000: {
                widget.qt_signal_pressed();
                return false;
            }
            case 1002: {
                widget.qt_signal_released();
                return false;
            }
            case 1010: {
                widget.qt_signal_slider_changed(n3);
                return false;
            }
            case 1019: {
                widget.qt_signal_slider_action_triggered(n3);
                return false;
            }
            case 1020: {
                widget.qt_signal_slider_released();
                return false;
            }
            case 1003: {
                this.qt_signal_timer(n8);
                return false;
            }
            case 1005: {
                widget.qt_signal_aboutToHide();
                return false;
            }
            case 1004: {
                widget.qt_signal_aboutToShow();
                return false;
            }
            case 1006: {
                widget.qt_signal_triggered(n3 > 0);
                return false;
            }
            case 1007: {
                widget.qt_signal_hover();
                return false;
            }
            case 1008: {
                widget.qt_signal_selectionChanged(n3, n4);
                return false;
            }
            case 1011: {
                widget.qt_signal_return_pressed();
                return false;
            }
            case 1015: {
                widget.qt_signal_table_itemSelectionChanged();
                return false;
            }
            case 1016: {
                widget.qt_signal_table_currentCellChanged(n3, n4, n5, n6);
                return false;
            }
            case 1017: {
                widget.qt_signal_table_cellChanged(n3, n4);
                return false;
            }
            case 1018: {
                widget.qt_signal_table_cellActivated(n3, n4);
                return false;
            }
            case 1012: {
                widget.qt_signal_list_itemSelectionChanged();
                return false;
            }
            case 1013: {
                widget.qt_signal_list_itemDoubleClicked(n3);
                return false;
            }
            case 1014: {
                widget.qt_signal_list_itemActivated(n3);
                return false;
            }
            case 1022: {
                widget.qt_signal_dateedit_dateTimeChanged();
                return false;
            }
            case 1030: {
                widget.qt_signal_tray_activated(n3);
                return false;
            }
            case 1031: {
                widget.qt_signal_tree_itemSelectionChanged();
                return false;
            }
            case 1032: {
                widget.qt_signal_tree_itemActivated(n3, n4);
                return false;
            }
            case 1033: {
                widget.qt_signal_tree_itemExpanded(n3);
                return false;
            }
            case 1034: {
                widget.qt_signal_tree_itemCollapsed(n3);
                return false;
            }
            case 1009: {
                widget.qt_signal_text_changed(string);
                return false;
            }
            case 1021: {
                widget.qt_signal_linkActivated(string);
                return false;
            }
            case 1035: {
                widget.qt_signal_current_tab_changed(n3);
                return true;
            }
            case 1036: {
                widget.qt_signal_abstractitemview_activated(n3, n4);
                return true;
            }
            case 1037: {
                widget.qt_signal_text_cursorPositionChanged(n3, n4);
                return true;
            }
            case 1038: {
                widget.qt_signal_text_selectionChanged();
                return true;
            }
        }
        return false;
    }

    protected void init() {
        super.init();
        this.initializeWidgetTable();
    }

    void initializeWidgetTable() {
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        for (int i = 0; i < 1023; ++i) {
            this.indexTable[i] = i + 1;
        }
        this.indexTable[1023] = -1;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        this.checkDevice();
        gCData.internalGc.releaseTarget();
        this.setScreenPaintingAttributes(false);
    }

    public int internal_new_GC(GCData gCData) {
        this.checkDevice();
        this.setScreenPaintingAttributes(true);
        gCData.internalGc = new GraphicsContext(OS.QApplication_desktop());
        gCData.drawable = OS.QWidget_swt_paintDevice(handle);
        gCData.device = this;
        gCData.background = Color.qt_new(this, 0xFFFFFF);
        gCData.foreground = Color.qt_new(this, 0);
        gCData.font = Font.qt_new(this, OS.SwtFontCache_cache(OS.QApplication_swt_font_new()));
        gCData.style &= 0xF7FFFFFF;
        gCData.buffered = false;
        gCData.internalGc.bindTarget(this);
        return gCData.internalGc.getHandle();
    }

    void interrupt() {
        int n = OS.QObject_thread(handle);
        int n2 = OS.QAbstractEventDispatcher_instance(n);
        OS.QAbstractEventDispatcher_interrupt(n2);
    }

    static boolean isValidClass(Class clazz) {
        int n;
        String string = clazz.getName();
        return string.substring(0, (n = string.lastIndexOf(46)) + 1).equals(PACKAGE_PREFIX) || string.substring(0, n + 1).equals(ERCP_MOBILE_PACKAGE_PREFIX) || string.substring(0, n + 1).equals(INTERNAL_EXTENSION_PACKAGE_PREFIX);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n, int n2) {
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            SWT.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            SWT.error(5);
        }
        Point point = new Point(n, n2);
        if (control2 != null && control != null) {
            point = control.toDisplay(point);
            point = control2.toControl(point);
        } else if (control2 != null) {
            point = control2.toControl(point);
        } else if (control != null) {
            point = control.toDisplay(point);
        }
        return point;
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control control, Control control2, int n, int n2, int n3, int n4) {
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            SWT.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (control2 != null && control != null) {
            Point point = control.toDisplay(n, n2);
            point = control2.toControl(point);
            rectangle.x = point.x;
            rectangle.y = point.y;
        } else if (control2 != null) {
            Point point = control2.toControl(n, n2);
            rectangle.x = point.x;
            rectangle.y = point.y;
        } else if (control != null) {
            Point point = control.toDisplay(n, n2);
            rectangle.x = point.x;
            rectangle.y = point.y;
        }
        return rectangle;
    }

    public boolean post(Event event) {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (event == null) {
            this.error(4);
        }
        int n = Display.unTranslateModifiers(event.stateMask);
        int n2 = Display.unTranslateEventType(event.type);
        int n3 = 0;
        int n4 = 0;
        n3 = event.widget == null ? OS.QApplication_focusWidget() : event.widget.handle;
        if (n3 == 0) {
            return false;
        }
        switch (n2) {
            case 6: 
            case 7: {
                if (event.keyCode == 0 && event.character == '\u0000') {
                    return false;
                }
                int n5 = Display.untranslateKey(event.keyCode);
                if (event.keyCode != 0 && n5 == 0) {
                    n5 = event.keyCode;
                }
                if (n5 == 0) {
                    switch (event.character) {
                        case '\b': {
                            n5 = 0x1000003;
                            break;
                        }
                        case '\r': {
                            n5 = 0x1000004;
                            break;
                        }
                        case '\u007f': {
                            n5 = 0x1000007;
                            break;
                        }
                        case '\u001b': {
                            n5 = 0x1000000;
                            break;
                        }
                        case '\t': {
                            n5 = 0x1000001;
                            break;
                        }
                        case '\n': {
                            return false;
                        }
                        default: {
                            n5 = Character.toUpperCase(event.character);
                        }
                    }
                }
                String string = event.character + "";
                n4 = OS.QKeyEvent_new(n2, n5, n, string);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Control control = (Control)this.getWidget(n3);
                if ((control.getStyle() & 0x8000000) != 0) {
                    event.x = control.getClientWidth() - event.x;
                }
                Point point = OS.QWidget_mapToGlobal(n3, event.x, event.y);
                int n6 = Display.unTranslateButton(event.button);
                if (n2 != 5 && n6 == 0) {
                    return false;
                }
                n4 = OS.QMouseEvent_new(n2, event.x, event.y, point.x, point.y, n6, n6, n);
                break;
            }
        }
        if (n4 != 0 && n3 != 0) {
            OS.QCoreApplication_postEvent(handle, n3, n4);
            return true;
        }
        return false;
    }

    void postEvent(Event event) {
        int n;
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n2 = this.eventQueue.length;
        for (n = 0; n < n2 && this.eventQueue[n] != null; ++n) {
        }
        if (n == n2) {
            Event[] eventArray = new Event[n2 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n2);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n] = event;
    }

    void qt_signal_timer(int n) {
        if (this.timerRunnables == null || this.timerHandles == null) {
            return;
        }
        Runnable runnable = this.timerRunnables[n];
        this.timerRunnables[n] = null;
        OS.QObject_deleteLater(this.timerHandles[n]);
        this.timerHandles[n] = 0;
        if (runnable != null) {
            runnable.run();
        }
    }

    void qt_swt_event_endKeyPressed() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            ExitNotificationWrapper.notifyExit();
        }
    }

    void qt_swt_event_systemShutdown() {
        Event event = new Event();
        this.sendEvent(21, event);
        ExitNotificationWrapper.notifyExit();
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        if (OS.QCoreApplication_hasPendingEvents(handle)) {
            if (this.repostFailedQEvents() || this.sendQEvents() || this.sendPostedQEvents() || this.sendPostedSwtEvents() || this.sendDeferredDeletionQEvents()) {
                this.tryDestroy();
                return false;
            }
            return true;
        }
        boolean bl = this.runAsyncMessages(false);
        if (this.disposed) {
            this.tryDestroy();
            return false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            for (int i = 0; i < Displays.length; ++i) {
                if (Displays[i] != null) continue;
                Display.Displays[i] = display;
                return;
            }
            Display[] displayArray = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
            displayArray[Display.Displays.length] = display;
            Displays = displayArray;
        }
    }

    protected void release() {
        int n;
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        for (n = 0; n < shellArray.length; ++n) {
            Shell shell = shellArray[n];
            if (shell.isDisposed()) continue;
            shell.dispose();
        }
        this.commandArranger.dispose();
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            for (n = 0; n < this.disposeList.length; ++n) {
                if (this.disposeList[n] == null) continue;
                this.disposeList[n].run();
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.thread = null;
        this.lastWidget = null;
        this.indexTable = null;
        this.widgetTable = null;
        super.release();
    }

    public void removeFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    Widget removeWidget(int n) {
        if (n == 0) {
            return null;
        }
        this.lastWidget = null;
        Widget widget = null;
        int n2 = OS.QObject_property(n, SWT_OBJECT_INDEX) - 1;
        if (0 <= n2 && n2 < this.widgetTable.length) {
            widget = this.widgetTable[n2];
            this.widgetTable[n2] = null;
            this.indexTable[n2] = this.freeSlot;
            this.freeSlot = n2;
            OS.QObject_setProperty(n, SWT_OBJECT_INDEX, 0);
        }
        return widget;
    }

    private final boolean repostFailedQEvents() {
        OS.SwtApplication_postDeferredEvents();
        return this.disposed;
    }

    boolean runAsyncMessages(boolean bl) {
        return this.synchronizer.runAsyncMessages(bl);
    }

    boolean runDeferredEvents() {
        Event event;
        while (this.eventQueue != null && (event = this.eventQueue[0]) != null) {
            Widget widget;
            int n = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n);
            this.eventQueue[n] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            widget2.sendEvent(event);
        }
        this.eventQueue = null;
        return true;
    }

    private final boolean sendDeferredDeletionQEvents() {
        OS.QCoreApplication_sendPostedEvents(handle, 0, 52);
        return this.disposed;
    }

    void sendEvent(int n, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    private final boolean sendPostedQEvents() {
        OS.QCoreApplication_sendPostedEvents(handle);
        return this.disposed;
    }

    private final boolean sendPostedSwtEvents() {
        this.runDeferredEvents();
        return this.disposed;
    }

    private final boolean sendQEvents() {
        OS.QCoreApplication_processEvents(handle, 0);
        return this.disposed;
    }

    public static void setAppName(String string) {
        APP_NAME = string;
    }

    public void setData(String string, Object object) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(ADD_WIDGET_KEY)) {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            Widget widget = (Widget)objectArray[1];
            this.addWidget(n, widget);
            return;
        }
        if (string.equals(REMOVE_WIDGET_KEY)) {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            this.removeWidget(n);
            return;
        }
        if (object == null) {
            int n;
            if (this.keys == null) {
                return;
            }
            for (n = 0; n < this.keys.length && !this.keys[n].equals(string); ++n) {
            }
            if (n == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                Object[] objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n);
                System.arraycopy(this.keys, n + 1, stringArray, n, stringArray.length - n);
                System.arraycopy(this.values, 0, objectArray, 0, n);
                System.arraycopy(this.values, n + 1, objectArray, n, objectArray.length - n);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(string)) continue;
            this.values[i] = object;
            return;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray;
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    void setScreenPaintingAttributes(boolean bl) {
        OS.QWidget_setAttribute(OS.QApplication_desktop(), 13, bl);
        OS.QWidget_setAttribute(OS.QApplication_desktop(), 8, bl);
        OS.QWidget_setAttribute(OS.QApplication_desktop(), 52, bl);
    }

    void setModalDialog(Dialog dialog) {
        this.modalDialog = dialog;
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].updateModal();
        }
    }

    void setModalShell(Shell shell) {
        Shell[] shellArray;
        int n;
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int n2 = this.modalShells.length;
        for (n = 0; n < n2; ++n) {
            if (this.modalShells[n] == shell) {
                return;
            }
            if (this.modalShells[n] == null) break;
        }
        if (n == n2) {
            shellArray = new Shell[n2 + 4];
            System.arraycopy(this.modalShells, 0, shellArray, 0, n2);
            this.modalShells = shellArray;
        }
        this.modalShells[n] = shell;
        shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].updateModal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        Synchronizer synchronizer2;
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            synchronizer2 = this.synchronizer;
            this.synchronizer = synchronizer;
        }
        if (synchronizer2 != null) {
            synchronizer2.runAsyncMessages(true);
        }
    }

    public boolean sleep() {
        this.checkDevice();
        OS.QCoreApplication_processEvents(handle, 4);
        if (this.disposed) {
            this.tryDestroy();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Synchronizer synchronizer;
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            synchronizer = this.synchronizer;
        }
        synchronizer.syncExec(runnable);
    }

    public void timerExec(int n, Runnable runnable) {
        int n2;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerRunnables == null) {
            this.timerRunnables = new Runnable[4];
        }
        if (this.timerHandles == null) {
            this.timerHandles = new int[4];
        }
        for (n2 = 0; n2 < this.timerRunnables.length && this.timerRunnables[n2] != runnable; ++n2) {
        }
        if (n2 != this.timerRunnables.length) {
            OS.QObject_deleteLater(this.timerHandles[n2]);
            this.timerRunnables[n2] = null;
            this.timerHandles[n2] = 0;
        } else {
            for (n2 = 0; n2 < this.timerRunnables.length && this.timerRunnables[n2] != null; ++n2) {
            }
            if (n2 == this.timerRunnables.length) {
                Runnable[] runnableArray = new Runnable[this.timerRunnables.length + 4];
                System.arraycopy(this.timerRunnables, 0, runnableArray, 0, this.timerRunnables.length);
                this.timerRunnables = runnableArray;
                int[] nArray = new int[this.timerHandles.length + 4];
                System.arraycopy(this.timerHandles, 0, nArray, 0, this.timerHandles.length);
                this.timerHandles = nArray;
            }
        }
        if (n < 0) {
            return;
        }
        int n3 = OS.QTimer_new();
        if (n3 != 0) {
            OS.QObject_setParent(n3, handle);
            OS.QTimer_setSingleShot(n3, true);
            int n4 = OS.SignalHandler_new(n3, this, 1003);
            OS.QObject_connectOrThrow(n3, "timeout()", n4, "widgetSignal()", 0);
            OS.QTimer_start(n3, n);
            this.timerHandles[n2] = n3;
            this.timerRunnables[n2] = runnable;
        }
    }

    static final int translateButton(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    static final int translateButtons(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 0x80000;
        }
        if ((n & 4) != 0) {
            n2 |= 0x100000;
        }
        if ((n & 2) != 0) {
            n2 |= 0x200000;
        }
        return n2;
    }

    static final int translateKey(int n, boolean bl) {
        int n2;
        if (bl) {
            for (n2 = 0; n2 < KeyPadKeyTable.length; ++n2) {
                if (KeyPadKeyTable[n2][0] != n) continue;
                return KeyPadKeyTable[n2][1];
            }
        }
        for (n2 = 0; n2 < KeyTable.length; ++n2) {
            if (KeyTable[n2][0] != n) continue;
            return KeyTable[n2][1];
        }
        return 0;
    }

    static final int translateModifiers(int n) {
        int n2 = 0;
        if ((n & 0x8000000) != 0) {
            n2 |= 0x10000;
        }
        if ((n & 0x2000000) != 0) {
            n2 |= 0x20000;
        }
        if ((n & 0x4000000) != 0) {
            n2 |= 0x40000;
        }
        return n2;
    }

    static final int translateDirection(int n) {
        if (n == 1) {
            return 0x4000000;
        }
        return 0x2000000;
    }

    private final void tryDestroy() {
        if (handle != 0 && OS.SwtApplication_javaCallbackCount() == 0) {
            OS.QObject_delete(handle);
            handle = 0;
            OS.cleanUpUiThread();
        }
    }

    static final int unTranslateButton(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    static final int unTranslateEventType(int n) {
        switch (n) {
            case 1: {
                return 6;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 2;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 3;
            }
            case 8: {
                return 4;
            }
        }
        return 0;
    }

    public static final int untranslateKey(int n) {
        int n2;
        for (n2 = 0; n2 < KeyTable.length; ++n2) {
            if (KeyTable[n2][1] != n) continue;
            return KeyTable[n2][0];
        }
        for (n2 = 0; n2 < KeyPadKeyTable.length; ++n2) {
            if (KeyPadKeyTable[n2][1] != n) continue;
            return KeyPadKeyTable[n2][0];
        }
        return 0;
    }

    static final int unTranslateModifiers(int n) {
        int n2 = 0;
        if ((n & 0x10000) != 0) {
            n2 |= 0x8000000;
        }
        if ((n & 0x20000) != 0) {
            n2 |= 0x2000000;
        }
        if ((n & 0x40000) != 0) {
            n2 |= 0x4000000;
        }
        return n2;
    }

    public void update() {
        this.checkDevice();
        if (OS.QCoreApplication_hasPendingEvents(handle)) {
            OS.QCoreApplication_processEvents(handle, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Display.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                return;
            }
            this.wakeThread();
        }
    }

    void wakeThread() {
        int n = OS.QObject_thread(handle);
        int n2 = OS.QAbstractEventDispatcher_instance(n);
        OS.QAbstractEventDispatcher_wakeup(n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        APP_NAME = "SWT";
        KeyTable = new int[][]{{16777251, 65536}, {0x1001103, 65536}, {0x1000022, 65536}, {0x1000020, 131072}, {0x1000021, 262144}, {0x1000013, 0x1000001}, {0x1000015, 0x1000002}, {0x1000012, 0x1000003}, {0x1000014, 0x1000004}, {0x1000016, 0x1000005}, {0x1000017, 0x1000006}, {0x1000010, 0x1000007}, {0x1000011, 0x1000008}, {0x1000006, 0x1000009}, {0x1000003, 8}, {0x1000004, 13}, {0x1000007, 127}, {0x1000000, 27}, {0x1000005, 13}, {0x1000001, 9}, {0x1000002, 9}, {0x1000030, 0x100000A}, {0x1000031, 0x100000B}, {16777266, 0x100000C}, {0x1000033, 0x100000D}, {16777268, 0x100000E}, {16777269, 0x100000F}, {16777270, 0x1000010}, {16777271, 0x1000011}, {16777272, 0x1000012}, {16777273, 0x1000013}, {16777274, 0x1000014}, {16777275, 0x1000015}, {16777276, 0x1000016}, {16777277, 0x1000017}, {16777278, 0x1000018}, {16777252, 16777298}, {16777253, 16777299}, {16777254, 16777300}, {0x1000008, 0x1000055}, {0x1000009, 16777303}, {16777304, 0x1000051}};
        KeyPadKeyTable = new int[][]{{42, 16777258}, {43, 16777259}, {0x1000005, 0x1000050}, {45, 16777261}, {46, 16777262}, {47, 16777263}, {48, 0x1000030}, {49, 0x1000031}, {50, 16777266}, {51, 0x1000033}, {52, 16777268}, {53, 16777269}, {54, 16777270}, {55, 16777271}, {56, 16777272}, {57, 16777273}, {61, 16777277}};
        Displays = new Display[4];
        DeviceFinder = new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                Display.setDevice(display);
            }
        };
    }
}

