/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

class EventTable {
    int[] types;
    Listener[] listeners;
    int level;

    EventTable() {
    }

    public Listener[] getListeners(int n) {
        if (this.types == null) {
            return new Listener[0];
        }
        int n2 = 0;
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != n) continue;
            ++n2;
        }
        Listener[] listenerArray = new Listener[n2];
        if (n2 == 0) {
            return listenerArray;
        }
        int n3 = 0;
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != n) continue;
            listenerArray[n3] = this.listeners[i];
            ++n3;
        }
        return listenerArray;
    }

    public void hook(int n, Listener listener) {
        int n2;
        if (this.types == null) {
            this.types = new int[4];
        }
        if (this.listeners == null) {
            this.listeners = new Listener[4];
        }
        int n3 = this.types.length;
        for (n2 = n3 - 1; n2 >= 0 && this.types[n2] == 0; --n2) {
        }
        if (++n2 == n3) {
            int[] nArray = new int[n3 + 4];
            System.arraycopy(this.types, 0, nArray, 0, n3);
            this.types = nArray;
            Listener[] listenerArray = new Listener[n3 + 4];
            System.arraycopy(this.listeners, 0, listenerArray, 0, n3);
            this.listeners = listenerArray;
        }
        this.types[n2] = n;
        this.listeners[n2] = listener;
    }

    public boolean hooks(int n) {
        if (this.types == null) {
            return false;
        }
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != n) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendEvent(Event event) {
        block15: {
            boolean bl;
            block14: {
                if (this.types == null) {
                    return;
                }
                this.level += this.level >= 0 ? 1 : -1;
                try {
                    for (int i = 0; i < this.types.length; ++i) {
                        Listener listener;
                        if (event.type == 0) {
                            Object var5_4 = null;
                            bl = this.level < 0;
                            break block14;
                        }
                        if (this.types[i] != event.type || (listener = this.listeners[i]) == null) continue;
                        listener.handleEvent(event);
                    }
                    break block15;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    boolean bl2 = this.level < 0;
                    this.level -= this.level >= 0 ? 1 : -1;
                    if (bl2 && this.level == 0) {
                        int n;
                        int n2 = 0;
                        for (n = 0; n < this.types.length; ++n) {
                            if (this.types[n] == 0) continue;
                            this.types[n2] = this.types[n];
                            this.listeners[n2] = this.listeners[n];
                            ++n2;
                        }
                        for (n = n2; n < this.types.length; ++n) {
                            this.types[n] = 0;
                            this.listeners[n] = null;
                        }
                    }
                    throw throwable;
                }
            }
            boolean bl3 = bl;
            this.level -= this.level >= 0 ? 1 : -1;
            if (bl3 && this.level == 0) {
                int n;
                int n3 = 0;
                for (n = 0; n < this.types.length; ++n) {
                    if (this.types[n] == 0) continue;
                    this.types[n3] = this.types[n];
                    this.listeners[n3] = this.listeners[n];
                    ++n3;
                }
                for (n = n3; n < this.types.length; ++n) {
                    this.types[n] = 0;
                    this.listeners[n] = null;
                }
            }
            return;
        }
        Object var5_5 = null;
        boolean bl = this.level < 0;
        this.level -= this.level >= 0 ? 1 : -1;
        if (bl && this.level == 0) {
            int n;
            int n4 = 0;
            for (n = 0; n < this.types.length; ++n) {
                if (this.types[n] == 0) continue;
                this.types[n4] = this.types[n];
                this.listeners[n4] = this.listeners[n];
                ++n4;
            }
            for (n = n4; n < this.types.length; ++n) {
                this.types[n] = 0;
                this.listeners[n] = null;
            }
        }
    }

    public int size() {
        if (this.types == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] == 0) continue;
            ++n;
        }
        return n;
    }

    void remove(int n) {
        if (this.level == 0) {
            int n2 = this.types.length - 1;
            System.arraycopy(this.types, n + 1, this.types, n, n2 - n);
            System.arraycopy(this.listeners, n + 1, this.listeners, n, n2 - n);
            n = n2;
        } else if (this.level > 0) {
            this.level = -this.level;
        }
        this.types[n] = 0;
        this.listeners[n] = null;
    }

    public void unhook(int n, Listener listener) {
        if (this.types == null) {
            return;
        }
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != n || this.listeners[i] != listener) continue;
            this.remove(i);
            return;
        }
    }

    public void unhook(int n, SWTEventListener sWTEventListener) {
        if (this.types == null) {
            return;
        }
        for (int i = 0; i < this.types.length; ++i) {
            TypedListener typedListener;
            if (this.types[i] != n || !(this.listeners[i] instanceof TypedListener) || (typedListener = (TypedListener)this.listeners[i]).getEventListener() != sWTEventListener) continue;
            this.remove(i);
            return;
        }
    }
}

