/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    Image image;

    public Label(Composite composite, int n) {
        super(composite, Label.checkStyle(n));
    }

    static int checkStyle(int n) {
        if (((n |= 0x80000) & 2) != 0) {
            n = Label.checkBits(n, 256, 512, 0, 0, 0, 0);
            return Label.checkBits(n, 32, 8, 4, 0, 0, 0) | 0x800;
        }
        return Label.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        if (n != -1 && n < 0) {
            n = -1;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = -1;
        }
        if ((this.style & 2) != 0 || this.image != null || (this.style & 4) != 0 || n == -1 && n2 == -1 || n != -1 && n2 != -1) {
            return super.computeSize(n, n2, bl);
        }
        this.checkWidget();
        if (bl) {
            OS.QWidget_updateGeometry(this.handle);
        }
        int n5 = this.getBorderWidth();
        if (n != -1) {
            n += 2 * n5;
        }
        if (n2 != -1) {
            n2 += 2 * n5;
        }
        Point point = OS.QWidget_minimumSize(this.handle);
        if (point.x < 2 * n5) {
            point.x = 2 * n5;
        }
        if (point.y < 2 * n5) {
            point.y = 2 * n5;
        }
        int n6 = point.x;
        int n7 = point.y;
        if (n > n6) {
            n6 = n;
        }
        if (n2 > n7) {
            n7 = n2;
        }
        if ((n4 = OS.QWidget_heightForWidth(this.handle, n3 = n != -1 ? n6 : n7)) >= 0) {
            if (n == -1) {
                n6 = n4;
            } else {
                n7 = n4;
            }
        }
        return new Point(n6, n7);
    }

    protected void createHandle(int n) {
        if ((this.style & 2) != 0) {
            this.handle = OS.QFrame_new();
        } else {
            this.handle = OS.QLabel_new();
            OS.QLabel_setBuddy(this.handle, this.parent.handle);
        }
        this.setStyle(this.style);
        this.state |= 8;
        if ((this.style & 2) != 0) {
            return;
        }
        this.setAlignment(this.style);
    }

    void createWidget(int n) {
        super.createWidget(n);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return OS.QLabel_text(this.handle);
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.image = null;
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((n &= 0x1024000) == 0) {
            return;
        }
        n = Label.checkBits(n, 16384, 131072, 0x1000000, 0, 0, 0);
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        int n2 = 0;
        if ((this.style & 0x4000) != 0) {
            n2 |= 1;
        } else if ((this.style & 0x1000000) != 0) {
            n2 |= 4;
        } else if ((this.style & 0x20000) != 0) {
            n2 |= 2;
        }
        OS.QLabel_setAlignment(this.handle, n2 |= 0x80);
    }

    void setStyle(int n) {
        int n2 = 0;
        if ((n & 2) != 0) {
            n2 = (n & 0x200) != 0 ? (n2 |= 5) : (n2 |= 4);
            n2 = (n & 4) != 0 ? (n2 |= 0x30) : ((n & 8) != 0 ? (n2 |= 0x20) : (n2 |= 0x10));
        } else {
            n2 = (n & 0x800) != 0 ? (n2 |= 6) : (n2 |= 0);
        }
        OS.QFrame_setFrameStyle(this.handle, n2);
        if ((n & 2) != 0) {
            return;
        }
        if ((n & 0x40) != 0) {
            OS.QLabel_setWordWrap(this.handle, true);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        if (this.image == image) {
            return;
        }
        OS.QLabel_setPixmap(this.handle, image == null ? 0 : image.internal_getPixmapHandle());
        this.image = image;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.image != null) {
            this.image = null;
            if (string.length() < 1) {
                OS.QLabel_setPixmap(this.handle, 0);
                return;
            }
        }
        OS.QLabel_setText(this.handle, string);
    }

    boolean isTabGroup() {
        return false;
    }

    boolean isTabItem() {
        return false;
    }

    protected int internal_frameHandle() {
        return this.handle;
    }
}

