/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.qt.ListUtils;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    private boolean ignoreSelectionEvent;

    public List(Composite composite, int n) {
        super(composite, List.checkStyle(n));
    }

    protected static int checkStyle(int n) {
        return List.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    protected void createHandle(int n) {
        this.scrollAreaHandle = OS.QListWidget_new();
        this.handle = OS.QAbstractScrollArea_viewPort(this.scrollAreaHandle);
        if ((this.style & 2) != 0) {
            OS.QAbstractItemView_setSelectionMode(this.scrollAreaHandle, 2);
        }
        this.state |= 8;
    }

    public void add(String string) {
        this.checkWidget();
        ListUtils.add(this.internal_topHandle(), string, null);
    }

    public void add(String string, int n) {
        this.checkWidget();
        ListUtils.add(this.internal_topHandle(), string, null, n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void hookEvents() {
        super.hookEvents();
        int n = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1012);
        OS.QObject_connectOrThrow(this.internal_topHandle(), "itemSelectionChanged()", n, "widgetSignal()", 0);
        int n2 = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1014);
        OS.QObject_connectOrThrow(this.internal_topHandle(), "itemActivated(QListWidgetItem* )", n2, "widgetSignal(QListWidgetItem* )", 0);
    }

    protected void qt_signal_list_itemSelectionChanged() {
        if (!this.ignoreSelectionEvent) {
            this.sendEvent(13);
        }
    }

    protected void qt_signal_list_itemActivated(int n) {
        if (!this.ignoreSelectionEvent) {
            this.sendEvent(14);
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.deselect(this.internal_topHandle(), n);
        this.ignoreSelectionEvent = false;
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.deselect(this.internal_topHandle(), n, n2);
        this.ignoreSelectionEvent = false;
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.deselect(this.internal_topHandle(), nArray);
        this.ignoreSelectionEvent = false;
    }

    public void deselectAll() {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.deselectAll(this.internal_topHandle());
        this.ignoreSelectionEvent = false;
    }

    public int getFocusIndex() {
        this.checkWidget();
        return OS.QListWidget_currentRow(this.internal_topHandle());
    }

    public String getItem(int n) {
        this.checkWidget();
        return ListUtils.getItem(this.internal_topHandle(), n);
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.QListWidget_count(this.internal_topHandle());
    }

    public int getItemHeight() {
        this.checkWidget();
        return ListUtils.getItemHeight(this.internal_topHandle());
    }

    public String[] getItems() {
        this.checkWidget();
        return ListUtils.getItems(this.internal_topHandle());
    }

    public String[] getSelection() {
        this.checkWidget();
        return ListUtils.getSelection(this.internal_topHandle());
    }

    public int getSelectionCount() {
        this.checkWidget();
        return ListUtils.getSelectionCount(this.internal_topHandle());
    }

    public int getSelectionIndex() {
        int[] nArray = this.getSelectionIndices();
        if (nArray.length < 1) {
            return -1;
        }
        return nArray[0];
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        return ListUtils.getSelectionIndices(this.internal_topHandle());
    }

    public int getTopIndex() {
        this.checkWidget();
        if (this.getItemCount() < 1) {
            return 0;
        }
        return OS.QAbstractItemView_swt_indexAt(this.internal_topHandle(), 1, 1);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        return ListUtils.indexOf(this.internal_topHandle(), string, n);
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        return ListUtils.isSelected(this.internal_topHandle(), n);
    }

    public void remove(int n) {
        this.checkWidget();
        ListUtils.remove(this.internal_topHandle(), n);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        ListUtils.remove(this.internal_topHandle(), n, n2);
    }

    public void remove(String string) {
        this.checkWidget();
        ListUtils.remove(this.internal_topHandle(), string);
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        ListUtils.remove(this.internal_topHandle(), nArray);
    }

    public void removeAll() {
        this.checkWidget();
        ListUtils.removeAll(this.internal_topHandle());
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.select(this.internal_topHandle(), n, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void select(int n, int n2) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.select(this.internal_topHandle(), n, n2, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void select(int[] nArray) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.select(this.internal_topHandle(), nArray, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void selectAll() {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.selectAll(this.internal_topHandle(), (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (n < 0 || n >= OS.QListWidget_count(this.internal_topHandle())) {
            SWT.error(6);
        }
        boolean bl = this.isSelected(n);
        OS.QListWidget_swt_setText(this.internal_topHandle(), n, string);
        if (bl) {
            this.select(n);
        }
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            SWT.error(4);
        }
        this.removeAll();
        int n = stringArray.length;
        if (n < 1) {
            return;
        }
        OS.QListWidget_addItems(this.internal_topHandle(), stringArray, null);
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.setSelection(this.internal_topHandle(), n);
        this.ignoreSelectionEvent = false;
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.setSelection(this.internal_topHandle(), n, n2, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.setSelection(this.internal_topHandle(), nArray, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.setSelection(this.internal_topHandle(), stringArray, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if (n < 0 || n > this.getItemCount() - 1) {
            return;
        }
        OS.QListWidget_scrollToItem(this.internal_topHandle(), n, 1);
    }

    public void showSelection() {
        this.checkWidget();
        ListUtils.showSelection(this.internal_topHandle());
    }

    protected Point getPreferredClientAreaSize() {
        int n = OS.QAbstractItemView_sizeHintForColumn(this.internal_topHandle(), 0);
        int n2 = OS.QAbstractItemView_sizeHintForIndex((int)this.internal_topHandle(), (int)0, (int)0).y * this.getItemCount();
        return new Point(n, n2);
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        int n5 = this.internal_topHandle();
        this.traverseDoit = false;
        this.traverseCancel = false;
        if (n == 4) {
            return;
        }
        switch (n2) {
            case 0x1000012: 
            case 0x1000013: {
                if (ListUtils.getFocusIndex(n5) != 0) break;
                this.traverseDoit = true;
                break;
            }
            case 0x1000014: 
            case 0x1000015: {
                if (ListUtils.getFocusIndex(n5) != ListUtils.getItemCount(n5) - 1) break;
                this.traverseDoit = true;
                break;
            }
            default: {
                super.setTraversalFlags(n, n2, n3, n4);
            }
        }
    }

    protected void setHBarPolicy(boolean bl) {
        if (bl) {
            super.setHBarPolicy(bl);
        }
    }
}

