/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    protected int actionGroupHandle;
    int x;
    int y;
    boolean hasLocation;
    MenuItem cascade;
    Decorations parent;
    static /* synthetic */ Class class$org$eclipse$swt$widgets$MenuItem;

    public Menu(Control control) {
        this(Menu.checkNull(control).menuShell(), 8);
    }

    public Menu(Decorations decorations, int n) {
        super(decorations, Menu.checkStyle(n));
        this.parent = decorations;
        this.createWidget(0);
    }

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem menuItem) {
        this(Menu.checkNull((MenuItem)menuItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem menuItem) {
        if (menuItem == null) {
            SWT.error(4);
        }
        return menuItem;
    }

    static int checkStyle(int n) {
        return Menu.checkBits(n, 8, 2, 4, 0, 0, 0);
    }

    public void addMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuListener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    protected void createHandle(int n) {
        this.handle = (this.style & 2) != 0 ? OS.QMenuBar_new(this.parent.internal_topHandle()) : OS.QMenu_new(this.parent.handle);
        if ((this.style & 0x4000000) != 0) {
            OS.QWidget_setLayoutDirection(this.handle, 1);
        }
        this.state |= 8;
    }

    void createWidget(int n) {
        this.checkOrientation(this.parent);
        super.createWidget(n);
        this.parent.addMenu(this);
    }

    void fixMenus(Decorations decorations) {
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        int n = OS.QMenu_defaultAction(this.handle);
        Widget widget = this.display.getWidget(n);
        if (widget != null && (class$org$eclipse$swt$widgets$MenuItem == null ? (class$org$eclipse$swt$widgets$MenuItem = Menu.class$("org.eclipse.swt.widgets.MenuItem")) : class$org$eclipse$swt$widgets$MenuItem).isInstance(widget)) {
            return (MenuItem)widget;
        }
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.QWidget_isEnabled(this.handle);
    }

    public MenuItem getItem(int n) {
        Widget widget;
        this.checkWidget();
        int[] nArray = OS.QWidget_actions(this.handle);
        int n2 = nArray.length;
        if (0 > n || n >= n2) {
            this.error(6);
        }
        if ((widget = this.display.getWidget(nArray[n])) == null || !(class$org$eclipse$swt$widgets$MenuItem == null ? (class$org$eclipse$swt$widgets$MenuItem = Menu.class$("org.eclipse.swt.widgets.MenuItem")) : class$org$eclipse$swt$widgets$MenuItem).isInstance(widget)) {
            this.error(8);
        }
        return (MenuItem)widget;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.QWidget_actions_size(this.handle);
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        int[] nArray = OS.QWidget_actions(this.handle);
        int n = nArray.length;
        if (n == 0) {
            return new MenuItem[0];
        }
        MenuItem[] menuItemArray = new MenuItem[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Widget widget;
            int n3 = nArray[i];
            if (n3 == 0 || (widget = this.display.getWidget(n3)) == null || widget == this || !(widget instanceof MenuItem)) continue;
            menuItemArray[n2++] = (MenuItem)widget;
        }
        if (n2 == n) {
            return menuItemArray;
        }
        MenuItem[] menuItemArray2 = new MenuItem[n2];
        System.arraycopy(menuItemArray, 0, menuItemArray2, 0, n2);
        return menuItemArray2;
    }

    String getNameText() {
        String string = "";
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                string = string + menuItemArray[i].getNameText() + ", ";
            }
            string = string + menuItemArray[n - 1].getNameText();
        }
        return string;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade == null) {
            return null;
        }
        return this.cascade.getParent();
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        this.checkWidget();
        return !OS.QWidget_isHidden(this.handle);
    }

    void qt_signal_aboutToHide() {
        this.sendEvent(23);
    }

    void qt_signal_aboutToShow() {
        this.sendEvent(22);
    }

    protected void hookEvents() {
        super.hookEvents();
        if ((this.style & 2) == 0) {
            int n = OS.SignalHandler_new(this.handle, this.display, 1005);
            OS.QObject_connectOrThrow(this.handle, "aboutToHide()", n, "widgetSignal()", 0);
            int n2 = OS.SignalHandler_new(this.handle, this.display, 1004);
            OS.QObject_connectOrThrow(this.handle, "aboutToShow()", n2, "widgetSignal()", 0);
        }
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            this.error(4);
        }
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            if (menuItemArray[i] != menuItem) continue;
            return i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu menu = this.getParentMenu();
        if (menu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && menu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return OS.QWidget_isVisible(this.handle);
    }

    protected void releaseChildren(boolean bl) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            if (menuItem == null || menuItem.isDisposed()) continue;
            menuItem.release(false);
        }
        super.releaseChildren(bl);
    }

    protected void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    protected void releaseWidget() {
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
        this.cascade = null;
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, menuListener);
        this.eventTable.unhook(22, menuListener);
    }

    public void setDefaultItem(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem != null) {
            if (menuItem.isDisposed()) {
                this.error(5);
            }
            if (menuItem.parent != this) {
                return;
            }
            OS.QMenu_setDefaultAction(this.handle, menuItem.handle);
        } else {
            OS.QMenu_setDefaultAction(this.handle, 0);
        }
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        OS.QWidget_setEnabled(this.handle, bl);
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = n;
        this.y = n2;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (bl) {
            OS.QMenu_popup(this.handle, this.x, this.y, 0);
        } else {
            OS.QWidget_setVisible(this.handle, bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

