/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    int minimum = 0;
    int maximum = 100;
    int selection = 0;

    public ProgressBar(Composite composite, int n) {
        super(composite, ProgressBar.checkStyle(n));
    }

    static int checkStyle(int n) {
        n |= 0x80000;
        n = ProgressBar.checkBits(n, 256, 512, 0, 0, 0, 0);
        return ProgressBar.checkBits(n, 65536, 2, 0, 0, 0, 0);
    }

    protected void createHandle(int n) {
        this.handle = OS.QProgressBar_new();
        this.state |= 8;
        this.setStyle();
    }

    void setStyle() {
        if ((this.style & 0x200) != 0) {
            OS.QProgressBar_setOrientation(this.handle, 2);
        }
        if ((this.style & 2) != 0) {
            OS.QProgressBar_setMaximum(this.handle, this.maximum);
        }
        OS.QProgressBar_setTextInVisible(this.handle);
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n <= this.minimum) {
            return;
        }
        this.maximum = n;
        this.selection = Math.min(this.selection, this.maximum);
        if (n <= this.selection && (this.style & 2) == 0) {
            OS.QProgressBar_setValue(this.handle, this.selection);
        }
        if ((this.style & 2) == 0) {
            OS.QProgressBar_setMaximum(this.handle, this.maximum);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.maximum) {
            return;
        }
        this.minimum = n;
        this.selection = Math.max(this.selection, this.minimum);
        if ((this.style & 2) == 0) {
            OS.QProgressBar_setMinimum(this.handle, n);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.selection = Math.max(this.minimum, Math.min(this.maximum, n));
        if ((this.style & 2) == 0) {
            OS.QProgressBar_setValue(this.handle, this.selection);
        }
    }
}

