/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    int pageIncrement = 1;

    ScrollBar(Scrollable scrollable, int n) {
        super(scrollable, ScrollBar.checkBits(n, 256, 512, 0, 0, 0, 0));
        this.parent = scrollable;
        this.checkOrientation(scrollable);
        this.createWidget(0);
    }

    protected void createHandle(int n) {
        if (this.parent.scrollAreaHandle == 0) {
            SWT.error(4);
        }
        this.handle = (this.style & 0x100) != 0 ? OS.QAbstractScrollArea_horizontalScrollBar(this.parent.scrollAreaHandle) : OS.QAbstractScrollArea_verticalScrollBar(this.parent.scrollAreaHandle);
        if (this.handle == 0) {
            SWT.error(1);
        }
        this.state |= 8;
    }

    protected void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            OS.QAbstractScrollArea_setHorizontalScrollBarPolicy(this.parent.scrollAreaHandle, 1);
            this.parent.horizontalBar = null;
        } else if (this.parent.verticalBar == this) {
            OS.QAbstractScrollArea_setVerticalScrollBarPolicy(this.parent.scrollAreaHandle, 1);
            this.parent.verticalBar = null;
        }
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public int getIncrement() {
        this.checkWidget();
        return OS.QAbstractSlider_singleStep(this.handle);
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.QAbstractSlider_maximum(this.handle) + OS.QAbstractSlider_pageStep(this.handle);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.QAbstractSlider_minimum(this.handle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        return OS.QAbstractSlider_value(this.handle);
    }

    public Point getSize() {
        this.checkWidget();
        if (!this.isVisible()) {
            this.parent.updateQLayouts();
        }
        return OS.QWidget_frameSize(this.handle);
    }

    public int getThumb() {
        this.checkWidget();
        return OS.QAbstractSlider_pageStep(this.handle);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.QWidget_isEnabled(this.handle);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.QWidget_isVisible(this.handle);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return OS.QWidget_isEnabled(this.handle) && this.parent.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return OS.QWidget_isVisible(this.handle) && this.parent.isVisible();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.state = bl ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        OS.QWidget_setEnabled(this.handle, bl);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.QAbstractSlider_setSingleStep(this.handle, n);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.QAbstractSlider_minimum(this.handle);
        if (n <= n2) {
            return;
        }
        int n3 = n - OS.QAbstractSlider_pageStep(this.handle);
        if (n3 < n2) {
            OS.QAbstractSlider_setPageStep(this.handle, n - n2);
            n3 = n2;
        }
        if (OS.QAbstractSlider_value(this.handle) > n3) {
            OS.QAbstractSlider_setValue(this.handle, n3);
        }
        OS.QAbstractSlider_setMaximum(this.handle, n3);
    }

    public void setMinimum(int n) {
        int n2;
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n3 = OS.QAbstractSlider_maximum(this.handle);
        if (n >= n3 + (n2 = OS.QAbstractSlider_pageStep(this.handle))) {
            return;
        }
        if (n3 + n2 - n < n2) {
            OS.QAbstractSlider_setPageStep(this.handle, n3 + n2 - n);
            OS.QAbstractSlider_setMaximum(this.handle, n);
        }
        if (OS.QAbstractSlider_value(this.handle) < n) {
            OS.QAbstractSlider_setValue(this.handle, n);
        }
        OS.QAbstractSlider_setMinimum(this.handle, n);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.pageIncrement = n;
    }

    public void setSelection(int n) {
        this.checkWidget();
        int n2 = OS.QAbstractSlider_minimum(this.handle);
        if (n < n2) {
            n = n2;
        } else {
            int n3 = OS.QAbstractSlider_maximum(this.handle);
            if (n > n3) {
                n = n3;
            }
        }
        OS.QAbstractSlider_setValue(this.handle, n);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.QAbstractSlider_pageStep(this.handle);
        if (n == n2) {
            return;
        }
        int n3 = OS.QAbstractSlider_maximum(this.handle);
        int n4 = n3 + n2 - OS.QAbstractSlider_minimum(this.handle);
        if (n > n4) {
            n = n4;
        }
        int n5 = n3 - (n - n2);
        if (OS.QAbstractSlider_value(this.handle) > n5) {
            OS.QAbstractSlider_setValue(this.handle, n5);
        }
        OS.QAbstractSlider_setPageStep(this.handle, n);
        OS.QAbstractSlider_setMaximum(this.handle, n5);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 >= 0) {
            OS.QAbstractSlider_setMinimum(this.handle, n2);
        } else {
            n2 = OS.QAbstractSlider_minimum(this.handle);
        }
        int n7 = OS.QAbstractSlider_pageStep(this.handle);
        boolean bl = true;
        if (n3 <= n2) {
            bl = false;
            n3 = OS.QAbstractSlider_maximum(this.handle) + n7;
        }
        if (n4 > 0) {
            if (n4 > n3 - n2) {
                n4 = n3 - n2;
            }
            OS.QAbstractSlider_setPageStep(this.handle, n4);
        } else if (n7 > n3 - n2) {
            n4 = n3 - n2;
            OS.QAbstractSlider_setPageStep(this.handle, n4);
        } else {
            n4 = n7;
        }
        if (bl) {
            OS.QAbstractSlider_setMaximum(this.handle, n3 - n4);
        }
        if (n < n2) {
            n = n2;
        } else if (n > n3 - n4) {
            n = n3 - n4;
        }
        OS.QAbstractSlider_setValue(this.handle, n);
        if (n5 > 0) {
            OS.QAbstractSlider_setSingleStep(this.handle, n5);
        }
        if (n6 > 0) {
            this.pageIncrement = n6;
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        OS.QWidget_setVisible(this.handle, bl);
    }

    protected void hookEvents() {
        super.hookEvents();
        int n = OS.SignalHandler_new(this.handle, this.display, 1019);
        OS.QObject_connectOrThrow(this.handle, "actionTriggered(int)", n, "widgetSignal(int)", 0);
        n = OS.SignalHandler_new(this.handle, this.display, 1020);
        OS.QObject_connectOrThrow(this.handle, "sliderReleased()", n, "widgetSignal()", 0);
    }

    void qt_signal_slider_action_triggered(int n) {
        int n2 = 0;
        switch (n) {
            case 7: {
                n2 = 1;
                break;
            }
            case 5: {
                n2 = 0x1000007;
                break;
            }
            case 6: {
                n2 = 0x1000008;
                break;
            }
            case 1: {
                n2 = 0x1000002;
                break;
            }
            case 2: {
                n2 = 0x1000001;
                break;
            }
            case 4: {
                n2 = 0x1000005;
                break;
            }
            case 3: {
                n2 = 0x1000006;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        this.sendSelectionEvent(n2);
    }

    void qt_signal_slider_released() {
        this.sendSelectionEvent(0);
    }

    void sendSelectionEvent(int n) {
        Event event = new Event();
        event.widget = this;
        event.detail = n;
        this.sendEvent(13, event, true);
    }
}

