/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    protected ScrollBar horizontalBar;
    protected ScrollBar verticalBar;
    protected int scrollAreaHandle;

    Scrollable() {
    }

    public Scrollable(Composite composite, int n) {
        this(composite, n, 0);
    }

    protected Scrollable(Composite composite, int n, int n2) {
        super(composite, n, n2);
    }

    int clientHandle() {
        return this.handle;
    }

    protected int internal_frameHandle() {
        return this.scrollAreaHandle;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (this.scrollAreaHandle == 0) {
            return super.computeSize(n, n2, bl);
        }
        if (bl) {
            OS.QWidget_updateGeometry(this.internal_topHandle());
        }
        Point point = this.getPreferredClientAreaSize();
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        Point point2 = new Point(rectangle.width, rectangle.height);
        if (n != -1) {
            point2.x = n + rectangle.width - point.x;
        }
        if (n2 != -1) {
            point2.y = n2 + rectangle.height - point.y;
        }
        return point2;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        ScrollBar scrollBar;
        this.checkWidget();
        int n5 = this.getBorderWidth();
        n -= n5;
        n2 -= n5;
        n3 += 2 * n5;
        n4 += 2 * n5;
        ScrollBar scrollBar2 = this.getVerticalBar();
        if (scrollBar2 != null) {
            int n6 = scrollBar2.getSize().x;
            n3 += n6;
        }
        if ((scrollBar = this.getHorizontalBar()) != null) {
            n4 += scrollBar.getSize().y;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    protected ScrollBar createScrollBar(int n) {
        if ((n & 0x100) != 0) {
            this.setHBarPolicy(true);
        } else {
            this.setVBarPolicy(true);
        }
        return new ScrollBar(this, n);
    }

    protected void createWidget(int n) {
        super.createWidget(n);
        this.createBars();
    }

    private void createBars() {
        if (this.scrollAreaHandle != 0) {
            if ((this.style & 0x100) != 0 && (this.state & 0x8000000) == 0) {
                if (this.horizontalBar == null) {
                    this.horizontalBar = this.createScrollBar(256);
                }
            } else {
                this.setHBarPolicy(false);
            }
            if ((this.style & 0x200) != 0 && (this.state & 0x8000000) == 0) {
                if (this.verticalBar == null) {
                    this.verticalBar = this.createScrollBar(512);
                }
            } else {
                this.setVBarPolicy(false);
            }
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (!this.isVisible()) {
            this.updateQLayouts();
        }
        Rectangle rectangle = OS.QWidget_rect(this.handle);
        if (rectangle.width < 0) {
            rectangle.width = 0;
        }
        if (rectangle.height < 0) {
            rectangle.height = 0;
        }
        return rectangle;
    }

    void updateQLayouts() {
        int n;
        if (this.parent != null) {
            this.parent.updateQLayouts();
        }
        this.updateLayoutOfQWidget(this.internal_topHandle());
        if (this.scrollAreaHandle != 0 && this.scrollAreaHandle != this.internal_topHandle()) {
            this.updateLayoutOfQWidget(this.scrollAreaHandle);
        }
        if (this.handle != this.scrollAreaHandle) {
            this.updateLayoutOfQWidget(this.handle);
        }
        if (this.scrollAreaHandle != 0 && (n = OS.QAbstractScrollArea_cornerWidget(this.scrollAreaHandle)) == 0) {
            OS.QAbstractScrollArea_setCornerWidget(this.scrollAreaHandle, 0);
        }
    }

    void updateLayoutOfQWidget(int n) {
        int n2 = OS.QWidget_layout(n);
        if (n2 != 0) {
            OS.QLayout_activate(n2);
            OS.QLayout_update(n2);
        }
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    protected Point getPreferredClientAreaSize() {
        if (this.handle == 0) {
            return new Point(64, 64);
        }
        Point point = OS.QWidget_sizeHint(this.handle);
        if (point.x < 0) {
            point.x = 64;
        }
        if (point.y < 0) {
            point.y = 64;
        }
        return point;
    }

    public void setData(String string, Object object) {
        super.setData(string, object);
        if (string.equals("org.eclipse.swt.internal.setEmbeddedScrollbarsState")) {
            if ((this.state & 0x8000000) != 0) {
                this.disposeBars();
                this.releaseBars();
            } else {
                this.createBars();
            }
        }
    }

    private void disposeBars() {
        if (this.horizontalBar != null && !this.horizontalBar.isDisposed()) {
            this.horizontalBar.dispose();
        }
        if (this.verticalBar != null && !this.verticalBar.isDisposed()) {
            this.verticalBar.dispose();
        }
    }

    protected void releaseChildren(boolean bl) {
        this.releaseBars();
        super.releaseChildren(bl);
    }

    private void releaseBars() {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
    }

    protected void deregister() {
        super.deregister();
        this.display.removeWidget(this.scrollAreaHandle);
    }

    public int internal_topHandle() {
        return this.scrollAreaHandle;
    }

    protected void register() {
        super.register();
        this.display.addWidget(this.scrollAreaHandle, this);
    }

    protected void releaseHandle() {
        this.scrollAreaHandle = 0;
        super.releaseHandle();
    }

    protected void setOrientation(int n, int n2) {
        this.checkWidget();
        int n3 = 0x6000000;
        if ((n2 & n3) == 0 || (n2 & n3) == n3) {
            return;
        }
        this.style &= ~n3;
        this.style |= n2 & n3;
        OS.QWidget_setLayoutDirection(n, n2 == 0x2000000 ? 0 : 1);
    }

    protected void setHBarPolicy(boolean bl) {
        if (bl) {
            OS.QAbstractScrollArea_setHorizontalScrollBarPolicy(this.scrollAreaHandle, 2);
        } else {
            OS.QAbstractScrollArea_setHorizontalScrollBarPolicy(this.scrollAreaHandle, 1);
        }
    }

    protected void setVBarPolicy(boolean bl) {
        if (bl) {
            OS.QAbstractScrollArea_setVerticalScrollBarPolicy(this.scrollAreaHandle, 2);
        } else {
            OS.QAbstractScrollArea_setVerticalScrollBarPolicy(this.scrollAreaHandle, 1);
        }
    }
}

