/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    int mainWindowHandle;
    int dialogWindowHandle;
    Rectangle defBounds;

    public Shell() {
        this((Display)null);
    }

    public Shell(int n) {
        this((Display)null, n);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int n) {
        this(display, null, n, 0, false);
    }

    Shell(Display display, Shell shell, int n, int n2, boolean bl) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (shell != null && shell.isDisposed()) {
            this.error(5);
        }
        this.style = Shell.checkStyle(n, shell);
        this.parent = shell;
        this.display = display;
        this.createWidget(0);
    }

    public Shell(Shell shell) {
        this(shell, 2144);
    }

    public Shell(Shell shell, int n) {
        this(shell != null ? shell.display : null, shell, n, 0, false);
    }

    protected static int checkStyle(int n, Composite composite) {
        n = Decorations.checkStyle(n, composite);
        n &= 0xBFFFFFFF;
        if (OS.windowServer == 1 && composite == null) {
            n |= 0x10;
        }
        int n2 = 229376;
        int n3 = n & ~n2;
        if ((n & 0x20000) != 0) {
            return n3 | 0x20000;
        }
        if ((n & 0x10000) != 0) {
            return n3 | 0x10000;
        }
        if ((n & 0x8000) != 0) {
            return n3 | 0x8000;
        }
        return n3;
    }

    public void addShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(shellListener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        if (OS.windowServer == 1 && this.parent == null) {
            return OS.QWidget_size(this.internal_topHandle());
        }
        Point point = super.computeSize(n, n2, bl);
        if (OS.windowServer == 2) {
            if ((this.style & 0x10) != 0) {
                if (point.x < 81) {
                    point.x = 81;
                }
                if (point.y < 100) {
                    point.y = 100;
                }
            } else if (this.willBeDecorated()) {
                point.x = Math.max(point.x, this.windowFrameTrim() * 2);
                point.y = Math.max(point.y, this.windowFrameTrim() * 2);
            }
        }
        return point;
    }

    Point setInitialSize() {
        Rectangle rectangle = this.display.getClientArea();
        if (OS.windowServer != 1) {
            rectangle.width /= 3;
            rectangle.height /= 3;
        }
        Point point = this.computeSize(rectangle.width, rectangle.height, true);
        point.x -= this.windowFrameTrim() * 2;
        point.y -= this.windowTitleTrim() + this.windowFrameTrim();
        if (OS.windowServer == 1 && this.parent == null) {
            this.setRestoreState(2, false);
        } else {
            OS.QWidget_resize(this.internal_topHandle(), point.x, point.y);
        }
        return point;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        int n5;
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        this.learnTrim();
        int n6 = n5 = this.windowFrameTrim();
        int n7 = n5;
        int n8 = this.windowTitleTrim();
        rectangle.x -= n7;
        rectangle.width += n7 + n6;
        rectangle.y -= n8;
        rectangle.height += n8 + n5;
        return rectangle;
    }

    boolean bypassWindowManager() {
        return (this.style & 0x4000) != 0 && (this.style & 0x80000) != 0 && (this.style & 8) != 0;
    }

    protected int windowFlagsFromStyle() {
        int n = this.parent == null || this.bypassWindowManager() ? 1 : 3;
        n |= 0x2000000;
        if ((this.style & 0x40) != 0) {
            n |= 0x8002000;
        }
        if ((this.style & 0x80) != 0) {
            n |= 0x4000;
        }
        if ((this.style & 0x400) != 0) {
            n |= 0x8000;
        }
        if ((this.style & 8) != 0) {
            n |= 0x800;
        }
        if ((this.style & 0x20) != 0) {
            n |= 0x1000;
        }
        if ((this.style & 0x4000) != 0) {
            n |= 0x40000;
        }
        if (this.bypassWindowManager()) {
            n |= 0xD;
        }
        return n;
    }

    protected void createHandle(int n) {
        int n2;
        if (this.parent == null) {
            this.mainWindowHandle = OS.QMainWindow_new(0, this.windowFlagsFromStyle());
            this.scrollAreaHandle = OS.QScrollArea_new(this.mainWindowHandle);
            this.handle = OS.QAbstractScrollArea_viewPort(this.scrollAreaHandle);
            OS.QMainWindow_setCentralWidget(this.mainWindowHandle, this.scrollAreaHandle);
        } else {
            this.dialogWindowHandle = OS.QWidget_new(this.parent.handle, this.windowFlagsFromStyle());
            this.scrollAreaHandle = OS.QScrollArea_new(this.dialogWindowHandle);
            this.handle = OS.QAbstractScrollArea_viewPort(this.scrollAreaHandle);
            int n3 = OS.QVBoxLayout_new(this.dialogWindowHandle);
            OS.QLayout_addWidget(n3, this.scrollAreaHandle);
            OS.QLayout_setContentsMargins(n3, 0, 0, 0, 0);
        }
        OS.QWidget_move(this.handle, 0, 0);
        Point point = this.setInitialSize();
        this.defBounds = OS.QWidget_rect(this.internal_topHandle());
        if ((this.style & 0x10) == 0) {
            OS.QWidget_setFixedSize(this.internal_topHandle(), point.x, point.y);
        } else {
            n2 = OS.QWidget_layout(this.internal_topHandle());
            if (n2 != 0 && OS.QLayout_sizeConstraint(n2) == 0) {
                OS.QLayout_setSizeConstraint(n2, 1);
            }
        }
        n2 = OS.QWidget_focusPolicy(this.internal_topHandle()) & 0xFFFFFFFD;
        OS.QWidget_setFocusPolicy(this.internal_topHandle(), n2);
        this.state |= 0xA;
    }

    public int internal_topHandle() {
        return this.mainWindowHandle != 0 ? this.mainWindowHandle : this.dialogWindowHandle;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isParentMirrored() {
        return false;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    protected void register() {
        super.register();
        if (this.mainWindowHandle != 0) {
            this.display.addWidget(this.mainWindowHandle, this);
        }
        if (this.dialogWindowHandle != 0) {
            this.display.addWidget(this.dialogWindowHandle, this);
        }
    }

    protected void releaseParent() {
    }

    public int getAlpha() {
        this.checkWidget();
        double d = OS.QWidget_windowOpacity(this.internal_topHandle());
        return (int)(255.0 * d);
    }

    public boolean getMaximized() {
        this.checkWidget();
        return !this.hasState(4) && super.getMaximized();
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    Shell _getShell() {
        return this;
    }

    public Shell[] getShells() {
        Shell[] shellArray;
        int n;
        this.checkWidget();
        int n2 = 0;
        Shell[] shellArray2 = this.display.getShells();
        for (n = 0; n < shellArray2.length; ++n) {
            shellArray = shellArray2[n];
            while ((shellArray = shellArray.getParent()) != null && shellArray != this) {
            }
            if (shellArray != this) continue;
            ++n2;
        }
        n = 0;
        shellArray = new Shell[n2];
        for (int i = 0; i < shellArray2.length; ++i) {
            Composite composite = shellArray2[i];
            while ((composite = composite.getParent()) != null && composite != this) {
            }
            if (composite != this) continue;
            shellArray[n++] = shellArray2[i];
        }
        return shellArray;
    }

    public void open() {
        this.checkWidget();
        this.setVisible(true);
        this.bringToTop(false);
        if (this.isDisposed()) {
            return;
        }
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus(7);
        }
    }

    public void removeShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, shellListener);
        this.eventTable.unhook(19, shellListener);
        this.eventTable.unhook(20, shellListener);
        this.eventTable.unhook(26, shellListener);
        this.eventTable.unhook(27, shellListener);
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
        if (OS.windowServer == 2 && OS.QWidget_isVisible(this.internal_topHandle())) {
            this.waitXRequestComplete();
        }
    }

    public void setAlpha(int n) {
        this.checkWidget();
        if (n < 0 || n > 255) {
            return;
        }
        OS.QWidget_setWindowOpacity(this.internal_topHandle(), (double)n / 255.0);
    }

    public Point getSize() {
        this.checkWidget();
        Point point = OS.QWidget_size(this.internal_topHandle());
        point.x += this.windowFrameTrim() * 2;
        point.y += this.windowFrameTrim() + this.windowTitleTrim();
        return point;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rectangle rectangle = OS.QWidget_geometry(this.internal_topHandle());
        rectangle.x -= this.windowFrameTrim();
        rectangle.y -= this.windowTitleTrim();
        rectangle.width += this.windowFrameTrim() * 2;
        rectangle.height += this.windowFrameTrim() + this.windowTitleTrim();
        return rectangle;
    }

    protected int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        int n6;
        if (OS.windowServer == 1 && this.parent == null) {
            return 0;
        }
        if (this.hasState(4)) {
            this.setRestoreState(4, true);
        }
        Rectangle rectangle = OS.QWidget_geometry(this.internal_topHandle());
        int n7 = 0;
        if (bl) {
            n6 = rectangle.x - this.windowFrameTrim();
            n5 = rectangle.y - this.windowTitleTrim();
            if (n6 != n || n5 != n2) {
                n7 |= 0x80;
            }
        }
        if (bl2) {
            n6 = rectangle.width + this.windowFrameTrim() * 2;
            n5 = rectangle.height + this.windowTitleTrim() + this.windowFrameTrim();
            if (n6 != n3 || n5 != n4) {
                n7 |= 0x100;
            }
        }
        if ((n7 & 0x80) != 0) {
            n6 = n + this.windowFrameTrim();
            n5 = n2 + this.windowTitleTrim();
            OS.QWidget_setGeometry(this.internal_topHandle(), n6, n5, rectangle.width, rectangle.height);
        }
        if ((n7 & 0x100) != 0) {
            n6 = n3 - this.windowFrameTrim() * 2;
            n5 = n4 - (this.windowFrameTrim() + this.windowTitleTrim());
            if ((this.style & 0x10) == 0) {
                this.unlockSize();
            }
            OS.QWidget_resize(this.internal_topHandle(), n6, n5);
            if ((this.style & 0x10) == 0) {
                OS.QWidget_setFixedSize(this.internal_topHandle(), Math.max(0, n6), Math.max(0, n5));
            }
        }
        return n7;
    }

    public Point getLocation() {
        this.checkWidget();
        Rectangle rectangle = OS.QWidget_geometry(this.internal_topHandle());
        Point point = new Point(rectangle.x, rectangle.y);
        point.x -= this.windowFrameTrim();
        point.y -= this.windowTitleTrim();
        return point;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == bl) {
            return;
        }
        super.setEnabled(bl);
        if (bl && this.internal_topHandle() == OS.QApplication_activeWindow() && !this.restoreFocus()) {
            this.traverseGroup(true);
        }
    }

    void enableWidget(boolean bl) {
        Control control = this.display._getFocusControl();
        super.enableWidget(bl);
        if (!bl) {
            Shell[] shellArray = this.getShells();
            for (int i = 0; i < shellArray.length; ++i) {
                if (shellArray[i].parent != this || !shellArray[i]._getEnabled()) continue;
                OS.QWidget_setEnabled(shellArray[i].internal_topHandle(), true);
            }
            if (control != null) {
                control.menuShell().restoreFocus();
            }
        }
    }

    public void setImeInputMode(int n) {
        this.checkWidget();
    }

    private final int modalityFromStyle() {
        int n = 0;
        if ((this.style & 0x20000) != 0) {
            return 2;
        }
        if ((this.style & 0x10000) != 0) {
            return 2;
        }
        if ((this.style & 0x8000) != 0) {
            return 2;
        }
        return n;
    }

    public void setVisible(boolean bl) {
        int n;
        Object object;
        this.checkWidget();
        int n2 = 229376;
        if ((this.style & n2) != 0) {
            if (bl) {
                this.display.setModalShell(this);
                if ((this.style & 0x30000) != 0) {
                    this.display.setModalDialog(null);
                }
                if ((object = this.display._getFocusControl()) != null && !((Control)object).isActive()) {
                    this.bringToTop(false);
                    if (this.isDisposed()) {
                        return;
                    }
                }
                OS.QWidget_setWindowModality(this.internal_topHandle(), this.modalityFromStyle());
                n = OS.QWidget_mouseGrabber();
                if (n != 0) {
                    OS.QWidget_releaseMouse(n);
                }
            } else {
                this.display.clearModal(this);
            }
        } else {
            this.updateModal();
        }
        super.setVisible(bl);
        if (this.isDisposed()) {
            return;
        }
        object = this.getShells();
        for (n = 0; n < ((Shell[])object).length; ++n) {
            Object object2 = object[n];
            if (((Shell)object2).isVisible() == bl) continue;
            ((Shell)object2).setVisible(bl);
            if (!this.isDisposed()) continue;
            return;
        }
        if (OS.windowServer == 2) {
            this.waitXRequestComplete();
        }
        if (this.isDisposed()) {
            return;
        }
        this.learnTrim();
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    void updateModal() {
    }

    protected void deregister() {
        super.deregister();
        if (this.mainWindowHandle != 0) {
            this.display.removeWidget(this.mainWindowHandle);
        }
        if (this.dialogWindowHandle != 0) {
            this.display.removeWidget(this.dialogWindowHandle);
        }
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    public void moveAbove(Control control) {
        if (this.parent == null) {
            OS.QWidget_raise(this.internal_topHandle());
        } else {
            super.moveAbove(control);
        }
    }

    public void moveBelow(Control control) {
        if (this.parent == null) {
            OS.QWidget_lower(this.internal_topHandle());
        } else {
            super.moveBelow(control);
        }
    }

    protected void releaseHandle() {
        this.mainWindowHandle = 0;
        this.dialogWindowHandle = 0;
        super.releaseHandle();
    }

    protected void releaseChildren(boolean bl) {
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            Shell shell = shellArray[i];
            if (shell == null || shell.isDisposed()) continue;
            shell.release(true);
        }
        super.releaseChildren(bl);
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.display.clearModal(this);
    }

    protected boolean qt_event_keypress(int n, int n2, int n3, int n4) {
        super.qt_event_keypress(n, n2, n3, n4);
        return true;
    }

    protected boolean qt_event_keyrelease(int n, int n2, int n3, int n4) {
        super.qt_event_keyrelease(n, n2, n3, n4);
        return true;
    }

    public Rectangle internal_getDefaultBounds() {
        return this.defBounds;
    }
}

