/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableItem
extends Item {
    Table parent;
    int[] handles;
    int columnCount;
    Font font;
    Font[] cellFont;
    Color background;
    Color[] cellBackground;
    Color foreground;
    Color[] cellForeground;
    Image[] cellImage;
    boolean cached;
    int checkBoxHandle;
    int radioButtonHandle;

    public TableItem(Table table, int n, int n2) {
        this(table, n, n2, true);
    }

    public TableItem(Table table, int n) {
        this(table, n, TableItem.checkNull(table).getItemCount(), true);
    }

    TableItem(Table table, int n, int n2, boolean bl) {
        super(table, n);
        this.parent = table;
        int n3 = this.columnCount = table.columnCount > 0 ? table.columnCount : 1;
        if (bl) {
            table.apiCheck = true;
            table.apiSelection = true;
            table.createItem(this, n2);
            OS.QTableWidget_insertRow(table.internal_topHandle(), n2);
            this.ensureValid(n2);
            if (n2 == 0 && (table.style & 0x10) != 0 && (table.style & 4) != 0) {
                OS.QAbstractButton_setChecked(this.radioButtonHandle, true);
            }
            table.apiCheck = false;
            table.apiSelection = false;
        }
    }

    protected void releaseHandle() {
        this.handle = 0;
        super.releaseHandle();
        this.parent = null;
        this.deregister();
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.font = null;
        this.cellFont = null;
        this.background = null;
        this.cellBackground = null;
        this.foreground = null;
        this.cellForeground = null;
        this.cellImage = null;
        this.handles = null;
        this.radioButtonHandle = 0;
    }

    void ensureValid(int n) {
        int n2;
        if (this.cached) {
            return;
        }
        this.cached = true;
        if (this.checkBoxHandle == 0 && (this.parent.style & 0x20) != 0) {
            this.checkBoxHandle = OS.QTableWidgetItem_new();
            OS.QTableWidgetItem_setFlags(this.checkBoxHandle, 49);
            OS.QTableWidgetItem_setData(this.checkBoxHandle, 10, 0);
            OS.QTableWidget_setItem(this.parent.internal_topHandle(), n, 0, this.checkBoxHandle);
        } else if (this.radioButtonHandle == 0 && (this.parent.style & 0x10) != 0 && (this.parent.style & 4) != 0) {
            this.radioButtonHandle = OS.QRadioButton_new();
            OS.QObject_setProperty(this.radioButtonHandle, "swt_obj_idx", OS.QObject_property(this.parent.internal_topHandle(), "swt_obj_idx"));
            n2 = OS.SignalHandler_new(this.radioButtonHandle, this.display, 1002);
            OS.QObject_connectOrThrow(this.radioButtonHandle, "released()", n2, "widgetSignal()", 0);
            OS.QWidget_setFocusPolicy(this.radioButtonHandle, 0);
            OS.QTableWidget_setCellWidget(this.parent.internal_topHandle(), n, 0, this.radioButtonHandle);
        }
        for (n2 = 0; n2 < this.columnCount; ++n2) {
            this.createCellItem(n, n2);
        }
    }

    void removeColumn(int n) {
        if (this.columnCount == 1) {
            return;
        }
        if (n < this.columnCount - 1) {
            if (this.handles != null) {
                System.arraycopy(this.handles, n + 1, this.handles, n, this.columnCount - n - 1);
            }
            if (this.cellForeground != null) {
                System.arraycopy(this.cellForeground, n + 1, this.cellForeground, n, this.columnCount - n - 1);
            }
            if (this.cellBackground != null) {
                System.arraycopy(this.cellBackground, n + 1, this.cellBackground, n, this.columnCount - n - 1);
            }
            if (this.cellImage != null) {
                System.arraycopy(this.cellImage, n + 1, this.cellImage, n, this.columnCount - n - 1);
            }
            if (this.cellFont != null) {
                System.arraycopy(this.cellFont, n + 1, this.cellFont, n, this.columnCount - n - 1);
            }
        }
        --this.columnCount;
        if (this.handles != null) {
            this.handles[this.columnCount] = 0;
        }
        if (this.cellForeground != null) {
            this.cellForeground[this.columnCount] = null;
        }
        if (this.cellBackground != null) {
            this.cellBackground[this.columnCount] = null;
        }
        if (this.cellImage != null) {
            this.cellImage[this.columnCount] = null;
        }
        if (this.cellFont != null) {
            this.cellFont[this.columnCount] = null;
        }
    }

    void addColumn(int n, int n2) {
        ++this.columnCount;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
        if (this.handles != null) {
            if (this.columnCount > this.handles.length) {
                int[] nArray = new int[this.columnCount];
                System.arraycopy(this.handles, 0, nArray, 0, this.handles.length);
                this.handles = nArray;
            }
            if (n2 < this.columnCount - 1) {
                System.arraycopy(this.handles, n2, this.handles, n2 + 1, this.columnCount - n2 - 1);
            }
            this.handles[n2] = 0;
        }
        this.cellForeground = this.updateColorArray(this.cellForeground, n2);
        this.cellBackground = this.updateColorArray(this.cellForeground, n2);
        this.cellImage = this.updateImageArray(this.cellImage, n2);
        this.cellFont = this.updateFontArray(this.cellFont, n2);
        this.createCellItem(n, n2);
    }

    Image[] updateImageArray(Image[] imageArray, int n) {
        if (imageArray != null) {
            if (this.columnCount > imageArray.length) {
                Image[] imageArray2 = new Image[this.columnCount];
                System.arraycopy(imageArray, 0, imageArray2, 0, imageArray.length);
                imageArray = imageArray2;
            }
            if (n < this.columnCount - 1) {
                System.arraycopy(imageArray, n, imageArray, n + 1, this.columnCount - n - 1);
            }
            imageArray[n] = null;
        }
        return imageArray;
    }

    Color[] updateColorArray(Color[] colorArray, int n) {
        if (colorArray != null) {
            if (this.columnCount > colorArray.length) {
                Color[] colorArray2 = new Color[this.columnCount];
                System.arraycopy(colorArray, 0, colorArray2, 0, colorArray.length);
                colorArray = colorArray2;
            }
            if (n < this.columnCount - 1) {
                System.arraycopy(colorArray, n, colorArray, n + 1, this.columnCount - n - 1);
            }
            colorArray[n] = null;
        }
        return colorArray;
    }

    Font[] updateFontArray(Font[] fontArray, int n) {
        if (fontArray != null) {
            if (this.columnCount > fontArray.length) {
                Font[] fontArray2 = new Font[this.columnCount];
                System.arraycopy(fontArray, 0, fontArray2, 0, fontArray.length);
                fontArray = fontArray2;
            }
            if (n < this.columnCount - 1) {
                System.arraycopy(fontArray, n, fontArray, n + 1, this.columnCount - n - 1);
            }
            fontArray[n] = null;
        }
        return fontArray;
    }

    void createCellItem(int n, int n2) {
        if (this.handles == null) {
            this.handles = new int[this.columnCount];
        }
        if (this.handles[n2] == 0) {
            this.handles[n2] = OS.QTableWidgetItem_new();
            OS.QTableWidgetItem_setFlags(this.handles[n2], 33);
            if (this.parent.columnCount > n2) {
                TableColumn tableColumn = this.parent.getColumn(n2);
                OS.QTableWidgetItem_setTextAlignment(this.handles[n2], tableColumn.getQtAlignment());
            }
            OS.QTableWidget_setItem(this.parent.internal_topHandle(), n, this.parent.getNativeColumnIndex(n2), this.handles[n2]);
            if (this.background != null) {
                OS.QTableWidgetItem_swt_setBackground(this.handles[n2], this.background.getRed(), this.background.getGreen(), this.background.getBlue(), false);
            }
            if (this.foreground != null) {
                OS.QTableWidgetItem_swt_setForeground(this.handles[n2], this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue(), false);
            }
            if (this.font != null) {
                OS.QTableWidgetItem_swt_setFont(this.handles[n2], this.font.handle);
            }
        }
    }

    void setSelected(boolean bl) {
        if (this.handles == null) {
            return;
        }
        this.parent.apiSelection = true;
        for (int i = 0; i < this.handles.length; ++i) {
            OS.QTableWidgetItem_setSelected(this.getHandle(i), bl);
        }
        if ((this.parent.style & 4) != 0 && (this.parent.style & 0x10) != 0) {
            OS.QAbstractButton_setChecked(this.radioButtonHandle, bl);
        }
        this.parent.apiSelection = false;
    }

    boolean isSelected() {
        if ((this.parent.style & 4) != 0 && (this.parent.style & 0x10) != 0) {
            return OS.QAbstractButton_isChecked(this.radioButtonHandle);
        }
        if (this.handles != null) {
            for (int i = 0; i < this.handles.length; ++i) {
                if (!OS.QTableWidgetItem_isSelected(this.getHandle(i))) continue;
                return true;
            }
        }
        return false;
    }

    int getHandle(int n) {
        if (n >= 0 && n < this.handles.length) {
            return this.handles[n];
        }
        return 0;
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public boolean isDisposed() {
        if (this.parent != null && (this.parent.style & 0x10000000) == 0) {
            if (this.handles == null) {
                return true;
            }
            if (this.handles.length == 0) {
                return true;
            }
            if (this.handles[0] == 0) {
                return true;
            }
        }
        return super.isDisposed();
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int internal_topHandle() {
        if (this.handles != null && this.handles.length > 0) {
            return this.handles[0];
        }
        return 0;
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (this.background != null) {
            return this.background;
        }
        return this.parent.getBackground();
    }

    public Color getBackground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (0 > n || this.handles.length < n) {
            return this.getBackground();
        }
        if (this.cellBackground != null && this.cellBackground[n] != null) {
            return this.cellBackground[n];
        }
        if (this.background != null) {
            return this.background;
        }
        return this.parent.getBackground();
    }

    public Rectangle getBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (n < 0 || this.handles == null || n >= this.handles.length) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n2 = this.getHandle(n);
        return OS.QTableWidget_visualItemRect(this.parent.internal_topHandle(), n2);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return OS.QTableWidgetItem_data(this.checkBoxHandle, 10) == 2;
    }

    boolean getRadioSelected() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x10) == 0) {
            return false;
        }
        return OS.QAbstractButton_isChecked(this.radioButtonHandle);
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (0 > n || n > n2 - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[n] == null) {
            return this.getFont();
        }
        return this.cellFont[n];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent.getForeground();
    }

    public Color getForeground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (0 > n || this.columnCount < n) {
            return this.getForeground();
        }
        if (this.cellForeground != null && this.cellForeground[n] != null) {
            return this.cellForeground[n];
        }
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent.getForeground();
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return OS.QTableWidgetItem_grayed(this.checkBoxHandle);
    }

    public Image getImage(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (n < 0 || n >= this.columnCount) {
            return null;
        }
        if (this.cellImage == null) {
            return null;
        }
        return this.cellImage[n];
    }

    public Rectangle getImageBounds(int n) {
        Rectangle rectangle = this.getBounds(n);
        rectangle.width = 0;
        rectangle.height = 0;
        if (n < 0 || this.handles == null || n >= this.columnCount || this.cellImage == null || this.cellImage[n] == null) {
            return rectangle;
        }
        Point point = OS.QAbstractItemView_iconSize(this.parent.internal_topHandle());
        rectangle.width = point.x;
        rectangle.height = point.y;
        return rectangle;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (n < 0 || n >= this.columnCount) {
            return "";
        }
        return OS.QTableWidgetItem_text(this.getHandle(n));
    }

    public String getText() {
        return this.getText(0);
    }

    public void setBackground(Color color) {
        int n;
        int n2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.background = color;
        if (this.checkBoxHandle != 0) {
            Color color2 = this.getBackground();
            boolean bl2 = color2 == null;
            int bl = color2 != null ? color2.getRed() : 0;
            n2 = color2 != null ? color2.getGreen() : 0;
            n = color2 != null ? color2.getBlue() : 0;
            OS.QTableWidgetItem_swt_setBackground(this.checkBoxHandle, bl, n2, n, bl2);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            Color color3 = this.getBackground(i);
            boolean bl = color3 == null;
            n2 = color3 != null ? color3.getRed() : 0;
            n = color3 != null ? color3.getGreen() : 0;
            int n3 = color3 != null ? color3.getBlue() : 0;
            OS.QTableWidgetItem_swt_setBackground(this.getHandle(i), n2, n, n3, bl);
        }
    }

    public void setBackground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (n < 0 || n >= this.handles.length) {
            return;
        }
        if (this.cellBackground == null) {
            if (color == null) {
                return;
            }
            this.cellBackground = new Color[this.columnCount];
        }
        this.cellBackground[n] = color;
        Color color2 = this.getBackground(n);
        boolean bl = color2 == null;
        int n2 = color2 != null ? color2.getRed() : 0;
        int n3 = color2 != null ? color2.getGreen() : 0;
        int n4 = color2 != null ? color2.getBlue() : 0;
        OS.QTableWidgetItem_swt_setBackground(this.getHandle(n), n2, n3, n4, bl);
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.getGrayed()) {
            return;
        }
        int n = bl ? 2 : 0;
        this.parent.apiCheck = true;
        OS.QTableWidgetItem_setData(this.checkBoxHandle, 10, n);
        this.parent.apiCheck = false;
    }

    public void setFont(Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        int n = font != null ? font.handle : 0;
        for (int i = 0; i < this.columnCount; ++i) {
            OS.QTableWidgetItem_swt_setFont(this.getHandle(i), n);
        }
        this.parent.updateRowHeight(this);
    }

    public void setFont(int n, Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (n < 0 || n >= this.columnCount) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[this.columnCount];
        }
        if ((font2 = this.cellFont[n]) == font) {
            return;
        }
        this.cellFont[n] = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        int n2 = font != null ? font.handle : 0;
        OS.QTableWidgetItem_swt_setFont(this.getHandle(n), n2);
        this.parent.updateRowHeight(this);
    }

    public void setForeground(Color color) {
        int n;
        int n2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.foreground = color;
        if (this.checkBoxHandle != 0) {
            Color color2 = this.getForeground();
            boolean bl2 = color2 == null;
            int bl = color2 != null ? color2.getRed() : 0;
            n2 = color2 != null ? color2.getGreen() : 0;
            n = color2 != null ? color2.getBlue() : 0;
            OS.QTableWidgetItem_swt_setForeground(this.checkBoxHandle, bl, n2, n, bl2);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            Color color3 = this.getForeground(i);
            boolean bl = color3 == null;
            n2 = color3 != null ? color3.getRed() : 0;
            n = color3 != null ? color3.getGreen() : 0;
            int n3 = color3 != null ? color3.getBlue() : 0;
            OS.QTableWidgetItem_swt_setForeground(this.getHandle(i), n2, n, n3, bl);
        }
    }

    public void setForeground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (n < 0 || n >= this.handles.length) {
            return;
        }
        if (this.cellForeground == null) {
            if (color == null) {
                return;
            }
            this.cellForeground = new Color[this.columnCount];
        }
        this.cellForeground[n] = color;
        Color color2 = this.getForeground(n);
        boolean bl = color2 == null;
        int n2 = color2 != null ? color2.getRed() : 0;
        int n3 = color2 != null ? color2.getGreen() : 0;
        int n4 = color2 != null ? color2.getBlue() : 0;
        OS.QTableWidgetItem_swt_setForeground(this.getHandle(n), n2, n3, n4, bl);
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        OS.QTableWidgetItem_swt_setGrayed(this.checkBoxHandle, bl);
    }

    public void setImage(int n, Image image) {
        this.checkWidget();
        if (n < 0 || n >= this.columnCount) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (n == 0) {
            this.image = image;
        }
        if (this.cellImage == null) {
            if (image == null) {
                return;
            }
            this.cellImage = new Image[this.columnCount];
        }
        this.cellImage[n] = image;
        if (image != null) {
            Rectangle rectangle = image.getBounds();
            this.parent.updateImageSize(rectangle.width, rectangle.height);
            OS.QTableWidgetItem_setIcon(this.getHandle(n), image.internal_getIconHandle());
        } else {
            OS.QTableWidgetItem_setIcon(this.getHandle(n), Image.internal_getNullIconHandle());
        }
        this.parent.updateRowHeight(false);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        this.setImage(0, image);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        for (int i = 0; i < imageArray.length; ++i) {
            this.setImage(i, imageArray[i]);
        }
    }

    public void setText(int n, String string) {
        this.checkWidget();
        this._setText(n, string);
        if (this.parent.getWordWrap()) {
            this.parent.updateRowHeight(this);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        this._setText(0, string);
        if (this.parent.getWordWrap()) {
            this.parent.updateRowHeight(this);
        }
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            this._setText(i, string);
        }
        if (this.parent.getWordWrap()) {
            this.parent.updateRowHeight(this);
        }
    }

    void _setText(int n, String string) {
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= this.columnCount) {
            return;
        }
        OS.QTableWidgetItem_setText(this.getHandle(n), string);
    }
}

