/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    String text;
    String message;
    TrayItem item;
    int x;
    int y;
    int timerId;
    int layoutText = 0;
    int layoutMessage = 0;
    int[] borderPolygon;
    boolean spikeAbove;
    boolean autohide;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 8000;

    public ToolTip(Shell shell, int n) {
        super(shell, ToolTip.checkStyle(n));
        this.parent = shell;
        this.createWidget(0);
    }

    static int checkStyle(int n) {
        int n2 = 11;
        if ((n & n2) == 0) {
            return n;
        }
        return ToolTip.checkBits(n, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
    }

    protected void createHandle(int n) {
        this.state |= 8;
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
        this.message = "";
        this.y = -1;
        this.x = -1;
        this.autohide = true;
    }

    protected void deregister() {
        super.deregister();
        if ((this.style & 0x1000) == 0) {
            // empty if block
        }
    }

    void destroyWidget() {
        int n = this.internal_topHandle();
        this.releaseHandle();
        if (n == 0 || (this.state & 8) == 0 || (this.style & 0x1000) != 0) {
            // empty if block
        }
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    Point getLocation() {
        int n = this.x;
        int n2 = this.y;
        return new Point(n, n2);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    String getNameText() {
        return this.getText();
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    Point getSize(int n) {
        return null;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        return false;
    }

    int gtk_button_press_event(int n, int n2) {
        this.notifyListeners(13, new Event());
        this.setVisible(false);
        return 0;
    }

    int gtk_expose_event(int n, int n2) {
        return 0;
    }

    int gtk_size_allocate(int n, int n2) {
        return 0;
    }

    protected void hookEvents() {
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    protected void register() {
        super.register();
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.timerId = 0;
        this.text = null;
        this.message = null;
        this.borderPolygon = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAutoHide(boolean bl) {
        this.checkWidget();
        this.autohide = bl;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
    }

    public void setVisible(boolean bl) {
    }

    int timerProc(int n) {
        return 0;
    }
}

