/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    String toolTipText;

    public TrayItem(Tray tray, int n) {
        super(tray, n);
        this.parent = tray;
        this.createWidget(tray.getItemCount());
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.parent.createItem(this, n);
        OS.QSystemTrayIcon_setVisible(this.handle, true);
    }

    protected void createHandle(int n) {
        this.getDisplay();
        this.handle = OS.QSystemTrayIcon_new(Display.handle);
        this.state |= 8;
    }

    void destroyWidget() {
        super.destroyWidget();
    }

    protected void releaseParent() {
        this.parent.destroyItem(this);
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    protected void qt_signal_tray_activated(int n) {
        switch (n) {
            case 1: {
                this.sendEvent(35);
                break;
            }
            case 3: {
                this.sendEvent(13);
                break;
            }
            case 2: {
                this.sendEvent(14);
                break;
            }
        }
    }

    protected void hookEvents() {
        int n = OS.SignalHandler_new(this.handle, this.display, 1030);
        OS.QObject_connectOrThrow(this.handle, "activated(QSystemTrayIcon::ActivationReason)", n, "widgetSignal(QSystemTrayIcon::ActivationReason)", 0);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.QSystemTrayIcon_isVisible(this.handle);
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.toolTipText = null;
        this.parent = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            OS.QSystemTrayIcon_setIcon(this.handle, image.internal_getIconHandle());
        } else {
            OS.QSystemTrayIcon_setIcon(this.handle, Image.internal_getNullIconHandle());
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        OS.QSystemTrayIcon_setToolTip(this.handle, string);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (OS.QSystemTrayIcon_isVisible(this.handle) == bl) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        } else {
            this.sendEvent(23);
        }
        OS.QSystemTrayIcon_setVisible(this.handle, bl);
    }
}

