/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends Composite {
    TreeItem[] topLevelItems;
    int topLevelItemCount;
    boolean ignoreSelectionEvent;
    boolean ignoreExpandEvent;
    int[] topLevelItemsHandle;
    int expandedItemCount = 0;

    static int checkStyle(int n) {
        return Tree.checkBits(n |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    public Tree(Composite composite, int n) {
        super(composite, Tree.checkStyle(n));
    }

    TreeItem _getItem(int n) {
        if ((this.style & 0x10000000) == 0) {
            return this.topLevelItems[n];
        }
        if (this.topLevelItems[n] != null) {
            return this.topLevelItems[n];
        }
        this.topLevelItems[n] = new TreeItem(this, 0, n, false);
        return this.topLevelItems[n];
    }

    void _showItem(TreeItem treeItem, int n) {
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.getParent() != this) {
            return;
        }
        int n2 = treeItem.internal_itemHandle();
        if ((this.style & 0x10000000) != 0 && !treeItem.cached) {
            TreeItem treeItem2 = treeItem.getParentItem();
            if (treeItem2 != null) {
                for (int i = 0; i < treeItem2.childrenItemCount; ++i) {
                    if (treeItem != treeItem2.childrenItems[i]) continue;
                    n2 = treeItem2.childrenItemsHandle[i];
                    break;
                }
            } else {
                for (int i = 0; i < this.topLevelItemCount; ++i) {
                    if (treeItem != this.topLevelItems[i]) continue;
                    n2 = this.topLevelItemsHandle[i];
                    break;
                }
            }
        }
        OS.QTreeWidget_scrollToItem(this.internal_topHandle(), n2, n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addTopLevelItem(TreeItem treeItem, int n, int n2) {
        if (0 > n || n > this.topLevelItemCount) {
            this.error(6);
        }
        this.increaseArraySize();
        System.arraycopy(this.topLevelItems, n, this.topLevelItems, n + 1, this.topLevelItemCount + 1 - n);
        this.topLevelItems[n] = treeItem;
        System.arraycopy(this.topLevelItemsHandle, n, this.topLevelItemsHandle, n + 1, this.topLevelItemCount + 1 - n);
        this.topLevelItemsHandle[n] = n2;
        ++this.topLevelItemCount;
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    boolean checkData(TreeItem treeItem, int n) {
        if (treeItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            if (n == -1) {
                return false;
            }
            Event event = new Event();
            event.item = treeItem;
            event.index = n;
            treeItem.ensureValid(n);
            this.sendEvent(36, event);
            if (this.isDisposed()) {
                return false;
            }
            if (treeItem.isDisposed()) {
                return false;
            }
        }
        if (this.isDisposed()) {
            return false;
        }
        return treeItem != null && !treeItem.isDisposed();
    }

    boolean checkData(TreeItem treeItem, TreeItem treeItem2) {
        return this.checkData(treeItem, treeItem2 == null ? this.getItemIndex(treeItem) : treeItem2.getChildItemIndex(treeItem));
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clearSelection() {
        for (int i = 0; i < this.topLevelItemCount; ++i) {
            TreeItem treeItem = this._getItem(i);
            treeItem.selection = false;
            treeItem.clearSelection();
        }
    }

    protected void createHandle(int n) {
        this.scrollAreaHandle = OS.QTreeWidget_new();
        this.handle = OS.QAbstractScrollArea_viewPort(this.internal_topHandle());
        this.state |= 8;
        this.state &= 0xFFFFFFFD;
        OS.QTreeWidget_setColumnCount(this.internal_topHandle(), 1);
        if ((this.style & 2) != 0) {
            OS.QAbstractItemView_setSelectionMode(this.internal_topHandle(), 2);
        } else {
            OS.QAbstractItemView_setSelectionMode(this.internal_topHandle(), 1);
        }
        OS.QTreeWidget_swt_setHeaderVisible(this.internal_topHandle(), false);
    }

    protected void createWidget(int n) {
        super.createWidget(n);
        this.topLevelItems = new TreeItem[4];
        this.topLevelItemCount = 0;
        this.topLevelItemsHandle = new int[4];
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.ignoreSelectionEvent = true;
        OS.QAbstractItemView_clearSelection(this.internal_topHandle());
        if ((this.style & 0x10000000) != 0) {
            this.clearSelection();
        }
        this.ignoreSelectionEvent = false;
    }

    TreeItem findParentItem(int n) {
        TreeItem treeItem = null;
        for (int i = 0; i < this.topLevelItemCount; ++i) {
            if (this.topLevelItemsHandle[i] == n) {
                treeItem = this._getItem(i);
                break;
            }
            TreeItem treeItem2 = this._getItem(i);
            if (treeItem2.cached && treeItem2.getExpanded()) {
                treeItem = treeItem2.findItem(n);
            }
            if (treeItem != null) break;
        }
        return treeItem;
    }

    public TreeItem getItem(Point point) {
        int n;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((n = OS.QTreeWidget_itemAt(this.internal_topHandle(), point.x, point.y)) == -1) {
            return null;
        }
        TreeItem treeItem = null;
        for (int i = 0; i < this.topLevelItemCount; ++i) {
            if (this.topLevelItemsHandle[i] == n) {
                treeItem = this._getItem(i);
                break;
            }
            treeItem = this._getItem(i).getItem(n);
            if (treeItem != null) break;
        }
        return treeItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.topLevelItemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        int n = 0;
        if (this.topLevelItemCount > 0) {
            n = OS.QAbstractItemView_sizeHintForRow(this.internal_topHandle(), 0);
        } else {
            OS.QTreeWidget_addTopLevelItem(this.internal_topHandle(), OS.QTreeWidgetItem_new());
            n = OS.QAbstractItemView_sizeHintForRow(this.internal_topHandle(), 0);
            OS.QTreeWidget_clear(this.internal_topHandle());
        }
        return n;
    }

    int getItemIndex(TreeItem treeItem) {
        if (treeItem == null) {
            this.error(4);
        }
        if (this.topLevelItemCount == 0 || this.topLevelItems == null || treeItem.getParent() != this) {
            return -1;
        }
        return OS.QTreeWidget_indexOfTopLevelItem(this.internal_topHandle(), treeItem.internal_itemHandle());
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (this.topLevelItemCount == 0) {
            return new TreeItem[0];
        }
        TreeItem[] treeItemArray = new TreeItem[this.topLevelItemCount];
        if ((this.style & 0x10000000) != 0) {
            for (int i = 0; i < this.topLevelItemCount; ++i) {
                treeItemArray[i] = this._getItem(i);
            }
        } else {
            System.arraycopy(this.topLevelItems, 0, treeItemArray, 0, this.topLevelItemCount);
        }
        return treeItemArray;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    protected Point getPreferredClientAreaSize() {
        Point point = OS.QWidget_sizeHint(this.internal_topHandle());
        if (this.topLevelItemCount > 0) {
            point.y = this.topLevelItemCount * this.getItemHeight();
            point.x = OS.QTreeView_columnWidth(this.internal_topHandle(), 0);
        }
        return point;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        int[] nArray = OS.QTreeWidget_selectedItems(this.internal_topHandle());
        TreeItem[] treeItemArray = new TreeItem[nArray.length];
        block0: for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.topLevelItemCount; ++j) {
                if (this.topLevelItems[j].itemHandle == nArray[i]) {
                    treeItemArray[i] = this.topLevelItems[j];
                    continue block0;
                }
                TreeItem treeItem = this.topLevelItems[j].getItem(nArray[i]);
                if (treeItem == null) continue;
                treeItemArray[i] = treeItem;
                continue block0;
            }
        }
        return treeItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return OS.QTreeWidget_swt_selectionCount(this.internal_topHandle());
    }

    public TreeItem getTopItem() {
        return this.getItem(new Point(1, 1));
    }

    protected void hookEvents() {
        super.hookEvents();
        int n = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1031);
        OS.QObject_connectOrThrow(this.internal_topHandle(), "itemSelectionChanged()", n, "widgetSignal()", 0);
        int n2 = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1032);
        OS.QObject_connectOrThrow(this.internal_topHandle(), "itemActivated(QTreeWidgetItem*,int)", n2, "widgetSignal(QTreeWidgetItem*,int)", 0);
        int n3 = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1033);
        OS.QObject_connectOrThrow(this.internal_topHandle(), "itemExpanded(QTreeWidgetItem*)", n3, "widgetSignal(QTreeWidgetItem*)", 0);
        int n4 = OS.SignalHandler_new(this.internal_topHandle(), this.display, 1034);
        OS.QObject_connectOrThrow(this.internal_topHandle(), "itemCollapsed(QTreeWidgetItem*)", n4, "widgetSignal(QTreeWidgetItem*)", 0);
    }

    void increaseArraySize() {
        Object[] objectArray;
        int n;
        if (this.topLevelItems == null) {
            this.topLevelItems = new TreeItem[4];
        }
        if (this.topLevelItemCount + 1 == this.topLevelItems.length) {
            n = Math.max(4, this.topLevelItems.length * 3 / 2);
            objectArray = new TreeItem[n];
            System.arraycopy(this.topLevelItems, 0, objectArray, 0, this.topLevelItems.length);
            this.topLevelItems = objectArray;
        }
        if (this.topLevelItemsHandle == null) {
            this.topLevelItemsHandle = new int[4];
        }
        if (this.topLevelItemCount + 1 == this.topLevelItemsHandle.length) {
            n = Math.max(4, this.topLevelItemsHandle.length * 3 / 2);
            objectArray = new int[n];
            System.arraycopy(this.topLevelItemsHandle, 0, objectArray, 0, this.topLevelItemsHandle.length);
            this.topLevelItemsHandle = (int[])objectArray;
        }
    }

    public int indexOf(TreeItem treeItem) {
        this.checkWidget();
        return this.getItemIndex(treeItem);
    }

    boolean isTopLevelLastItemAndLastChildren() {
        boolean bl = false;
        if (this.topLevelItemCount > 0) {
            TreeItem treeItem = null;
            int n = OS.QTreeWidget_currentItem(this.internal_topHandle());
            if (!(this.topLevelItems[this.topLevelItemCount - 1].itemHandle != n || this.topLevelItems[this.topLevelItemCount - 1].childrenItemCount != 0 && this.topLevelItems[this.topLevelItemCount - 1].getExpanded())) {
                return true;
            }
            treeItem = this.topLevelItems[this.topLevelItemCount - 1].getItem(n);
            if (treeItem != null && treeItem.isLastItemOfLastChild() && (treeItem.childrenItemCount == 0 || !treeItem.getExpanded())) {
                return true;
            }
        }
        return bl;
    }

    boolean qt_event_paint(int n, int n2, int n3, int n4, int n5, int n6) {
        block21: {
            int n7;
            block22: {
                if (n != this.handle || (this.style & 0x10000000) == 0 || this.topLevelItemCount <= 0) break block21;
                n7 = OS.QTreeWidget_swt_rowAt(this.internal_topHandle(), (this.style & 0x8000000) != 0 ? OS.QWidget_rect((int)this.handle).width - n2 : n2, n3);
                if (n7 == -1) break block22;
                int n8 = 0;
                int n9 = this.getItemHeight();
                n8 = this.expandedItemCount > 0 ? n7 + (n5 % n9 == 0 ? n5 / n9 : n5 / n9 + 1) - 1 : Math.min(this.topLevelItemCount - 1, n7 + (n5 % n9 == 0 ? n5 / n9 : n5 / n9 + 1) - 1);
                for (int i = n7; i <= n8; ++i) {
                    TreeItem treeItem = this._getItem(i);
                    this.checkData(treeItem, i);
                    if (treeItem.getExpanded()) {
                        int n10 = this.setAndGetRemainingItemsToPaint(treeItem, n8 - i);
                        n8 = i + n10;
                    }
                    if (i != this.topLevelItemCount - 1) {
                        continue;
                    }
                    break block21;
                }
                break block21;
            }
            if (n7 != -1) break block21;
            int n11 = OS.QTreeWidget_itemAt(this.internal_topHandle(), (this.style & 0x8000000) != 0 ? OS.QWidget_rect((int)this.handle).width - n2 : n2, n3);
            int n12 = OS.QTreeWidget_itemAt(this.internal_topHandle(), (this.style & 0x8000000) != 0 ? OS.QWidget_rect((int)this.handle).width - n2 : n2, n3 + n5);
            if (n12 != 0 || n11 != 0) {
                int n13 = 0;
                n13 = n12 == 0 ? OS.QTreeWidgetItem_swt_isSameParent(n11, n11) : OS.QTreeWidgetItem_swt_isSameParent(n11, n12);
                if (n13 != -1) {
                    int n14 = OS.QTreeWidgetItem_indexOfChild(n13, n11);
                    int n15 = 0;
                    n15 = n12 == 0 ? OS.QTreeWidget_swt_parentChildCount(n11) - 1 : OS.QTreeWidgetItem_indexOfChild(n13, n12);
                    TreeItem treeItem = this.findParentItem(n13);
                    int n16 = this.getItemHeight();
                    int n17 = n5 % n16 == 0 ? n5 / n16 : n5 / n16 + 1;
                    for (int i = n14; i <= n15; ++i) {
                        TreeItem treeItem2 = treeItem._getItem(i);
                        this.checkData(treeItem2, i);
                        --n17;
                        n17 = this.setAndGetRemainingItemsToPaint(treeItem2, n17);
                    }
                    TreeItem treeItem3 = null;
                    block2: while (treeItem != null && n17 > 0) {
                        TreeItem treeItem4;
                        int n18;
                        int n19;
                        int n20;
                        treeItem3 = treeItem;
                        if ((treeItem = treeItem3.getParentItem()) != null) {
                            n20 = OS.QTreeWidgetItem_indexOfChild(treeItem.internal_itemHandle(), treeItem3.internal_itemHandle());
                            n19 = treeItem.childrenItemCount - (n20 + 1) > n17 ? n17 : treeItem.childrenItemCount - 1;
                            for (n18 = n20 + 1; n18 <= n19; ++n18) {
                                treeItem4 = treeItem._getItem(n18);
                                this.checkData(treeItem4, n18);
                                --n17;
                                n17 = this.setAndGetRemainingItemsToPaint(treeItem4, n17);
                                if (n17 <= 0) continue block2;
                            }
                            continue;
                        }
                        n20 = OS.QTreeWidget_indexOfTopLevelItem(this.internal_topHandle(), treeItem3.internal_itemHandle());
                        n19 = this.topLevelItemCount - (n20 + 1) > n17 ? n17 : this.topLevelItemCount - 1;
                        for (n18 = n20 + 1; n18 <= n19; ++n18) {
                            treeItem4 = this._getItem(n18);
                            this.checkData(treeItem4, n18);
                            --n17;
                            n17 = this.setAndGetRemainingItemsToPaint(treeItem4, n17);
                            if (n17 <= 0) continue block2;
                        }
                    }
                } else {
                    TreeItem treeItem = this.findParentItem(n11);
                    TreeItem treeItem5 = treeItem.getParentItem();
                    int n21 = OS.QTreeWidgetItem_indexOfChild(treeItem5.internal_itemHandle(), n11);
                    TreeItem treeItem6 = this.findParentItem(n12);
                    TreeItem treeItem7 = null;
                    for (int i = n21; i < treeItem5.childrenItemCount; ++i) {
                        treeItem7 = treeItem5._getItem(i);
                        this.checkData(treeItem7, i);
                        if (treeItem7 == treeItem6) break;
                        if (treeItem7.getExpanded()) {
                            treeItem7 = this.upperItemPaintAndSearch(treeItem7, treeItem6, -1);
                        }
                        if (treeItem7 == treeItem6) break;
                    }
                    if (treeItem7 != treeItem6) {
                        int n22;
                        TreeItem treeItem8 = null;
                        while (treeItem5 != null) {
                            treeItem8 = treeItem5;
                            if ((treeItem5 = treeItem5.getParentItem()) != null) {
                                n22 = OS.QTreeWidgetItem_indexOfChild(treeItem5.internal_itemHandle(), treeItem8.internal_itemHandle());
                                treeItem7 = this.upperItemPaintAndSearch(treeItem5, treeItem6, n22);
                            }
                            if (treeItem7 != treeItem6) continue;
                        }
                        if (treeItem7 != treeItem6) {
                            n22 = OS.QTreeWidget_indexOfTopLevelItem(this.internal_topHandle(), treeItem8.internal_itemHandle());
                            for (int i = n22 + 1; i < this.topLevelItemCount; ++i) {
                                TreeItem treeItem9 = this._getItem(i);
                                this.checkData(treeItem9, i);
                                if (treeItem9 != treeItem6) {
                                    if (treeItem9.getExpanded()) {
                                        treeItem7 = this.upperItemPaintAndSearch(treeItem9, treeItem6, -1);
                                    }
                                    if (treeItem7 != treeItem6) {
                                        continue;
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
            }
        }
        return super.qt_event_paint(n, n2, n3, n4, n5, n6);
    }

    protected void qt_signal_tree_itemActivated(int n, int n2) {
        if (!this.ignoreSelectionEvent) {
            this.sendEvent(14);
        }
    }

    protected void qt_signal_tree_itemCollapsed(int n) {
        --this.expandedItemCount;
        if (!this.ignoreExpandEvent) {
            this.sendEvent(18);
        }
    }

    protected void qt_signal_tree_itemExpanded(int n) {
        ++this.expandedItemCount;
        if (!this.ignoreExpandEvent) {
            this.sendEvent(17);
        }
        this.updateColumnWidth();
    }

    protected void qt_signal_tree_itemSelectionChanged() {
        if (!this.ignoreSelectionEvent) {
            this.sendEvent(13);
        }
    }

    protected void releaseChildren(boolean bl) {
        if (this.topLevelItems != null) {
            for (int i = this.topLevelItemCount - 1; i >= 0; --i) {
                TreeItem treeItem = this._getItem(i);
                if (!treeItem.cached || treeItem == null || treeItem.isDisposed()) continue;
                treeItem.childrenItemCount = 0;
                treeItem.childrenItems = null;
                treeItem.childrenItemsHandle = null;
                treeItem.itemHandle = 0;
                treeItem.parentItem = null;
                treeItem.tree = null;
                treeItem.cached = false;
                treeItem.release(bl);
            }
        }
        OS.QTreeWidget_clear(this.internal_topHandle());
        super.releaseChildren(bl);
    }

    protected void releaseHandle() {
        this.expandedItemCount = 0;
        this.topLevelItems = null;
        this.topLevelItemCount = 0;
        this.topLevelItemsHandle = null;
        super.releaseHandle();
    }

    void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.topLevelItemCount) {
            this.error(6);
        }
        for (int i = n2; i >= n; --i) {
            TreeItem treeItem = this._getItem(i);
            if (treeItem == null || treeItem.isDisposed()) continue;
            treeItem.release(false);
        }
    }

    public void removeAll() {
        this.checkWidget();
        OS.QTreeWidget_clear(this.internal_topHandle());
        this.expandedItemCount = 0;
        this.topLevelItems = null;
        this.topLevelItemCount = 0;
        this.topLevelItemsHandle = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, treeListener);
        this.eventTable.unhook(18, treeListener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.ignoreSelectionEvent = true;
        OS.QTreeView_selectAll(this.internal_topHandle());
        this.ignoreSelectionEvent = false;
    }

    int setAndGetRemainingItemsToPaint(TreeItem treeItem, int n) {
        int n2 = n;
        if (treeItem.getExpanded()) {
            int n3 = Math.min(n, treeItem.childrenItemCount);
            for (int i = 0; i < n3; ++i) {
                if (n2 <= 0) continue;
                TreeItem treeItem2 = treeItem._getItem(i);
                this.checkData(treeItem2, i);
                --n2;
                if (!treeItem2.getExpanded()) continue;
                n2 = this.setAndGetRemainingItemsToPaint(treeItem2, n2);
            }
        }
        return n2;
    }

    public void setItemCount(int n) {
        boolean bl;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.topLevelItemCount) {
            return;
        }
        boolean bl2 = bl = (this.style & 0x10000000) != 0;
        if (!bl) {
            this.setRedraw(false);
        }
        int n2 = this.topLevelItemCount;
        this.remove(n, this.topLevelItemCount - 1);
        int n3 = Math.max(4, (n + 3) / 4 * 4);
        TreeItem[] treeItemArray = new TreeItem[n3];
        if (this.topLevelItems == null) {
            this.topLevelItems = new TreeItem[n];
        }
        System.arraycopy(this.topLevelItems, 0, treeItemArray, 0, this.topLevelItemCount);
        this.topLevelItems = treeItemArray;
        if (bl) {
            if (n2 < n) {
                int[] nArray = OS.QTreeWidget_addTopLevelItems(this.internal_topHandle(), n - this.topLevelItemCount);
                int[] nArray2 = new int[n];
                if (this.topLevelItemsHandle == null) {
                    this.topLevelItemsHandle = new int[n];
                }
                System.arraycopy(this.topLevelItemsHandle, 0, nArray2, 0, this.topLevelItemCount);
                System.arraycopy(nArray, 0, nArray2, this.topLevelItemCount, nArray.length);
                this.topLevelItemsHandle = nArray2;
            }
            this.topLevelItemCount = n;
        } else {
            for (int i = this.topLevelItemCount; i < n; ++i) {
                new TreeItem(this, 0, i);
            }
        }
        if (!bl) {
            this.setRedraw(true);
        }
    }

    public void setSelection(TreeItem[] treeItemArray) {
        int n;
        this.checkWidget();
        if (treeItemArray == null) {
            this.error(4);
        }
        this.ignoreSelectionEvent = true;
        OS.QAbstractItemView_clearSelection(this.internal_topHandle());
        if (treeItemArray.length == 0 || (this.style & 4) != 0 && treeItemArray.length > 1) {
            return;
        }
        TreeItem[] treeItemArray2 = new TreeItem[treeItemArray.length];
        int n2 = 0;
        for (n = 0; n < treeItemArray.length; ++n) {
            if (treeItemArray[n] == null || treeItemArray[n].isDisposed() || treeItemArray[n].getParent() != this) continue;
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                if (!treeItemArray2[i].equals(treeItemArray[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            treeItemArray2[n2] = treeItemArray[n];
            ++n2;
        }
        if (n2 < treeItemArray2.length) {
            TreeItem[] treeItemArray3 = new TreeItem[n2];
            System.arraycopy(treeItemArray2, 0, treeItemArray3, 0, n2);
            treeItemArray2 = treeItemArray3;
        }
        for (n = 0; n < treeItemArray2.length; ++n) {
            if ((this.style & 0x10000000) != 0) {
                if (treeItemArray2[n].cached) {
                    OS.QTreeWidget_setCurrentItem(this.internal_topHandle(), treeItemArray2[n].internal_itemHandle());
                }
                treeItemArray2[n].selection = true;
                continue;
            }
            OS.QTreeWidget_setCurrentItem(this.internal_topHandle(), treeItemArray2[n].internal_itemHandle());
        }
        this.ignoreSelectionEvent = false;
    }

    public void setTopItem(TreeItem treeItem) {
        this.checkWidget();
        this._showItem(treeItem, 1);
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        this.traverseDoit = false;
        this.traverseCancel = false;
        if (n == 4) {
            return;
        }
        switch (n2) {
            case 0x1000012: 
            case 0x1000014: {
                this.traverseDoit = false;
                break;
            }
            case 0x1000013: {
                if (this.topLevelItems[0].itemHandle != OS.QTreeWidget_currentItem(this.internal_topHandle())) break;
                this.traverseDoit = true;
                break;
            }
            case 0x1000015: {
                if (!this.isTopLevelLastItemAndLastChildren()) break;
                this.traverseDoit = true;
                break;
            }
            default: {
                super.setTraversalFlags(n, n2, n3, n4);
            }
        }
    }

    public void showItem(TreeItem treeItem) {
        this.checkWidget();
        this._showItem(treeItem, 0);
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] treeItemArray = this.getSelection();
        if (treeItemArray.length == 0) {
            return;
        }
        this._showItem(treeItemArray[0], 0);
    }

    void updateColumnWidth() {
        if (this.isDisposed()) {
            return;
        }
        OS.QTreeWidget_swt_setHeaderStretch(this.internal_topHandle(), false);
        OS.QTreeView_resizeColumnToContents(this.internal_topHandle(), 0);
    }

    TreeItem upperItemPaintAndSearch(TreeItem treeItem, TreeItem treeItem2, int n) {
        TreeItem treeItem3 = null;
        if (treeItem != null && treeItem.getExpanded()) {
            for (int i = n + 1; i < treeItem.childrenItemCount; ++i) {
                treeItem3 = treeItem._getItem(i);
                this.checkData(treeItem3, i);
                if (treeItem3 == treeItem2) break;
                if (treeItem3.getExpanded()) {
                    treeItem3 = this.upperItemPaintAndSearch(treeItem3, treeItem2, -1);
                }
                if (treeItem3 == treeItem2) break;
            }
        }
        return treeItem3;
    }
}

