/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    Tree tree;
    int itemHandle;
    TreeItem parentItem;
    TreeItem[] childrenItems;
    int childrenItemCount;
    int[] childrenItemsHandle;
    Font font;
    Color background;
    Color foreground;
    boolean grayed;
    boolean cached;
    int checkedState;
    boolean selection;

    static Tree checkNull(Tree tree) {
        if (tree == null) {
            SWT.error(4);
        }
        return tree;
    }

    static TreeItem checkNull(TreeItem treeItem) {
        if (treeItem == null) {
            SWT.error(4);
        }
        return treeItem;
    }

    public TreeItem(Tree tree, int n) {
        this(tree, n, TreeItem.checkNull(tree).getItemCount(), true);
    }

    public TreeItem(Tree tree, int n, int n2) {
        this(tree, n, n2, true);
    }

    TreeItem(Tree tree, int n, int n2, boolean bl) {
        super(tree, n);
        this.tree = tree;
        if (bl) {
            this.itemHandle = OS.QTreeWidgetItem_new();
            OS.QTreeWidget_insertTopLevelItem(tree.internal_topHandle(), this.itemHandle, n2);
            tree.addTopLevelItem(this, n2, this.itemHandle);
            this.ensureValid(n2);
        }
    }

    public TreeItem(TreeItem treeItem, int n) {
        this(treeItem, n, TreeItem.checkNull(treeItem).getItemCount(), true);
    }

    public TreeItem(TreeItem treeItem, int n, int n2) {
        this(treeItem, n, n2, true);
    }

    TreeItem(TreeItem treeItem, int n, int n2, boolean bl) {
        super(treeItem, n);
        this.parentItem = treeItem;
        this.tree = this.parentItem.tree;
        if (bl) {
            this.itemHandle = OS.QTreeWidgetItem_new();
            OS.QTreeWidgetItem_insertChild(treeItem.internal_itemHandle(), this.itemHandle, n2);
            this.parentItem.addChild(this, n2, this.itemHandle);
            this.ensureValid(n2);
        }
    }

    TreeItem _getItem(int n) {
        if ((this.tree.getStyle() & 0x10000000) == 0) {
            return this.childrenItems[n];
        }
        if (this.childrenItems[n] != null) {
            return this.childrenItems[n];
        }
        this.childrenItems[n] = new TreeItem(this, 0, n, false);
        return this.childrenItems[n];
    }

    int _getItemHandle() {
        int n = 0;
        TreeItem treeItem = this.getParentItem();
        if (treeItem != null) {
            for (int i = 0; i < treeItem.childrenItemCount; ++i) {
                if (this != treeItem.childrenItems[i]) continue;
                n = treeItem.childrenItemsHandle[i];
                break;
            }
        } else {
            for (int i = 0; i < this.tree.topLevelItemCount; ++i) {
                if (this != this.tree.topLevelItems[i]) continue;
                n = this.tree.topLevelItemsHandle[i];
                break;
            }
        }
        return n;
    }

    void addChild(TreeItem treeItem, int n, int n2) {
        this.increaseChildrenArraySize();
        if (0 > n || n > this.childrenItemCount) {
            this.error(6);
        }
        System.arraycopy(this.childrenItems, n, this.childrenItems, n + 1, this.childrenItemCount + 1 - n);
        this.childrenItems[n] = treeItem;
        System.arraycopy(this.childrenItemsHandle, n, this.childrenItemsHandle, n + 1, this.childrenItemCount + 1 - n);
        this.childrenItemsHandle[n] = n2;
        ++this.childrenItemCount;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void clearSelection() {
        for (int i = 0; i < this.childrenItemCount; ++i) {
            TreeItem treeItem = this._getItem(i);
            treeItem.selection = false;
            treeItem.clearSelection();
        }
    }

    void ensureValid(int n) {
        if (this.cached) {
            return;
        }
        this.cached = true;
        if (this.internal_itemHandle() == 0) {
            this.itemHandle = this.parentItem == null ? this.tree.topLevelItemsHandle[n] : this.parentItem.childrenItemsHandle[n];
        }
        if ((this.tree.getStyle() & 0x20) != 0) {
            OS.QTreeWidgetItem_setFlags(this.itemHandle, 49);
            OS.QTreeWidgetItem_setCheckState(this.itemHandle, this.checkedState);
        } else {
            OS.QTreeWidgetItem_setFlags(this.itemHandle, 33);
        }
        if (this.background != null) {
            OS.QTreeWidgetItem_swt_setBackground(this.itemHandle, this.background.getRed(), this.background.getGreen(), this.background.getBlue(), false);
        }
        if (this.foreground != null) {
            OS.QTreeWidgetItem_swt_setForeground(this.itemHandle, this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue(), false);
        }
        if (this.font != null) {
            OS.QTreeWidgetItem_swt_setFont(this.itemHandle, this.font.handle);
        }
        if (this.text != null) {
            OS.QTreeWidgetItem_setText(this.itemHandle, this.text);
        }
        if (this.image != null) {
            OS.QTreeWidgetItem_setIcon(this.itemHandle, this.image.internal_getIconHandle());
        }
        this.tree.ignoreSelectionEvent = true;
        if (this.selection && (this.tree.getStyle() & 0x10000000) != 0) {
            OS.QTreeWidgetItem_setSelected(this.internal_itemHandle(), this.selection);
            this.selection = false;
        }
        this.tree.ignoreSelectionEvent = false;
        this.tree.updateColumnWidth();
    }

    TreeItem findItem(int n) {
        TreeItem treeItem = null;
        for (int i = 0; i < this.childrenItemCount; ++i) {
            if (this.childrenItemsHandle[i] == n) {
                treeItem = this._getItem(i);
                break;
            }
            TreeItem treeItem2 = this._getItem(i);
            if (treeItem2.cached && treeItem2.getExpanded()) {
                treeItem = treeItem2.findItem(n);
            }
            if (treeItem != null) break;
        }
        return treeItem;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.cached && !this.tree.checkData(this, this.getParentItem())) {
            this.error(24);
        }
        if (this.background != null) {
            return Color.qt_new(this.display, this.background.handle);
        }
        return this.tree.getBackground();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.cached) {
            if (!this.tree.checkData(this, this.getParentItem())) {
                this.error(24);
            }
            return OS.QTreeWidget_visualItemRect(this.tree.internal_topHandle(), this.internal_itemHandle());
        }
        return OS.QTreeWidget_visualItemRect(this.tree.internal_topHandle(), this._getItemHandle());
    }

    public boolean getChecked() {
        this.checkWidget();
        if (this.cached) {
            if (!this.tree.checkData(this, this.getParentItem())) {
                this.error(24);
            }
            if ((this.tree.style & 0x20) == 0) {
                return false;
            }
            return OS.QTreeWidgetItem_checkState(this.internal_itemHandle()) == 2;
        }
        return this.checkedState == 2;
    }

    int getChildItemIndex(TreeItem treeItem) {
        if (treeItem == null) {
            this.error(4);
        }
        if (this.childrenItemCount == 0 || this.childrenItems == null || treeItem.getParent() != this.tree) {
            return -1;
        }
        return OS.QTreeWidgetItem_indexOfChild(this.internal_itemHandle(), treeItem.internal_itemHandle());
    }

    public boolean getExpanded() {
        this.checkWidget();
        if (this.cached) {
            if (!this.tree.checkData(this, this.getParentItem())) {
                this.error(24);
            }
            return OS.QTreeWidgetItem_isExpanded(this.internal_itemHandle());
        }
        return false;
    }

    public Font getFont() {
        this.checkWidget();
        if (this.cached && !this.tree.checkData(this, this.getParentItem())) {
            this.error(24);
        }
        return this.font == null ? this.getParent().getFont() : this.font;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.cached && !this.tree.checkData(this, this.getParentItem())) {
            this.error(24);
        }
        if (this.foreground != null) {
            return Color.qt_new(this.display, this.foreground.handle);
        }
        return this.tree.getForeground();
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (this.cached && !this.tree.checkData(this, this.getParentItem())) {
            this.error(24);
        }
        if ((this.tree.getStyle() & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    TreeItem getItem(int n) {
        TreeItem treeItem = null;
        for (int i = 0; i < this.childrenItemCount; ++i) {
            if (this.childrenItemsHandle[i] == n) {
                treeItem = this._getItem(i);
                break;
            }
            treeItem = this._getItem(i).getItem(n);
            if (treeItem != null) break;
        }
        return treeItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.childrenItemCount;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (this.childrenItemCount == 0) {
            return new TreeItem[0];
        }
        TreeItem[] treeItemArray = new TreeItem[this.childrenItemCount];
        if ((this.tree.getStyle() & 0x10000000) != 0) {
            for (int i = 0; i < this.childrenItemCount; ++i) {
                treeItemArray[i] = this._getItem(i);
            }
        } else {
            System.arraycopy(this.childrenItems, 0, treeItemArray, 0, this.childrenItemCount);
        }
        return treeItemArray;
    }

    public Tree getParent() {
        this.checkWidget();
        return this.tree;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        if (this.parentItem != null) {
            return this.parentItem;
        }
        return null;
    }

    void increaseChildrenArraySize() {
        Object[] objectArray;
        int n;
        if (this.childrenItems == null) {
            this.childrenItems = new TreeItem[4];
        }
        if (this.childrenItemCount + 1 == this.childrenItems.length) {
            n = Math.max(4, this.childrenItems.length * 3 / 2);
            objectArray = new TreeItem[n];
            System.arraycopy(this.childrenItems, 0, objectArray, 0, this.childrenItems.length);
            this.childrenItems = objectArray;
        }
        if (this.childrenItemsHandle == null) {
            this.childrenItemsHandle = new int[4];
        }
        if (this.childrenItemCount + 1 == this.childrenItemsHandle.length) {
            n = Math.max(4, this.childrenItemsHandle.length * 3 / 2);
            objectArray = new int[n];
            System.arraycopy(this.childrenItemsHandle, 0, objectArray, 0, this.childrenItemsHandle.length);
            this.childrenItemsHandle = (int[])objectArray;
        }
    }

    public int indexOf(TreeItem treeItem) {
        this.checkWidget();
        return this.getChildItemIndex(treeItem);
    }

    public int internal_itemHandle() {
        return this.itemHandle;
    }

    public boolean isDisposed() {
        if (this.tree != null && (this.tree.style & 0x10000000) == 0 && this.itemHandle == 0) {
            return true;
        }
        return super.isDisposed();
    }

    boolean isLastItemOfLastChild() {
        boolean bl = false;
        if (this.parentItem != null) {
            if (this.parentItem.childrenItems[this.parentItem.childrenItemCount - 1] == this) {
                bl = this.parentItem.isLastItemOfLastChild();
            }
        } else {
            bl = this.tree.topLevelItems[this.tree.topLevelItemCount - 1] == this;
        }
        return bl;
    }

    protected void releaseChildren(boolean bl) {
        if (this.childrenItems != null) {
            for (int i = this.childrenItemCount - 1; i >= 0; --i) {
                TreeItem treeItem = this._getItem(i);
                if (treeItem == null || treeItem.isDisposed()) continue;
                treeItem.release(bl);
            }
        }
    }

    protected void releaseHandle() {
        if (this.tree != null) {
            int n = this.internal_itemHandle();
            if ((this.tree.getStyle() & 0x10000000) != 0 && !this.cached) {
                n = this._getItemHandle();
            }
            if (this.cached || (this.tree.getStyle() & 0x10000000) != 0 && !this.cached) {
                if (this.getParentItem() != null) {
                    int n2 = OS.QTreeWidgetItem_indexOfChild(this.parentItem.internal_itemHandle(), n);
                    OS.QTreeWidgetItem_removeChild(this.parentItem.internal_itemHandle(), n);
                    int[] nArray = new int[this.parentItem.childrenItemsHandle.length - 1];
                    System.arraycopy(this.parentItem.childrenItemsHandle, 0, nArray, 0, n2);
                    System.arraycopy(this.parentItem.childrenItemsHandle, n2 + 1, nArray, n2, nArray.length - n2);
                    this.parentItem.childrenItemsHandle = nArray;
                    TreeItem[] treeItemArray = new TreeItem[this.parentItem.childrenItems.length - 1];
                    System.arraycopy(this.parentItem.childrenItems, 0, treeItemArray, 0, n2);
                    System.arraycopy(this.parentItem.childrenItems, n2 + 1, treeItemArray, n2, treeItemArray.length - n2);
                    this.parentItem.childrenItems = treeItemArray;
                    --this.parentItem.childrenItemCount;
                } else {
                    int n3 = OS.QTreeWidget_indexOfTopLevelItem(this.tree.internal_topHandle(), n);
                    OS.QTreeWidget_takeTopLevelItem(this.tree.internal_topHandle(), n3);
                    int[] nArray = new int[this.tree.topLevelItemsHandle.length - 1];
                    System.arraycopy(this.tree.topLevelItemsHandle, 0, nArray, 0, n3);
                    System.arraycopy(this.tree.topLevelItemsHandle, n3 + 1, nArray, n3, nArray.length - n3);
                    this.tree.topLevelItemsHandle = nArray;
                    TreeItem[] treeItemArray = new TreeItem[this.tree.topLevelItems.length - 1];
                    System.arraycopy(this.tree.topLevelItems, 0, treeItemArray, 0, n3);
                    System.arraycopy(this.tree.topLevelItems, n3 + 1, treeItemArray, n3, treeItemArray.length - n3);
                    this.tree.topLevelItems = treeItemArray;
                    --this.tree.topLevelItemCount;
                }
            }
        }
        this.childrenItemCount = 0;
        this.childrenItems = null;
        this.childrenItemsHandle = null;
        this.itemHandle = 0;
        this.parentItem = null;
        this.tree = null;
        this.cached = false;
        super.releaseHandle();
    }

    protected void releaseWidget() {
        super.releaseWidget();
        this.font = null;
        this.background = null;
        this.foreground = null;
        this.checkedState = 0;
        this.selection = false;
    }

    void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.childrenItemCount) {
            this.error(6);
        }
        for (int i = n2; i >= n; --i) {
            TreeItem treeItem = this._getItem(i);
            if (treeItem == null || treeItem.isDisposed()) continue;
            treeItem.release(false);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.background = color == null ? null : Color.qt_new(this.display, color.handle);
        if (this.cached) {
            Color color2 = this.getBackground();
            boolean bl = color2 == null;
            int n = color2 != null ? color2.getRed() : 0;
            int n2 = color2 != null ? color2.getGreen() : 0;
            int n3 = color2 != null ? color2.getBlue() : 0;
            OS.QTreeWidgetItem_swt_setBackground(this.internal_itemHandle(), n, n2, n3, bl);
        }
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.tree.getStyle() & 0x20) == 0) {
            return;
        }
        int n = this.checkedState = bl ? 2 : 0;
        if (this.cached) {
            OS.QTreeWidgetItem_setCheckState(this.internal_itemHandle(), this.checkedState);
        }
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        if (this.cached) {
            if (this.childrenItemCount == 0) {
                return;
            }
            this.tree.ignoreExpandEvent = true;
            OS.QTreeWidgetItem_setExpanded(this.internal_itemHandle(), bl);
            this.tree.ignoreExpandEvent = false;
        }
    }

    public void setFont(Font font) {
        int n;
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        int n2 = n = font != null ? font.handle : 0;
        if (this.cached) {
            OS.QTreeWidgetItem_swt_setFont(this.internal_itemHandle(), n);
            this.tree.updateColumnWidth();
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.foreground = color == null ? null : Color.qt_new(this.display, color.handle);
        if (this.cached) {
            Color color2 = this.getForeground();
            boolean bl = color2 == null;
            int n = color2 != null ? color2.getRed() : 0;
            int n2 = color2 != null ? color2.getGreen() : 0;
            int n3 = color2 != null ? color2.getBlue() : 0;
            OS.QTreeWidgetItem_swt_setForeground(this.internal_itemHandle(), n, n2, n3, bl);
        }
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.tree.getStyle() & 0x20) == 0) {
            return;
        }
        this.grayed = bl;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (this.cached) {
            if (image != null && image.isDisposed()) {
                this.error(5);
            }
            if (image != null) {
                OS.QTreeWidgetItem_setIcon(this.internal_itemHandle(), image.internal_getIconHandle());
            } else {
                OS.QTreeWidgetItem_setIcon(this.internal_itemHandle(), Image.internal_getNullIconHandle());
            }
        }
        super.setImage(image);
    }

    public void setItemCount(int n) {
        boolean bl;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.childrenItemCount) {
            return;
        }
        boolean bl2 = bl = (this.tree.style & 0x10000000) != 0;
        if (!bl) {
            this.tree.setRedraw(false);
        }
        int n2 = this.childrenItemCount;
        this.remove(n, this.childrenItemCount - 1);
        int n3 = Math.max(4, (n + 3) / 4 * 4);
        TreeItem[] treeItemArray = new TreeItem[n3];
        if (this.childrenItems == null) {
            this.childrenItems = new TreeItem[n];
        }
        System.arraycopy(this.childrenItems, 0, treeItemArray, 0, this.childrenItemCount);
        this.childrenItems = treeItemArray;
        if (bl) {
            if (n2 < n) {
                int n4 = this.internal_itemHandle();
                if ((this.tree.getStyle() & 0x10000000) != 0 && !this.cached) {
                    n4 = this._getItemHandle();
                }
                int[] nArray = OS.QTreeWidgetItem_addChildren(n4, n - this.childrenItemCount);
                int[] nArray2 = new int[n];
                if (this.childrenItemsHandle == null) {
                    this.childrenItemsHandle = new int[n];
                }
                System.arraycopy(this.childrenItemsHandle, 0, nArray2, 0, this.childrenItemCount);
                System.arraycopy(nArray, 0, nArray2, this.childrenItemCount, nArray.length);
                this.childrenItemsHandle = nArray2;
            }
            this.childrenItemCount = n;
        } else {
            for (int i = this.childrenItemCount; i < n; ++i) {
                new TreeItem(this, 0, i);
            }
        }
        if (!bl) {
            this.tree.setRedraw(true);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        if (this.cached) {
            OS.QTreeWidgetItem_setText(this.itemHandle, string);
            this.tree.updateColumnWidth();
        }
    }
}

