/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    public int handle;
    protected int style;
    protected int state;
    protected int extraStyle;
    protected Display display;
    EventTable eventTable;
    Object data;
    protected static final int DISPOSED = 1;
    protected static final int CANVAS = 2;
    protected static final int KEYED_DATA = 4;
    protected static final int HANDLE = 8;
    protected static final int DISABLED = 16;
    protected static final int MENU = 32;
    protected static final int OBSCURED = 64;
    protected static final int MOVED = 128;
    protected static final int RESIZED = 256;
    protected static final int ZERO_WIDTH = 512;
    protected static final int ZERO_HEIGHT = 1024;
    protected static final int HIDDEN = 2048;
    protected static final int FOREGROUND = 4096;
    protected static final int BACKGROUND = 8192;
    protected static final int FONT = 16384;
    protected static final int PARENT_BACKGROUND = 32768;
    protected static final int THEME_BACKGROUND = 65536;
    static final int LAYOUT_NEEDED = 131072;
    static final int LAYOUT_CHANGED = 262144;
    static final int LAYOUT_CHILD = 524288;
    static final int RELEASED = 0x100000;
    static final int DISPOSE_SENT = 0x200000;
    static final int FOREIGN_HANDLE = 0x400000;
    static final int DRAG_DETECT = 0x800000;
    protected static final int NO_TRAVERSE = 0x1000000;
    protected static final int NO_KEY_PROPAGATE = 0x2000000;
    protected static final int NO_MOUSE_PROPAGATE = 0x4000000;
    protected static final int EMBEDDED_SCROLLBARS = 0x8000000;
    protected static final int DEFAULT_WIDTH = 64;
    protected static final int DEFAULT_HEIGHT = 64;
    protected static final String SET_CANVAS_STATE_KEY = "org.eclipse.swt.internal.setCanvasState";
    protected static final String SET_NO_TRAVERSE_STATE_KEY = "org.eclipse.swt.internal.setNoTraverseState";
    protected static final String SET_NO_KEY_PROPAGATE_STATE_KEY = "org.eclipse.swt.internal.setNoKeyPropagateState";
    protected static final String SET_NO_MOUSE_PROPAGATE_STATE_KEY = "org.eclipse.swt.internal.setNoMousePropagateState";
    protected static final String SET_EMBEDDED_SCROLLBARS_STATE_KEY = "org.eclipse.swt.internal.setEmbeddedScrollbarsState";

    protected static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    Widget() {
    }

    public Widget(Widget widget, int n) {
        this(widget, n, 0);
    }

    protected Widget(Widget widget, int n, int n2) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n;
        this.extraStyle = n2;
        this.display = widget.display;
    }

    protected static final void addCommand(Control control, Command command) {
        control.addCommand(command);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(disposeListener);
        this.addListener(12, typedListener);
    }

    public void addListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(n, listener);
    }

    void _addListener(int n, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    protected void addWidget(int n) {
        this.display.addWidget(n, this);
    }

    protected void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0) {
            if (widget != null) {
                if ((widget.style & 0x2000000) != 0) {
                    this.style |= 0x2000000;
                }
                if ((widget.style & 0x4000000) != 0) {
                    this.style |= 0x4000000;
                }
            } else if (this.display.defaultOrientation != 0x2000000) {
                this.style |= this.display.defaultOrientation;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    protected void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    protected void createHandle(int n) {
    }

    void createWidget(int n) {
        this.createHandle(n);
        this.hookEvents();
        this.register();
    }

    protected void deregister() {
        if (this.handle != 0) {
            this.display.removeWidget(this.handle);
        }
    }

    void destroyWidget() {
        int n = this.internal_topHandle();
        this.releaseHandle();
        if (n != 0 && (this.state & 8) != 0) {
            OS.QObject_deleteLater(n);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void error(int n) {
        SWT.error(n);
    }

    boolean filters(int n) {
        return this.display.filters(n);
    }

    protected static final Command[] getCommands(Control control) {
        return control.getCommands();
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            for (int i = 1; i < objectArray.length; i += 2) {
                if (!string.equals(objectArray[i])) continue;
                return objectArray[i + 1];
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.length();
        while (--n > 0 && string.charAt(n) != '.') {
        }
        return string.substring(n + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    public String getStyleSheet() {
        this.checkWidget();
        return OS.QWidget_styleSheet(this.handle);
    }

    protected void hookEvents() {
    }

    boolean hooks(int n) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n);
    }

    public int internal_topHandle() {
        return this.handle;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int n) {
        this.checkWidget();
        return this.hooks(n);
    }

    protected boolean isSelectionKey(int n, int n2) {
        return OS.windowServer == 2 ? n2 == 32 : OS.windowServer == 1 && (n == 0x1000004 || n2 == -5);
    }

    protected boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    Event makeKeyEvent(int n, int n2, int n3) {
        Event event = new Event();
        switch (n) {
            case 0x1000004: 
            case 0x1000005: {
                event.character = (char)13;
                break;
            }
            case 0x1000003: {
                event.character = (char)8;
                break;
            }
            case 0x1000007: {
                event.character = (char)127;
                break;
            }
            case 0x1000000: {
                event.character = (char)27;
                break;
            }
            case 0x1000001: {
                event.character = (char)9;
                break;
            }
            default: {
                event.character = (char)n3;
            }
        }
        boolean bl = (n2 & 0x20000000) != 0;
        event.keyCode = Display.translateKey(n, bl);
        if (event.keyCode == 0) {
            event.keyCode = n3;
        }
        if ((n2 & 0) == 0) {
            event.stateMask = Display.translateModifiers(n2);
        }
        return event;
    }

    public void notifyListeners(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n, event);
    }

    void postEvent(int n) {
        this.sendEvent(n, null, false);
    }

    void postEvent(int n, Event event) {
        this.sendEvent(n, event, false);
    }

    boolean qt_event_close() {
        return false;
    }

    boolean qt_event_contextmenu(int n, int n2, int n3) {
        return false;
    }

    protected boolean qt_event_focusIn(int n) {
        return false;
    }

    protected boolean qt_event_focusOut(int n) {
        return false;
    }

    protected boolean qt_event_keypress(int n, int n2, int n3, int n4) {
        if ((this.state & 0x2000000) != 0 && n != this.handle) {
            return true;
        }
        return this.sendKeyEvent(1, n2, n3, n4);
    }

    protected boolean qt_event_keyrelease(int n, int n2, int n3, int n4) {
        if ((this.state & 0x2000000) != 0 && n != this.handle) {
            return true;
        }
        return this.sendKeyEvent(2, n2, n3, n4);
    }

    protected boolean qt_event_mouseButtonDblClick(int n, int n2, int n3, int n4, int n5, int n6) {
        return false;
    }

    protected boolean qt_event_mouseButtonPress(int n, int n2, int n3, int n4, int n5, int n6) {
        return false;
    }

    protected boolean qt_event_mouseButtonRelease(int n, int n2, int n3, int n4, int n5, int n6) {
        return false;
    }

    boolean qt_event_mouseMove(int n, int n2, int n3, int n4, int n5, int n6) {
        return false;
    }

    boolean qt_event_move(int n) {
        return false;
    }

    boolean qt_event_paint(int n, int n2, int n3, int n4, int n5, int n6) {
        return false;
    }

    protected boolean qt_event_resize(int n) {
        return false;
    }

    boolean qt_event_shortcut(int n, int n2, int n3) {
        return false;
    }

    boolean qt_event_windowActivate(int n) {
        return false;
    }

    boolean qt_event_windowDeactivate(int n) {
        return false;
    }

    boolean qt_event_windowStateChange(int n, int n2) {
        return false;
    }

    void qt_signal_aboutToHide() {
    }

    void qt_signal_aboutToShow() {
    }

    protected void qt_signal_current_tab_changed(int n) {
    }

    protected void qt_signal_dateedit_dateTimeChanged() {
    }

    void qt_signal_hover() {
    }

    protected void qt_signal_linkActivated(String string) {
    }

    protected void qt_signal_list_itemActivated(int n) {
    }

    protected void qt_signal_list_itemDoubleClicked(int n) {
    }

    protected void qt_signal_list_itemSelectionChanged() {
    }

    void qt_signal_pressed() {
    }

    void qt_signal_released() {
    }

    protected void qt_signal_return_pressed() {
    }

    protected void qt_signal_selectionChanged(int n, int n2) {
    }

    void qt_signal_slider_action_triggered(int n) {
    }

    void qt_signal_slider_changed(int n) {
    }

    void qt_signal_slider_released() {
    }

    void qt_signal_table_cellActivated(int n, int n2) {
    }

    void qt_signal_table_cellChanged(int n, int n2) {
    }

    void qt_signal_table_currentCellChanged(int n, int n2, int n3, int n4) {
    }

    void qt_signal_table_itemSelectionChanged() {
    }

    protected void qt_signal_text_changed(String string) {
    }

    protected void qt_signal_text_cursorPositionChanged(int n, int n2) {
    }

    protected void qt_signal_text_selectionChanged() {
    }

    protected void qt_signal_tray_activated(int n) {
    }

    protected void qt_signal_tree_itemActivated(int n, int n2) {
    }

    protected void qt_signal_tree_itemCollapsed(int n) {
    }

    protected void qt_signal_tree_itemExpanded(int n) {
    }

    protected void qt_signal_tree_itemSelectionChanged() {
    }

    protected void qt_signal_triggered(boolean bl) {
    }

    protected void qt_signal_abstractitemview_activated(int n, int n2) {
    }

    void qt_swt_event_focusWasGained() {
    }

    void qt_swt_event_focusWasLost() {
    }

    protected void qt_swt_event_widgetMoved(int n) {
    }

    void qt_swt_event_widgetPainted(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    protected void qt_swt_event_widgetResized(int n, int n2, int n3, int n4, int n5) {
    }

    protected void register() {
        if (this.handle == 0) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.addWidget(this.handle, this);
        }
    }

    void release(boolean bl) {
        if ((this.state & 0x200000) == 0) {
            this.state |= 0x200000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(bl);
        }
        if ((this.state & 0x100000) == 0) {
            this.state |= 0x100000;
            if (bl) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    protected void releaseChildren(boolean bl) {
    }

    protected void releaseHandle() {
        this.handle = 0;
        this.state |= 1;
        this.display = null;
    }

    protected void releaseParent() {
    }

    protected void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    protected static final void removeCommand(Control control, Command command) {
        control.removeCommand(command);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, disposeListener);
    }

    public void removeListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    protected void removeListener(int n, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, sWTEventListener);
    }

    protected Widget removeWidget(int n) {
        return this.display.removeWidget(n);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    protected void sendEvent(int n) {
        this.sendEvent(n, null, true);
    }

    protected void sendEvent(int n, Event event) {
        this.sendEvent(n, event, true);
    }

    void sendEvent(int n, Event event, boolean bl) {
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (bl) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int n, int n2, int n3, int n4) {
        Event event = this.makeKeyEvent(n2, n3, n4);
        this.sendEvent(n, event);
        if (this.isDisposed()) {
            return true;
        }
        return !event.doit;
    }

    public void setData(Object object) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(SET_CANVAS_STATE_KEY)) {
            boolean bl = (Boolean)object;
            this.state = bl ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
            return;
        }
        if (string.equals(SET_NO_TRAVERSE_STATE_KEY)) {
            boolean bl = (Boolean)object;
            this.state = bl ? (this.state |= 0x1000000) : (this.state &= 0xFEFFFFFF);
            return;
        }
        if (string.equals(SET_NO_KEY_PROPAGATE_STATE_KEY)) {
            boolean bl = (Boolean)object;
            this.state = bl ? (this.state |= 0x2000000) : (this.state &= 0xFDFFFFFF);
            return;
        }
        if (string.equals(SET_NO_MOUSE_PROPAGATE_STATE_KEY)) {
            boolean bl = (Boolean)object;
            this.state = bl ? (this.state |= 0x4000000) : (this.state &= 0xFBFFFFFF);
            return;
        }
        if (string.equals(SET_EMBEDDED_SCROLLBARS_STATE_KEY)) {
            boolean bl = (Boolean)object;
            this.state = bl ? (this.state |= 0x8000000) : (this.state &= 0xF7FFFFFF);
            return;
        }
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            for (n = 1; n < objectArray.length && !string.equals(objectArray[n]); n += 2) {
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n] = string;
            objectArray[n + 1] = object;
        } else if ((this.state & 4) != 0 && n != objectArray.length) {
            int n2 = objectArray.length - 2;
            if (n2 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n2];
                System.arraycopy(objectArray, 0, objectArray3, 0, n);
                System.arraycopy(objectArray, n + 2, objectArray3, n, n2 - n);
                this.data = objectArray3;
            }
        }
    }

    public void setStyleSheet(String string) {
        this.checkWidget();
        OS.QWidget_setStyleSheet(this.handle, "*[swt_obj_idx=\"" + OS.QObject_property(this.handle, "swt_obj_idx") + "\"] " + string);
    }

    protected void sort(int[] nArray) {
        int n = nArray.length;
        for (int i = n / 2; i > 0; i /= 2) {
            for (int j = i; j < n; ++j) {
                for (int k = j - i; k >= 0; k -= i) {
                    if (nArray[k] <= nArray[k + i]) continue;
                    int n2 = nArray[k];
                    nArray[k] = nArray[k + i];
                    nArray[k + i] = n2;
                }
            }
        }
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }
}

