/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Event;

public abstract class Action
implements IAction {
    private static final String VAL_PUSH_BTN = "PUSH_BTN";
    private static final Integer VAL_RADIO_BTN_ON = new Integer(1);
    private static final Integer VAL_RADIO_BTN_OFF = new Integer(0);
    private static final Boolean VAL_TOGGLE_BTN_ON = Boolean.TRUE;
    private static final Boolean VAL_TOGGLE_BTN_OFF = Boolean.FALSE;
    private static Map keyCodes = null;
    private static Map localizedKeyCodes = null;
    private static String LOCALIZED_CTRL;
    private static String LOCALIZED_SHIFT;
    private static String LOCALIZED_ALT;
    private static String LOCALIZED_COMMAND;
    private static Map keyStrings;
    private ListenerList listeners = new ListenerList(3);
    private String text;
    private String description;
    private String id;
    private String actionDefinitionId;
    private String toolTipText;
    private ImageDescriptor image;
    private ImageDescriptor hoverImage;
    private ImageDescriptor disabledImage;
    private Object value = null;
    private int accelerator = 0;
    private boolean enabled = true;

    static {
        keyStrings = null;
    }

    protected Action() {
    }

    protected Action(String string) {
        this();
        this.setText(string);
    }

    protected Action(String string, ImageDescriptor imageDescriptor) {
        this(string);
        this.setImageDescriptor(imageDescriptor);
    }

    protected Action(String string, int n) {
        this(string);
        switch (n) {
            case 1: {
                this.value = VAL_PUSH_BTN;
                break;
            }
            case 2: {
                this.value = VAL_TOGGLE_BTN_OFF;
                break;
            }
            case 8: {
                this.value = VAL_RADIO_BTN_OFF;
            }
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add(iPropertyChangeListener);
    }

    private static int convertLocalizedAccelerator(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        int n2 = -1;
        boolean bl = stringTokenizer.hasMoreTokens();
        while (bl) {
            String string2 = stringTokenizer.nextToken();
            bl = stringTokenizer.hasMoreTokens();
            if (bl) {
                int n3 = Action.findLocalizedModifier(string2);
                if (n3 != 0) {
                    n |= n3;
                    continue;
                }
                return 0;
            }
            n2 = Action.findLocalizedKeyCode(string2);
        }
        if (n2 != -1) {
            n |= n2;
        }
        return n;
    }

    public static int convertAccelerator(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        int n2 = -1;
        boolean bl = stringTokenizer.hasMoreTokens();
        while (bl) {
            String string2 = stringTokenizer.nextToken();
            bl = stringTokenizer.hasMoreTokens();
            if (bl) {
                int n3 = Action.findModifier(string2);
                if (n3 != 0) {
                    n |= n3;
                    continue;
                }
                return 0;
            }
            n2 = Action.findKeyCode(string2);
        }
        if (n2 != -1) {
            n |= n2;
        }
        return n;
    }

    public static String convertAccelerator(int n) {
        String string = Action.getModifierString(n);
        String string2 = string.equals("") ? Action.findKeyString(n) : String.valueOf(string) + "+" + Action.findKeyString(n);
        return string2;
    }

    private static String getModifierString(int n) {
        String string = "";
        if ((n & 0x40000) != 0) {
            string = Action.findModifierString(n & 0x40000);
        }
        if ((n & 0x10000) != 0) {
            string = string.equals("") ? Action.findModifierString(n & 0x10000) : String.valueOf(string) + "+" + Action.findModifierString(n & 0x10000);
        }
        if ((n & 0x20000) != 0) {
            string = string.equals("") ? Action.findModifierString(n & 0x20000) : String.valueOf(string) + "+" + Action.findModifierString(n & 0x20000);
        }
        if ((n & 0x400000) != 0) {
            string = string.equals("") ? Action.findModifierString(n & 0x400000) : String.valueOf(string) + "+" + Action.findModifierString(n & 0x400000);
        }
        return string;
    }

    private static String extractAcceleratorText(String string) {
        int n = string.lastIndexOf(9);
        if (n == -1) {
            n = string.lastIndexOf(64);
        }
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    public static int findKeyCode(String string) {
        Integer n;
        if (keyCodes == null) {
            Action.initKeyCodes();
        }
        if ((n = (Integer)keyCodes.get(string = string.toUpperCase())) != null) {
            return n;
        }
        if (string.length() == 1) {
            return string.charAt(0);
        }
        return -1;
    }

    private static int findLocalizedKeyCode(String string) {
        Integer n;
        if (localizedKeyCodes == null) {
            Action.initLocalizedKeyCodes();
        }
        if ((n = (Integer)localizedKeyCodes.get(string = string.toUpperCase())) != null) {
            return n;
        }
        if (string.length() == 1) {
            return string.charAt(0);
        }
        return -1;
    }

    public static String findKeyString(int n) {
        int n2;
        Integer n3;
        String string;
        if (keyStrings == null) {
            Action.initKeyStrings();
        }
        if ((string = (String)keyStrings.get(n3 = new Integer(n2 = n & 0xFFB8FFFF))) != null) {
            return string;
        }
        string = new String(new char[]{(char)n2});
        return string;
    }

    public static int findModifier(String string) {
        if ((string = string.toUpperCase()).equals("CTRL")) {
            return 262144;
        }
        if (string.equals("SHIFT")) {
            return 131072;
        }
        if (string.equals("ALT")) {
            return 65536;
        }
        if (string.equals("COMMAND")) {
            return 0x400000;
        }
        return 0;
    }

    private static int findLocalizedModifier(String string) {
        if (LOCALIZED_CTRL == null) {
            Action.initLocalizedModifiers();
        }
        if ((string = string.toUpperCase()).equals(LOCALIZED_CTRL)) {
            return 262144;
        }
        if (string.equals(LOCALIZED_SHIFT)) {
            return 131072;
        }
        if (string.equals(LOCALIZED_ALT)) {
            return 65536;
        }
        if (string.equals(LOCALIZED_COMMAND)) {
            return 0x400000;
        }
        return 0;
    }

    private static void initLocalizedModifiers() {
        LOCALIZED_CTRL = JFaceResources.getString("Ctrl").toUpperCase();
        LOCALIZED_SHIFT = JFaceResources.getString("Shift").toUpperCase();
        LOCALIZED_ALT = JFaceResources.getString("Alt").toUpperCase();
        LOCALIZED_COMMAND = JFaceResources.getString("Command").toUpperCase();
    }

    public static String findModifierString(int n) {
        if (n == 262144) {
            return JFaceResources.getString("Ctrl");
        }
        if (n == 65536) {
            return JFaceResources.getString("Alt");
        }
        if (n == 131072) {
            return JFaceResources.getString("Shift");
        }
        if (n == 0x400000) {
            return JFaceResources.getString("Command");
        }
        return null;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (!this.listeners.isEmpty()) {
            this.firePropertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public int getAccelerator() {
        return this.accelerator;
    }

    public String getActionDefinitionId() {
        return this.actionDefinitionId;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.getToolTipText();
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return this.disabledImage;
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this.hoverImage;
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.image;
    }

    public int getStyle() {
        if (this.value == VAL_PUSH_BTN || this.value == null) {
            return 1;
        }
        if (this.value == VAL_TOGGLE_BTN_ON || this.value == VAL_TOGGLE_BTN_OFF) {
            return 2;
        }
        if (this.value == VAL_RADIO_BTN_ON || this.value == VAL_RADIO_BTN_OFF) {
            return 8;
        }
        return 1;
    }

    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    private static void initKeyCodes() {
        keyCodes = new HashMap(40);
        keyCodes.put("BACKSPACE", new Integer(8));
        keyCodes.put("TAB", new Integer(9));
        keyCodes.put("RETURN", new Integer(13));
        keyCodes.put("ENTER", new Integer(13));
        keyCodes.put("ESCAPE", new Integer(27));
        keyCodes.put("ESC", new Integer(27));
        keyCodes.put("DELETE", new Integer(127));
        keyCodes.put("SPACE", new Integer(32));
        keyCodes.put("ARROW_UP", new Integer(0x1000001));
        keyCodes.put("ARROW_DOWN", new Integer(0x1000002));
        keyCodes.put("ARROW_LEFT", new Integer(0x1000003));
        keyCodes.put("ARROW_RIGHT", new Integer(0x1000004));
        keyCodes.put("PAGE_UP", new Integer(0x1000005));
        keyCodes.put("PAGE_DOWN", new Integer(0x1000006));
        keyCodes.put("HOME", new Integer(0x1000007));
        keyCodes.put("END", new Integer(0x1000008));
        keyCodes.put("INSERT", new Integer(0x1000009));
        keyCodes.put("F1", new Integer(0x100000A));
        keyCodes.put("F2", new Integer(0x100000B));
        keyCodes.put("F3", new Integer(0x100000C));
        keyCodes.put("F4", new Integer(0x100000D));
        keyCodes.put("F5", new Integer(0x100000E));
        keyCodes.put("F6", new Integer(0x100000F));
        keyCodes.put("F7", new Integer(0x1000010));
        keyCodes.put("F8", new Integer(0x1000011));
        keyCodes.put("F9", new Integer(0x1000012));
        keyCodes.put("F10", new Integer(0x1000013));
        keyCodes.put("F11", new Integer(0x1000014));
        keyCodes.put("F12", new Integer(0x1000015));
    }

    private static void initLocalizedKeyCodes() {
        localizedKeyCodes = new HashMap(40);
        localizedKeyCodes.put(JFaceResources.getString("Backspace").toUpperCase(), new Integer(8));
        localizedKeyCodes.put(JFaceResources.getString("Tab").toUpperCase(), new Integer(9));
        localizedKeyCodes.put(JFaceResources.getString("Return").toUpperCase(), new Integer(13));
        localizedKeyCodes.put(JFaceResources.getString("Enter").toUpperCase(), new Integer(13));
        localizedKeyCodes.put(JFaceResources.getString("Escape").toUpperCase(), new Integer(27));
        localizedKeyCodes.put(JFaceResources.getString("Esc").toUpperCase(), new Integer(27));
        localizedKeyCodes.put(JFaceResources.getString("Delete").toUpperCase(), new Integer(127));
        localizedKeyCodes.put(JFaceResources.getString("Space").toUpperCase(), new Integer(32));
        localizedKeyCodes.put(JFaceResources.getString("Arrow_Up").toUpperCase(), new Integer(0x1000001));
        localizedKeyCodes.put(JFaceResources.getString("Arrow_Down").toUpperCase(), new Integer(0x1000002));
        localizedKeyCodes.put(JFaceResources.getString("Arrow_Left").toUpperCase(), new Integer(0x1000003));
        localizedKeyCodes.put(JFaceResources.getString("Arrow_Right").toUpperCase(), new Integer(0x1000004));
        localizedKeyCodes.put(JFaceResources.getString("Page_Up").toUpperCase(), new Integer(0x1000005));
        localizedKeyCodes.put(JFaceResources.getString("Page_Down").toUpperCase(), new Integer(0x1000006));
        localizedKeyCodes.put(JFaceResources.getString("Home").toUpperCase(), new Integer(0x1000007));
        localizedKeyCodes.put(JFaceResources.getString("End").toUpperCase(), new Integer(0x1000008));
        localizedKeyCodes.put(JFaceResources.getString("Insert").toUpperCase(), new Integer(0x1000009));
        localizedKeyCodes.put(JFaceResources.getString("F1").toUpperCase(), new Integer(0x100000A));
        localizedKeyCodes.put(JFaceResources.getString("F2").toUpperCase(), new Integer(0x100000B));
        localizedKeyCodes.put(JFaceResources.getString("F3").toUpperCase(), new Integer(0x100000C));
        localizedKeyCodes.put(JFaceResources.getString("F4").toUpperCase(), new Integer(0x100000D));
        localizedKeyCodes.put(JFaceResources.getString("F5").toUpperCase(), new Integer(0x100000E));
        localizedKeyCodes.put(JFaceResources.getString("F6").toUpperCase(), new Integer(0x100000F));
        localizedKeyCodes.put(JFaceResources.getString("F7").toUpperCase(), new Integer(0x1000010));
        localizedKeyCodes.put(JFaceResources.getString("F8").toUpperCase(), new Integer(0x1000011));
        localizedKeyCodes.put(JFaceResources.getString("F9").toUpperCase(), new Integer(0x1000012));
        localizedKeyCodes.put(JFaceResources.getString("F10").toUpperCase(), new Integer(0x1000013));
        localizedKeyCodes.put(JFaceResources.getString("F11").toUpperCase(), new Integer(0x1000014));
        localizedKeyCodes.put(JFaceResources.getString("F12").toUpperCase(), new Integer(0x1000015));
    }

    private static void initKeyStrings() {
        keyStrings = new HashMap(40);
        keyStrings.put(new Integer(8), JFaceResources.getString("Backspace"));
        keyStrings.put(new Integer(9), JFaceResources.getString("Tab"));
        keyStrings.put(new Integer(13), JFaceResources.getString("Return"));
        keyStrings.put(new Integer(13), JFaceResources.getString("Enter"));
        keyStrings.put(new Integer(27), JFaceResources.getString("Escape"));
        keyStrings.put(new Integer(27), JFaceResources.getString("Esc"));
        keyStrings.put(new Integer(127), JFaceResources.getString("Delete"));
        keyStrings.put(new Integer(32), JFaceResources.getString("Space"));
        keyStrings.put(new Integer(0x1000001), JFaceResources.getString("Arrow_Up"));
        keyStrings.put(new Integer(0x1000002), JFaceResources.getString("Arrow_Down"));
        keyStrings.put(new Integer(0x1000003), JFaceResources.getString("Arrow_Left"));
        keyStrings.put(new Integer(0x1000004), JFaceResources.getString("Arrow_Right"));
        keyStrings.put(new Integer(0x1000005), JFaceResources.getString("Page_Up"));
        keyStrings.put(new Integer(0x1000006), JFaceResources.getString("Page_Down"));
        keyStrings.put(new Integer(0x1000007), JFaceResources.getString("Home"));
        keyStrings.put(new Integer(0x1000008), JFaceResources.getString("End"));
        keyStrings.put(new Integer(0x1000009), JFaceResources.getString("Insert"));
        keyStrings.put(new Integer(0x100000A), JFaceResources.getString("F1"));
        keyStrings.put(new Integer(0x100000B), JFaceResources.getString("F2"));
        keyStrings.put(new Integer(0x100000C), JFaceResources.getString("F3"));
        keyStrings.put(new Integer(0x100000D), JFaceResources.getString("F4"));
        keyStrings.put(new Integer(0x100000E), JFaceResources.getString("F5"));
        keyStrings.put(new Integer(0x100000F), JFaceResources.getString("F6"));
        keyStrings.put(new Integer(0x1000010), JFaceResources.getString("F7"));
        keyStrings.put(new Integer(0x1000011), JFaceResources.getString("F8"));
        keyStrings.put(new Integer(0x1000012), JFaceResources.getString("F9"));
        keyStrings.put(new Integer(0x1000013), JFaceResources.getString("F10"));
        keyStrings.put(new Integer(0x1000014), JFaceResources.getString("F11"));
        keyStrings.put(new Integer(0x1000015), JFaceResources.getString("F12"));
    }

    public boolean isChecked() {
        return this.value == VAL_TOGGLE_BTN_ON || this.value == VAL_RADIO_BTN_ON;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static String removeAcceleratorText(String string) {
        int n = string.lastIndexOf(9);
        if (n == -1) {
            n = string.lastIndexOf(64);
        }
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String removeMnemonics(String string) {
        int n = string.indexOf(38);
        if (n == -1) {
            return string;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n != -1) {
            if (n == n2 - 1) break;
            if (string.charAt(n + 1) == '&') {
                ++n;
            }
            stringBuffer.append(string.substring(n3, n));
            n3 = ++n;
            n = string.indexOf(38, n);
        }
        if (n3 < n2) {
            stringBuffer.append(string.substring(n3, n2));
        }
        return ((Object)stringBuffer).toString();
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove(iPropertyChangeListener);
    }

    public void run() {
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    public void setActionDefinitionId(String string) {
        this.actionDefinitionId = string;
    }

    public void setChecked(boolean bl) {
        Comparable<Boolean> comparable = null;
        if (this.value == null || this.value == VAL_TOGGLE_BTN_ON || this.value == VAL_TOGGLE_BTN_OFF) {
            comparable = bl ? VAL_TOGGLE_BTN_ON : VAL_TOGGLE_BTN_OFF;
        } else if (this.value == VAL_RADIO_BTN_ON || this.value == VAL_RADIO_BTN_OFF) {
            comparable = bl ? VAL_RADIO_BTN_ON : VAL_RADIO_BTN_OFF;
        } else {
            return;
        }
        if (comparable != this.value) {
            this.value = comparable;
            if (bl) {
                this.firePropertyChange("checked", Boolean.FALSE, Boolean.TRUE);
            } else {
                this.firePropertyChange("checked", Boolean.TRUE, Boolean.FALSE);
            }
        }
    }

    public void setDescription(String string) {
        if (this.description == null && string != null || this.description != null && string == null || this.description != null && string != null && !string.equals(this.description)) {
            String string2 = this.description;
            this.description = string;
            this.firePropertyChange("description", string2, this.description);
        }
    }

    public void setDisabledImageDescriptor(ImageDescriptor imageDescriptor) {
        if (this.disabledImage != imageDescriptor) {
            ImageDescriptor imageDescriptor2 = this.disabledImage;
            this.disabledImage = imageDescriptor;
            this.firePropertyChange("image", imageDescriptor2, imageDescriptor);
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            Boolean bl2 = this.enabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.enabled = bl;
            this.firePropertyChange("enabled", bl2, bl3);
        }
    }

    public void setHoverImageDescriptor(ImageDescriptor imageDescriptor) {
        if (this.hoverImage != imageDescriptor) {
            ImageDescriptor imageDescriptor2 = this.hoverImage;
            this.hoverImage = imageDescriptor;
            this.firePropertyChange("image", imageDescriptor2, imageDescriptor);
        }
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        if (this.image != imageDescriptor) {
            ImageDescriptor imageDescriptor2 = this.image;
            this.image = imageDescriptor;
            this.firePropertyChange("image", imageDescriptor2, imageDescriptor);
        }
    }

    public void setText(String string) {
        int n;
        String string2;
        String string3 = this.text;
        int n2 = this.accelerator;
        this.text = string;
        if (string != null && (string2 = Action.extractAcceleratorText(string)) != null && (n = Action.convertLocalizedAccelerator(string2)) > 0) {
            this.setAccelerator(n);
        }
        if (this.accelerator != n2 || (string3 == null ? this.text != null : !string3.equals(this.text))) {
            this.firePropertyChange("text", string3, this.text);
        }
    }

    public void setToolTipText(String string) {
        String string2 = this.toolTipText;
        if (string2 == null ? string != null : !string2.equals(string)) {
            this.toolTipText = string;
            this.firePropertyChange("toolTipText", string2, string);
        }
    }

    public void setAccelerator(int n) {
        this.accelerator = n;
    }

    public final void notifyResult(boolean bl) {
        this.firePropertyChange("result", null, new Boolean(bl));
    }
}

