/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class PreferenceConverter {
    public static final Point POINT_DEFAULT_DEFAULT = new Point(0, 0);
    public static final Rectangle RECTANGLE_DEFAULT_DEFAULT = new Rectangle(0, 0, 0, 0);
    public static final RGB COLOR_DEFAULT_DEFAULT = new RGB(0, 0, 0);
    private static final String ENTRY_SEPARATOR = ";";
    public static final FontData[] FONTDATA_ARRAY_DEFAULT_DEFAULT;
    public static final FontData FONTDATA_DEFAULT_DEFAULT;

    static {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        FONTDATA_ARRAY_DEFAULT_DEFAULT = display.getSystemFont().getFontData();
        FONTDATA_DEFAULT_DEFAULT = FONTDATA_ARRAY_DEFAULT_DEFAULT[0];
    }

    private PreferenceConverter() {
    }

    private static RGB basicGetColor(String string) {
        if ("".equals(string)) {
            return COLOR_DEFAULT_DEFAULT;
        }
        RGB rGB = StringConverter.asRGB(string, null);
        if (rGB == null) {
            return COLOR_DEFAULT_DEFAULT;
        }
        return rGB;
    }

    public static FontData[] basicGetFontData(String string) {
        if ("".equals(string)) {
            return FONTDATA_ARRAY_DEFAULT_DEFAULT;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ENTRY_SEPARATOR);
        int n = stringTokenizer.countTokens();
        FontData[] fontDataArray = new FontData[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                fontDataArray[n2] = new FontData(stringTokenizer.nextToken());
            }
            catch (SWTException sWTException) {
                return FONTDATA_ARRAY_DEFAULT_DEFAULT;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return FONTDATA_ARRAY_DEFAULT_DEFAULT;
            }
            ++n2;
        }
        return fontDataArray;
    }

    public static FontData[] readFontData(String string) {
        return PreferenceConverter.basicGetFontData(string);
    }

    private static Point basicGetPoint(String string) {
        Point point = new Point(PreferenceConverter.POINT_DEFAULT_DEFAULT.x, PreferenceConverter.POINT_DEFAULT_DEFAULT.y);
        if ("".equals(string)) {
            return point;
        }
        return StringConverter.asPoint(string, point);
    }

    private static Rectangle basicGetRectangle(String string) {
        Rectangle rectangle = new Rectangle(PreferenceConverter.RECTANGLE_DEFAULT_DEFAULT.x, PreferenceConverter.RECTANGLE_DEFAULT_DEFAULT.y, PreferenceConverter.RECTANGLE_DEFAULT_DEFAULT.width, PreferenceConverter.RECTANGLE_DEFAULT_DEFAULT.height);
        if ("".equals(string)) {
            return rectangle;
        }
        return StringConverter.asRectangle(string, rectangle);
    }

    public static RGB getColor(IPreferenceStore iPreferenceStore, String string) {
        return PreferenceConverter.basicGetColor(iPreferenceStore.getString(string));
    }

    public static RGB getDefaultColor(IPreferenceStore iPreferenceStore, String string) {
        return PreferenceConverter.basicGetColor(iPreferenceStore.getDefaultString(string));
    }

    public static FontData[] getDefaultFontDataArray(IPreferenceStore iPreferenceStore, String string) {
        return PreferenceConverter.basicGetFontData(iPreferenceStore.getDefaultString(string));
    }

    public static FontData getDefaultFontData(IPreferenceStore iPreferenceStore, String string) {
        return PreferenceConverter.getDefaultFontDataArray(iPreferenceStore, string)[0];
    }

    public static Point getDefaultPoint(IPreferenceStore iPreferenceStore, String string) {
        return PreferenceConverter.basicGetPoint(iPreferenceStore.getDefaultString(string));
    }

    public static Rectangle getDefaultRectangle(IPreferenceStore iPreferenceStore, String string) {
        return PreferenceConverter.basicGetRectangle(iPreferenceStore.getDefaultString(string));
    }

    public static FontData[] getFontDataArray(IPreferenceStore iPreferenceStore, String string) {
        return PreferenceConverter.basicGetFontData(iPreferenceStore.getString(string));
    }

    public static FontData getFontData(IPreferenceStore iPreferenceStore, String string) {
        return PreferenceConverter.getFontDataArray(iPreferenceStore, string)[0];
    }

    public static Point getPoint(IPreferenceStore iPreferenceStore, String string) {
        return PreferenceConverter.basicGetPoint(iPreferenceStore.getString(string));
    }

    public static Rectangle getRectangle(IPreferenceStore iPreferenceStore, String string) {
        return PreferenceConverter.basicGetRectangle(iPreferenceStore.getString(string));
    }

    public static void setDefault(IPreferenceStore iPreferenceStore, String string, FontData fontData) {
        FontData[] fontDataArray = new FontData[]{fontData};
        PreferenceConverter.setDefault(iPreferenceStore, string, fontDataArray);
    }

    public static void setDefault(IPreferenceStore iPreferenceStore, String string, FontData[] fontDataArray) {
        iPreferenceStore.setDefault(string, PreferenceConverter.getStoredRepresentation(fontDataArray));
    }

    public static void setDefault(IPreferenceStore iPreferenceStore, String string, Point point) {
        iPreferenceStore.setDefault(string, StringConverter.asString(point));
    }

    public static void setDefault(IPreferenceStore iPreferenceStore, String string, Rectangle rectangle) {
        iPreferenceStore.setDefault(string, StringConverter.asString(rectangle));
    }

    public static void setDefault(IPreferenceStore iPreferenceStore, String string, RGB rGB) {
        iPreferenceStore.setDefault(string, StringConverter.asString(rGB));
    }

    public static void setValue(IPreferenceStore iPreferenceStore, String string, FontData fontData) {
        PreferenceConverter.setValue(iPreferenceStore, string, new FontData[]{fontData});
    }

    public static void setValue(IPreferenceStore iPreferenceStore, String string, FontData[] fontDataArray) {
        Object[] objectArray = PreferenceConverter.getFontDataArray(iPreferenceStore, string);
        if (!Arrays.equals(objectArray, fontDataArray)) {
            iPreferenceStore.putValue(string, PreferenceConverter.getStoredRepresentation(fontDataArray));
            JFaceResources.getFontRegistry().put(string, fontDataArray);
            iPreferenceStore.firePropertyChangeEvent(string, objectArray, fontDataArray);
        }
    }

    public static void putValue(IPreferenceStore iPreferenceStore, String string, FontData[] fontDataArray) {
        Object[] objectArray = PreferenceConverter.getFontDataArray(iPreferenceStore, string);
        if (!Arrays.equals(objectArray, fontDataArray)) {
            iPreferenceStore.putValue(string, PreferenceConverter.getStoredRepresentation(fontDataArray));
        }
    }

    public static String getStoredRepresentation(FontData[] fontDataArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < fontDataArray.length) {
            if (fontDataArray[n] != null) {
                stringBuffer.append(fontDataArray[n].toString());
                stringBuffer.append(ENTRY_SEPARATOR);
            }
            ++n;
        }
        return ((Object)stringBuffer).toString();
    }

    public static void setValue(IPreferenceStore iPreferenceStore, String string, Point point) {
        Point point2 = PreferenceConverter.getPoint(iPreferenceStore, string);
        if (point2 == null || !point2.equals((Object)point)) {
            iPreferenceStore.putValue(string, StringConverter.asString(point));
            iPreferenceStore.firePropertyChangeEvent(string, point2, point);
        }
    }

    public static void setValue(IPreferenceStore iPreferenceStore, String string, Rectangle rectangle) {
        Rectangle rectangle2 = PreferenceConverter.getRectangle(iPreferenceStore, string);
        if (rectangle2 == null || !rectangle2.equals((Object)rectangle)) {
            iPreferenceStore.putValue(string, StringConverter.asString(rectangle));
            iPreferenceStore.firePropertyChangeEvent(string, rectangle2, rectangle);
        }
    }

    public static void setValue(IPreferenceStore iPreferenceStore, String string, RGB rGB) {
        RGB rGB2 = PreferenceConverter.getColor(iPreferenceStore, string);
        if (rGB2 == null || !rGB2.equals((Object)rGB)) {
            iPreferenceStore.putValue(string, StringConverter.asString(rGB));
            iPreferenceStore.firePropertyChangeEvent(string, rGB2, rGB);
        }
    }
}

