/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class StringConverter {
    private static final String REGULAR = "regular";
    private static final String BOLD = "bold";
    private static final String ITALIC = "italic";
    private static final String BOLD_ITALIC = "bold italic";
    private static final char SEPARATOR = '-';
    private static final String FONT_SEPARATOR = ";";

    private StringConverter() {
    }

    public static String[] asArray(String string) throws DataFormatException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] asArray(String string, String[] stringArray) {
        try {
            return StringConverter.asArray(string);
        }
        catch (DataFormatException dataFormatException) {
            return stringArray;
        }
    }

    public static boolean asBoolean(String string) throws DataFormatException {
        String string2 = string.toLowerCase();
        if (string2.equals("t") || string2.equals("true")) {
            return true;
        }
        if (string.equals("f") || string2.equals("false")) {
            return false;
        }
        throw new DataFormatException("Value " + string + "doesn't represent a boolean");
    }

    public static boolean asBoolean(String string, boolean bl) {
        try {
            return StringConverter.asBoolean(string);
        }
        catch (DataFormatException dataFormatException) {
            return bl;
        }
    }

    public static double asDouble(String string) throws DataFormatException {
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException(numberFormatException.getMessage());
        }
    }

    public static double asDouble(String string, double d) {
        try {
            return StringConverter.asDouble(string);
        }
        catch (DataFormatException dataFormatException) {
            return d;
        }
    }

    public static float asFloat(String string) throws DataFormatException {
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException(numberFormatException.getMessage());
        }
    }

    public static float asFloat(String string, float f) {
        try {
            return StringConverter.asFloat(string);
        }
        catch (DataFormatException dataFormatException) {
            return f;
        }
    }

    public static FontData asFontData(String string) throws DataFormatException {
        if (string == null) {
            throw new DataFormatException("Null doesn't represent a valid font data");
        }
        String string2 = null;
        int n = 0;
        int n2 = 0;
        try {
            int n3 = string.length();
            int n4 = string.lastIndexOf(45);
            if (n4 == -1) {
                throw new DataFormatException("No correct font data format \"" + string + "\"");
            }
            n = StringConverter.asInt(string.substring(n4 + 1, n3));
            int n5 = string.lastIndexOf(45, n4 - 1);
            if (n5 == -1) {
                throw new DataFormatException("No correct font data format \"" + string + "\"");
            }
            String string3 = string.substring(n5 + 1, n4);
            if (BOLD_ITALIC.equals(string3)) {
                n2 = 3;
            } else if (BOLD.equals(string3)) {
                n2 = 1;
            } else if (ITALIC.equals(string3)) {
                n2 = 2;
            } else if (REGULAR.equals(string3)) {
                n2 = 0;
            } else {
                throw new DataFormatException("Unknown face name \"" + string3 + "\"");
            }
            string2 = string.substring(0, n5);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DataFormatException(noSuchElementException.getMessage());
        }
        return new FontData(string2, n, n2);
    }

    private static String[] getArrayFromList(String string, String string2) {
        if (string == null || string.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equals("")) continue;
            arrayList.add(string3);
        }
        return arrayList.isEmpty() ? new String[]{} : arrayList.toArray(new String[arrayList.size()]);
    }

    public static FontData[] asFontDataArray(String string) {
        String[] stringArray = StringConverter.getArrayFromList(string, FONT_SEPARATOR);
        ArrayList<FontData> arrayList = new ArrayList<FontData>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            try {
                arrayList.add(StringConverter.asFontData(stringArray[n]));
            }
            catch (DataFormatException dataFormatException) {}
            ++n;
        }
        return arrayList.toArray(new FontData[arrayList.size()]);
    }

    public static FontData asFontData(String string, FontData fontData) {
        try {
            return StringConverter.asFontData(string);
        }
        catch (DataFormatException dataFormatException) {
            return fontData;
        }
    }

    public static int asInt(String string) throws DataFormatException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException(numberFormatException.getMessage());
        }
    }

    public static int asInt(String string, int n) {
        try {
            return StringConverter.asInt(string);
        }
        catch (DataFormatException dataFormatException) {
            return n;
        }
    }

    public static long asLong(String string) throws DataFormatException {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException(numberFormatException.getMessage());
        }
    }

    public static long asLong(String string, long l) {
        try {
            return StringConverter.asLong(string);
        }
        catch (DataFormatException dataFormatException) {
            return l;
        }
    }

    public static Point asPoint(String string) throws DataFormatException {
        if (string == null) {
            throw new DataFormatException("Null doesn't represent a valid point");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(string2);
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException(numberFormatException.getMessage());
        }
        return new Point(n, n2);
    }

    public static Point asPoint(String string, Point point) {
        try {
            return StringConverter.asPoint(string);
        }
        catch (DataFormatException dataFormatException) {
            return point;
        }
    }

    public static Rectangle asRectangle(String string) throws DataFormatException {
        if (string == null) {
            throw new DataFormatException("Null doesn't represent a valid rectangle");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            n = Integer.parseInt(string2);
            n2 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string4);
            n4 = Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException(numberFormatException.getMessage());
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public static Rectangle asRectangle(String string, Rectangle rectangle) {
        try {
            return StringConverter.asRectangle(string);
        }
        catch (DataFormatException dataFormatException) {
            return rectangle;
        }
    }

    public static RGB asRGB(String string) throws DataFormatException {
        if (string == null) {
            throw new DataFormatException("Null doesn't represent a valid RGB");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            try {
                n = Integer.parseInt(string2);
                n2 = Integer.parseInt(string3);
                n3 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException(numberFormatException.getMessage());
            }
            return new RGB(n, n2, n3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DataFormatException(noSuchElementException.getMessage());
        }
    }

    public static RGB asRGB(String string, RGB rGB) {
        try {
            return StringConverter.asRGB(string);
        }
        catch (DataFormatException dataFormatException) {
            return rGB;
        }
    }

    public static String asString(double d) {
        return String.valueOf(d);
    }

    public static String asString(float f) {
        return String.valueOf(f);
    }

    public static String asString(int n) {
        return String.valueOf(n);
    }

    public static String asString(long l) {
        return String.valueOf(l);
    }

    public static String asString(Boolean bl) {
        Assert.isNotNull(bl);
        return String.valueOf(bl);
    }

    public static String asString(Double d) {
        Assert.isNotNull(d);
        return String.valueOf(d);
    }

    public static String asString(Float f) {
        Assert.isNotNull(f);
        return String.valueOf(f.floatValue());
    }

    public static String asString(Integer n) {
        Assert.isNotNull(n);
        return String.valueOf(n);
    }

    public static String asString(Long l) {
        Assert.isNotNull(l);
        return String.valueOf(l);
    }

    public static String asString(FontData[] fontDataArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < fontDataArray.length) {
            stringBuffer.append(StringConverter.asString(fontDataArray[n]));
            if (n != fontDataArray.length - 1) {
                stringBuffer.append(FONT_SEPARATOR);
            }
            ++n;
        }
        return ((Object)stringBuffer).toString();
    }

    public static String asString(FontData fontData) {
        boolean bl;
        Assert.isNotNull(fontData);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(fontData.getName());
        stringBuffer.append('-');
        int n = fontData.getStyle();
        boolean bl2 = (n & 1) == 1;
        boolean bl3 = bl = (n & 2) == 2;
        if (bl2 && bl) {
            stringBuffer.append(BOLD_ITALIC);
        } else if (bl2) {
            stringBuffer.append(BOLD);
        } else if (bl) {
            stringBuffer.append(ITALIC);
        } else {
            stringBuffer.append(REGULAR);
        }
        stringBuffer.append('-');
        stringBuffer.append(fontData.getHeight());
        return ((Object)stringBuffer).toString();
    }

    public static String asString(Point point) {
        Assert.isNotNull(point);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(point.x);
        stringBuffer.append(',');
        stringBuffer.append(point.y);
        return ((Object)stringBuffer).toString();
    }

    public static String asString(Rectangle rectangle) {
        Assert.isNotNull(rectangle);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(rectangle.x);
        stringBuffer.append(',');
        stringBuffer.append(rectangle.y);
        stringBuffer.append(',');
        stringBuffer.append(rectangle.width);
        stringBuffer.append(',');
        stringBuffer.append(rectangle.height);
        return ((Object)stringBuffer).toString();
    }

    public static String asString(RGB rGB) {
        Assert.isNotNull(rGB);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(rGB.red);
        stringBuffer.append(',');
        stringBuffer.append(rGB.green);
        stringBuffer.append(',');
        stringBuffer.append(rGB.blue);
        return ((Object)stringBuffer).toString();
    }

    public static String asString(boolean bl) {
        return String.valueOf(bl);
    }

    public static String removeWhiteSpaces(String string) {
        boolean bl = false;
        int n = -1;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            bl = Character.isWhitespace(string.charAt(n3));
            if (bl) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
        int n4 = n + 1;
        while (n4 < n2) {
            char c = string.charAt(n4);
            if (!Character.isWhitespace(c)) {
                stringBuffer.append(c);
            }
            ++n4;
        }
        return ((Object)stringBuffer).toString();
    }

    public static String asDisplayableString(FontData fontData) {
        boolean bl;
        Assert.isNotNull(fontData);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(fontData.getName());
        stringBuffer.append('-');
        int n = fontData.getStyle();
        boolean bl2 = (n & 1) == 1;
        boolean bl3 = bl = (n & 2) == 2;
        if (bl2 && bl) {
            stringBuffer.append(JFaceResources.getString("BoldItalicFont"));
        } else if (bl2) {
            stringBuffer.append(JFaceResources.getString("BoldFont"));
        } else if (bl) {
            stringBuffer.append(JFaceResources.getString("ItalicFont"));
        } else {
            stringBuffer.append(JFaceResources.getString("RegularFont"));
        }
        stringBuffer.append('-');
        stringBuffer.append(fontData.getHeight());
        return ((Object)stringBuffer).toString();
    }
}

