/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.eworkbench;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ercp.eworkbench.IApplicationDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ApplicationDescriptor
implements IApplicationDescriptor,
IPluginContribution {
    private String id;
    private String pluginId;
    private String label;
    private String className;
    private String description;
    private boolean singleton;
    private ImageDescriptor image;
    private IConfigurationElement configElement;
    private Hashtable views = new Hashtable();
    private String icon;

    public ApplicationDescriptor(String string, String string2) {
        this.id = string;
        this.label = string2;
    }

    public ApplicationDescriptor(String string, IConfigurationElement iConfigurationElement) throws CoreException {
        this.configElement = iConfigurationElement;
        this.id = string;
        if (this.getId() == null || this.getLabel() == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "Invalid extension (missing label, id or class name): " + this.getId(), null));
        }
    }

    public String getDescription() {
        return this.configElement == null ? this.description : RegistryReader.getDescription((IConfigurationElement)this.configElement);
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.image == null && this.configElement != null) {
            String string = this.configElement.getAttribute("icon");
            if (string != null) {
                this.image = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.configElement.getNamespace(), (String)string);
            }
            if (this.image == null) {
                this.image = WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_DEF_PERSPECTIVE");
            }
        }
        return this.image;
    }

    public void setImage(String string, String string2) {
        this.icon = string2;
        if (string != null && string2 != null) {
            this.image = AbstractUIPlugin.imageDescriptorFromPlugin((String)string, (String)string2);
        }
        if (this.image == null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ApplicationDescriptor.this.image = WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_DEF_PERSPECTIVE");
                }
            });
        }
    }

    public String getLabel() {
        return this.configElement == null ? this.label : this.configElement.getAttribute("name");
    }

    public boolean isSingleton() {
        return this.configElement == null ? this.singleton : this.configElement.getAttributeAsIs("singleton") != null;
    }

    public IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.configElement == null ? this.pluginId : this.configElement.getNamespace();
    }

    public String getClassName() {
        return this.configElement == null ? this.className : RegistryReader.getClassValue((IConfigurationElement)this.configElement, (String)"class");
    }

    public void setViewId(String string, String string2) {
        this.views.put(string, string2);
    }

    public String getViewId(String string) {
        return (String)this.views.get(string);
    }
}

