/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.internal.qt.QObjectDeleteWrapper;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TypedListener;

public class Command
extends Item {
    public static final int GENERAL = 1;
    public static final int SELECT = 2;
    public static final int COMMANDGROUP = 10;
    public static final int OK = 3;
    public static final int CANCEL = 4;
    public static final int DELETE = 5;
    public static final int BACK = 6;
    public static final int EXIT = 7;
    public static final int STOP = 8;
    public static final int HELP = 9;
    public Control control;
    public int type;
    private int priority;
    private int accelerator;
    private String longLabel;
    private Command parent;
    private Command[] children;
    private int commandgroup_handle;

    public Command(Command command, int n, int n2) {
        super(command, 0);
        this.checkWidget();
        this.checkCommand(n, n2);
        if (command.type != 10) {
            SWT.error(5);
        }
        this.control = command.control;
        this.parent = command;
        this.type = n;
        this.priority = n2;
        this.createWidget();
    }

    public Command(Control control, int n, int n2) {
        super(control, 0);
        this.checkWidget();
        this.checkCommand(n, n2);
        this.control = control;
        this.type = n;
        this.priority = n2;
        this.createWidget();
        Command.addCommand(control, this);
    }

    private void checkCommand(int n, int n2) {
        if (n2 < 0) {
            SWT.error(5);
        }
        if (n < 1 || n > 10) {
            SWT.error(5);
        }
    }

    void createWidget() {
        this.createHandle(0);
        this.hookEvents();
        this.register();
    }

    protected void createHandle(int n) {
        this.handle = OS.QAction_new(this.control.handle);
        this.state |= 8;
        if (this.type == 10) {
            this.commandgroup_handle = OS.QMenu_new(this.control.handle);
            OS.QAction_setMenu(this.handle, this.commandgroup_handle);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    protected void hookEvents() {
        super.hookEvents();
        if (this.type == 10) {
            return;
        }
        int n = OS.SignalHandler_new(this.handle, this.display, 1006);
        OS.QObject_connectOrThrow(this.handle, "triggered(bool)", n, "widgetSignal(bool)", 0);
    }

    protected void qt_signal_triggered(boolean bl) {
        Event event = new Event();
        this.sendEvent(13, event);
    }

    protected void register() {
        super.register();
        if (this.parent != null) {
            this.parent.addCommand(this);
        } else {
            Command.addCommand(this.control, this);
            this.display.commandArranger.commandAdded(this);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
    }

    public static Command[] internal_getCommands(Control control) {
        return Command.getCommands(control);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.QAction_isEnabled(this.handle);
    }

    public String getLongLabel() {
        this.checkWidget();
        return this.longLabel;
    }

    public int getPriority() {
        this.checkWidget();
        return this.priority;
    }

    public boolean isDefaultCommand() {
        this.checkWidget();
        return this.display.commandArranger.getDefaultCommand() == this;
    }

    public boolean isEnabled() {
        this.checkWidget();
        if (this.parent != null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && this.control.isEnabled();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.removeListener(13, selectionListener);
    }

    public void setAccelerator(int n) {
        int n2;
        int n3;
        this.checkWidget();
        if (this.accelerator == n) {
            return;
        }
        int n4 = 0;
        if ((n & 0x10000) != 0) {
            n4 |= 0x8000000;
        }
        if ((n & 0x20000) != 0) {
            n4 |= 0x2000000;
        }
        if ((n & 0x40000) != 0) {
            n4 |= 0x4000000;
        }
        if ((n3 = Display.untranslateKey(n2 = n & 0x100FFFF)) != 0) {
            n2 = n3;
        }
        int n5 = OS.QKeySequence_new(n4 + n2);
        OS.QAction_setShortcut(this.handle, n5);
        this.accelerator = n;
        OS.QKeySequence_delete(n5);
    }

    public void setDefaultCommand() {
        this.checkWidget();
        this.display.commandArranger.setDefaultCommand(this);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        OS.QAction_setEnabled(this.handle, bl);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (this.getText().equals(string)) {
            return;
        }
        OS.QAction_setIconText(this.handle, string);
        super.setText(string);
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            OS.QAction_setIcon(this.handle, image.internal_getIconHandle());
        } else {
            OS.QAction_setIcon(this.handle, Image.internal_getNullIconHandle());
        }
    }

    public void setLongLabel(String string) {
        this.checkWidget();
        if (this.longLabel != null && this.longLabel.equals(string)) {
            return;
        }
        OS.QAction_setText(this.handle, string);
        this.longLabel = string;
    }

    private void addCommand(Command command) {
        int n;
        if (this.type != 10) {
            return;
        }
        if (this.children == null) {
            this.children = new Command[1];
            this.children[0] = command;
            OS.QMenu_addAction(this.commandgroup_handle, command.handle);
            return;
        }
        for (n = 0; n < this.children.length && this.children[n].getPriority() >= command.getPriority(); ++n) {
        }
        Command[] commandArray = new Command[this.children.length + 1];
        System.arraycopy(this.children, 0, commandArray, 0, n);
        System.arraycopy(this.children, n, commandArray, n + 1, this.children.length - n);
        commandArray[n] = command;
        this.children = commandArray;
        if (n + 1 >= this.children.length) {
            OS.QMenu_addAction(this.commandgroup_handle, command.handle);
            return;
        }
        OS.QWidget_insertAction(this.commandgroup_handle, this.children[n + 1].handle, command.handle);
    }

    private void removeCommand(Command command) {
        if (this.type != 10) {
            return;
        }
        if (this.children == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != command) continue;
            n = i;
        }
        if (n == -1) {
            return;
        }
        Command[] commandArray = new Command[this.children.length - 1];
        System.arraycopy(this.children, 0, commandArray, 0, n);
        System.arraycopy(this.children, n + 1, commandArray, n, this.children.length - n - 1);
        this.children = commandArray;
        OS.QWidget_removeAction(this.commandgroup_handle, command.handle);
    }

    protected void releaseChildren(boolean bl) {
        if (this.type != 10 || this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.length; ++i) {
            Command command = this.children[i];
            command.dispose();
        }
    }

    protected void releaseParent() {
        if (this.parent != null) {
            this.parent.removeCommand(this);
            OS.QWidget_removeAction(this.parent.commandgroup_handle, this.handle);
        } else {
            Command.removeCommand(this.control, this);
        }
    }

    protected void releaseWidget() {
        super.releaseWidget();
        if (this.parent == null) {
            this.display.commandArranger.commandRemoved(this);
        }
        this.accelerator = 0;
        this.parent = null;
        this.children = null;
        if (this.type == 10) {
            QObjectDeleteWrapper.deleteSafely(this.commandgroup_handle);
        }
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            SWT.error(43);
        }
    }
}

