/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.internal.qt.TextUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class ConstrainedText
extends Control {
    public static final int NUMERIC = 1;
    public static final int DECIMAL = 2;
    public static final int PHONENUMBER = 4;
    private int validator;

    public ConstrainedText(Composite composite, int n, int n2) {
        super(composite, ConstrainedText.checkStyle(n), ConstrainedText.checkConstrainedStyle(n2));
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (OS.QValidator_validate(this.validator, string)) {
            TextUtils.append(this.variant(), this.handle, string, OS.QLineEdit_maxLength(this.handle), null);
        } else {
            SWT.error(5);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        TextUtils.clearSelection(this.variant(), this.handle);
    }

    public void copy() {
        this.checkWidget();
        TextUtils.copy(this.variant(), this.handle);
    }

    public void cut() {
        this.checkWidget();
        TextUtils.cut(this.variant(), this.handle, this);
    }

    public int getCaretPosition() {
        this.checkWidget();
        return TextUtils.getCaretPosition(this.variant(), this.handle);
    }

    public int getCharCount() {
        this.checkWidget();
        return TextUtils.getCharCount(this.variant(), this.handle);
    }

    public boolean getEditable() {
        this.checkWidget();
        return !TextUtils.getReadOnly(this.variant(), this.handle);
    }

    public String getText() {
        this.checkWidget();
        return TextUtils.getText(this.variant(), this.handle);
    }

    public int getTextLimit() {
        this.checkWidget();
        return OS.QLineEdit_maxLength(this.handle);
    }

    public void insert(String string) {
        this.checkWidget();
        if (OS.QValidator_validate(this.validator, string)) {
            TextUtils.insert(this.variant(), this.handle, string, OS.QLineEdit_maxLength(this.handle), null);
        } else {
            SWT.error(5);
        }
    }

    public void paste() {
        this.checkWidget();
        if (OS.QValidator_validate(this.validator, OS.QClipboard_text())) {
            TextUtils.paste(this.variant(), this.handle, OS.QLineEdit_maxLength(this.handle), null);
        } else {
            SWT.error(5);
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.removeListener(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void selectAll() {
        this.checkWidget();
        TextUtils.selectAll(this.variant(), this.handle);
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!bl) {
            this.style |= 8;
        }
        TextUtils.setReadOnly(this.variant(), this.handle, !bl);
    }

    public void setSelection(int n) {
        this.setSelection(n, n);
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        if (n < 0 || n2 < 0) {
            SWT.error(5);
        }
        if (n > n2 || n2 > TextUtils.getText(this.variant(), this.handle).length()) {
            SWT.error(6);
        }
        TextUtils.setSelection(this.variant(), this.handle, n, n2);
    }

    public void setText(String string) {
        this.checkWidget();
        if (OS.QValidator_validate(this.validator, string)) {
            TextUtils.setText(this.variant(), this.handle, string, OS.QLineEdit_maxLength(this.handle), null);
        } else {
            SWT.error(5);
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n <= 0 || n > Text.LIMIT) {
            SWT.error(5);
        }
        this.sendEvent(24);
        OS.QLineEdit_setMaxLength(this.handle, n);
    }

    public void showSelection() {
        this.checkWidget();
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        this.traverseDoit = false;
        this.traverseCancel = false;
        if (n == 128) {
            this.traverseDoit = true;
            return;
        }
        switch (n2) {
            case 0x1000001: 
            case 0x1000004: 
            case 0x1000005: 
            case 0x1000013: 
            case 0x1000015: {
                this.traverseDoit = true;
                break;
            }
            case 0x1000012: 
            case 0x1000014: {
                this.traverseDoit = false;
                break;
            }
            default: {
                super.setTraversalFlags(n, n2, n3, n4);
            }
        }
    }

    protected int variant() {
        return 0;
    }

    protected void checkBorder() {
        super.checkBorder();
        OS.QLineEdit_setFrame(this.internal_topHandle(), (this.style & 0x800) != 0);
    }

    protected void createHandle(int n) {
        this.handle = OS.QLineEdit_new();
        OS.QWidget_setGeometry(this.handle, 0, 0, 0, 0);
        OS.QLineEdit_setMaxLength(this.handle, Text.LIMIT);
        int n2 = 1;
        if ((this.style & 0x1000000) != 0) {
            n2 = 4;
        } else if ((this.style & 0x20000) != 0) {
            n2 = 2;
        }
        OS.QLineEdit_setAlignment(this.handle, n2 | 0x80);
        switch (this.extraStyle) {
            case 1: {
                this.validator = OS.QRegExpValidator_new(this.handle, "[\\+\\-]?\\d*");
                break;
            }
            case 2: {
                this.validator = OS.QRegExpValidator_new(this.handle, "[\\+\\-]?\\d*(\\.?(\\d+([eE][\\+\\-]?\\d*)?)?)?");
                break;
            }
            case 4: {
                this.validator = OS.QRegExpValidator_new(this.handle, "[\\+\\d\\sABCD,TP!W@;>IiGg\\*\\#\\.\\(\\)\\/\\-]*");
                break;
            }
        }
        OS.QLineEdit_setValidator(this.handle, this.validator);
        this.state |= 8;
    }

    protected void hookEvents() {
        super.hookEvents();
        int n = OS.SignalHandler_new(this.handle, this.display, 1009);
        OS.QObject_connectOrThrow(this.handle, "textChanged(const QString&)", n, "widgetSignal(const QString&)", 0);
        int n2 = OS.SignalHandler_new(this.handle, this.display, 1011);
        OS.QObject_connectOrThrow(this.handle, "returnPressed()", n2, "widgetSignal()", 0);
    }

    protected void qt_signal_return_pressed() {
        this.sendEvent(14);
    }

    protected void qt_signal_text_changed(String string) {
        this.sendEvent(24);
    }

    static int checkStyle(int n) {
        return n | 4;
    }

    static int checkConstrainedStyle(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                return n;
            }
        }
        SWT.error(5);
        return 1;
    }
}

