/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.ListUtils;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class ListView
extends Scrollable {
    private Vector icons = new Vector();
    private int density;
    private int spacing;
    private boolean ignoreSelectionEvent;
    public static final int LOW = 1;
    public static final int MEDIUM = 2;
    public static final int HIGH = 3;

    public ListView(Composite composite, int n) {
        super(composite, ListView.checkStyle(n));
    }

    public ListView(Composite composite, int n, int n2) {
        super(composite, n);
        if (n2 != 1 && n2 != 2 && n2 != 3) {
            SWT.error(5);
        }
        this.density = n2;
    }

    public void add(String string, Image image) {
        this.checkWidget();
        ListUtils.add(this.internal_topHandle(), string, image);
        this.icons.addElement(image);
        this.resetGeometry(this.getItemCount() - 1);
    }

    public void add(String string, Image image, int n) {
        this.checkWidget();
        ListUtils.add(this.internal_topHandle(), string, image, n);
        this.icons.insertElementAt(image, n);
        this.resetGeometry(n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void deselect(int n) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.deselect(this.internal_topHandle(), n);
        this.ignoreSelectionEvent = false;
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.deselect(this.internal_topHandle(), nArray);
        this.ignoreSelectionEvent = false;
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.deselect(this.internal_topHandle(), n, n2);
        this.ignoreSelectionEvent = false;
    }

    public void deselectAll() {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.deselectAll(this.internal_topHandle());
        this.ignoreSelectionEvent = false;
    }

    public int getFocusIndex() {
        this.checkWidget();
        return ListUtils.getFocusIndex(this.internal_topHandle());
    }

    public Image getIcon(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.icons.size()) {
            SWT.error(6);
        }
        return (Image)this.icons.elementAt(n);
    }

    public Point getIconSize(int n) {
        this.checkWidget();
        if (n != 1 && n != 2 && n != 3) {
            SWT.error(5);
        }
        return OS.QAbstractItemView_iconSize(this.internal_topHandle());
    }

    public String getItem(int n) {
        this.checkWidget();
        return ListUtils.getItem(this.internal_topHandle(), n);
    }

    public int getItemCount() {
        this.checkWidget();
        return ListUtils.getItemCount(this.internal_topHandle());
    }

    public String[] getItems() {
        this.checkWidget();
        return ListUtils.getItems(this.internal_topHandle());
    }

    public int getLayout() {
        this.checkWidget();
        if (0 == OS.QListView_flow(this.internal_topHandle())) {
            return 256;
        }
        return 512;
    }

    public int getLayoutDensity() {
        this.checkWidget();
        return this.density;
    }

    public String[] getSelection() {
        this.checkWidget();
        return ListUtils.getSelection(this.internal_topHandle());
    }

    public int getSelectionCount() {
        this.checkWidget();
        return ListUtils.getSelectionCount(this.internal_topHandle());
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        return ListUtils.getSelectionIndices(this.internal_topHandle());
    }

    public int getTopIndex() {
        this.checkWidget();
        return OS.QAbstractItemView_swt_indexAt(this.internal_topHandle(), 1, 1);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        return ListUtils.indexOf(this.internal_topHandle(), string, n);
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        return ListUtils.isSelected(this.internal_topHandle(), n);
    }

    public void remove(int n) {
        this.checkWidget();
        ListUtils.remove(this.internal_topHandle(), n);
        this.icons.removeElementAt(n);
        this.resetGeometry();
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        ListUtils.remove(this.internal_topHandle(), n, n2);
        for (int i = n2; i >= n; --i) {
            this.icons.removeElementAt(i);
        }
        this.resetGeometry();
    }

    public void remove(String string) {
        int n;
        if (string == null) {
            SWT.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            SWT.error(5);
        }
        this.remove(n);
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        int[] nArray2 = ListUtils.remove(this.internal_topHandle(), nArray);
        int n = -1;
        for (int i = nArray2.length - 1; i >= 0; --i) {
            if (n != nArray2[i]) {
                this.icons.removeElementAt(nArray2[i]);
            }
            n = nArray2[i];
        }
        this.resetGeometry();
    }

    public void removeAll() {
        this.checkWidget();
        ListUtils.removeAll(this.internal_topHandle());
        this.resetGeometry();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.select(this.internal_topHandle(), n, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void select(int n, int n2) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.select(this.internal_topHandle(), n, n2, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void select(int[] nArray) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.select(this.internal_topHandle(), nArray, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void selectAll() {
        this.ignoreSelectionEvent = true;
        this.checkWidget();
        ListUtils.selectAll(this.internal_topHandle(), (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(int n, String string, Image image) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        boolean bl = this.isSelected(n);
        this.setRedraw(false);
        try {
            this.remove(n);
            this.add(string, image, n);
            if (bl) {
                this.select(n);
            }
            this.resetGeometry();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setRedraw(true);
            throw throwable;
        }
        this.setRedraw(true);
    }

    public void setItems(String[] stringArray, Image[] imageArray) {
        this.checkWidget();
        ListUtils.setItems(this.internal_topHandle(), stringArray, imageArray);
        this.icons.removeAllElements();
        for (int i = 0; i < stringArray.length; ++i) {
            this.icons.addElement(imageArray == null ? null : imageArray[i]);
        }
        this.resetGeometry();
    }

    public void setLayout(int n) {
        this.checkWidget();
        if (n != 256 && n != 512) {
            SWT.error(5);
        }
        this.style &= 0xFFFFFDFF;
        this.style &= 0xFFFFFEFF;
        if (n == 256) {
            this.style |= 0x200;
            if (this.verticalBar == null) {
                this.verticalBar = this.createScrollBar(512);
            }
            OS.QAbstractScrollArea_setVerticalScrollBarPolicy(this.scrollAreaHandle, 2);
            OS.QAbstractScrollArea_setHorizontalScrollBarPolicy(this.scrollAreaHandle, 1);
            OS.QListView_setFlow(this.internal_topHandle(), 0);
        } else {
            this.style |= 0x100;
            if (this.horizontalBar == null) {
                this.horizontalBar = this.createScrollBar(256);
            }
            OS.QAbstractScrollArea_setHorizontalScrollBarPolicy(this.scrollAreaHandle, 2);
            OS.QAbstractScrollArea_setVerticalScrollBarPolicy(this.scrollAreaHandle, 1);
            OS.QListView_setFlow(this.internal_topHandle(), 1);
        }
    }

    public void setLayoutDensity(int n) {
        this.checkWidget();
        if (n != 1 && n != 2 && n != 3) {
            SWT.error(5);
        }
        this.density = n;
        this.resetGeometry();
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.setSelection(this.internal_topHandle(), n);
        this.ignoreSelectionEvent = false;
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.setSelection(this.internal_topHandle(), n, n2, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.setSelection(this.internal_topHandle(), nArray, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        this.ignoreSelectionEvent = true;
        ListUtils.setSelection(this.internal_topHandle(), stringArray, (2 & this.getStyle()) != 0);
        this.ignoreSelectionEvent = false;
    }

    public void showSelection() {
        this.checkWidget();
        ListUtils.showSelection(this.internal_topHandle());
    }

    protected void createHandle(int n) {
        super.createHandle(n);
        this.scrollAreaHandle = OS.QListWidget_new();
        this.handle = OS.QAbstractScrollArea_viewPort(this.scrollAreaHandle);
        OS.QListView_setMovement(this.scrollAreaHandle, 0);
        OS.QListView_setViewMode(this.scrollAreaHandle, 1);
        OS.QListView_setResizeMode(this.scrollAreaHandle, 1);
        OS.QAbstractItemView_setSelectionBehavior(this.scrollAreaHandle, 0);
        if ((this.getStyle() & 2) != 0) {
            OS.QAbstractItemView_setSelectionMode(this.scrollAreaHandle, 2);
        } else {
            OS.QAbstractItemView_setSelectionMode(this.scrollAreaHandle, 1);
        }
        if ((this.getStyle() & 0x100) != 0) {
            this.setLayout(512);
        } else {
            this.setLayout(256);
        }
        this.spacing = OS.QListView_spacing(this.scrollAreaHandle);
        this.density = 2;
        this.state |= 8;
    }

    protected void hookEvents() {
        super.hookEvents();
        int n = this.internal_topHandle();
        int n2 = OS.SignalHandler_new(n, this.display, 1012);
        OS.QObject_connectOrThrow(n, "itemSelectionChanged()", n2, "widgetSignal()", 0);
        int n3 = OS.SignalHandler_new(n, this.display, 1013);
        OS.QObject_connectOrThrow(n, "itemDoubleClicked(QListWidgetItem*)", n3, "widgetSignal(QListWidgetItem*)", 0);
    }

    protected void qt_signal_list_itemSelectionChanged() {
        if (!this.ignoreSelectionEvent) {
            this.sendEvent(13);
        }
    }

    protected void qt_signal_list_itemDoubleClicked(int n) {
        if (!this.ignoreSelectionEvent) {
            this.sendEvent(14);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.resetGeometry();
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        this.traverseDoit = false;
        this.traverseCancel = false;
        int n5 = this.internal_topHandle();
        switch (n2) {
            case 0x1000013: {
                if (this.getVisualRow(ListUtils.getFocusIndex(n5)) != 0) break;
                this.traverseDoit = true;
                this.traverseCancel = true;
                break;
            }
            case 0x1000012: {
                if (this.getVisualCol(ListUtils.getFocusIndex(n5)) != 0) break;
                this.traverseDoit = true;
                this.traverseCancel = true;
                break;
            }
            case 0x1000015: {
                int n6 = ListUtils.getFocusIndex(n5);
                int n7 = ListUtils.getItemCount(n5);
                int n8 = this.getVisualRowCount();
                int n9 = this.getVisualRow(n6);
                if (this.getLayout() == 256) {
                    if (n9 != n8 - 1 && (n9 != n8 - 2 || this.getVisualCol(n6) <= this.getVisualCol(n7 - 1))) break;
                    this.traverseDoit = true;
                    this.traverseCancel = true;
                    break;
                }
                if (n6 != n7 - 1 && n9 != n8 - 1) break;
                this.traverseDoit = true;
                this.traverseCancel = true;
                break;
            }
            case 0x1000014: {
                int n10 = ListUtils.getFocusIndex(n5);
                int n11 = ListUtils.getItemCount(n5);
                int n12 = this.getVisualColCount();
                int n13 = this.getVisualCol(n10);
                if (this.getLayout() == 256) {
                    if (n10 != n11 - 1 && n13 != this.getVisualColCount() - 1) break;
                    this.traverseDoit = true;
                    this.traverseCancel = true;
                    break;
                }
                if (n13 != n12 - 1 && (n13 != n12 - 2 || this.getVisualRow(n10) <= this.getVisualRow(n11 - 1))) break;
                this.traverseDoit = true;
                this.traverseCancel = true;
                break;
            }
            default: {
                this.traverseDoit = true;
                this.traverseCancel = true;
            }
        }
    }

    protected Point getPreferredClientAreaSize() {
        int n = this.getItemCount();
        if (n > 0) {
            int n2 = 0;
            int n3 = 0;
            Point point = OS.QListView_gridSize(this.internal_topHandle());
            if (this.getLayout() == 256) {
                n2 += point.x * n;
                n3 += point.y;
                n2 += 16;
            } else {
                n2 += point.x;
                n3 += point.y * n;
                n3 += 16;
            }
            return new Point(n2, n3);
        }
        return OS.QWidget_sizeHint(this.internal_topHandle());
    }

    private static int checkStyle(int n) {
        int n2 = ListView.checkBits(n, 256, 512, 0, 0, 0, 0);
        n &= 0xFFFFFDFF;
        n &= 0xFFFFFEFF;
        n = (n2 & 0x200) != 0 ? (n |= 0x100) : (n |= 0x200);
        return ListView.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    private int getSpacing(int n) {
        switch (n) {
            case 1: {
                if (this.spacing != 0) {
                    return this.spacing * 2;
                }
                return 20;
            }
            case 3: {
                return 0;
            }
        }
        return this.spacing;
    }

    private int getVisualCol(int n) {
        if (this.getLayout() == 256) {
            return n % this.getVisualColCount();
        }
        return (int)Math.floor(n / this.getVisualRowCount());
    }

    private int getVisualRow(int n) {
        if (this.getLayout() == 256) {
            return (int)Math.floor(n / this.getVisualColCount());
        }
        return n % this.getVisualRowCount();
    }

    private int getVisualColCount() {
        int n = this.internal_topHandle();
        int n2 = 1;
        int n3 = ListUtils.getItemCount(this.internal_topHandle());
        if (this.getLayout() == 256) {
            int n4;
            int n5 = OS.QAbstractItemView_visualRect((int)n, (int)0, (int)0).y;
            for (int i = 1; i < n3 && (n4 = n5) == (n5 = OS.QAbstractItemView_visualRect((int)n, (int)i, (int)0).y); ++i) {
                ++n2;
            }
        } else {
            int n6 = this.getVisualRowCount();
            n2 = (int)Math.floor(n3 / n6);
            if (n3 % n6 > 0) {
                ++n2;
            }
        }
        return n2;
    }

    private int getVisualRowCount() {
        int n = this.internal_topHandle();
        int n2 = 1;
        int n3 = ListUtils.getItemCount(this.internal_topHandle());
        if (this.getLayout() == 256) {
            int n4 = this.getVisualColCount();
            n2 = (int)Math.floor(n3 / n4);
            if (n3 % n4 > 0) {
                ++n2;
            }
        } else {
            int n5;
            int n6 = OS.QAbstractItemView_visualRect((int)n, (int)0, (int)0).x;
            for (int i = 1; i < n3 && (n5 = n6) == (n6 = OS.QAbstractItemView_visualRect((int)n, (int)i, (int)0).x); ++i) {
                ++n2;
            }
        }
        return n2;
    }

    private void resetGeometry() {
        this.resetGeometry(-1);
    }

    private void resetGeometry(int n) {
        this.resetIconSize(n);
        this.resetGridSize(n);
    }

    private void resetGridSize(int n) {
        Point point;
        int n2 = this.internal_topHandle();
        if (n > -1) {
            point = OS.QListView_gridSize(this.internal_topHandle());
            Point point2 = OS.QAbstractItemView_sizeHintForIndex(n2, n, 0);
            point.x = Math.max(point.x, point2.x);
            point.y = Math.max(point.y, point2.y);
        } else {
            point = new Point(0, 0);
            for (int i = 0; i < this.getItemCount(); ++i) {
                Point point3 = OS.QAbstractItemView_sizeHintForIndex(n2, i, 0);
                point.x = Math.max(point.x, point3.x);
                point.y = Math.max(point.y, point3.y);
            }
        }
        int n3 = this.getSpacing(this.density);
        OS.QListView_setGridSize(n2, point.x + n3, point.y + n3);
    }

    private void resetIconSize(int n) {
        Point point;
        int n2 = this.internal_topHandle();
        if (n > -1 && this.getIcon(n) != null) {
            point = OS.QAbstractItemView_iconSize(n2);
            Rectangle rectangle = this.getIcon(n).getBounds();
            point.x = Math.max(point.x, rectangle.width);
            point.y = Math.max(point.y, rectangle.height);
        } else {
            point = new Point(0, 0);
            for (int i = 0; i < this.getItemCount(); ++i) {
                Image image = this.getIcon(i);
                if (image == null) continue;
                Rectangle rectangle = image.getBounds();
                point.x = Math.max(point.x, rectangle.width);
                point.y = Math.max(point.y, rectangle.height);
            }
        }
        OS.QAbstractItemView_setIconSize(n2, point.x, point.y);
    }
}

