/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class MobileShell
extends Shell {
    String title;
    Vector keyCodeVector = new Vector(10, 10);
    Listener keyListener;
    public static final int NO_STATUS_PANE = 1;
    public static final int SMALL_STATUS_PANE = 2;
    public static final int LARGE_STATUS_PANE = 3;

    public MobileShell(int n) {
        this((Display)null, n);
    }

    public MobileShell(Display display) {
        this(display, 1264);
    }

    public MobileShell(Display display, int n) {
        this(display, n, 3);
    }

    public MobileShell(Display display, int n, int n2) {
        super(display, n);
        if (!this.isValidSubclass()) {
            SWT.error(43);
        }
        this.changeTrim(n, n2);
        this.init();
    }

    public boolean getKeyState(int n) {
        this.checkWidget();
        Display display = this.getDisplay();
        if (display.getActiveShell() != this) {
            return false;
        }
        Enumeration enumeration = this.keyCodeVector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Integer n3 = (Integer)enumeration.nextElement();
            if (n3 == n) {
                this.keyCodeVector.removeElementAt(n2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setFullScreenMode(boolean bl) {
        this.checkWidget();
        this.setRestoreState(4, !bl);
    }

    public void setFullScreenMode(boolean bl, boolean bl2) {
        this.setFullScreenMode(bl);
    }

    public void changeTrim(int n, int n2) {
        this.checkWidget();
        Shell.checkStyle(n, null);
        int n3 = -4;
        if ((n2 & n3) != 0) {
            SWT.error(5);
        }
        if (OS.windowServer != 2) {
            n &= 0xFFFFF30F;
            n |= n;
            OS.QWidget_setWindowFlags(this.internal_topHandle(), this.windowFlagsFromStyle());
        }
    }

    public boolean getFullScreenMode() {
        this.checkWidget();
        return this.hasState(4);
    }

    public void setStatusText(String string) {
        this.checkWidget();
        this.title = string;
    }

    public String getStatusText() {
        this.checkWidget();
        return this.title;
    }

    private void init() {
        final Display display = this.getDisplay();
        final MobileShell mobileShell = this;
        this.keyListener = new Listener(){

            public void handleEvent(Event event) {
                if (display.getActiveShell() == mobileShell) {
                    Integer n;
                    Enumeration enumeration = MobileShell.this.keyCodeVector.elements();
                    boolean bl = false;
                    while (enumeration.hasMoreElements()) {
                        n = (Integer)enumeration.nextElement();
                        if (n != event.keyCode) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        n = new Integer(event.keyCode);
                        MobileShell.this.keyCodeVector.addElement(n);
                    }
                }
            }
        };
        display.addFilter(1, this.keyListener);
        mobileShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (mobileShell != null && !mobileShell.isDisposed()) {
                    mobileShell.getDisplay().removeFilter(1, MobileShell.this.keyListener);
                }
            }
        });
    }
}

