/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class MultiPageDialog
extends Dialog {
    private Shell shell;
    private internal_TabControl tabControl;
    private boolean isOpen;
    private boolean ignoreSelectionEvent;

    public MultiPageDialog(Shell shell) {
        this(shell, 0);
    }

    public MultiPageDialog(Shell shell, int n) {
        super(shell, MultiPageDialog.internal_checkStyle(shell, n));
        this.checkParent(shell);
        this.checkSubclass();
        int n2 = 100892672;
        this.shell = new Shell(shell, 0x860 | this.style & n2);
        this.shell.setText(this.title);
        this.shell.setLayout(new FillLayout());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                MultiPageDialog.this.isOpen = false;
            }
        });
        this.tabControl = new internal_TabControl(this.shell, (n & 0x10000000) != 0);
        this.shell.layout(true);
        this.ignoreSelectionEvent = false;
    }

    private void checkDialog() {
        if (this.shell.isDisposed()) {
            SWT.error(24);
        }
        this.tabControl.checkWidget();
    }

    public void addListener(int n, Listener listener) {
        this.checkDialog();
        if (listener == null) {
            SWT.error(4);
        }
        this.tabControl.addListener(n, listener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkDialog();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.tabControl.addListener(13, typedListener);
    }

    public void close() {
        this.checkDialog();
        this.shell.dispose();
        this.isOpen = false;
    }

    public Composite createPage(String string, Image image) {
        this.checkDialog();
        if (string == null) {
            SWT.error(4);
        }
        internal_PageComposite internal_PageComposite2 = new internal_PageComposite(this.tabControl, 0);
        int n = image != null ? image.internal_getIconHandle() : Image.internal_getNullIconHandle();
        this.ignoreSelectionEvent = true;
        OS.QTabWidget_addTab(this.tabControl.internal_topHandle(), internal_PageComposite2.internal_topHandle(), n, string);
        this.ignoreSelectionEvent = false;
        internal_PageComposite2.setSize(OS.QSwtTabWidget_stackedWidgetSize(this.tabControl.internal_topHandle()));
        return internal_PageComposite2;
    }

    public void deletePage(int n) {
        this.checkDialog();
        this.checkRange(n);
        Composite composite = this.getPage(n);
        this.ignoreSelectionEvent = true;
        OS.QTabWidget_removeTab(this.tabControl.internal_topHandle(), n);
        this.ignoreSelectionEvent = false;
        composite.dispose();
    }

    public void dispose() {
        this.isOpen = false;
        if (this.shell.isDisposed()) {
            return;
        }
        this.shell.dispose();
    }

    public Composite getPage(int n) {
        this.checkDialog();
        this.checkRange(n);
        int n2 = OS.QTabWidget_widget(this.tabControl.internal_topHandle(), n);
        Control[] controlArray = this.tabControl._getChildren();
        Composite composite = null;
        for (int i = 0; i < controlArray.length; ++i) {
            if (controlArray[i].internal_topHandle() != n2) continue;
            composite = (Composite)controlArray[i];
            break;
        }
        return composite;
    }

    public int getPageCount() {
        this.checkDialog();
        return OS.QTabWidget_count(this.tabControl.internal_topHandle());
    }

    public String getTitle(int n) {
        this.checkDialog();
        this.checkRange(n);
        return OS.QTabWidget_tabText(this.tabControl.internal_topHandle(), n);
    }

    public int getSelectionIndex() {
        this.checkDialog();
        return OS.QTabWidget_currentIndex(this.tabControl.internal_topHandle());
    }

    protected static int internal_checkStyle(Shell shell, int n) {
        int n2;
        if (shell != null) {
            n = Dialog.checkStyle(shell, n);
        }
        if ((n & (n2 = 98304)) == 0) {
            n |= 0x10000;
        }
        if ((n & 0x10000) != 0) {
            n = n & ~n2 | 0x10000;
        }
        if ((n & 0x8000) != 0) {
            n = n & ~n2 | 0x8000;
        }
        return n;
    }

    public void open() {
        this.checkDialog();
        if (!this.isOpen) {
            this.tabControl.sendSetDataEvent(this.getSelectionIndex());
            this.shell.open();
            this.isOpen = true;
            Display display = this.shell.getDisplay();
            while (this.isOpen) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        } else {
            this.shell.forceActive();
        }
    }

    public void removeListener(int n, Listener listener) {
        this.checkDialog();
        if (listener == null) {
            SWT.error(4);
        }
        this.tabControl.removeListener(n, listener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkDialog();
        this.tabControl.removeSelectionListener(selectionListener);
    }

    public void setSelection(int n) {
        this.checkDialog();
        this.checkRange(n);
        this.ignoreSelectionEvent = true;
        OS.QTabWidget_setCurrentIndex(this.tabControl.internal_topHandle(), n);
        this.ignoreSelectionEvent = false;
    }

    public void setImage(int n, Image image) {
        this.checkDialog();
        if (image == null) {
            SWT.error(4);
        }
        this.checkRange(n);
        OS.QTabWidget_setTabIcon(this.tabControl.internal_topHandle(), n, image.internal_getIconHandle());
    }

    public void setText(String string) {
        this.checkDialog();
        super.setText(string);
        this.shell.setText(string);
    }

    public void setTitle(int n, String string) {
        this.checkDialog();
        if (string == null) {
            SWT.error(4);
        }
        this.checkRange(n);
        OS.QTabWidget_setTabText(this.tabControl.internal_topHandle(), n, string);
    }

    private void checkRange(int n) {
        if (n < 0 || this.getPageCount() <= n) {
            SWT.error(6);
        }
    }

    private class internal_PageComposite
    extends Composite {
        boolean setDataSent = false;

        internal_PageComposite(Composite composite, int n) {
            super(composite, n);
        }
    }

    private class internal_TabControl
    extends Composite {
        boolean virtual;
        int stackedWidgetHandle;

        internal_TabControl(Shell shell, boolean bl) {
            super(shell, 0);
            this.virtual = bl;
        }

        public void checkWidget() {
            super.checkWidget();
        }

        protected void createHandle(int n) {
            this.scrollAreaHandle = 0;
            this.handle = OS.QSwtTabWidget_new();
            this.stackedWidgetHandle = OS.QTabWidget_swt_stackedWidgetHandle(this.handle);
            this.state |= 0xA;
        }

        protected Control[] _getChildren() {
            return this._getChildren(this.stackedWidgetHandle);
        }

        protected void hookEvents() {
            super.hookEvents();
            int n = OS.SignalHandler_new(this.handle, this.display, 1035);
            OS.QObject_connectOrThrow(this.handle, "currentChanged(int)", n, "widgetSignal(int)", 0);
        }

        public int internal_topHandle() {
            return this.handle;
        }

        protected void qt_signal_current_tab_changed(int n) {
            if (MultiPageDialog.this.isOpen) {
                this.sendSetDataEvent(n);
            }
            if (!MultiPageDialog.this.ignoreSelectionEvent) {
                Event event = this.createEvent(13, n < 0 ? null : MultiPageDialog.this.getPage(n));
                this.sendEvent(13, event);
            }
        }

        public void removeSelectionListener(SelectionListener selectionListener) {
            this.removeListener(13, selectionListener);
        }

        public void sendSetDataEvent(int n) {
            if (!this.virtual || n < 0) {
                return;
            }
            internal_PageComposite internal_PageComposite2 = (internal_PageComposite)MultiPageDialog.this.getPage(n);
            if (!internal_PageComposite2.setDataSent) {
                this.sendEvent(36, this.createEvent(36, internal_PageComposite2));
                internal_PageComposite2.setDataSent = true;
                internal_PageComposite2.setFocus();
            }
        }

        private Event createEvent(int n, Composite composite) {
            Event event = new Event();
            event.type = n;
            event.display = this.display;
            event.item = composite;
            event.time = 0;
            return event;
        }
    }
}

