/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.ercp.swt.mobile.DateEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class QueryDialog
extends Dialog {
    private int queryType;
    private int minimum;
    private int maximum;
    private String promptText;
    private String defaultValue;
    private boolean isMidnight;
    private static final String midnightHour = "24:00:00";
    private static final String platformMidnightHour = "00:00:00";
    private String dialogID;
    static int dialogCount;
    private static final int MAX_DECIMALS = 10;
    public static final int STANDARD = 0;
    public static final int PASSWORD = 1;
    public static final int NUMERIC = 2;
    public static final int TIME = 3;
    public static final int DATE = 4;

    public QueryDialog(Shell shell) {
        this(shell, 65536, 0);
    }

    public QueryDialog(Shell shell, int n) {
        this(shell, n, 0);
    }

    public QueryDialog(Shell shell, int n, int n2) {
        super(shell, QueryDialog.checkStyle(shell, n));
        this.checkSubclass();
        this.checkDialog();
        if (!QueryDialog.internal_checkQueryType(n2)) {
            SWT.error(5);
        }
        this.dialogID = this.toString() + String.valueOf(++dialogCount);
        this.queryType = n2;
        this.defaultValue = null;
        this.isMidnight = false;
    }

    protected static int checkStyle(Shell shell, int n) {
        int n2;
        if (((n = Dialog.checkStyle(shell, n)) & (n2 = 98304)) == 0) {
            n |= 0x10000;
        }
        if ((n & 0x10000) != 0) {
            n = n & ~n2 | 0x10000;
        }
        if ((n & 0x8000) != 0) {
            n = n & ~n2 | 0x8000;
        }
        return n;
    }

    static boolean internal_checkQueryType(int n) {
        return n == 0 || n == 2 || n == 1 || n == 3 || n == 4;
    }

    private void checkDialog() {
        Display display = this.getParent().getDisplay();
        if (display.getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
    }

    public String open() {
        this.checkDialog();
        String string = null;
        if (this.queryType == 3 || this.queryType == 4) {
            internal_DateTimeDialog internal_DateTimeDialog2 = new internal_DateTimeDialog();
            string = internal_DateTimeDialog2.open();
            if (this.isMidnight && string.equals(platformMidnightHour)) {
                string = midnightHour;
            }
        } else {
            DisposeListener disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    if (disposeEvent.widget == QueryDialog.this.parent) {
                        OS.QDialog_swt_closeDialogs(((QueryDialog)QueryDialog.this).parent.handle, QueryDialog.this.dialogID);
                    }
                }
            };
            this.parent.addDisposeListener(disposeListener);
            if (this.queryType == 0 || this.queryType == 1) {
                int n = this.queryType == 1 ? 2 : 0;
                string = OS.QInputDialog_swt_getText(this.parent.handle, this.title, this.promptText, n, this.defaultValue, this.dialogID);
            } else {
                double d;
                double d2 = Double.MAX_VALUE;
                double d3 = d = this.defaultValue == null ? 0.0 : Double.parseDouble(this.defaultValue);
                if (this.maximum > 0) {
                    String string2 = "";
                    for (int i = 0; i < this.maximum; ++i) {
                        string2 = string2 + 9;
                    }
                    d2 = Double.parseDouble(string2);
                }
                string = OS.QInputDialog_swt_getDouble(this.parent.handle, this.title, this.promptText, -d2, d2, d, 10, this.dialogID);
            }
            if (this.parent != null && !this.parent.isDisposed()) {
                this.parent.removeDisposeListener(disposeListener);
            }
        }
        return string;
    }

    public void setMaximum(int n) {
        this.checkDialog();
        if (n < 0 || n < this.minimum) {
            SWT.error(4);
        }
        if (n > Short.MAX_VALUE) {
            SWT.error(5);
        }
        this.maximum = n;
    }

    public void setMinimum(int n) {
        this.checkDialog();
        if (n < 0 || this.maximum > 0 && n > this.maximum) {
            SWT.error(4);
        }
        this.minimum = n;
    }

    public void setPromptText(String string, String string2) {
        this.checkDialog();
        if (string2 == null) {
            SWT.error(4);
        }
        if (this.checkFormat(string2)) {
            this.defaultValue = this.queryType != 4 && this.queryType != 3 && this.maximum > 0 && string2.length() > this.maximum ? string2.substring(0, this.maximum) : string2;
            this.promptText = string;
        } else {
            SWT.error(5);
        }
    }

    private boolean checkFormat(String string) {
        switch (this.queryType) {
            case 2: {
                try {
                    Double.parseDouble(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            case 3: {
                try {
                    if (string.length() != 8 || string.charAt(2) != ':' || string.charAt(5) != ':') {
                        return false;
                    }
                    String string2 = string.substring(0, 2);
                    int n = Integer.parseInt(string2);
                    if (n < 0) {
                        return false;
                    }
                    String string3 = string.substring(3, 5);
                    int n2 = Integer.parseInt(string3);
                    if (n == 24 && n2 != 0 || n2 < 0 || n2 > 59) {
                        return false;
                    }
                    String string4 = string.substring(6, 8);
                    int n3 = Integer.parseInt(string4);
                    if (n == 24 && n3 != 0 || n3 < 0 || n3 > 60) {
                        return false;
                    }
                    this.isMidnight = n == 24;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            case 4: {
                try {
                    if (string.length() != 10 || string.charAt(4) != '-' || string.charAt(7) != '-') {
                        return false;
                    }
                    String string5 = string.substring(0, 4);
                    int n = Integer.parseInt(string5);
                    if (n < 0) {
                        return false;
                    }
                    String string6 = string.substring(5, 7);
                    int n4 = Integer.parseInt(string6);
                    if (n4 < 1 || n4 > 12) {
                        return false;
                    }
                    String string7 = string.substring(8, 10);
                    int n5 = Integer.parseInt(string7);
                    if (n5 < 1 || n5 > 31) {
                        return false;
                    }
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        }
        return true;
    }

    private class internal_DateTimeDialog
    implements SelectionListener {
        private Shell shell;
        private DateEditor editor;
        private Button okButton;
        private Button cancelButton;
        private Date retValue = null;

        public String open() {
            this.createShell();
            this.shell.open();
            Display display = QueryDialog.this.parent.getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (this.retValue == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.retValue);
            if (QueryDialog.this.queryType == 3) {
                return this.getIntValue(calendar.get(11)) + ":" + this.getIntValue(calendar.get(12)) + ":" + this.getIntValue(calendar.get(13));
            }
            return this.getIntValue(calendar.get(1)) + "-" + this.getIntValue(calendar.get(2) + 1) + "-" + this.getIntValue(calendar.get(5));
        }

        private void createShell() {
            Object object;
            this.shell = new Shell(QueryDialog.this.getParent(), 0x860 | QueryDialog.this.getStyle());
            this.shell.setText(QueryDialog.this.title);
            Label label = new Label(this.shell, 16704);
            if (QueryDialog.this.promptText != null) {
                label.setText(QueryDialog.this.promptText);
            }
            int n = 0x6000000;
            int n2 = QueryDialog.this.queryType == 4 ? 1 : 2;
            this.editor = new DateEditor(this.shell, QueryDialog.this.getStyle() & n, n2);
            if (QueryDialog.this.queryType == 4) {
                this.editor.setDate(new Date());
            } else {
                this.editor.setTime(0);
            }
            this.editor.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent traverseEvent) {
                    if (traverseEvent.detail == 4) {
                        traverseEvent.doit = true;
                    }
                }
            });
            if (QueryDialog.this.defaultValue != null) {
                object = Calendar.getInstance();
                if (QueryDialog.this.queryType == 4) {
                    ((Calendar)object).set(1, Integer.parseInt(QueryDialog.this.defaultValue.substring(0, 4)));
                    ((Calendar)object).set(2, Integer.parseInt(QueryDialog.this.defaultValue.substring(5, 7)) - 1);
                    ((Calendar)object).set(5, Integer.parseInt(QueryDialog.this.defaultValue.substring(8)));
                } else {
                    ((Calendar)object).set(11, Integer.parseInt(QueryDialog.this.defaultValue.substring(0, 2)));
                    ((Calendar)object).set(12, Integer.parseInt(QueryDialog.this.defaultValue.substring(3, 5)));
                    ((Calendar)object).set(13, Integer.parseInt(QueryDialog.this.defaultValue.substring(6, 8)));
                }
                this.editor.setDate(((Calendar)object).getTime());
            }
            this.cancelButton = new Button(this.shell, 8);
            this.okButton = new Button(this.shell, 8);
            this.shell.setDefaultButton(this.okButton);
            this.okButton.setText(OS.QDialogButtonBox_tr("&OK"));
            this.cancelButton.setText(OS.QDialogButtonBox_tr("Cancel"));
            this.okButton.addSelectionListener(this);
            this.cancelButton.addSelectionListener(this);
            object = new GridLayout(2, false);
            this.shell.setLayout((Layout)object);
            GridData gridData = new GridData(4, 0x1000008, false, true, 2, 1);
            GridData gridData2 = new GridData(4, 0x1000000, false, true, 2, 1);
            label.setLayoutData(gridData);
            this.editor.setLayoutData(gridData2);
            GridData gridData3 = new GridData(0x1000008, 128, true, true, 1, 1);
            GridData gridData4 = new GridData(0x1000008, 128, false, true, 1, 1);
            this.cancelButton.setLayoutData(gridData3);
            this.okButton.setLayoutData(gridData4);
            this.shell.pack();
            this.shell.layout(true);
        }

        private String getIntValue(int n) {
            String string = "";
            if (n < 10) {
                string = string + Integer.toString(0);
            }
            return string + Integer.toString(n);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget.equals(this.okButton)) {
                this.retValue = this.editor.getDate();
            }
            this.shell.dispose();
        }
    }
}

