/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class QtWebKit
extends WebBrowser {
    private static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    private static final String REMOVE_WIDGET_KEY = "org.eclipse.swt.internal.removeWidget";
    private static final String SET_CANVAS_STATE_KEY = "org.eclipse.swt.internal.setCanvasState";
    private static final String SET_NO_TRAVERSE_STATE_KEY = "org.eclipse.swt.internal.setNoTraverseState";
    private static final String SET_NO_KEY_PROPAGATE_STATE_KEY = "org.eclipse.swt.internal.setNoKeyPropagateState";
    private static final String SET_NO_MOUSE_PROPAGATE_STATE_KEY = "org.eclipse.swt.internal.setNoMousePropagateState";
    private static final String SET_EMBEDDED_SCROLLBARS_STATE_KEY = "org.eclipse.swt.internal.setEmbeddedScrollbarsState";
    private boolean ignoreDispose = false;
    private int webViewHandle;

    QtWebKit() {
    }

    public void create(Composite composite, int n) {
        int n2 = this.browser.internal_topHandle();
        int n3 = this.browser.handle;
        this.webViewHandle = OS.QWebView_new();
        OS.QWidget_setParent(this.webViewHandle, n2);
        int n4 = OS.QVBoxLayout_new(0);
        OS.QLayout_setContentsMargins(n4, 0, 0, 0, 0);
        OS.QLayout_setSpacing(n4, 0);
        OS.QLayout_addWidget(n4, this.webViewHandle);
        OS.QWidget_setLayout(n2, n4);
        OS.QWidget_setVisible(this.webViewHandle, true);
        OS.QLayout_activate(n4);
        OS.QLayout_update(n4);
        Display display = this.browser.getDisplay();
        display.setData(ADD_WIDGET_KEY, new Object[]{new Integer(this.webViewHandle), this.browser});
        this.browser.handle = this.webViewHandle;
        OS.QWidget_setFocusProxy(n2, this.webViewHandle);
        OS.QWidget_setFocusProxy(n3, this.webViewHandle);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (QtWebKit.this.ignoreDispose) {
                            QtWebKit.this.ignoreDispose = false;
                            break;
                        }
                        QtWebKit.this.ignoreDispose = true;
                        QtWebKit.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        event.display.setData(QtWebKit.REMOVE_WIDGET_KEY, new Object[]{new Integer(QtWebKit.this.webViewHandle)});
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.setData(SET_CANVAS_STATE_KEY, new Boolean(false));
        this.browser.setData(SET_NO_TRAVERSE_STATE_KEY, new Boolean(true));
        this.browser.setData(SET_NO_KEY_PROPAGATE_STATE_KEY, new Boolean(true));
        this.browser.setData(SET_NO_MOUSE_PROPAGATE_STATE_KEY, new Boolean(true));
        this.browser.setData(SET_EMBEDDED_SCROLLBARS_STATE_KEY, new Boolean(true));
        int n5 = OS.SignalHandler_new(this.webViewHandle, this, 1026);
        OS.QObject_connectOrThrow(this.webViewHandle, "loadFinished(bool)", n5, "widgetSignal(bool)", 0);
        int n6 = OS.SignalHandler_new(this.webViewHandle, this, 1025);
        OS.QObject_connectOrThrow(this.webViewHandle, "loadProgress(int)", n6, "widgetSignal(int)", 0);
        int n7 = OS.SignalHandler_new(this.webViewHandle, this, 1024);
        OS.QObject_connectOrThrow(this.webViewHandle, "loadStarted()", n7, "widgetSignal()", 0);
        int n8 = OS.SignalHandler_new(this.webViewHandle, this, 1027);
        OS.QObject_connectOrThrow(this.webViewHandle, "statusBarMessage(const QString&)", n8, "widgetSignal(const QString&)", 0);
        int n9 = OS.SignalHandler_new(this.webViewHandle, this, 1028);
        OS.QObject_connectOrThrow(this.webViewHandle, "titleChanged(const QString&)", n9, "widgetSignal(const QString&)", 0);
        int n10 = OS.SignalHandler_new(this.webViewHandle, this, 1029);
        OS.QObject_connectOrThrow(this.webViewHandle, "urlChanged(const QUrl&)", n10, "widgetSignal(const QUrl&)", 0);
        int n11 = OS.SignalHandler_new(this.webViewHandle, this, 1023);
        OS.QObject_connectOrThrow(this.webViewHandle, "linkClicked(const QUrl&)", n11, "widgetSignal(const QUrl&)", 0);
    }

    public boolean back() {
        if (OS.QWebView_swt_canGoBack(this.webViewHandle) && this.sendLocationEventChanging((int)System.currentTimeMillis(), OS.QWebView_swt_backUrl(this.webViewHandle))) {
            OS.QWebView_back(this.webViewHandle);
            return true;
        }
        return false;
    }

    public boolean execute(String string) {
        return OS.QWebView_swt_evaluateJavaScript(this.webViewHandle, string);
    }

    public boolean forward() {
        if (OS.QWebView_swt_canGoForward(this.webViewHandle) && this.sendLocationEventChanging((int)System.currentTimeMillis(), OS.QWebView_swt_forwardUrl(this.webViewHandle))) {
            OS.QWebView_forward(this.webViewHandle);
            return true;
        }
        return false;
    }

    public String getBrowserType() {
        return "qtwebkit";
    }

    public String getText() {
        return null;
    }

    public String getUrl() {
        return OS.QWebView_url(this.webViewHandle);
    }

    public boolean isBackEnabled() {
        return OS.QWebView_swt_canGoBack(this.webViewHandle);
    }

    public boolean isForwardEnabled() {
        return OS.QWebView_swt_canGoForward(this.webViewHandle);
    }

    public void refresh() {
        if (this.sendLocationEventChanging((int)System.currentTimeMillis(), OS.QWebView_url(this.webViewHandle))) {
            OS.QWebView_reload(this.webViewHandle);
        }
    }

    public boolean setText(String string) {
        if (this.sendLocationEventChanging((int)System.currentTimeMillis(), "about:blank")) {
            OS.QWebView_setHtml(this.webViewHandle, string);
            return true;
        }
        return false;
    }

    public boolean setUrl(String string) {
        if (this.sendLocationEventChanging((int)System.currentTimeMillis(), string)) {
            OS.QWebView_setUrl(this.webViewHandle, string);
            return true;
        }
        return false;
    }

    public void stop() {
        OS.QWebView_stop(this.webViewHandle);
    }

    final boolean eventProcess(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string) {
        if (this.browser.isDisposed()) {
            return false;
        }
        if (n != this.webViewHandle) {
            return false;
        }
        switch (n2) {
            case 1026: {
                this.sendProgressEventCompleted(n3);
                break;
            }
            case 1025: {
                this.sendProgressEventChanged(n3, n4);
                break;
            }
            case 1024: {
                this.sendProgressEventChanged(n3, 0);
                break;
            }
            case 1023: {
                this.sendLocationEventChanging(n3, string);
                break;
            }
            case 1027: {
                this.sendStatusTextEventChanged(n3, string);
                break;
            }
            case 1028: {
                this.sendTitleEventChanged(n3, string);
                break;
            }
            case 1029: {
                this.sendLocationEventChanged(n3, string);
                break;
            }
        }
        return false;
    }

    private void sendProgressEventChanged(int n, int n2) {
        ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = this.browser.getDisplay();
        progressEvent.widget = this.browser;
        progressEvent.time = n;
        progressEvent.current = n2;
        progressEvent.total = 100;
        for (int i = 0; i < this.progressListeners.length; ++i) {
            this.progressListeners[i].changed(progressEvent);
        }
    }

    private void sendProgressEventCompleted(int n) {
        ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = this.browser.getDisplay();
        progressEvent.widget = this.browser;
        progressEvent.time = n;
        progressEvent.current = 100;
        progressEvent.total = 100;
        for (int i = 0; i < this.progressListeners.length; ++i) {
            this.progressListeners[i].completed(progressEvent);
        }
    }

    private void sendStatusTextEventChanged(int n, String string) {
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.time = n;
        statusTextEvent.text = string;
        for (int i = 0; i < this.statusTextListeners.length; ++i) {
            this.statusTextListeners[i].changed(statusTextEvent);
        }
    }

    private void sendTitleEventChanged(int n, String string) {
        TitleEvent titleEvent = new TitleEvent(this.browser);
        titleEvent.display = this.browser.getDisplay();
        titleEvent.widget = this.browser;
        titleEvent.time = n;
        titleEvent.title = string;
        for (int i = 0; i < this.titleListeners.length; ++i) {
            this.titleListeners[i].changed(titleEvent);
        }
    }

    private void sendLocationEventChanged(int n, String string) {
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.time = n;
        locationEvent.location = string;
        locationEvent.doit = true;
        locationEvent.top = true;
        for (int i = 0; i < this.locationListeners.length; ++i) {
            this.locationListeners[i].changed(locationEvent);
        }
    }

    private boolean sendLocationEventChanging(int n, String string) {
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.time = n;
        locationEvent.location = string;
        locationEvent.doit = true;
        boolean bl = true;
        for (int i = 0; i < this.locationListeners.length; ++i) {
            this.locationListeners[i].changing(locationEvent);
            bl &= locationEvent.doit;
        }
        return bl;
    }
}

