/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;

public abstract class Device
implements Drawable {
    protected int paintDevice;
    static Device[] Devices = new Device[4];
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    Color COLOR_LIST_BACKGROUND;
    Color COLOR_LIST_FOREGROUND;
    Color COLOR_LIST_SELECTION;
    Color COLOR_LIST_SELECTION_TEXT;
    Color COLOR_TITLE_BACKGROUND;
    Color COLOR_TITLE_BACKGROUND_GRADIENT;
    Color COLOR_TITLE_FOREGROUND;
    Color COLOR_TITLE_INACTIVE_BACKGROUND;
    Color COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
    Color COLOR_TITLE_INACTIVE_FOREGROUND;
    Color COLOR_WIDGET_BACKGROUND;
    Color COLOR_WIDGET_BORDER;
    Color COLOR_WIDGET_DARK_SHADOW;
    Color COLOR_WIDGET_FOREGROUND;
    Color COLOR_WIDGET_HIGHLIGHT_SHADOW;
    Color COLOR_WIDGET_LIGHT_SHADOW;
    Color COLOR_WIDGET_NORMAL_SHADOW;
    protected boolean disposed;
    static int nullIconHandle;
    static final int FONT_DEF_HEIGHT = 12;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;
    static /* synthetic */ Class class$org$eclipse$swt$graphics$Device;

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Device.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(deviceData);
            this.init();
            Device.register(this);
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData deviceData) {
    }

    static synchronized void deregister(Device device) {
        for (int i = 0; i < Devices.length; ++i) {
            if (device != Devices[i]) continue;
            Device.Devices[i] = null;
        }
    }

    protected void destroy() {
    }

    int deviceCount() {
        int n = 0;
        for (int i = 0; i < Devices.length; ++i) {
            if (Devices[i] == null || Devices[i].isDisposed()) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Device.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            if (this.isDisposed()) {
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            Device.deregister(this);
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.printErrors();
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != object) continue;
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
        }
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, OS.QPaintDevice_width(this.paintDevice), OS.QPaintDevice_height(this.paintDevice));
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n;
                int n2 = 0;
                int n3 = this.objects.length;
                for (n = 0; n < n3; ++n) {
                    if (this.objects[n] == null) continue;
                    ++n2;
                }
                n = 0;
                deviceData.objects = new Object[n2];
                deviceData.errors = new Error[n2];
                for (int i = 0; i < n3; ++i) {
                    if (this.objects[i] == null) continue;
                    deviceData.objects[n] = this.objects[i];
                    deviceData.errors[n] = this.errors[i];
                    ++n;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public int getDepth() {
        this.checkDevice();
        return OS.QPaintDevice_depth(this.paintDevice);
    }

    public Point getDPI() {
        this.checkDevice();
        return new Point(OS.QPaintDevice_physicalDpiX(this.paintDevice), OS.QPaintDevice_physicalDpiY(this.paintDevice));
    }

    public FontData[] getFontList(String string, boolean bl) {
        this.checkDevice();
        int n = 0;
        n = OS.QFontDatabase_new();
        String[] stringArray = OS.QFontDatabase_families(n);
        Vector vector = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = null;
            if (string == null) {
                string2 = stringArray[i];
            } else {
                if (!string.equals(stringArray[i])) continue;
                string2 = stringArray[i];
            }
            this.getFontList(vector, n, string2, bl);
            if (string != null) break;
        }
        OS.QFontDatabase_delete(n);
        n = 0;
        if (vector.size() > 0) {
            FontData[] fontDataArray = new FontData[vector.size()];
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                fontDataArray[i] = (FontData)vector.elementAt(i);
            }
            return fontDataArray;
        }
        return new FontData[0];
    }

    private void getFontList(Vector vector, int n, String string, boolean bl) {
        String[] stringArray = OS.QFontDatabase_styles(n, string);
        int n2 = -1;
        int n3 = 0;
        do {
            String string2 = stringArray.length > 0 ? stringArray[n3] : null;
            boolean bl2 = OS.QFontDatabase_isScalable(n, string, string2);
            int n4 = 0;
            if (OS.QFontDatabase_bold(n, string, string2)) {
                n4 |= 1;
            }
            if (OS.QFontDatabase_italic(n, string, string2)) {
                n4 |= 2;
            }
            if (n4 == n2) continue;
            n2 = n4;
            int[] nArray = null;
            int n5 = 0;
            if (bl && bl2) {
                nArray = new int[]{12};
            } else if (!bl && !bl2) {
                nArray = OS.QFontDatabase_heights(n, string, string2);
            }
            if (nArray == null) continue;
            do {
                FontData fontData = new FontData(string, nArray[n5], n4);
                vector.addElement(fontData);
            } while (!bl && !bl2 && ++n5 < nArray.length);
        } while (++n3 < stringArray.length);
    }

    public Color getSystemColor(int n) {
        int n2;
        this.checkDevice();
        switch (n) {
            case 1: {
                n2 = 0xFFFFFF;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 255;
                break;
            }
            case 4: {
                n2 = 128;
                break;
            }
            case 5: {
                n2 = 65280;
                break;
            }
            case 6: {
                n2 = 32768;
                break;
            }
            case 7: {
                n2 = 65535;
                break;
            }
            case 8: {
                n2 = 32896;
                break;
            }
            case 9: {
                n2 = 0xFF0000;
                break;
            }
            case 10: {
                n2 = 0x800000;
                break;
            }
            case 11: {
                n2 = 0xFF00FF;
                break;
            }
            case 12: {
                n2 = 0x800080;
                break;
            }
            case 13: {
                n2 = 0xFFFF00;
                break;
            }
            case 14: {
                n2 = 0x808000;
                break;
            }
            case 15: {
                n2 = 0xC0C0C0;
                break;
            }
            case 16: {
                n2 = 0x808080;
                break;
            }
            case 25: {
                n2 = this.COLOR_LIST_BACKGROUND.handle;
                break;
            }
            case 24: {
                n2 = this.COLOR_LIST_FOREGROUND.handle;
                break;
            }
            case 26: {
                n2 = this.COLOR_LIST_SELECTION.handle;
                break;
            }
            case 27: {
                n2 = this.COLOR_LIST_SELECTION_TEXT.handle;
                break;
            }
            case 31: {
                n2 = this.COLOR_TITLE_BACKGROUND.handle;
                break;
            }
            case 32: {
                n2 = this.COLOR_TITLE_BACKGROUND_GRADIENT.handle;
                break;
            }
            case 30: {
                n2 = this.COLOR_TITLE_FOREGROUND.handle;
                break;
            }
            case 34: {
                n2 = this.COLOR_TITLE_INACTIVE_BACKGROUND.handle;
                break;
            }
            case 35: {
                n2 = this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT.handle;
                break;
            }
            case 33: {
                n2 = this.COLOR_TITLE_INACTIVE_FOREGROUND.handle;
                break;
            }
            case 22: {
                n2 = this.COLOR_WIDGET_BACKGROUND.handle;
                break;
            }
            case 23: {
                n2 = this.COLOR_WIDGET_BORDER.handle;
                break;
            }
            case 17: {
                n2 = this.COLOR_WIDGET_DARK_SHADOW.handle;
                break;
            }
            case 21: {
                n2 = this.COLOR_WIDGET_FOREGROUND.handle;
                break;
            }
            case 20: {
                n2 = this.COLOR_WIDGET_HIGHLIGHT_SHADOW.handle;
                break;
            }
            case 19: {
                n2 = this.COLOR_WIDGET_LIGHT_SHADOW.handle;
                break;
            }
            case 18: {
                n2 = this.COLOR_WIDGET_NORMAL_SHADOW.handle;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return Color.qt_new(this, n2);
    }

    public Font getSystemFont() {
        this.checkDevice();
        return Font.qt_new(this, OS.SwtFontCache_cache(OS.QApplication_swt_font_new()));
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        int n = OS.QApplication_swt_palette_new();
        try {
            int[] nArray = OS.QPalette_color(n, 0, 9);
            this.COLOR_LIST_BACKGROUND = new Color(this, nArray[0], nArray[1], nArray[2]);
            nArray = OS.QPalette_color(n, 0, 6);
            this.COLOR_LIST_FOREGROUND = new Color(this, nArray[0], nArray[1], nArray[2]);
            nArray = OS.QPalette_color(n, 0, 12);
            this.COLOR_LIST_SELECTION = new Color(this, nArray[0], nArray[1], nArray[2]);
            this.COLOR_TITLE_BACKGROUND = new Color(this, nArray[0], nArray[1], nArray[2]);
            this.COLOR_TITLE_BACKGROUND_GRADIENT = new Color(this, nArray[0], nArray[1], nArray[2]);
            this.COLOR_WIDGET_HIGHLIGHT_SHADOW = new Color(this, nArray[0], nArray[1], nArray[2]);
            nArray = OS.QPalette_color(n, 0, 13);
            this.COLOR_LIST_SELECTION_TEXT = new Color(this, nArray[0], nArray[1], nArray[2]);
            this.COLOR_TITLE_FOREGROUND = new Color(this, nArray[0], nArray[1], nArray[2]);
            nArray = OS.QPalette_color(n, 1, 12);
            this.COLOR_TITLE_INACTIVE_BACKGROUND = new Color(this, nArray[0], nArray[1], nArray[2]);
            this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = new Color(this, nArray[0], nArray[1], nArray[2]);
            nArray = OS.QPalette_color(n, 1, 6);
            this.COLOR_TITLE_INACTIVE_FOREGROUND = new Color(this, nArray[0], nArray[1], nArray[2]);
            nArray = OS.QPalette_color(n, 0, 10);
            this.COLOR_WIDGET_BACKGROUND = new Color(this, nArray[0], nArray[1], nArray[2]);
            nArray = OS.QPalette_color(n, 0, 0);
            this.COLOR_WIDGET_FOREGROUND = new Color(this, nArray[0], nArray[1], nArray[2]);
            nArray = OS.QPalette_color(n, 0, 4);
            this.COLOR_WIDGET_DARK_SHADOW = new Color(this, nArray[0], nArray[1], nArray[2]);
            nArray = OS.QPalette_color(n, 0, 5);
            this.COLOR_WIDGET_BORDER = new Color(this, nArray[0], nArray[1], nArray[2]);
            this.COLOR_WIDGET_NORMAL_SHADOW = new Color(this, nArray[0], nArray[1], nArray[2]);
            nArray = OS.QPalette_color(n, 0, 1);
            this.COLOR_WIDGET_LIGHT_SHADOW = new Color(this, nArray[0], nArray[1], nArray[2]);
        }
        finally {
            OS.QPalette_delete(n);
        }
    }

    public boolean internal_isDisposed() {
        return this.isDisposed();
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class clazz = class$org$eclipse$swt$graphics$Device == null ? (class$org$eclipse$swt$graphics$Device = Device.class$("org.eclipse.swt.graphics.Device")) : class$org$eclipse$swt$graphics$Device;
        synchronized (clazz) {
            return this.disposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != null) continue;
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    static synchronized void register(Device device) {
        for (int i = 0; i < Devices.length; ++i) {
            if (Devices[i] != null) continue;
            Device.Devices[i] = device;
            return;
        }
        Device[] deviceArray = new Device[Devices.length + 4];
        System.arraycopy(Devices, 0, deviceArray, 0, Devices.length);
        deviceArray[Device.Devices.length] = device;
        Devices = deviceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printErrors() {
        if (!DEBUG) {
            return;
        }
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                if (this.objects == null || this.errors == null) {
                    return;
                }
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                for (int i = 0; i < this.objects.length; ++i) {
                    Object object2 = this.objects[i];
                    if (object2 == null) continue;
                    ++n;
                    if (object2 instanceof Color) {
                        ++n2;
                    }
                    if (object2 instanceof Font) {
                        ++n3;
                    }
                    if (object2 instanceof GC) {
                        ++n4;
                    }
                    if (!(object2 instanceof Image)) continue;
                    ++n5;
                }
                if (n != 0) {
                    String string = "Summary: ";
                    if (n2 != 0) {
                        string = string + n2 + " Color(s), ";
                    }
                    if (n3 != 0) {
                        string = string + n3 + " Font(s), ";
                    }
                    if (n4 != 0) {
                        string = string + n4 + " GC(s), ";
                    }
                    if (n5 != 0) {
                        string = string + n5 + " Image(s), ";
                    }
                    if (string.length() != 0) {
                        string = string.substring(0, string.length() - 2);
                        System.err.println(string);
                    }
                    for (int i = 0; i < this.errors.length; ++i) {
                        if (this.errors[i] == null) continue;
                        this.errors[i].printStackTrace();
                    }
                }
            }
        }
    }

    protected void release() {
        if (this.deviceCount() == 1 && nullIconHandle != 0) {
            OS.QIcon_delete(nullIconHandle);
            nullIconHandle = 0;
        }
        this.COLOR_LIST_BACKGROUND.dispose();
        this.COLOR_LIST_FOREGROUND.dispose();
        this.COLOR_LIST_SELECTION.dispose();
        this.COLOR_LIST_SELECTION_TEXT.dispose();
        this.COLOR_TITLE_BACKGROUND.dispose();
        this.COLOR_TITLE_BACKGROUND_GRADIENT.dispose();
        this.COLOR_TITLE_FOREGROUND.dispose();
        this.COLOR_TITLE_INACTIVE_BACKGROUND.dispose();
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT.dispose();
        this.COLOR_TITLE_INACTIVE_FOREGROUND.dispose();
        this.COLOR_WIDGET_BACKGROUND.dispose();
        this.COLOR_WIDGET_BORDER.dispose();
        this.COLOR_WIDGET_DARK_SHADOW.dispose();
        this.COLOR_WIDGET_FOREGROUND.dispose();
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW.dispose();
        this.COLOR_WIDGET_LIGHT_SHADOW.dispose();
        this.COLOR_WIDGET_NORMAL_SHADOW.dispose();
        this.COLOR_LIST_BACKGROUND = null;
        this.COLOR_LIST_FOREGROUND = null;
        this.COLOR_LIST_SELECTION = null;
        this.COLOR_LIST_SELECTION_TEXT = null;
        this.COLOR_TITLE_BACKGROUND = null;
        this.COLOR_TITLE_BACKGROUND_GRADIENT = null;
        this.COLOR_TITLE_FOREGROUND = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = null;
        this.COLOR_TITLE_INACTIVE_FOREGROUND = null;
        this.COLOR_WIDGET_BACKGROUND = null;
        this.COLOR_WIDGET_BORDER = null;
        this.COLOR_WIDGET_DARK_SHADOW = null;
        this.COLOR_WIDGET_FOREGROUND = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = null;
        this.COLOR_WIDGET_LIGHT_SHADOW = null;
        this.COLOR_WIDGET_NORMAL_SHADOW = null;
        this.paintDevice = 0;
    }

    public void setWarnings(boolean bl) {
        this.checkDevice();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

