/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.internal.qt.QtSupplementaryFontData;

public final class FontData {
    String name;
    int height;
    int style;
    String lang;
    String country;
    String variant;
    QtSupplementaryFontData extraFontData;
    String xlfd;

    public FontData() {
        this("", 12, 0);
    }

    public FontData(String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.parseFontDescriptor(string);
        this.updateFontData();
    }

    public FontData(String string, int n, int n2) {
        if (string == null) {
            SWT.error(4);
        }
        if (n < 0) {
            SWT.error(5);
        }
        this.setName(string);
        this.setHeight(n);
        this.setStyle(n2);
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontData)) {
            return false;
        }
        FontData fontData = (FontData)object;
        if (!(this.xlfd == null && fontData.xlfd == null || this.xlfd != null && fontData.xlfd != null)) {
            return false;
        }
        if (!(this.extraFontData == null && fontData.extraFontData == null || this.extraFontData != null && fontData.extraFontData != null)) {
            return false;
        }
        if (this.xlfd != null) {
            return this.xlfd.trim().equals(fontData.xlfd.trim());
        }
        boolean bl2 = bl = this.name.equals(fontData.name) && this.height == fontData.height && this.style == fontData.style;
        if (bl && this.extraFontData != null) {
            return bl && this.extraFontData.underline == fontData.extraFontData.underline && this.extraFontData.underline == fontData.extraFontData.underline && this.extraFontData.overline == fontData.extraFontData.overline && this.extraFontData.strikeOut == fontData.extraFontData.strikeOut && this.extraFontData.stretch == fontData.extraFontData.stretch && this.extraFontData.fixedPitch == fontData.extraFontData.fixedPitch && this.extraFontData.style == fontData.extraFontData.style && this.extraFontData.weight == fontData.extraFontData.weight && this.extraFontData.styleStrategy == fontData.extraFontData.styleStrategy;
        }
        return bl;
    }

    public int getHeight() {
        return this.height;
    }

    public String getLocale() {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char c = '_';
        if (this.lang != null) {
            stringBuffer.append(this.lang);
            stringBuffer.append(c);
        }
        if (this.country != null) {
            stringBuffer.append(this.country);
            stringBuffer.append(c);
        }
        if (this.variant != null) {
            stringBuffer.append(this.variant);
        }
        if ((n = (string = stringBuffer.toString()).length()) > 0 && string.charAt(n - 1) == c) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.height ^ this.style;
    }

    void parseFontDescriptor(String string) {
        int n = 0;
        int n2 = string.indexOf(124);
        if (n2 == -1) {
            SWT.error(5);
        }
        String string2 = string.substring(n, n2);
        try {
            if (Integer.parseInt(string2) != 1) {
                SWT.error(5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        n = n2 + 1;
        n2 = string.indexOf(124, n);
        if (n2 == -1) {
            SWT.error(5);
        }
        String string3 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf(124, n)) == -1) {
            SWT.error(5);
        }
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        n = n2 + 1;
        n2 = string.indexOf(124, n);
        if (n2 == -1) {
            SWT.error(5);
        }
        int n4 = 0;
        try {
            n4 = Integer.parseInt(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        n = n2 + 1;
        n2 = string.indexOf(124, n);
        this.setName(string3);
        this.setHeight(n3);
        this.setStyle(n4);
        if (n2 == -1) {
            return;
        }
        String string4 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf(124, n)) == -1) {
            return;
        }
        String string5 = string.substring(n, n2);
        if (string4.trim().toUpperCase().equals("QT") && string5.equals("1")) {
            try {
                this.extraFontData = new QtSupplementaryFontData();
                n = n2 + 1;
                n2 = string.indexOf(124, n);
                if (n2 == -1) {
                    return;
                }
                this.extraFontData.underline = Integer.parseInt(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                this.extraFontData.overline = Integer.parseInt(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                this.extraFontData.strikeOut = Integer.parseInt(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                int n5 = Integer.parseInt(string.substring(n, n2));
                if (n5 > 0) {
                    if (n5 > 4000) {
                        n5 = 4000;
                    }
                    this.extraFontData.stretch = n5;
                }
                if ((n2 = string.indexOf(124, n = n2 + 1)) == -1) {
                    this.extraFontData = null;
                    return;
                }
                this.extraFontData.fixedPitch = Integer.parseInt(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                int n6 = Integer.parseInt(string.substring(n, n2));
                if (n6 == 0 || n6 == 1 || n6 == 2) {
                    this.extraFontData.style = n6;
                }
                if ((n2 = string.indexOf(124, n = n2 + 1)) == -1) {
                    return;
                }
                int n7 = Integer.parseInt(string.substring(n, n2));
                if (n7 > -1) {
                    if (n7 > 99) {
                        n7 = 99;
                    }
                    this.extraFontData.weight = n7;
                }
                if ((n2 = string.indexOf(124, n = n2 + 1)) == -1) {
                    return;
                }
                int n8 = Integer.parseInt(string.substring(n, n2));
                int[] nArray = new int[]{1, 2, 4, 8, 16, 256, 128, 512, 32768};
                boolean bl = n8 == 64 || n8 == 32;
                for (int i = 0; i < nArray.length; ++i) {
                    if ((n8 & nArray[i]) == 0) continue;
                    if (n8 != nArray[i] && n8 != (nArray[i] | 0x40) && n8 != (nArray[i] | 0x20)) break;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.extraFontData.styleStrategy = n8;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.extraFontData = null;
            }
        } else if (string4.trim().toUpperCase().equals("X11") && OS.windowServer == 2) {
            n = n2 + 1;
            if ((n2 = string.indexOf(124, n)) == -1) {
                return;
            }
            this.xlfd = string.substring(n, n2);
            if (this.xlfd.length() < 1) {
                this.xlfd = null;
            }
        }
    }

    public void setHeight(int n) {
        if (n < 0) {
            SWT.error(5);
        }
        this.height = n;
    }

    public void setLocale(String string) {
        this.variant = null;
        this.country = null;
        this.lang = null;
        if (string != null) {
            int n;
            int n2 = 95;
            int n3 = string.length();
            int n4 = string.indexOf(n2);
            if (n4 == -1) {
                n4 = n = n3;
            } else {
                n = string.indexOf(n2, n4 + 1);
                if (n == -1) {
                    n = n3;
                }
            }
            if (n4 > 0) {
                this.lang = string.substring(0, n4);
            }
            if (n > n4 + 1) {
                this.country = string.substring(n4 + 1, n);
            }
            if (n3 > n + 1) {
                this.variant = string.substring(n + 1);
            }
        }
    }

    public void setName(String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.name = string;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("1|");
        stringBuffer.append(this.getName());
        stringBuffer.append("|");
        stringBuffer.append(this.getHeight());
        stringBuffer.append("|");
        stringBuffer.append(this.getStyle());
        stringBuffer.append("|");
        if (this.xlfd != null) {
            stringBuffer.append("X11|1|");
            stringBuffer.append(this.xlfd);
            stringBuffer.append("|");
        } else if (this.extraFontData != null) {
            stringBuffer.append("QT|1|");
            stringBuffer.append(this.extraFontData.overline);
            stringBuffer.append("|");
            stringBuffer.append(this.extraFontData.underline);
            stringBuffer.append("|");
            stringBuffer.append(this.extraFontData.strikeOut);
            stringBuffer.append("|");
            stringBuffer.append(this.extraFontData.stretch);
            stringBuffer.append("|");
            stringBuffer.append(this.extraFontData.fixedPitch);
            stringBuffer.append("|");
            stringBuffer.append(this.extraFontData.style);
            stringBuffer.append("|");
            stringBuffer.append(this.extraFontData.weight);
            stringBuffer.append("|");
            stringBuffer.append(this.extraFontData.styleStrategy);
            stringBuffer.append("|");
        }
        return stringBuffer.toString();
    }

    void updateFontData() {
        if (this.extraFontData == null && this.xlfd == null) {
            return;
        }
        boolean bl = (this.style & 2) != 0;
        int n = 50;
        if ((this.style & 1) != 0) {
            n = 75;
        }
        int n2 = OS.QFont_new(this.name, this.height, n, bl);
        if (this.xlfd != null) {
            OS.QFont_setRawName(n2, this.xlfd);
        } else {
            if (this.extraFontData.underline > -1) {
                OS.QFont_setUnderline(n2, this.extraFontData.underline > 0);
            }
            if (this.extraFontData.overline > -1) {
                OS.QFont_setOverline(n2, this.extraFontData.overline > 0);
            }
            if (this.extraFontData.strikeOut > -1) {
                OS.QFont_setStrikeOut(n2, this.extraFontData.strikeOut > 0);
            }
            if (this.extraFontData.stretch > -1) {
                OS.QFont_setStretch(n2, this.extraFontData.stretch);
            }
            if (this.extraFontData.fixedPitch > -1) {
                OS.QFont_setFixedPitch(n2, this.extraFontData.fixedPitch > 0);
            }
            if (this.extraFontData.style > -1) {
                OS.QFont_setStyle(n2, this.extraFontData.style);
            }
            if (this.extraFontData.weight > -1) {
                OS.QFont_setWeight(n2, this.extraFontData.weight);
            }
            if (this.extraFontData.styleStrategy > -1) {
                OS.QFont_setStyleStrategy(n2, this.extraFontData.styleStrategy);
            }
        }
        this.name = OS.QFont_family(n2);
        this.height = OS.QFont_pointSize(n2);
        n = OS.QFont_weight(n2);
        bl = OS.QFont_italic(n2);
        this.style = 0;
        if (n > 50) {
            this.style |= 1;
        }
        if (bl) {
            this.style |= 2;
        }
        if (this.extraFontData != null) {
            this.extraFontData.underline = OS.QFont_underline(n2) ? 1 : 0;
            this.extraFontData.overline = OS.QFont_overline(n2) ? 1 : 0;
            this.extraFontData.strikeOut = OS.QFont_strikeOut(n2) ? 1 : 0;
            this.extraFontData.stretch = OS.QFont_stretch(n2);
            this.extraFontData.fixedPitch = OS.QFont_fixedPitch(n2) ? 1 : 0;
            this.extraFontData.style = OS.QFont_style(n2);
            this.extraFontData.weight = OS.QFont_weight(n2);
            this.extraFontData.styleStrategy = OS.QFont_styleStrategy(n2);
            OS.QFont_delete(n2);
        }
    }
}

